/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.support.base;

import com.softaspects.framework.galileo.components.tree.TreeItemBase;
import com.softaspects.framework.galileo.components.tree.TreeItemImpl;
import com.softaspects.framework.galileo.components.treemodel.BaseTreeDataModel;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TreeDynamicDataModelProviderServlet
extends HttpServlet {
    protected static final String FOLDER_JS_COMPONENT = "Folder";
    protected static final String FOLDER_JS_COMPONENT_SCRAMBLED = "x12049837485630893245895636";
    protected static final String ITEM_JS_COMPONENT = "Item";
    protected static final String ITEM_JS_COMPONENT_SCRAMBLED = "x3477545457483574857451";

    protected void setModifiedProperties(TreeItemImpl anItem, String anObjectVarName, StringBuffer generatedContent) {
        if (anItem == null) {
            throw new IllegalStateException("setModifiedProperties : Item is null.");
        }
        String modifiedPropertyString = null;
        Iterator modifiedPropertiesIterator = ((AbstractList)anItem.getModifiedPropertiesList()).iterator();
        while (modifiedPropertiesIterator.hasNext()) {
            modifiedPropertyString = String.valueOf(anObjectVarName) + "." + (String)modifiedPropertiesIterator.next() + "\n";
            generatedContent.append(modifiedPropertyString);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long itemCounter = 0L;
        StringBuffer generatedContent = new StringBuffer();
        String dataModelName = null;
        BaseTreeDataModel dataModel = null;
        String parentVarName = request.getParameter("folder");
        String selectionIndex = request.getParameter("path");
        String componentVarName = request.getParameter("componentVarName");
        dataModelName = String.valueOf(componentVarName) + "DataModel";
        dataModel = (BaseTreeDataModel)RendererFactory.findAttributeValueInAllScopes(dataModelName, request);
        if (dataModel == null) {
            throw new IllegalStateException("TreeDynamicDataModelProviderServlet : TreeView dataModel hasn't been put in Context.");
        }
        boolean scrambled = dataModel.getScrambled();
        TreeItemImpl selectedFolder = (TreeItemImpl)dataModel.getElementAt(selectionIndex);
        TreeItemImpl item = null;
        String itemVarName = null;
        Iterator itemsIterator = selectedFolder.elements();
        generatedContent.append("<script>\n");
        generatedContent.append("if(parent." + parentVarName + (scrambled ? ".nCH" : ".nChildren") + " == 0){");
        while (itemsIterator.hasNext()) {
            item = (TreeItemImpl)itemsIterator.next();
            itemVarName = String.valueOf(parentVarName) + itemCounter;
            if (TreeItemBase.getItemTypeShortValue(item.getType()) == 2) {
                generatedContent.append("parent." + itemVarName + " = new parent." + (scrambled ? FOLDER_JS_COMPONENT_SCRAMBLED : FOLDER_JS_COMPONENT) + "('" + itemVarName + "',false,'" + item.getDescription() + "','" + item.getData() + "');\n");
            } else {
                generatedContent.append("parent." + itemVarName + " = new parent." + (scrambled ? ITEM_JS_COMPONENT_SCRAMBLED : ITEM_JS_COMPONENT) + "('" + itemVarName + "','" + item.getDescription() + "','" + item.getData() + "');\n");
            }
            this.setModifiedProperties(item, "parent." + itemVarName, generatedContent);
            generatedContent.append("parent." + parentVarName + (scrambled ? ".aC(" : ".addChild(") + "parent." + itemVarName + ");\n");
            ++itemCounter;
        }
        generatedContent.append("}");
        generatedContent.append("parent." + (scrambled ? "lINTL" : "lazyInitialize") + "(parent." + parentVarName + ");\n");
        generatedContent.append("</script>\n");
        response.getOutputStream().println(generatedContent.toString());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

