/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table;

import com.softaspects.framework.galileo.components.base.ComponentBase;
import com.softaspects.framework.galileo.components.base.PresentationEvent;
import com.softaspects.framework.galileo.components.base.Renderer;
import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.components.table.InterfaceManager;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.base.ContextRenderer;
import com.softaspects.framework.galileo.renderers.html.base.HtmlProperty;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptProviderBase;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptResource;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.table.AbstractTableRenderer;
import com.softaspects.framework.galileo.renderers.html.table.CellRenderer;
import com.softaspects.framework.galileo.renderers.html.table.DefaultNavigationBarRenderer;
import com.softaspects.framework.galileo.renderers.html.table.HeaderRenderer;
import com.softaspects.framework.galileo.renderers.html.table.MainTableRenderer;
import com.softaspects.framework.galileo.renderers.html.table.RendererUtils;
import com.softaspects.framework.galileo.renderers.html.table.TableRenderer;
import com.softaspects.framework.galileo.support.components.ListException;
import com.softaspects.framework.galileo.support.components.ListVariables;
import com.softaspects.galileo.client.jsp.html.base.ColorFactory;
import com.softaspects.galileo.client.jsp.html.base.TagFactory;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;

public class TableRendererImpl
extends AbstractTableRenderer
implements MainTableRenderer {
    protected static final String TABLE_SCRIPT_WAS_LOADED = "TABLE_SCRIPT_WAS_LOADED";
    protected static final String TABLE_SCRIPT_FUNCTION = "TableComponent";
    protected static final String REQUEST_METHOD = "get";
    protected static final String INIT_COLUMNMODEL = "columnSelectionModel.initSelection";
    protected static final String INIT_ROWMODEL = "rowSelectionModel.initSelection";
    protected static final String INIT_COLUMNS = "initVisisbleColumns";
    protected static final String INIT_EDITED = "initEditModeCells";
    private StringBuffer generatedContent = null;
    protected Renderer navigationBarRenderer = null;

    public TableRendererImpl() {
        this.setNavigationBarRenderer(new DefaultNavigationBarRenderer());
    }

    public TableRendererImpl(ComponentBase component) {
        this.setComponent(component);
        this.setNavigationBarRenderer(new DefaultNavigationBarRenderer(component));
    }

    public String doRender() throws RendererException {
        TableRenderer tableRenderer;
        JspWriter out = this.fPageContext.getOut();
        Table table = this.getTable();
        InterfaceManager tableUIManager = table.getInterfaceManager();
        tableUIManager.setPageContextRendering(false);
        int editorMode = table.getEditorMode();
        this.generatedContent = new StringBuffer();
        if (tableUIManager != null && (tableRenderer = tableUIManager.getRenderer()) != null) {
            tableRenderer.setTable(table);
            this.generatedContent.append(RendererFactory.componentRender(tableRenderer, this.fPageContext));
        }
        table.clearAllChangeResponseMeassages();
        table.setChangeRequest(this.fPageContext.getRequest());
        table.changeTableByRequest();
        try {
            int[] visibleColumns;
            int[] selectedColumns;
            String function;
            int[] selectedRows;
            Object flag = this.fPageContext.getAttribute(TABLE_SCRIPT_WAS_LOADED, 2);
            if (flag == null) {
                JavaScriptResource javaScriptResource = new JavaScriptProviderBase().getJavaScriptResource((HttpServletRequest)this.fPageContext.getRequest());
                this.fPageContext.getOut().println(RendererFactory.createJScriptBeginTag(javaScriptResource.getComponentJavaScriptSource(table.getComponentTypeName()), null));
                this.fPageContext.getOut().println(RendererFactory.createJScriptEndTag());
                this.fPageContext.setAttribute(TABLE_SCRIPT_WAS_LOADED, (Object)TABLE_SCRIPT_WAS_LOADED, 2);
            }
            this.generatedContent.append("<TABLE");
            this.generatedContent.append(ListVariables.performListing(this.context));
            Iterator htmlProperties = RendererFactory.componentHtmlPropertiesIterator(table);
            while (htmlProperties.hasNext()) {
                this.generatedContent.append(' ');
                HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
                this.generatedContent.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
            }
            Iterator uniqHtmlProperty = ((AbstractList)this.getTableUniqPropertiesList(table)).iterator();
            while (uniqHtmlProperty.hasNext()) {
                this.generatedContent.append(' ');
                HtmlProperty htmlProperty = (HtmlProperty)uniqHtmlProperty.next();
                this.generatedContent.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
            }
            Iterator presentationEvents = table.getPresentationEvents();
            while (presentationEvents.hasNext()) {
                this.generatedContent.append(' ');
                PresentationEvent presentationEvent = (PresentationEvent)presentationEvents.next();
                String type = RendererFactory.getPresentationEventName(presentationEvent.getType());
                String value = presentationEvent.getValue();
                this.generatedContent.append(RendererFactory.createHtmlStylePropertyString(type, value));
            }
            this.generatedContent.append('>');
            if (table.getCaption() != null) {
                this.generatedContent.append("<CAPTION");
                if (table.getCaptionAlign() != -1) {
                    this.generatedContent.append(' ');
                    String align = RendererUtils.getCaptionAlignValue(table.getCaptionAlign());
                    this.generatedContent.append(RendererFactory.createHtmlStylePropertyString("ALIGN", align));
                }
                this.generatedContent.append('>');
                this.generatedContent.append(RendererFactory.indentString(2, table.getCaption()));
                this.generatedContent.append(RendererFactory.indentString(1, "</CAPTION>"));
            }
            if (table.isShowHeader()) {
                this.generatedContent.append(RendererFactory.indentString(1, "<TR>"));
                int i = 0;
                while (i < table.getColumnCount()) {
                    if (table.isColumnVisible(i)) {
                        String tdStart = this.getHeaderStartTDtag(table, i);
                        this.generatedContent.append(RendererFactory.indentString(1, tdStart));
                        this.generatedContent.append(this.renderHeader(table, i));
                        this.generatedContent.append(RendererFactory.indentString(1, "</TD>"));
                    }
                    ++i;
                }
                this.generatedContent.append(RendererFactory.indentString(1, "</TR>"));
            }
            int rowCount = table.getRowCountByCursor();
            int columnCount = table.getColumnCount();
            int j = 0;
            while (j < rowCount) {
                this.generatedContent.append(RendererFactory.indentString(1, "<TR>"));
                int i = 0;
                while (i < columnCount) {
                    if (table.isColumnVisible(i)) {
                        int row = table.getFirstRowIndexByCursor() + j;
                        String tdStart = this.getCellStartTDtag(table, row, i);
                        this.generatedContent.append(RendererFactory.indentString(1, tdStart));
                        boolean editable = table.isCellEditable(row, i);
                        if (editorMode == 0 || !editable) {
                            this.generatedContent.append(this.renderCell(table, row, i, editable));
                        } else {
                            String cellId = RendererUtils.getTableCellId(table, row, i);
                            this.generatedContent.append(RendererFactory.indentString(2, this.getDIVstartTag(cellId, true)));
                            this.generatedContent.append(this.renderCell(table, row, i, false));
                            this.generatedContent.append(RendererFactory.indentString(2, "</DIV>"));
                            this.generatedContent.append(RendererFactory.indentString(2, this.getDIVstartTag(cellId, false)));
                            this.generatedContent.append(this.renderCell(table, row, i, true));
                            this.generatedContent.append(RendererFactory.indentString(2, "</DIV>"));
                        }
                        this.generatedContent.append(RendererFactory.indentString(1, "</TD>"));
                    }
                    ++i;
                }
                this.generatedContent.append(RendererFactory.indentString(1, "</TR>"));
                ++j;
            }
            this.generatedContent.append("</TABLE>");
            this.generatedContent.append("<!-- Navigation Bar -->\n");
            Renderer navigationBarRenderer = this.getNavigationBarRenderer();
            if (navigationBarRenderer instanceof ContextRenderer) {
                ((ContextRenderer)navigationBarRenderer).setPageContext(this.fPageContext);
            }
            String navigationBarContent = navigationBarRenderer.render();
            this.generatedContent.append(navigationBarContent);
            this.generatedContent.append("\n");
            String formID = String.valueOf(table.getId()) + "_form";
            this.generatedContent.append("<FORM");
            this.generatedContent.append(' ');
            this.generatedContent.append(RendererFactory.createHtmlStylePropertyString("ID", formID));
            this.generatedContent.append(' ');
            this.generatedContent.append(RendererFactory.createHtmlStylePropertyString("METHOD", REQUEST_METHOD));
            if (table.getTarget() != null) {
                this.generatedContent.append(' ');
                this.generatedContent.append(RendererFactory.createHtmlStylePropertyString("TARGET", table.getTarget()));
            }
            this.generatedContent.append(' ');
            String jspPath = RendererFactory.getJSPPath(this.fPageContext);
            jspPath = RendererFactory.getEncodedURL(jspPath, this.fPageContext);
            this.generatedContent.append(RendererFactory.createHtmlStylePropertyString("ACTION", jspPath));
            this.generatedContent.append('>');
            Iterator params = table.getTableChangeRequest().getSupportedParams();
            while (params.hasNext()) {
                String param = (String)params.next();
                this.generatedContent.append(RendererFactory.indentString(2, TableRendererImpl.getHiddenFiled(param.toLowerCase())));
            }
            this.generatedContent.append(RendererFactory.indentString(2, TableRendererImpl.getHiddenFiled("tableID", table.getId())));
            this.generatedContent.append("</FORM>");
            ArrayList<String> jScriptParamList = new ArrayList<String>();
            jScriptParamList.add(formID);
            jScriptParamList.add(String.valueOf(table.getVisibleColumnsCount()));
            jScriptParamList.add(String.valueOf(table.getFirstRowIndexByCursor()));
            jScriptParamList.add(String.valueOf(table.getLastRowIndexByCursor()));
            jScriptParamList.add(String.valueOf(table.getColumnSortedKey()));
            jScriptParamList.add(String.valueOf(table.isColumnSortedAsc()));
            jScriptParamList.add(String.valueOf(table.isRowSelectionAllowed()));
            jScriptParamList.add(String.valueOf(table.isColumnSelectionAllowed()));
            jScriptParamList.add(String.valueOf(table.getRowSelectionType()));
            jScriptParamList.add(String.valueOf(table.getColumnSelectionType()));
            jScriptParamList.add(String.valueOf(table.getCursorPagesCount()));
            jScriptParamList.add(String.valueOf(table.getCursorCurrentPage()));
            String funcOnDataChanged = tableUIManager.getJScriptFunctionOnDataModelChanged();
            if (funcOnDataChanged == null) {
                funcOnDataChanged = AbstractTableRenderer.createEventFunction(table, "refresh");
            }
            jScriptParamList.add(RendererFactory.bracketString(funcOnDataChanged));
            jScriptParamList.add(String.valueOf(table.isShowHeader()));
            jScriptParamList.add(String.valueOf(table.getEditorMode() == 1));
            jScriptParamList.add(String.valueOf(table.isSimpleViewMode()));
            this.generatedContent.append(RendererFactory.createHtmlJScriptVariable((ComponentBase)table, TABLE_SCRIPT_FUNCTION, ((AbstractList)jScriptParamList).iterator()));
            this.generatedContent.append("<SCRIPT LANGUAGE=\"JavaScript\">");
            if (table.isRowSelectionAllowed() && (selectedRows = table.getRowSelectionModel().getSelectionIndexes()) != null && selectedRows.length > 0) {
                function = AbstractTableRenderer.initVariables(table, selectedRows, INIT_ROWMODEL);
                this.generatedContent.append(RendererFactory.indentString(1, function));
            }
            if (table.isColumnSelectionAllowed() && (selectedColumns = table.getColumnSelectionModel().getSelectionIndexes()) != null && selectedColumns.length > 0) {
                function = AbstractTableRenderer.initVariables(table, selectedColumns, INIT_COLUMNMODEL);
                this.generatedContent.append(RendererFactory.indentString(1, function));
            }
            if ((visibleColumns = table.getVisibleColumns()) != null && visibleColumns.length > 0) {
                function = AbstractTableRenderer.initVariables(table, visibleColumns, INIT_COLUMNS);
                this.generatedContent.append(RendererFactory.indentString(1, function));
            }
            if (editorMode == 0) {
                StringBuffer sBuffer = new StringBuffer();
                Iterator editableCells = table.getEditableCells();
                while (editableCells.hasNext()) {
                    int[] cell = (int[])editableCells.next();
                    sBuffer.append(cell[0]);
                    sBuffer.append(',');
                    sBuffer.append(cell[1]);
                    if (!editableCells.hasNext()) continue;
                    sBuffer.append(',');
                }
                if (sBuffer.length() > 0) {
                    String function2 = AbstractTableRenderer.initVariables(table, sBuffer.toString(), INIT_EDITED);
                    this.generatedContent.append(function2);
                }
            }
            if (!table.isSimpleViewMode()) {
                Iterator commands = ((AbstractList)this.fJsCommandArrayList).iterator();
                while (commands.hasNext()) {
                    String command = (String)commands.next();
                    this.generatedContent.append(RendererFactory.indentString(1, command));
                }
            }
            this.generatedContent.append("</SCRIPT>");
            String result = this.generatedContent.toString();
            if (table.isPageContextRendering()) {
                out.println(result);
            }
            return result;
        }
        catch (ListException e) {
            throw new IllegalStateException();
        }
        catch (Exception e) {
            throw new RendererException(e.getMessage());
        }
    }

    protected String getHeaderStartTDtag(Table aTable, int aColumnIndex) {
        String funcOnDblClick;
        String funcOnClick;
        String funcOnMouseOut;
        String horizontalBorderStyle;
        String verticalBorderStyle;
        boolean focused;
        boolean sorted;
        boolean selected;
        int background;
        String height;
        String hintText;
        int valign;
        InterfaceManager interfaceManager = aTable.getInterfaceManager();
        String headerId = RendererUtils.getTableHeaderId(aTable, aColumnIndex);
        ArrayList<HtmlProperty> propertyList = new ArrayList<HtmlProperty>();
        propertyList.add(new HtmlProperty("ID", headerId));
        int align = interfaceManager.getHeaderAlignMode(aColumnIndex);
        if (align != -1) {
            propertyList.add(new HtmlProperty("ALIGN", TagFactory.getAlignValue(align)));
        }
        if ((valign = interfaceManager.getHeaderValignMode(aColumnIndex)) != -1) {
            propertyList.add(new HtmlProperty("VALIGN", TagFactory.getValignValue(valign)));
        }
        if ((hintText = interfaceManager.getHeaderHintText(aColumnIndex)) != null) {
            propertyList.add(new HtmlProperty("TITLE", hintText));
        }
        if (aTable.isHeaderNoWrapMode()) {
            propertyList.add(new HtmlProperty("NOWRAP", null));
        }
        StringBuffer style = new StringBuffer();
        String width = aTable.getColumnPrefferedWidth(aColumnIndex);
        if (width != null) {
            style.append(RendererFactory.createHtmlStyleString("WIDTH", width));
        }
        if ((height = aTable.getHeaderHeight()) != null) {
            style.append(RendererFactory.createHtmlStyleString("HEIGHT", height));
        }
        if ((background = interfaceManager.getHeaderBackground(selected = aTable.isColumnSelected(aColumnIndex), sorted = aTable.isColumnSortKey(aColumnIndex), focused = false, aColumnIndex)) != 0) {
            String color = ColorFactory.convertColorFromIntToHtml(background);
            style.append(RendererFactory.createHtmlStyleString("BACKGROUND", color));
        }
        if ((verticalBorderStyle = aTable.getVerticalBorderStyle()) != null && aColumnIndex < aTable.getVisibleColumnsCount() - 1) {
            style.append(RendererFactory.createHtmlStyleString("BORDER-RIGHT", verticalBorderStyle));
        }
        if ((horizontalBorderStyle = aTable.getHorizontalBorderStyle()) != null) {
            style.append(RendererFactory.createHtmlStyleString("BORDER-BOTTOM", horizontalBorderStyle));
        }
        if (style.length() > 0) {
            propertyList.add(new HtmlProperty("STYLE", style.toString()));
        }
        StringBuffer sBuffer = new StringBuffer("<TD");
        Iterator htmlProperties = ((AbstractList)propertyList).iterator();
        while (htmlProperties.hasNext()) {
            sBuffer.append(' ');
            HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
            sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
        }
        String funcOnMouseOver = AbstractTableRenderer.createEventFunction(interfaceManager.getHeaderJScriptFunctionOnMouseOver(aColumnIndex), aColumnIndex);
        if (funcOnMouseOver == null && aTable.isHeaderHighLightAllowed()) {
            funcOnMouseOver = AbstractTableRenderer.createEventFunction(aTable, "header_focus", aColumnIndex);
        }
        if (funcOnMouseOver != null) {
            sBuffer.append(' ');
            sBuffer.append(RendererUtils.createHtmlEvent(5, funcOnMouseOver));
        }
        if ((funcOnMouseOut = AbstractTableRenderer.createEventFunction(interfaceManager.getHeaderJScriptFunctionOnMouseOut(aColumnIndex), aColumnIndex)) == null && aTable.isHeaderHighLightAllowed()) {
            funcOnMouseOut = AbstractTableRenderer.createEventFunction(aTable, "header_blur", aColumnIndex);
        }
        if (funcOnMouseOut != null) {
            sBuffer.append(' ');
            sBuffer.append(RendererUtils.createHtmlEvent(3, funcOnMouseOut));
        }
        if ((funcOnClick = AbstractTableRenderer.createEventFunction(interfaceManager.getHeaderJScriptFunctionOnClick(aColumnIndex), aColumnIndex)) == null && aTable.isColumnSelectionAllowed()) {
            funcOnClick = AbstractTableRenderer.createEventFunction(aTable, "columnSelection", aColumnIndex);
        }
        if (funcOnClick != null) {
            sBuffer.append(' ');
            sBuffer.append(RendererUtils.createHtmlEvent(22, funcOnClick));
        }
        if ((funcOnDblClick = AbstractTableRenderer.createEventFunction(interfaceManager.getHeaderJScriptFunctionOnDblClick(aColumnIndex), aColumnIndex)) == null && aTable.isColumnSortSupported(aColumnIndex)) {
            funcOnDblClick = AbstractTableRenderer.createEventFunction(aTable, "changeSortColumn", aColumnIndex);
        }
        if (funcOnDblClick != null) {
            sBuffer.append(' ');
            sBuffer.append(RendererUtils.createHtmlEvent(1, funcOnDblClick));
        }
        sBuffer.append('>');
        return sBuffer.toString();
    }

    protected String getCellStartTDtag(Table aTable, int aRowIndex, int aColumnIndex) {
        String funcOnDblClick;
        String funcOnClick;
        String funcOnMouseOut;
        String horizontalBorderStyle;
        String verticalBorderStyle;
        boolean focused;
        boolean selected;
        int background;
        String height;
        String hintText;
        int valign;
        InterfaceManager interfaceManager = aTable.getInterfaceManager();
        String cellId = RendererUtils.getTableCellId(aTable, aRowIndex, aColumnIndex);
        ArrayList<HtmlProperty> propertyList = new ArrayList<HtmlProperty>();
        propertyList.add(new HtmlProperty("ID", cellId));
        int align = interfaceManager.getCellAlignMode(aRowIndex, aColumnIndex);
        if (align != -1) {
            propertyList.add(new HtmlProperty("ALIGN", TagFactory.getAlignValue(align)));
        }
        if ((valign = interfaceManager.getCellValignMode(aRowIndex, aColumnIndex)) != -1) {
            propertyList.add(new HtmlProperty("VALIGN", TagFactory.getValignValue(valign)));
        }
        if ((hintText = interfaceManager.getCellHintText(aRowIndex, aColumnIndex)) != null) {
            propertyList.add(new HtmlProperty("TITLE", hintText));
        }
        StringBuffer style = new StringBuffer();
        if (aRowIndex == 0 && !aTable.isShowHeader()) {
            String width = aTable.getColumnPrefferedWidth(aColumnIndex);
            if (width != null) {
                style.append(RendererFactory.createHtmlStyleString("WIDTH", width));
            }
            if (aTable.isHeaderNoWrapMode()) {
                propertyList.add(new HtmlProperty("NOWRAP", null));
            }
        } else if (aTable.isColumnNoWrapMode(aColumnIndex)) {
            propertyList.add(new HtmlProperty("NOWRAP", null));
        }
        if ((height = interfaceManager.getRowHeight(aRowIndex)) != null) {
            style.append(RendererFactory.createHtmlStyleString("HEIGHT", height));
        }
        if ((background = interfaceManager.getCellBackground(selected = aTable.isCellSelected(aRowIndex, aColumnIndex), focused = false, false, aRowIndex, aColumnIndex)) != 0) {
            String color = ColorFactory.convertColorFromIntToHtml(background);
            style.append(RendererFactory.createHtmlStyleString("BACKGROUND", color));
        }
        if ((verticalBorderStyle = aTable.getVerticalBorderStyle()) != null && aColumnIndex < aTable.getVisibleColumnsCount() - 1) {
            style.append(RendererFactory.createHtmlStyleString("BORDER-RIGHT", verticalBorderStyle));
        }
        if ((horizontalBorderStyle = aTable.getHorizontalBorderStyle()) != null && aRowIndex < aTable.getLastRowIndexByCursor()) {
            style.append(RendererFactory.createHtmlStyleString("BORDER-BOTTOM", horizontalBorderStyle));
        }
        if (style.length() > 0) {
            propertyList.add(new HtmlProperty("STYLE", style.toString()));
        }
        StringBuffer sBuffer = new StringBuffer("<TD");
        Iterator htmlProperties = ((AbstractList)propertyList).iterator();
        while (htmlProperties.hasNext()) {
            sBuffer.append(' ');
            HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
            sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
        }
        String funcOnMouseOver = AbstractTableRenderer.createEventFunction(interfaceManager.getCellJScriptFunctionOnMouseOver(aRowIndex, aColumnIndex), aRowIndex, aColumnIndex);
        if (funcOnMouseOver == null && aTable.isColumnHighLightAllowed(aColumnIndex)) {
            funcOnMouseOver = AbstractTableRenderer.createEventFunction(aTable, "cell_focus", aRowIndex, aColumnIndex);
        }
        if (funcOnMouseOver != null) {
            sBuffer.append(' ');
            sBuffer.append(RendererUtils.createHtmlEvent(5, funcOnMouseOver));
        }
        if ((funcOnMouseOut = AbstractTableRenderer.createEventFunction(interfaceManager.getCellJScriptFunctionOnMouseOut(aRowIndex, aColumnIndex), aRowIndex, aColumnIndex)) == null && aTable.isColumnHighLightAllowed(aColumnIndex)) {
            funcOnMouseOut = AbstractTableRenderer.createEventFunction(aTable, "cell_blur", aRowIndex, aColumnIndex);
        }
        if (funcOnMouseOut != null) {
            sBuffer.append(' ');
            sBuffer.append(RendererUtils.createHtmlEvent(3, funcOnMouseOut));
        }
        if ((funcOnClick = AbstractTableRenderer.createEventFunction(interfaceManager.getCellJScriptFunctionOnClick(aRowIndex, aColumnIndex), aRowIndex, aColumnIndex)) == null) {
            if (aTable.isRowSelectionAllowed()) {
                funcOnClick = AbstractTableRenderer.createEventFunction(aTable, "rowSelection", aRowIndex, -1);
            }
            if (aTable.isColumnSelectionAllowed()) {
                funcOnClick = String.valueOf(funcOnClick) + AbstractTableRenderer.createEventFunction(aTable, "columnSelection", aColumnIndex);
            }
        }
        if (funcOnClick != null) {
            sBuffer.append(' ');
            sBuffer.append(RendererUtils.createHtmlEvent(22, funcOnClick));
        }
        if ((funcOnDblClick = AbstractTableRenderer.createEventFunction(interfaceManager.getCellJScriptFunctionOnDblClick(aRowIndex, aColumnIndex), aRowIndex, aColumnIndex)) == null && aTable.isCellEditable(aRowIndex, aColumnIndex) && aTable.getEditorMode() == 1) {
            funcOnDblClick = AbstractTableRenderer.createEventFunction(aTable, "setEditMode", aRowIndex, aColumnIndex);
        }
        if (funcOnDblClick != null) {
            sBuffer.append(' ');
            sBuffer.append(RendererUtils.createHtmlEvent(1, funcOnDblClick));
        }
        sBuffer.append('>');
        return sBuffer.toString();
    }

    protected ArrayList getTableUniqPropertiesList(Table aTable) {
        ArrayList<HtmlProperty> uniqProperies = new ArrayList<HtmlProperty>();
        if (aTable.getBorder() != -1) {
            uniqProperies.add(new HtmlProperty("BORDER", aTable.getBorder()));
        }
        if (aTable.getCellPadding() != -1) {
            uniqProperies.add(new HtmlProperty("CELLPADDING", aTable.getCellPadding()));
        }
        if (aTable.getCellSpacing() != -1) {
            uniqProperies.add(new HtmlProperty("CELLSPACING", aTable.getCellSpacing()));
        }
        if (aTable.getBorderColor() != 0) {
            String color = ColorFactory.convertColorFromIntToHtml(aTable.getBorderColor());
            uniqProperies.add(new HtmlProperty("BORDERCOLOR", color));
        }
        if (aTable.getFrame() != -1) {
            String frame = RendererUtils.getFramesValue(aTable.getFrame());
            uniqProperies.add(new HtmlProperty("FRAME", frame));
        }
        if (aTable.getRules() != -1) {
            String rules = RendererUtils.getRulesValue(aTable.getRules());
            uniqProperies.add(new HtmlProperty("RULES", rules));
        }
        if (aTable.getBackGround() != null) {
            uniqProperies.add(new HtmlProperty("BACKGROUND", aTable.getBackGround()));
        }
        return uniqProperies;
    }

    protected static String getHiddenFiled(String aName, String aValue) {
        StringBuffer sBuffer = new StringBuffer("<INPUT");
        sBuffer.append(' ');
        sBuffer.append(RendererFactory.createHtmlStylePropertyString("NAME", aName));
        sBuffer.append(' ');
        sBuffer.append(RendererFactory.createHtmlStylePropertyString("TYPE", "HIDDEN"));
        if (aValue != null) {
            sBuffer.append(' ');
            sBuffer.append(RendererFactory.createHtmlStylePropertyString("VALUE", aValue));
        }
        sBuffer.append('>');
        return sBuffer.toString();
    }

    protected static String getHiddenFiled(String aName) {
        return TableRendererImpl.getHiddenFiled(aName, null);
    }

    protected String renderCell(Table aTable, int aRow, int aColumn, boolean aEditMode) throws RendererException {
        CellRenderer tableCellRenderer = aEditMode ? aTable.getCellEditor(aRow, aColumn) : aTable.getCellRenderer(aRow, aColumn);
        tableCellRenderer.setTable(aTable);
        tableCellRenderer.setColumnIndex(aColumn);
        tableCellRenderer.setRowIndex(aRow);
        return RendererFactory.componentRender(tableCellRenderer, this.fPageContext);
    }

    protected String renderHeader(Table aTable, int aColumn) throws RendererException {
        HeaderRenderer headerRenderer = aTable.getColumnHeaderRenderer(aColumn);
        headerRenderer.setTable(aTable);
        headerRenderer.setColumnIndex(aColumn);
        return RendererFactory.componentRender(headerRenderer, this.fPageContext);
    }

    protected String getDIVstartTag(String aCellId, boolean aVisible) {
        StringBuffer sBuffer = new StringBuffer("<DIV");
        sBuffer.append(' ');
        String id = String.valueOf(aCellId) + (aVisible ? "_view" : "_hide");
        sBuffer.append(RendererFactory.createHtmlStylePropertyString("ID", id));
        sBuffer.append(' ');
        String style = "OVERFLOW:hidden; DISPLAY:" + (aVisible ? "block" : "none");
        sBuffer.append(RendererFactory.createHtmlStylePropertyString("STYLE", style));
        sBuffer.append('>');
        return sBuffer.toString();
    }

    public Renderer getNavigationBarRenderer() {
        return this.navigationBarRenderer;
    }

    public void setNavigationBarRenderer(Renderer navigationBarRenderer) {
        this.navigationBarRenderer = navigationBarRenderer;
    }
}

