/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.components.table.InterfaceManager;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.table.AbstractTableRenderer;
import com.softaspects.galileo.client.jsp.html.base.ColorFactory;
import java.io.IOException;
import javax.servlet.jsp.JspWriter;

public class InterfaceManagerRenderer
extends AbstractTableRenderer {
    private StringBuffer generatedContent = null;

    public String doRender() throws RendererException {
        Table table = this.getTable();
        InterfaceManager interfaceManager = table.getInterfaceManager();
        JspWriter out = this.fPageContext.getOut();
        String interfaceManagerId = String.valueOf(table.getId()) + "_interfaceManager_";
        String result = null;
        this.generatedContent = new StringBuffer();
        try {
            this.generatedContent.append("<SCRIPT LANGUAGE=\"JavaScript\">");
            this.generatedContent.append(this.renderHeaderFunction(String.valueOf(interfaceManagerId) + "getHeaderBackground", interfaceManager.getHeaderDefaultBackground(), interfaceManager.getHeaderSortedBackground(), interfaceManager.getHeaderFocusedBackground(), interfaceManager.getHeaderSelectedBackground()));
            this.generatedContent.append("\n");
            if (!table.isSimpleViewMode()) {
                this.generatedContent.append(this.renderHeaderFunction(String.valueOf(interfaceManagerId) + "getHeaderForeground", interfaceManager.getHeaderDefaultForeground(), interfaceManager.getHeaderSortedForeground(), interfaceManager.getHeaderFocusedForeground(), interfaceManager.getHeaderSelectedForeground()));
                this.generatedContent.append("\n");
            }
            int step = interfaceManager.getCellAltStep();
            this.generatedContent.append(this.renderCellFunction(String.valueOf(interfaceManagerId) + "getCellBackground", interfaceManager.getCellDefaultBackground(), interfaceManager.getCellAltBackground(), interfaceManager.getCellEditedBackground(), interfaceManager.getCellFocusedBackground(), interfaceManager.getCellSelectedBackground(), step));
            this.generatedContent.append("\n");
            if (!table.isSimpleViewMode()) {
                this.generatedContent.append(this.renderCellFunction(String.valueOf(interfaceManagerId) + "getCellForeground", interfaceManager.getCellDefaultForeground(), interfaceManager.getCellAltForeground(), interfaceManager.getCellEditedForeground(), interfaceManager.getCellFocusedForeground(), interfaceManager.getCellSelectedForeground(), step));
            }
            this.generatedContent.append("</SCRIPT>");
            this.generatedContent.append("\n");
            result = this.generatedContent.toString();
            if (interfaceManager.isPageContextRendering()) {
                out.println(result);
            }
        }
        catch (IOException e) {
            throw new RendererException(e.toString());
        }
        return result;
    }

    protected String renderHeaderFunction(String aFunctionName, int aDefaultColor, int aSortedColor, int aFocusedColor, int aSelectedColor) throws IOException {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(InterfaceManagerRenderer.initFunction(aFunctionName, "aSelected, aSorted, aFocused, aColumnIndex"));
        sBuffer.append('{');
        sBuffer.append(RendererFactory.indentString(1, "var colors = new Array();"));
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.initColorsArray(0, aDefaultColor)));
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.initColorsArray(2, aSelectedColor)));
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.initColorsArray(1, aSortedColor)));
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.initColorsArray(3, aFocusedColor)));
        sBuffer.append("\n");
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.initKeyVariable(0)));
        sBuffer.append("\n");
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.ifValue("aFocused", 3)));
        sBuffer.append(RendererFactory.indentString(2, "else"));
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.ifValue("aSelected", 2)));
        sBuffer.append(RendererFactory.indentString(2, "else"));
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.ifValue("aSorted", 1)));
        sBuffer.append("\n");
        sBuffer.append(InterfaceManagerRenderer.outWhile());
        sBuffer.append(InterfaceManagerRenderer.outEndOfFunction());
        return sBuffer.toString();
    }

    protected String renderCellFunction(String aFunctionName, int aDefaultColor, int aAltColor, int aEditedColor, int aFocusedColor, int aSelectedColor, int aStep) throws IOException {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(InterfaceManagerRenderer.initFunction(aFunctionName, "aSelected, aFocused, aEdited, aRowIndex, aColumnIndex"));
        sBuffer.append('{');
        sBuffer.append(RendererFactory.indentString(1, "var colors = new Array();"));
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.initColorsArray(0, aDefaultColor)));
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.initColorsArray(1, aEditedColor)));
        if (aStep > 0 && aAltColor != 0) {
            sBuffer.append("\n");
            sBuffer.append("if ( ");
            sBuffer.append(InterfaceManagerRenderer.getCompareToStep("aRowIndex", aStep));
            sBuffer.append(" ) { ");
            sBuffer.append(InterfaceManagerRenderer.initColorsArray(0, aAltColor));
            sBuffer.append(" }");
            sBuffer.append("\n");
        }
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.initColorsArray(3, aFocusedColor)));
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.initColorsArray(2, aSelectedColor)));
        sBuffer.append("\n");
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.initKeyVariable(0)));
        sBuffer.append("\n");
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.ifValue("aEdited", 1)));
        sBuffer.append(RendererFactory.indentString(2, "else"));
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.ifValue("aFocused", 3)));
        sBuffer.append(RendererFactory.indentString(2, "else"));
        sBuffer.append(RendererFactory.indentString(1, InterfaceManagerRenderer.ifValue("aSelected", 2)));
        sBuffer.append("\n");
        sBuffer.append(InterfaceManagerRenderer.outWhile());
        sBuffer.append(InterfaceManagerRenderer.outEndOfFunction());
        return sBuffer.toString();
    }

    protected static String initColorsArray(int aIndex, int aValue) {
        StringBuffer sBuffer = new StringBuffer("colors[");
        sBuffer.append(aIndex);
        sBuffer.append("] = ");
        String color = ColorFactory.convertColorFromIntToHtml(aValue);
        sBuffer.append(RendererFactory.bracketString(color));
        sBuffer.append(';');
        return sBuffer.toString();
    }

    protected static String ifValue(String aVariable, int aValue) {
        StringBuffer sBuffer = new StringBuffer("if ( ");
        sBuffer.append(aVariable);
        sBuffer.append(" ) key = ");
        sBuffer.append(aValue);
        sBuffer.append(';');
        return sBuffer.toString();
    }

    protected static String initKeyVariable(int aValue) {
        StringBuffer sBuffer = new StringBuffer("var key =");
        sBuffer.append(aValue);
        sBuffer.append(';');
        return sBuffer.toString();
    }

    protected static String initFunction(String aFunctionName, String aParam) {
        StringBuffer sBuffer = new StringBuffer("function");
        sBuffer.append(' ');
        sBuffer.append(aFunctionName);
        sBuffer.append('(');
        sBuffer.append(aParam);
        sBuffer.append(')');
        return sBuffer.toString();
    }

    protected static String outWhile() throws IOException {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(RendererFactory.indentString(1, "while(key >= 0)"));
        sBuffer.append(RendererFactory.indentString(1, "{"));
        sBuffer.append(RendererFactory.indentString(2, "if (colors[key] != null && colors[key] != \"\")"));
        sBuffer.append(RendererFactory.indentString(2, "{"));
        sBuffer.append(RendererFactory.indentString(3, "return colors[key];"));
        sBuffer.append(RendererFactory.indentString(2, "}"));
        sBuffer.append(RendererFactory.indentString(2, "key--;"));
        sBuffer.append(RendererFactory.indentString(1, "}"));
        return sBuffer.toString();
    }

    protected static String outEndOfFunction() throws IOException {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(RendererFactory.indentString(1, "return '' ;"));
        sBuffer.append('}');
        return sBuffer.toString();
    }

    protected static String getCompareToStep(String aVarName, int aStep) {
        StringBuffer sBuffer = new StringBuffer("Math.floor(");
        sBuffer.append(aVarName);
        if (aStep > 1) {
            sBuffer.append('/');
            sBuffer.append(aStep);
        }
        sBuffer.append(") % 2 == 1");
        return sBuffer.toString();
    }

    protected static String getNotCompareToStep(String aVarName, int aStep) {
        StringBuffer sBuffer = new StringBuffer("Math.floor(");
        sBuffer.append(aVarName);
        if (aStep > 1) {
            sBuffer.append('/');
            sBuffer.append(aStep);
        }
        sBuffer.append(") % 2 != 1");
        return sBuffer.toString();
    }
}

