/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.components.table.InterfaceManager;
import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.base.HtmlProperty;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.table.BaseHeaderRenderer;
import com.softaspects.galileo.client.jsp.html.base.TagFactory;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class DefaultHeaderRenderer
extends BaseHeaderRenderer {
    public String makeRender() throws RendererException {
        int columnIndex = this.getColumnIndex();
        Table table = this.getTable();
        StringBuffer sBuffer = new StringBuffer();
        try {
            sBuffer.append(RendererFactory.indentString(3, this.getTableStartTag()));
            sBuffer.append(RendererFactory.indentString(4, "<TR>"));
            sBuffer.append(RendererFactory.indentString(5, this.getTDStartTag()));
            sBuffer.append(super.makeRender());
            if (table.isColumnSortSupported(columnIndex)) {
                InterfaceManager interfaceManager = table.getInterfaceManager();
                boolean ascMode = table.isColumnSortedAsc();
                boolean sorted = table.isColumnSortKey(columnIndex);
                String image = interfaceManager.getHeaderImage(sorted, ascMode, columnIndex);
                if (image == null) {
                    image = interfaceManager.getHeaderUnSortedImage();
                }
                sBuffer.append("&nbsp;&nbsp;");
                sBuffer.append("<IMG");
                sBuffer.append(' ');
                sBuffer.append(RendererFactory.createHtmlStylePropertyString("SRC", image));
                String altText = interfaceManager.getHeaderAltText(sorted, ascMode, columnIndex);
                if (altText != null) {
                    sBuffer.append(' ');
                    sBuffer.append(RendererFactory.createHtmlStylePropertyString("ALT", altText));
                }
                sBuffer.append('>');
            }
            sBuffer.append(RendererFactory.indentString(5, "</TD>"));
            sBuffer.append(RendererFactory.indentString(4, "</TR>"));
            sBuffer.append(RendererFactory.indentString(3, "</TABLE>"));
        }
        catch (Exception e) {
            throw new RendererException(e.toString());
        }
        return sBuffer.toString();
    }

    protected String getTableStartTag() {
        StringBuffer sBuffer = new StringBuffer("<TABLE");
        ArrayList<HtmlProperty> propertyList = new ArrayList<HtmlProperty>();
        propertyList.add(new HtmlProperty("BORDER", 0));
        propertyList.add(new HtmlProperty("CELLPADDING", 0));
        propertyList.add(new HtmlProperty("CELLSPACING", 0));
        propertyList.add(new HtmlProperty("WIDTH", "100%"));
        propertyList.add(new HtmlProperty("HEIGHT", "100%"));
        Iterator htmlProperties = ((AbstractList)propertyList).iterator();
        while (htmlProperties.hasNext()) {
            sBuffer.append(' ');
            HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
            sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
        }
        sBuffer.append(" STYLE=\"CURSOR:HAND\" ");
        sBuffer.append('>');
        return sBuffer.toString();
    }

    protected String getTDStartTag() {
        Table table = this.getTable();
        int columnIndex = this.getColumnIndex();
        InterfaceManager interfaceManager = table.getInterfaceManager();
        int align = interfaceManager.getHeaderAlignMode(columnIndex);
        int valign = interfaceManager.getHeaderValignMode(columnIndex);
        ArrayList<HtmlProperty> propertyList = new ArrayList<HtmlProperty>();
        propertyList.add(new HtmlProperty("WIDTH", "100%"));
        if (align != -1) {
            propertyList.add(new HtmlProperty("ALIGN", TagFactory.getAlignValue(align)));
        }
        if (valign != -1) {
            propertyList.add(new HtmlProperty("VALIGN", TagFactory.getValignValue(valign)));
        }
        if (table.isHeaderNoWrapMode()) {
            propertyList.add(new HtmlProperty("NOWRAP", null));
        }
        StringBuffer sBuffer = new StringBuffer("<TD");
        Iterator htmlProperties = ((AbstractList)propertyList).iterator();
        while (htmlProperties.hasNext()) {
            sBuffer.append(' ');
            HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
            sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
        }
        sBuffer.append('>');
        return sBuffer.toString();
    }
}

