/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.table;

import com.softaspects.framework.galileo.components.table.Table;
import com.softaspects.framework.galileo.renderers.html.base.ContextRendererImpl;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.renderers.html.table.TableRenderer;
import java.util.ArrayList;

public abstract class AbstractTableRenderer
extends ContextRendererImpl
implements TableRenderer {
    protected static final String HEADER_OnDblClick = "changeSortColumn";
    protected static final String HEADER_OnClick = "columnSelection";
    protected static final String HEADER_onMouseOver = "header_focus";
    protected static final String HEADER_onMouseOut = "header_blur";
    protected static final String CELL_OnDblClick = "setEditMode";
    protected static final String CELL_OnClick_1 = "rowSelection";
    protected static final String CELL_OnClick_2 = "columnSelection";
    protected static final String CELL_onMouseOver = "cell_focus";
    protected static final String CELL_onMouseOut = "cell_blur";
    protected static final String JS_onDataChanged = "refresh";
    protected static final int VALUE_NOT_GIVEN = -1;
    protected static final int EVENT_ONMOUSEOVER = 5;
    protected static final int EVENT_ONMOUSEOUT = 3;
    protected static final int EVENT_ONCLICK = 22;
    protected static final int EVENT_ONDBLCLICK = 1;
    protected static final int EVENT_ONBLUR = 8;
    protected static final int EVENT_ONFOCUS = 13;
    protected ArrayList fJsCommandArrayList = null;

    public void setTable(Table aTable) {
        if (aTable == null) {
            throw new IllegalArgumentException("TableRenderer: Table can't be null.");
        }
        this.setComponent(aTable);
    }

    public Table getTable() {
        if (this.getComponent() == null) {
            throw new IllegalStateException("TableRenderer: Uses setTable to init renderer.");
        }
        return (Table)this.getComponent();
    }

    public void addJScriptCommamd(String aJsCommand) {
        if (aJsCommand != null && aJsCommand.length() > 0) {
            if (this.fJsCommandArrayList == null) {
                Table table = this.getTable();
                int rowCount = table.isShowHeader() ? 1 : 0;
                this.fJsCommandArrayList = new ArrayList(table.getVisibleColumnsCount() * (rowCount += table.getRowCount() > table.getCursorPageSize() ? table.getCursorPageSize() : table.getRowCount()));
            }
            this.fJsCommandArrayList.add(aJsCommand);
        }
    }

    protected static String createEventFunction(Table aTable, String aFunction) {
        if (aFunction != null) {
            StringBuffer sBuffer = new StringBuffer();
            if (aTable != null) {
                sBuffer.append(RendererFactory.createJScriptVariableName(aTable));
                sBuffer.append('.');
            }
            sBuffer.append(aFunction);
            return sBuffer.toString();
        }
        return null;
    }

    protected static String createEventFunction(Table aTable, String aFunction, int aRowIndex, int aColumnIndex) {
        if (aFunction != null) {
            String tryBlockBegin = "";
            String tryBlockEnd = "";
            if (HEADER_onMouseOver.equalsIgnoreCase(aFunction) || HEADER_onMouseOut.equalsIgnoreCase(aFunction) || CELL_onMouseOver.equalsIgnoreCase(aFunction) || CELL_onMouseOut.equalsIgnoreCase(aFunction)) {
                tryBlockBegin = "try{";
                tryBlockEnd = "}catch(e){}";
            }
            StringBuffer sBuffer = new StringBuffer(tryBlockBegin);
            String function = aFunction.trim();
            if (function.endsWith(";")) {
                function = function.substring(0, function.length() - 1).trim();
            }
            if (function.endsWith(")")) {
                function = function.substring(0, function.length() - 1).trim();
                sBuffer.append(AbstractTableRenderer.createEventFunction(aTable, function));
                if (!function.endsWith("(")) {
                    sBuffer.append(',');
                }
            } else {
                sBuffer.append(AbstractTableRenderer.createEventFunction(aTable, function));
                sBuffer.append('(');
            }
            if (aRowIndex != -1) {
                sBuffer.append(aRowIndex);
                if (aColumnIndex != -1) {
                    sBuffer.append(',');
                    sBuffer.append(aColumnIndex);
                }
            } else if (aColumnIndex != -1) {
                sBuffer.append(aColumnIndex);
            }
            sBuffer.append(");");
            sBuffer.append(tryBlockEnd);
            return sBuffer.toString();
        }
        return null;
    }

    protected static String createEventFunction(String aFunction, int aRow, int aColumn) {
        return AbstractTableRenderer.createEventFunction(null, aFunction, aRow, aColumn);
    }

    protected static String createEventFunction(Table aTable, String aFunction, int aColumn) {
        return AbstractTableRenderer.createEventFunction(aTable, aFunction, -1, aColumn);
    }

    protected static String createEventFunction(String aFunction, int aColumnIndex) {
        return AbstractTableRenderer.createEventFunction(null, aFunction, aColumnIndex);
    }

    protected static String initVariables(Table aTable, String aArgumnet, String aFunction) {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(RendererFactory.createJScriptVariableName(aTable));
        sBuffer.append('.');
        sBuffer.append(aFunction);
        sBuffer.append('(');
        if (aArgumnet != null) {
            sBuffer.append(aArgumnet);
        }
        sBuffer.append(");");
        return sBuffer.toString();
    }

    protected static String initVariables(Table aTable, int[] aValues, String aFunction) {
        StringBuffer sBuffer = new StringBuffer();
        if (aValues != null) {
            int i = 0;
            while (i < aValues.length) {
                sBuffer.append(aValues[i]);
                if (i < aValues.length - 1) {
                    sBuffer.append(',');
                }
                ++i;
            }
        }
        return AbstractTableRenderer.initVariables(aTable, sBuffer.toString(), aFunction);
    }

    protected static String createJsCommand(String aPrefix, String aId, String aJScriptComponent, String aParams) {
        StringBuffer sBuffer = new StringBuffer("var");
        sBuffer.append(' ');
        sBuffer.append(RendererFactory.createJScriptVariableName(aPrefix, aId));
        sBuffer.append("= new");
        sBuffer.append(' ');
        sBuffer.append(aJScriptComponent);
        sBuffer.append('(');
        sBuffer.append(RendererFactory.bracketString(aId));
        if (aParams != null) {
            sBuffer.append(',');
            sBuffer.append(aParams);
        }
        sBuffer.append(')');
        sBuffer.append(';');
        return sBuffer.toString();
    }

    protected static String createJsCommand(String aPrefix, String aId, String aJScriptComponent) {
        return AbstractTableRenderer.createJsCommand(aPrefix, aId, aJScriptComponent, null);
    }

    protected Object generateExceptionIfTypeNotCompartable(int aRow, int aColumn, Object aValue) {
        StringBuffer sBuffer = new StringBuffer("TableRenderer: Type of renderer don't compartable with data type.");
        sBuffer.append(' ');
        sBuffer.append("Row:");
        sBuffer.append(aRow);
        sBuffer.append(' ');
        sBuffer.append("Column:");
        sBuffer.append(aColumn);
        sBuffer.append(' ');
        sBuffer.append("Type:");
        if (aValue == null) {
            sBuffer.append("null");
        } else {
            sBuffer.append(aValue.getClass().getName());
        }
        throw new IllegalStateException(sBuffer.toString());
    }
}

