/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.input;

import com.softaspects.framework.galileo.components.base.ComponentBase;
import com.softaspects.framework.galileo.components.base.PresentationEvent;
import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.renderers.html.base.ContextRenderer;
import com.softaspects.framework.galileo.renderers.html.base.ContextRendererImpl;
import com.softaspects.framework.galileo.renderers.html.base.HtmlProperty;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptProviderBase;
import com.softaspects.framework.galileo.renderers.html.base.JavaScriptResource;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.support.components.input.InputImpl;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;

public abstract class InputRendererWorker
extends ContextRendererImpl
implements ContextRenderer {
    private static final String INPUT_MODEL_SCRIPT_WAS_LOADED = "INPUT_MODEL_SCRIPT_WAS_LOADED";
    private static final String JS_INPUT_COMPONENT = "InputComponent";
    InputImpl fInputComponent = null;

    public String doRender() throws RendererException {
        JspWriter out = this.fPageContext.getOut();
        this.fInputComponent = (InputImpl)this.getComponent();
        try {
            StringBuffer sBuffer = new StringBuffer();
            Object flag = this.fPageContext.getAttribute(INPUT_MODEL_SCRIPT_WAS_LOADED, 2);
            if (flag == null) {
                JavaScriptResource javaScriptResource = new JavaScriptProviderBase().getJavaScriptResource((HttpServletRequest)this.fPageContext.getRequest());
                sBuffer.append(RendererFactory.createJScriptBeginTag(javaScriptResource.getComponentJavaScriptSource(this.fInputComponent.getComponentTypeName()), null));
                sBuffer.append(RendererFactory.createJScriptEndTag());
                sBuffer.append("\n");
                this.fPageContext.setAttribute(INPUT_MODEL_SCRIPT_WAS_LOADED, (Object)INPUT_MODEL_SCRIPT_WAS_LOADED, 2);
            }
            String specificRenderResult = this.doSpecificRender();
            sBuffer.append(specificRenderResult);
            Iterator htmlProperties = RendererFactory.componentHtmlPropertiesIterator(this.fInputComponent);
            while (htmlProperties.hasNext()) {
                HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
                sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
                sBuffer.append(' ');
            }
            if (!this.fInputComponent.isEditable()) {
                HtmlProperty htmlPropertyOne = new HtmlProperty("READONLY", this.fInputComponent.isEditable());
                sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlPropertyOne));
                sBuffer.append(' ');
            }
            HtmlProperty htmlPropertyTwo = new HtmlProperty("SIZE", this.fInputComponent.getSize());
            sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlPropertyTwo));
            sBuffer.append(' ');
            HtmlProperty htmlPropertyThree = new HtmlProperty("VALUE", this.fInputComponent.getDataModel().getValue());
            sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlPropertyThree));
            sBuffer.append(' ');
            Iterator presentationEvents = this.fInputComponent.getPresentationEvents();
            while (presentationEvents.hasNext()) {
                PresentationEvent presentationEvent = (PresentationEvent)presentationEvents.next();
                String type = RendererFactory.getPresentationEventName(presentationEvent.getType());
                String value = presentationEvent.getValue();
                sBuffer.append(RendererFactory.createHtmlStylePropertyString(type, value));
                sBuffer.append(' ');
            }
            sBuffer.append(">");
            String params = String.valueOf(this.fInputComponent.isFocused());
            sBuffer.append(RendererFactory.createHtmlJScriptVariable((ComponentBase)this.fInputComponent, JS_INPUT_COMPONENT, params));
            String result = sBuffer.toString();
            if (this.fInputComponent.isPageContextRendering()) {
                out.println(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RendererException(e.toString());
        }
    }

    abstract String doSpecificRender();
}

