/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.renderers.html.anc;

import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.renderers.html.base.ContextRendererImpl;
import com.softaspects.framework.galileo.renderers.html.base.HtmlProperty;
import com.softaspects.framework.galileo.renderers.html.base.RendererFactory;
import com.softaspects.framework.galileo.support.components.anc.Anc;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.jsp.JspWriter;

public class AnchorComponentRenderer
extends ContextRendererImpl {
    public String doRender() throws RendererException {
        JspWriter out = this.fPageContext.getOut();
        Anc anchor = (Anc)this.getComponent();
        try {
            StringBuffer sBuffer = new StringBuffer("<A");
            Iterator htmlProperties = RendererFactory.componentBaseHtmlPropertiesIterator(anchor);
            while (htmlProperties.hasNext()) {
                sBuffer.append(' ');
                HtmlProperty htmlProperty = (HtmlProperty)htmlProperties.next();
                sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
            }
            ArrayList<HtmlProperty> aList = new ArrayList<HtmlProperty>();
            if (anchor.getHref() != null) {
                String encodedHref = RendererFactory.getEncodedURL(anchor.getHref(), this.fPageContext);
                aList.add(new HtmlProperty("HREF", encodedHref));
            }
            if (anchor.getRel() != null) {
                aList.add(new HtmlProperty("REL", anchor.getRel()));
            }
            if (anchor.getRev() != null) {
                aList.add(new HtmlProperty("REV", anchor.getRev()));
            }
            if (anchor.getTarget() != null) {
                aList.add(new HtmlProperty("TARGET", anchor.getTarget()));
            }
            Iterator uniqHtmlProperty = ((AbstractList)aList).iterator();
            while (uniqHtmlProperty.hasNext()) {
                sBuffer.append(' ');
                HtmlProperty htmlProperty = (HtmlProperty)uniqHtmlProperty.next();
                sBuffer.append(RendererFactory.createHtmlStylePropertyString(htmlProperty));
            }
            sBuffer.append('>');
            if (anchor.getText() != null) {
                sBuffer.append(anchor.getText());
            }
            sBuffer.append("</A>");
            String result = sBuffer.toString();
            if (anchor.isPageContextRendering()) {
                out.println(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RendererException(e.toString());
        }
    }
}

