/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.components.treemodel;

import com.softaspects.framework.galileo.components.treemodel.BaseTreeSelectionModel;
import com.softaspects.framework.galileo.support.util.ReverseHashMap;

public class BaseTreeSelectionModelImpl
implements BaseTreeSelectionModel {
    private static final String SELECTION_CLEARED = null;
    private short fSelectionType = 1;
    private static ReverseHashMap fSelectionTypeToStringMap = new ReverseHashMap();
    protected String fCurrentSelection = SELECTION_CLEARED;
    protected boolean fSelectionChanged = false;

    static {
        BaseTreeSelectionModelImpl.initializeSelectionTypeToStringMap();
    }

    public void setSelectionType(short aSelectionType) {
        this.fSelectionType = aSelectionType;
    }

    public short getSelectionType() {
        return this.fSelectionType;
    }

    public void setCurrentSelection(String aCurrentSelection) {
        if (aCurrentSelection == null) {
            throw new IllegalStateException("ToolBarSelectionModelImpl : selection mustn't be null.");
        }
        String selection = aCurrentSelection.toUpperCase();
        if (this.fSelectionType == 1) {
            this.fCurrentSelection = selection;
        } else {
            StringBuffer multipleSelection = new StringBuffer(this.fCurrentSelection);
            multipleSelection.append(selection);
            this.fCurrentSelection = multipleSelection.toString();
        }
        this.fSelectionChanged = true;
    }

    public String getCurrentSelection() {
        return this.fCurrentSelection;
    }

    public boolean isSelectionChanged() {
        return this.fSelectionChanged;
    }

    public boolean isSelected(String anItem) {
        String selection = anItem.toUpperCase();
        return this.fCurrentSelection.indexOf(selection) != -1;
    }

    public void clear() {
        this.fCurrentSelection = SELECTION_CLEARED;
    }

    public boolean isEmpty() {
        return this.fCurrentSelection.equals(SELECTION_CLEARED);
    }

    private static void initializeSelectionTypeToStringMap() {
        fSelectionTypeToStringMap.put(new Short(1), "SINGLE");
        fSelectionTypeToStringMap.put(new Short(2), "MULTIPLE");
    }

    public static short getSelectionType(String aSelectionString) {
        Short selectionTypeObject = null;
        String selectionString = aSelectionString.toUpperCase();
        selectionTypeObject = (Short)fSelectionTypeToStringMap.getKey(selectionString);
        if (selectionTypeObject == null) {
            return 1;
        }
        return selectionTypeObject;
    }
}

