/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.components.treemodel;

import com.softaspects.framework.galileo.components.base.Component;
import com.softaspects.framework.galileo.components.toolbar.PageHeaderImpl;
import com.softaspects.framework.galileo.components.toolbar.PageItemImpl;
import com.softaspects.framework.galileo.components.treemodel.BaseTreeDataModel;
import com.softaspects.framework.galileo.support.base.TreeEntity;
import com.softaspects.framework.galileo.support.util.collections.BoundList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class BaseTreeDataModelImpl
extends BoundList
implements BaseTreeDataModel,
TreeEntity {
    private Component fParentComponent = null;
    protected TreeEntity fParent = this;
    private boolean fScrambled = true;
    private static HashMap fToolBarElementTypeToImplClassMap = new HashMap();

    static {
        BaseTreeDataModelImpl.initializeToolBarElementTypeToImplClassMap();
    }

    public boolean getScrambled() {
        return this.fScrambled;
    }

    public void setScrambled(boolean scrambled) {
        this.fScrambled = scrambled;
    }

    public Component getParentComponent() {
        return this.fParentComponent;
    }

    public void setParentComponent(Component parentComponent) {
        this.fParentComponent = parentComponent;
    }

    public BaseTreeDataModelImpl() {
        super(new ArrayList());
    }

    public void setParent(TreeEntity aParent) {
        this.fParent = aParent;
    }

    public TreeEntity getParent() {
        return this.fParent;
    }

    public List getChildren() {
        ArrayList<TreeEntity> childrenList = null;
        if (!this.getContainedList().isEmpty()) {
            childrenList = new ArrayList<TreeEntity>();
            Iterator modelIterator = this.elements();
            while (modelIterator.hasNext()) {
                TreeEntity node = (TreeEntity)modelIterator.next();
                if (node.getChildren() == null && node.getLeaves() == null) continue;
                boolean bl = childrenList.add(node);
            }
        }
        return childrenList;
    }

    public List getLeaves() {
        ArrayList<TreeEntity> leavesList = null;
        if (!this.getContainedList().isEmpty()) {
            leavesList = new ArrayList<TreeEntity>();
            Iterator modelIterator = this.elements();
            while (modelIterator.hasNext()) {
                TreeEntity node = (TreeEntity)modelIterator.next();
                if (node.getChildren() != null || node.getLeaves() != null) continue;
                boolean bl = leavesList.add(node);
            }
        }
        return leavesList;
    }

    public int getSize() {
        return this.getContainedList().size();
    }

    public TreeEntity setElement(int anIndex, TreeEntity aToolBarPage) {
        if (anIndex < 0) {
            throw new IllegalArgumentException(" setElement : Index " + anIndex + " mustn't be negative");
        }
        TreeEntity result = (TreeEntity)this.getContainedList().get(anIndex);
        this.beforeRemoveElement(result);
        boolean beforeAddElementResult = this.beforeAddElement(aToolBarPage);
        if (beforeAddElementResult) {
            this.getContainedList().set(anIndex, aToolBarPage);
            this.fireRemoveElement(result);
            this.fireAddElement(aToolBarPage);
        }
        return result;
    }

    public boolean addElement(TreeEntity aToolBarPage) {
        boolean result;
        boolean beforeAddElementResult = this.beforeAddElement(aToolBarPage);
        if (beforeAddElementResult && (result = this.getContainedList().add(aToolBarPage))) {
            this.fireAddElement(aToolBarPage);
        }
        return beforeAddElementResult;
    }

    public void addElementAt(int anIndex, TreeEntity aToolBarPage) {
        if (anIndex < 0) {
            throw new IllegalArgumentException(" addElementAt : Index " + anIndex + " mustn't be negative");
        }
        boolean beforeAddElementResult = this.beforeAddElement(aToolBarPage);
        if (beforeAddElementResult) {
            this.getContainedList().add(anIndex, aToolBarPage);
            this.fireAddElement(aToolBarPage);
        }
    }

    public TreeEntity removeElement(int anIndex) {
        return (TreeEntity)this.remove(anIndex);
    }

    public boolean removeElement(TreeEntity aToolBarPage) {
        return this.remove(aToolBarPage);
    }

    public TreeEntity getElementAt(int anIndex) {
        if (anIndex < 0) {
            throw new IllegalArgumentException(" getElementAt(int) : Index " + anIndex + " mustn't be negative");
        }
        return (TreeEntity)this.getContainedList().get(anIndex);
    }

    public TreeEntity getElementAt(String anIndex) {
        if (anIndex == null || anIndex.equals("") || anIndex.indexOf(",") == -1) {
            throw new IllegalArgumentException(" getElementAt(String) : Index " + anIndex + " mustn't be null,blank or has no comma separator");
        }
        TreeEntity resultElement = null;
        BaseTreeDataModel currentParent = this;
        String currentIndexString = null;
        StringTokenizer selectionIndexTokenizer = new StringTokenizer(anIndex, ",");
        while (selectionIndexTokenizer.hasMoreTokens()) {
            currentIndexString = selectionIndexTokenizer.nextToken();
            int currentIndexValue = new Integer(currentIndexString);
            if (currentIndexValue < 0) {
                throw new IllegalArgumentException(" getElementAt(String) : Index " + currentIndexString + " mustn't be negative");
            }
            resultElement = currentParent.getElementAt(currentIndexValue);
            currentParent = (BaseTreeDataModel)((Object)resultElement);
        }
        return resultElement;
    }

    public boolean contains(TreeEntity aToolBarPage) {
        return this.getContainedList().contains(aToolBarPage);
    }

    public int indexOf(TreeEntity aToolBarPage) {
        return this.getContainedList().indexOf(aToolBarPage);
    }

    public Iterator elements() {
        return this.iterator();
    }

    public boolean isEmpty() {
        return this.getContainedList().isEmpty();
    }

    public void clear() {
        this.getContainedList().clear();
    }

    protected boolean beforeAddElement(TreeEntity aToolBarPage) {
        return !BaseTreeDataModelImpl.containImplClass(aToolBarPage);
    }

    private static void initializeToolBarElementTypeToImplClassMap() {
        fToolBarElementTypeToImplClassMap.put(new Short(1), new PageHeaderImpl());
        fToolBarElementTypeToImplClassMap.put(new Short(2), new PageItemImpl());
    }

    public static boolean containImplClass(TreeEntity anEntity) {
        return fToolBarElementTypeToImplClassMap.containsValue(anEntity);
    }
}

