/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.components.table;

import com.softaspects.framework.galileo.components.base.Interval;
import com.softaspects.framework.galileo.components.table.Column;
import com.softaspects.framework.galileo.components.table.ColumnModel;
import com.softaspects.framework.galileo.support.components.listmodel.ListSelectionModel;
import com.softaspects.framework.galileo.support.components.listmodel.ListSelectionModelImpl;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ColumnModelImpl
implements ColumnModel {
    private ArrayList fTableColumnsList = new ArrayList();
    private HashMap fColumnsIdMap = new HashMap();
    private ListSelectionModel fListSelectionModel = new ListSelectionModelImpl();
    private boolean fColumnSelectionAllowed = false;
    private int fHighLightAllowed = -1;
    private int fNoWrapMode = -1;
    private int fSortedColumn = -1;
    private boolean fSortedMode = true;

    public void addColumn(Column aTableColumn) {
        this.validateColumnID(aTableColumn);
        this.fTableColumnsList.add(aTableColumn);
        this.fColumnsIdMap.put(aTableColumn.getID(), aTableColumn);
    }

    public void insertColumn(Column aTableColumn, int aColumnIndex) {
        this.validateColumnID(aTableColumn);
        this.validateColumnIndex(aColumnIndex);
        this.fTableColumnsList.add(aColumnIndex, aTableColumn);
        this.fColumnsIdMap.put(aTableColumn.getID(), aTableColumn);
    }

    public Column findColumn(int aColumnIndex) {
        if (aColumnIndex >= 0 && aColumnIndex < this.getColumnCount()) {
            return (Column)this.fTableColumnsList.get(aColumnIndex);
        }
        return null;
    }

    public Column findColumn(Object aColumnID) {
        if (aColumnID != null) {
            return (Column)this.fColumnsIdMap.get(aColumnID);
        }
        return null;
    }

    public void removeColumn(Column aTableColumn) {
        if (aTableColumn != null && aTableColumn.getID() != null) {
            ((AbstractCollection)this.fTableColumnsList).remove(aTableColumn);
            this.fColumnsIdMap.remove(aTableColumn.getID());
        }
    }

    public void removeColumn(int aColumnIndex) {
        this.removeColumn(this.findColumn(aColumnIndex));
    }

    public int getColumnCount() {
        return this.fTableColumnsList.size();
    }

    public Iterator getColumns() {
        return ((AbstractList)this.fTableColumnsList).iterator();
    }

    public int getColumnIndex(Column aTableColumn) {
        if (aTableColumn != null) {
            return this.fTableColumnsList.indexOf(aTableColumn);
        }
        return -1;
    }

    public int getColumnIndex(Object aColumnID) {
        return this.getColumnIndex(this.findColumn(aColumnID));
    }

    public void setColumnSelectionModel(ListSelectionModel aListSelectionModel) {
        this.fListSelectionModel = aListSelectionModel;
    }

    public ListSelectionModel getColumnSelectionModel() {
        return this.fListSelectionModel;
    }

    public void setColumnSelectionAllowed(boolean aColumnSelectionAllowed) {
        this.fColumnSelectionAllowed = aColumnSelectionAllowed;
    }

    public boolean isColumnSelectionAllowed() {
        return this.fColumnSelectionAllowed;
    }

    public int getSelectedColumnCount() {
        ListSelectionModel listSelectionModel = this.getColumnSelectionModel();
        if (listSelectionModel != null) {
            return listSelectionModel.getSelectionCount();
        }
        return 0;
    }

    public int[] getSelectedColumns() {
        ListSelectionModel listSelectionModel = this.getColumnSelectionModel();
        if (listSelectionModel != null) {
            return listSelectionModel.getSelectionIndexes();
        }
        return null;
    }

    public void moveColumn(int aColumnIndex, int aNewColumnIndex) {
        this.validateColumnIndex(aColumnIndex);
        this.validateColumnIndex(aNewColumnIndex);
        if (aColumnIndex != aNewColumnIndex) {
            Column tableColumn = this.findColumn(aColumnIndex);
            ListSelectionModel selectionModel = this.getColumnSelectionModel();
            boolean reselect = false;
            if (selectionModel != null && selectionModel.isSelected(aColumnIndex)) {
                reselect = true;
            }
            this.removeColumn(aColumnIndex);
            this.fTableColumnsList.add(aNewColumnIndex, tableColumn);
            this.fColumnsIdMap.put(tableColumn.getID(), tableColumn);
            if (reselect) {
                selectionModel.removeSelectionInterval(new Interval(aColumnIndex));
                selectionModel.addSelectionInterval(new Interval(aNewColumnIndex));
            }
        }
    }

    public boolean isColumnSortKey(int aColumnIndex) {
        return aColumnIndex == this.fSortedColumn;
    }

    public void setColumnSortedKey(int aColumnIndex) {
        this.validateColumnIndex(aColumnIndex);
        this.fSortedColumn = aColumnIndex;
    }

    public int getColumnSortedKey() {
        return this.fSortedColumn;
    }

    public void setColumnSortedAsc(boolean aColumnSortedAsc) {
        this.fSortedMode = aColumnSortedAsc;
    }

    public boolean isColumnSortedAsc() {
        return this.fSortedMode;
    }

    public boolean isColumnVisible(int aColumnIndex) {
        this.validateColumnIndex(aColumnIndex);
        Column tableColumn = this.findColumn(aColumnIndex);
        return tableColumn.isVisible();
    }

    public void setHighLightAllowed(boolean aHighLightAllowed) {
        this.fHighLightAllowed = aHighLightAllowed ? 1 : 0;
    }

    public int getHighLightAllowed() {
        return this.fHighLightAllowed;
    }

    public void setNoWrapMode(boolean aNoWrapMode) {
        this.fNoWrapMode = aNoWrapMode ? 1 : 0;
    }

    public int getNoWrapMode() {
        return this.fNoWrapMode;
    }

    public int getVisibleColumnsCount() {
        int result = 0;
        int i = 0;
        while (i < this.getColumnCount()) {
            if (this.isColumnVisible(i)) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public int[] getVisibleColumns() {
        int[] result = new int[this.getVisibleColumnsCount()];
        int j = 0;
        int i = 0;
        while (i < this.getColumnCount()) {
            if (this.isColumnVisible(i)) {
                result[j] = i;
                ++j;
            }
            ++i;
        }
        return result;
    }

    protected static void validateValue(Object aValue, String aName) {
        if (aValue == null) {
            throw new IllegalArgumentException("TableColumnModel: " + aName + " can't be null.");
        }
    }

    protected void validateColumnID(Column aTableColumn) {
        ColumnModelImpl.validateValue(aTableColumn, "Table column");
        ColumnModelImpl.validateValue(aTableColumn.getID(), "Table column ID");
        if (this.fColumnsIdMap.containsKey(aTableColumn.getID())) {
            throw new IllegalArgumentException("TableColumnmodel: Columns ID duplication.");
        }
    }

    protected void validateColumnIndex(int aColumnIndex) {
        if (aColumnIndex < 0 || aColumnIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException("TableColumnModel: Column index out of bounds.");
        }
    }
}

