/*
 * Decompiled with CFR 0.152.
 */
package com.softaspects.framework.galileo.components.base;

import com.softaspects.framework.galileo.components.base.ComponentBase;
import com.softaspects.framework.galileo.components.base.Constraint;
import com.softaspects.framework.galileo.components.base.Renderer;
import com.softaspects.framework.galileo.components.base.RendererException;
import com.softaspects.framework.galileo.support.components.container.layout.LayoutManagerPolicy;
import java.util.StringTokenizer;

public abstract class ComponentBaseImpl
implements ComponentBase {
    protected Renderer fRenderer = null;
    protected String fResourcesGroup = null;
    protected ComponentBase fParentComponent = null;
    protected String fId = null;
    protected String fName = null;
    protected String fStyle = null;
    protected String fStyleClass = null;
    protected boolean fComponentConstraintAlreadyWasSet = false;
    protected Constraint fConstraint = null;
    private boolean fPageContextRendering = true;

    public String getId() {
        return this.fId;
    }

    public void setId(String aId) {
        ComponentBaseImpl.validateValue(aId, "ID");
        this.fId = aId;
        this.fName = aId;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String aName) {
        this.fName = aName;
    }

    public String getStyleClass() {
        return this.fStyleClass;
    }

    public void setStyleClass(String aStyleClass) {
        this.fStyleClass = aStyleClass;
    }

    public String getStyle() {
        return this.fStyle;
    }

    public void setStyle(String aStyle) {
        this.fStyle = aStyle;
    }

    public void addStyleProperty(String aStyleProperty, String aValue) {
        ComponentBaseImpl.validateValue(aStyleProperty, "Style property");
        ComponentBaseImpl.validateValue(aValue, "Style value");
        StringBuffer sb = new StringBuffer();
        if (this.getStyle() != null) {
            this.removeStyleProperty(aStyleProperty);
            String style = this.getStyle().trim();
            if (style.length() > 0) {
                sb.append(style);
                if (!style.endsWith(";")) {
                    sb.append(';');
                }
                sb.append(' ');
            }
        }
        sb.append(aStyleProperty);
        sb.append(':');
        sb.append(aValue);
        sb.append(';');
        this.setStyle(sb.toString());
    }

    public boolean isStylePropertyPresent(String aStyleProperty) {
        String lowerProperty;
        String style = this.getStyle();
        if (style == null || aStyleProperty == null) {
            return false;
        }
        String lowerStyle = style.toLowerCase();
        if (lowerStyle.indexOf(lowerProperty = aStyleProperty.toLowerCase()) < 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(lowerStyle, ";");
        while (st.hasMoreTokens()) {
            if (!st.nextToken().trim().startsWith(lowerProperty)) continue;
            return true;
        }
        return false;
    }

    public void removeStyleProperty(String aStyleProperty) {
        String lowerProperty;
        String style = this.getStyle();
        if (style == null || aStyleProperty == null) {
            return;
        }
        String lowerStyle = style.toLowerCase();
        if (lowerStyle.indexOf(lowerProperty = aStyleProperty.toLowerCase()) < 0) {
            return;
        }
        StringBuffer sBuffer = new StringBuffer();
        StringTokenizer st = new StringTokenizer(style, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.toLowerCase().startsWith(lowerProperty)) continue;
            sBuffer.append(token);
            sBuffer.append(';');
        }
        this.setStyle(sBuffer.toString());
    }

    public String getResourcesGroup() {
        return this.fResourcesGroup;
    }

    public void setResourcesGroup(String aGroupName) {
        this.fResourcesGroup = aGroupName;
    }

    public void setParentComponent(ComponentBase aParentComponent) {
        this.fParentComponent = aParentComponent;
    }

    public ComponentBase getParentComponent() {
        return this.fParentComponent;
    }

    public Renderer getRenderer() {
        return this.fRenderer;
    }

    public void setRenderer(Renderer aRenderer) {
        if (aRenderer == null) {
            throw new IllegalStateException("Component: Renderer can't be null.");
        }
        this.fRenderer = aRenderer;
    }

    public boolean isPageContextRendering() {
        return this.fPageContextRendering;
    }

    public void setPageContextRendering(boolean anPageContextRendering) {
        this.fPageContextRendering = anPageContextRendering;
    }

    public String render() throws RendererException {
        if (this.fRenderer == null) {
            throw new IllegalStateException("Component: Renderer not set or null.");
        }
        return this.fRenderer.render();
    }

    public void setConstraint(Constraint aConstraint) {
        if (!this.fComponentConstraintAlreadyWasSet) {
            this.fComponentConstraintAlreadyWasSet = true;
        } else if (LayoutManagerPolicy.generateExceptionIfComponentAlreadyHasConstraint()) {
            throw new IllegalStateException("Component base: Component already has constraint.");
        }
        this.fConstraint = aConstraint;
    }

    public Constraint getConstraint() {
        return this.fConstraint;
    }

    protected static void validateValue(String aValue, String aName) {
        if (aValue == null || aValue.length() == 0) {
            throw new IllegalArgumentException("Component: " + aName + " value is null.");
        }
    }

    protected static void validateValue(int aValue, String aName) {
        if (aValue < 0) {
            throw new IllegalArgumentException("Component: " + aName + " value is negative.");
        }
    }

    public abstract String getComponentTypeName();
}

