//================================
// Demo Program of JPEG API
// Design: He Lingsong
// 1999.12.20
//================================
#include <time.h>
#include "stdafx.h"
#include "test.h"
#include "testDlg.h"
#include "jpegdll.h"   // Include JPEG API header file

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

HWND hWnd; 

/////////////////////////////////////////////////////////////////////////////
CTestDlg::CTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTestDlg::IDD, pParent)
{   //{{AFX_DATA_INIT(CTestDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTestDlg::DoDataExchange(CDataExchange* pDX)
{	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTestDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTestDlg, CDialog)
	//{{AFX_MSG_MAP(CTestDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_MENUITEM32771, OnMenuitem32771)
	ON_COMMAND(ID_MENUITEM32772, OnMenuitem32772)
	ON_COMMAND(ID_EXIT, OnExit)
	ON_COMMAND(ID_BMP_READBIRDBMP, OnBmpReadbirdbmp)
	ON_COMMAND(ID_BMP_SAVETOBIRD1BMP, OnBmpSavetobird1bmp)
	ON_COMMAND(ID_FILE_JPEGTOBMP, OnFileJpegtobmp)
	ON_COMMAND(ID_FILE_BMPTOJPEG, OnFileBmptojpeg)
	ON_COMMAND(ID_CLIPBOARD_COPYTOCLIPBOARD, OnClipboardCopytoclipboard)
	ON_COMMAND(ID_CLIPBOARD_CLIPBOARDTOJPEG, OnClipboardClipboardtojpeg)
	ON_COMMAND(ID_CLIPBOARD_CLIPBOARDTOBMP, OnClipboardClipboardtobmp)
	ON_COMMAND(ID_CLIPBOARD_COPYAREATOCLIPBOARD, OnClipboardCopyareatoclipboard)
	ON_COMMAND(ID_CLIPBOARD_PASTEAREATOBIRD3JPG, OnClipboardPasteareatobird3jpg)
	ON_COMMAND(ID_CLIPBOARD_COPYAREATOBIRD3BMP, OnClipboardCopyareatobird3bmp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestDlg message handlers

void CTestDlg::OnPaint() 
{ if (IsIconic())
   { CPaintDC dc(this);
     SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);
     int cxIcon = GetSystemMetrics(SM_CXICON);
	 int cyIcon = GetSystemMetrics(SM_CYICON);
	 CRect rect;  GetClientRect(&rect);
	 int x = (rect.Width() - cxIcon + 1) / 2;
	 int y = (rect.Height() - cyIcon + 1) / 2;
     dc.DrawIcon(x, y, m_hIcon);
	}
	else {CDialog::OnPaint();}
}

HCURSOR CTestDlg::OnQueryDragIcon()
{return (HCURSOR) m_hIcon;}

//=================================================================
BOOL CTestDlg::OnInitDialog()
{CDialog::OnInitDialog();
 SetIcon(m_hIcon, TRUE);
 SetIcon(m_hIcon, FALSE);
 hWnd=this->m_hWnd;           // get the handle of the window 
 init_jpeg();                 // init JPEG API Libary
 return TRUE;  
}

void CTestDlg::OnExit() 
{CDialog::OnOK();}

void CTestDlg::OnMenuitem32771()         // Open a jpeg file
{showjpg("bird.jpg",(long)(hWnd),2,2);}

void CTestDlg::OnMenuitem32772()         // Copy Window to a jpeg file 
{copy_to_jpeg((long)(hWnd),"bird1.jpg",1,75);
 
}

void CTestDlg::OnBmpReadbirdbmp() // Read BMP file
{show_bmp("bird.bmp",(long)(hWnd),2,2);}

void CTestDlg::OnBmpSavetobird1bmp() // Save to BMP
{copy_to_bmp((long)(hWnd),"bird1.bmp",1);}

void CTestDlg::OnFileJpegtobmp() // JPEG to BMP
{jpg_to_bmp("bird.jpg","bird1.bmp");}

void CTestDlg::OnFileBmptojpeg() // BMP to JPEG
{bmp_to_jpg("bird.bmp","bird1.jpg",75);}

void CTestDlg::OnClipboardCopytoclipboard() // Copy to Clipboard
{to_clip((long)(hWnd),0);}

void CTestDlg::OnClipboardClipboardtojpeg() // Clipboard to JPEG
{clip_to_jpeg("bird2.jpg",(long)(hWnd),75);}

void CTestDlg::OnClipboardClipboardtobmp()  // Clipboard to BMP
{clip_to_bmp("bird2.bmp",(long)(hWnd));}

void CTestDlg::OnClipboardCopyareatoclipboard() // Copy Area
{Area_Copy((long)(hWnd),0,0,300,400);}

void CTestDlg::OnClipboardPasteareatobird3jpg() // Copy Area to a JPEG file
{Area_to_jpeg((long)(hWnd),0,0,300,400,"bird3.jpg",75);}

void CTestDlg::OnClipboardCopyareatobird3bmp()  // Copy Area to a BMP file
{Area_to_bmp((long)(hWnd),0,0,300,400,"bird3.bmp");}
