// Ado_Test.cpp : An example that uses the hlAdo class.
//===================================================================
// By Konstantine Kougios, (C) September 2001

// We will just open the database (Access 97 format)
// and do some simple queries.

#include "stdafx.h"
#include "hlAdo_Demo.h"
#include "hlAdo.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only application object

CWinApp theApp;

using namespace std;


int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
		nRetCode = 1;
	}
	else
	{
		// HERE is our main code. We'll catch any errors with the
		// try/catch method.
		try
		{

			// ====================================================
			// open the database using the jet engine.
			// Our database is an Access 97 db which lies in the
			// db.mdb file.
			// ====================================================
			hlAdo hl("Provider=Microsoft.JET.OLEDB.3.51;Data Source=DB.mdb");
	
			// ====================================================
			// Print the contents of the database.
			// We will create a recordset, and then iterate it.
			// ====================================================

			// get the names and the phone numbers from the Directory
			// table of the database
			hlAdoRs rs(hl,"SELECT names,phones FROM Directory");
			while (rs.next()) // while there are records...
			{
				// ... print them
				cout << (LPCTSTR)rs.GetItem("names") << "\t" << (LPCTSTR)rs.GetItem("phones") << endl;
			}

			// ====================================================
			// Now we will execute some UPDATES to the database.
			// To be sure that all the updates will be executed, or
			// none of them if there is an error, we'll do a
			// transaction. In case of an error, the database
			// will automatically RollbackTrans() when the hl
			// object will be destucted.
			// ====================================================

			hl.BeginTrans();
			hl.ExecuteCommand("UPDATE directory SET phones='555-22555' WHERE names='Philipos'");
			hl.ExecuteCommand("UPDATE directory SET phones='555-22555' WHERE names='Philipas'");
			hl.ExecuteCommand("DELETE FROM directory WHERE names='Andreas'");
			hl.CommitTrans();

			// Thats it, now the rs and hl objects will be automatically
			// released, so we don't have to worry about releasing them.
		}

		// catch any ADO errors and print them on screen
		AdoCatch(e)
		{
			cout << (LPCTSTR)ComError(e) << endl;
		}
	}

	cout << endl << "*** Program terminated normally." << endl;
	return nRetCode;
}
