
{******************************************}
{                                          }
{   FastReport CLX v2.4 - IBX components   }
{           Query params editor            }
{                                          }
{        Copyright (c) 2000 by EMS         }
{ Copyright (c) 1998-2001 by Tzyganenko A. }
{                                          }
{******************************************}

unit fr_ibxqueryparam;

interface

{$I fr.inc}

uses
  Types, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, fr_ctrls, QExtCtrls, DB, IBQuery, fr_ibxquery;

type
  TfrIBXParamsForm = class(TForm)
    GroupBox1: TGroupBox;
    Label2: TLabel;
    ParamsLB: TListBox;
    TypeCB: TComboBox;
    ValueRB: TRadioButton;
    AssignRB: TRadioButton;
    Label1: TLabel;
    ValueE: TfrComboEdit;
    Button1: TButton;
    Button2: TButton;
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure ParamsLBClick(Sender: TObject);
    procedure ValueEExit(Sender: TObject);
    procedure TypeCBChange(Sender: TObject);
    procedure ValueRBClick(Sender: TObject);
    procedure AssignRBClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure VarSBClick(Sender: TObject);
  private
    { Private declarations }
    FBusy: Boolean;
    function CurParam: Integer;
    procedure Localize;
  public
    { Public declarations }
    Query: TIBQuery;
    QueryComp: TfrIBXQuery;
  end;

implementation

uses fr_const, fr_class, fr_dbutils, fr_utils;

{$R *.xfm}


function TfrIBXParamsForm.CurParam: Integer;
var
  i: Integer;
  s: String;
begin
  Result := 0;
  s := ParamsLB.Items[ParamsLB.ItemIndex];
  for i := 0 to Query.Params.Count - 1 do
    if Query.Params[i].Name = s then
    begin
      Result := i;
      break;
    end;
end;

procedure TfrIBXParamsForm.FormShow(Sender: TObject);
var
  i: Integer;
begin
  with Query.Params do
  for i := 0 to Count - 1 do
    if ParamsLB.Items.IndexOf(Items[i].Name) = -1 then
      ParamsLB.Items.Add(Items[i].Name);
  with TypeCB.Items do
  begin
    Clear;
    Add(SParamType1);
    Add(SParamType2);
    Add(SParamType3);
    Add(SParamType4);
    Add(SParamType5);
    Add(SParamType6);
    Add(SParamType7);
    Add(SParamType8);
    Add(SParamType9);
    Add(SParamType10);
    Add(SParamType11);
  end;
  ParamsLB.ItemIndex := 0;
  ParamsLBClick(nil);
end;

procedure TfrIBXParamsForm.FormHide(Sender: TObject);
begin
  if ValueE.Enabled then ValueEExit(nil);
end;

procedure TfrIBXParamsForm.ParamsLBClick(Sender: TObject);
var
  i: Integer;
begin
  TypeCB.ItemIndex := -1;
  for i := 0 to 10 do
    if Query.Params[CurParam].DataType = ParamTypes[i] then
    begin
      TypeCB.ItemIndex := i;
      break;
    end;
  FBusy := True;
  ValueE.Text := '';
  ValueE.Enabled := False;
  if QueryComp.ParamKind[CurParam] = pkValue then
  begin
    ValueE.Text := QueryComp.ParamText[CurParam];
    ValueE.Enabled := True;
    ValueRB.Checked := True;
  end
  else
    AssignRB.Checked := True;
  FBusy := False;
end;

procedure TfrIBXParamsForm.ValueEExit(Sender: TObject);
begin
  QueryComp.ParamText[CurParam] := ValueE.Text;
end;

procedure TfrIBXParamsForm.TypeCBChange(Sender: TObject);
begin
  Query.Params[CurParam].DataType := ParamTypes[TypeCB.ItemIndex];
  if ValueE.Enabled then
    ValueEExit(nil);
end;

procedure TfrIBXParamsForm.ValueRBClick(Sender: TObject);
begin
  if FBusy then Exit;
  ValueE.Enabled := True;
  QueryComp.ParamKind[CurParam] := pkValue;
end;

procedure TfrIBXParamsForm.AssignRBClick(Sender: TObject);
begin
  if FBusy then Exit;
  ValueE.Text := '';
  ValueE.Enabled := False;
  QueryComp.ParamKind[CurParam] := pkAssignFromMaster;
end;

procedure TfrIBXParamsForm.Localize;
begin
  Font.Name := frDefaultFont;
  GroupBox1.Caption := S56110;
  Label2.Caption := S56111;
  Label1.Caption := S56112;
  ValueRB.Caption := S56113;
  AssignRB.Caption := S56115;
  ValueE.ButtonHint := S53575;
  Button1.Caption := (SOk);
  Button2.Caption := (SCancel);
end;

procedure TfrIBXParamsForm.FormCreate(Sender: TObject);
begin
  Localize;
end;

procedure TfrIBXParamsForm.VarSBClick(Sender: TObject);
begin
  ValueE.Text := frDesigner.InsertExpression;
end;

end.

