
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{             Variables form               }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_var;

interface

{$I fr.inc}

uses
  SysUtils, Types, Classes, QGraphics, QControls,
  QForms, QDialogs, QStdCtrls, fr_const, QExtCtrls;

type
  TfrVarForm = class(TForm)
    VarLB: TListBox;
    CategoryLB: TListBox;
    Button1: TButton;
    Button2: TButton;
    Image1: TImage;
    Image2: TImage;
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure CategoryLBClick(Sender: TObject);
    procedure VarLBDblClick(Sender: TObject);
    procedure CategoryLBDrawItem(Sender: TObject; Index: Integer;
      ARect: TRect; State: TOwnerDrawState; var Handled: Boolean);
  private
    { Private declarations }
    function CurVal: String;
    function CurDataSet: String;
    procedure GetVariables;
    procedure GetSpecValues;
    procedure FillCategoryLB;
    procedure Localize;
  public
    { Public declarations }
    SelectedItem: String;
  end;

var
  frVarForm: TfrVarForm;

implementation

{$R *.xfm}

uses fr_class, fr_utils, fr_ctrls;

var
  LastCategory: String;
  

function TfrVarForm.CurVal: String;
begin
  Result := '';
  with VarLB do
  if ItemIndex <> -1 then
    Result := Items[ItemIndex];
end;

function TfrVarForm.CurDataSet: String;
begin
  Result := '';
  with CategoryLB do
    if ItemIndex <> -1 then
      Result := Items[ItemIndex];
end;

procedure TfrVarForm.FillCategoryLB;
var
  s: TStringList;
begin
  s := TStringList.Create;
  CurReport.Dictionary.GetCategoryList(s);
  s.Add((SSystemVariables));
  CategoryLB.Items.Assign(s);
  s.Free;
end;

procedure TfrVarForm.CategoryLBClick(Sender: TObject);
begin
  if CurDataSet = (SSystemVariables) then
    GetSpecValues else
    GetVariables;
end;

procedure TfrVarForm.GetVariables;
begin
  CurReport.Dictionary.GetVariablesList(CategoryLB.Items[CategoryLB.ItemIndex],
    VarLB.Items);
end;

procedure TfrVarForm.GetSpecValues;
begin
  with VarLB.Items do
  begin
    Clear;
    Add(SVar1);
    Add(SVar3);
    Add(SVar4);
    Add(SVar5);
    Add(SVar6);
    Add(SVar7);
    Add(SVar8);
    Add(SVar9);
  end;
end;

procedure TfrVarForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S53440;
  Button1.Caption := (SOk);
  Button2.Caption := (SCancel);
end;

procedure TfrVarForm.FormCreate(Sender: TObject);
begin
  Localize;
end;

procedure TfrVarForm.FormActivate(Sender: TObject);
begin
  FillCategoryLB;
  with CategoryLB do
    if Items.IndexOf(LastCategory) <> -1 then
      ItemIndex := Items.IndexOf(LastCategory) else
      ItemIndex := 0;
  CategoryLBClick(nil);
end;

procedure TfrVarForm.FormDeactivate(Sender: TObject);
begin
  if ModalResult = mrOk then
    if CurDataSet <> (SSystemVariables) then
      SelectedItem := CurVal
    else
      if VarLB.ItemIndex > 0 then
        SelectedItem := frSpecFuncs[VarLB.ItemIndex + 1] else
        SelectedItem := frSpecFuncs[0];
  LastCategory := CategoryLB.Items[CategoryLB.ItemIndex];
end;

procedure TfrVarForm.VarLBDblClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TfrVarForm.CategoryLBDrawItem(Sender: TObject; Index: Integer;
  ARect: TRect; State: TOwnerDrawState; var Handled: Boolean);
var
  Image: TImage;
  r: TRect;
begin
  r := ARect;
  r.Right := r.Left + 18;
  r.Bottom := r.Top + 16;
  OffsetRect(r, 2, 0);
  with TListBox(Sender) do
  begin
    Canvas.FillRect(ARect);
    if Sender = CategoryLB then
      Image := Image1 else
      Image := Image2;
    frDrawTransparent(Canvas, r.Left, r.Top, Image.Picture.Bitmap);
    Canvas.TextOut(ARect.Left + 20, ARect.Top + 1, Items[Index]);
  end;
end;


end.

