
{******************************************}
{                                          }
{  FastReport CLX v2.4 - Dialog designer   }
{           String list editor             }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_ledit;

interface

{$I fr.inc}

uses
  SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, fr_ctrls, QButtons;

type
  TfrLinesEditorForm = class(TForm)
    MemoPanel: TPanel;
    Bevel2: TBevel;
    M1: TMemo;
    Panel2: TPanel;
    Panel1: TPanel;
    OkBtn: TfrSpeedButton;
    CancelBtn: TfrSpeedButton;
    Bevel1: TBevel;
    CutBtn: TfrSpeedButton;
    CopyBtn: TfrSpeedButton;
    PasteBtn: TfrSpeedButton;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure M1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure CutBtnClick(Sender: TObject);
    procedure CopyBtnClick(Sender: TObject);
    procedure PasteBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
  private
    { Private declarations }
    procedure Localize;
  public
    { Public declarations }
  end;


implementation

uses fr_class, fr_const, fr_utils, Qt;

{$R *.xfm}


procedure TfrLinesEditorForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = key_Return) and (ssCtrl in Shift) then
  begin
    ModalResult := mrOk;
    Key := 0;
  end;
end;

procedure TfrLinesEditorForm.M1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = key_Escape then ModalResult := mrCancel;
end;

procedure TfrLinesEditorForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S57000;
  CutBtn.Hint := S53091;
  CopyBtn.Hint := S53092;
  PasteBtn.Hint := S53093;
  OkBtn.Hint := (SOk);
  CancelBtn.Hint := (SCancel);
end;

procedure TfrLinesEditorForm.FormCreate(Sender: TObject);
begin
  Localize;
  M1.Font.Charset := TFontCharset(frCharset);
end;

procedure TfrLinesEditorForm.CutBtnClick(Sender: TObject);
begin
  M1.CutToClipboard;
end;

procedure TfrLinesEditorForm.CopyBtnClick(Sender: TObject);
begin
  M1.CopyToClipboard;
end;

procedure TfrLinesEditorForm.PasteBtnClick(Sender: TObject);
begin
  M1.PasteFromClipboard;
end;

procedure TfrLinesEditorForm.CancelBtnClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TfrLinesEditorForm.OkBtnClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

end.
