
{******************************************}
{                                          }
{           FastReport CLX v2.5            }
{       Highlight attributes dialog        }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_hilit;

interface

{$I fr.inc}

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QButtons, fr_ctrls, fr_const, QExtCtrls;

type
  TfrHilightForm = class(TForm)
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    CB1: TCheckBox;
    CB2: TCheckBox;
    CB3: TCheckBox;
    Button3: TButton;
    Button4: TButton;
    ColorDialog1: TColorDialog;
    SpeedButton1: TfrSpeedButton;
    SpeedButton2: TfrSpeedButton;
    RB1: TRadioButton;
    RB2: TRadioButton;
    GroupBox3: TGroupBox;
    Edit1: TfrComboEdit;
    Image1: TImage;
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure RB1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Edit1ButtonClick(Sender: TObject);
  private
    { Private declarations }
    procedure Localize;
    procedure SetGlyph(Color: TColor; sb: TfrSpeedButton; n: Integer);
  public
    { Public declarations }
    FontColor, FillColor: TColor;
  end;


implementation

uses fr_desgn, fr_class, fr_expr, fr_utils;

{$R *.xfm}

procedure TfrHilightForm.SetGlyph(Color: TColor; sb: TfrSpeedButton; n: Integer);
var
  b: TBitmap;
  r: TRect;
  i, j: Integer;
begin
  b := TBitmap.Create;
  b.Width := 32;
  b.Height := 16;
  with b.Canvas do
  begin
    r := Rect(n * 32, 0, n * 32 + 32, 16);
    CopyRect(Rect(0, 0, 32, 16), Image1.Picture.Bitmap.Canvas, r);
    Pen.Color := Color;
    for i := 0 to 15 do
      for j := 12 to 14 do
        DrawPoint(i, j);
{    if Color = clNone then
      for i := 1 to 14 do
        Pixels[i, 13] := clBtnFace;}
  end;
  sb.Glyph.Assign(b);
  sb.NumGlyphs := 2;
  b.Free;
end;

procedure TfrHilightForm.SpeedButton1Click(Sender: TObject);
begin
  ColorDialog1.Color := FontColor;
  if ColorDialog1.Execute then
  begin
    FontColor := ColorDialog1.Color;
    SetGlyph(FontColor, SpeedButton1, 0);
  end;
end;

procedure TfrHilightForm.SpeedButton2Click(Sender: TObject);
begin
  ColorDialog1.Color := FillColor;
  if ColorDialog1.Execute then
  begin
    FillColor := ColorDialog1.Color;
    SetGlyph(FillColor, SpeedButton2, 1);
  end;
end;

procedure TfrHilightForm.FormActivate(Sender: TObject);
begin
  SetGlyph(FontColor, SpeedButton1, 0);
  SetGlyph(FillColor, SpeedButton2, 1);
  if FillColor = clNone then
    RB1.Checked := True else
    RB2.Checked := True;
  RB1Click(nil);
end;

procedure TfrHilightForm.RB1Click(Sender: TObject);
begin
  SpeedButton2.Enabled := RB2.Checked;
  if RB1.Checked then FillColor := clNone;
end;

procedure TfrHilightForm.Edit1ButtonClick(Sender: TObject);
begin
  with TfrExprForm.Create(nil) do
  begin
    ExprMemo.Text := Edit1.Text;
    if ShowModal = mrOk then
      Edit1.Text := ExprMemo.Text;
    Free;
  end;
end;

procedure TfrHilightForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S53520;
  GroupBox3.Caption := S53521;
  GroupBox1.Caption := S53522;
  SpeedButton1.Caption := S53523;
  CB1.Caption := S53524;
  CB2.Caption := S53525;
  CB3.Caption := S53526;
  GroupBox2.Caption := S53527;
  SpeedButton2.Caption := S53528;
  RB1.Caption := S53529;
  RB2.Caption := S53530;
  Edit1.ButtonHint := S53575;
  Button3.Caption := (SOk);
  Button4.Caption := (SCancel);
end;

procedure TfrHilightForm.FormCreate(Sender: TObject);
begin
  Localize;
end;


end.

