
{******************************************}
{                                          }
{   FastReport CLX v2.4 - DB components    }
{          Lookup field definition         }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_dbnewlookup;

interface

{$I fr.inc}

uses
  Types, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, DB;

type
  TfrDBLookupFieldForm = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    NameE: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    TypeCB: TComboBox;
    SizeE: TEdit;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    lFieldCB: TComboBox;
    lDatasetCB: TComboBox;
    lKeyCB: TComboBox;
    lResultCB: TComboBox;
    Button1: TButton;
    Button2: TButton;
    procedure FormShow(Sender: TObject);
    procedure lDatasetCBChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    FLookup: TDataset;
    procedure Localize;
  public
    { Public declarations }
    Dataset: TDataset;
  end;

implementation

uses fr_class, fr_dbutils, fr_const, fr_utils;


{$R *.xfm}

procedure TfrDBLookupFieldForm.FormShow(Sender: TObject);
begin
  with TypeCB.Items do
  begin
    Clear;
    Add(SFieldType1);
    Add(SFieldType2);
    Add(SFieldType3);
    Add(SFieldType4);
    Add(SFieldType5);
    Add(SFieldType6);
    Add(SFieldType7);
    Add(SFieldType8);
    Add(SFieldType9);
    Add(SFieldType10);
  end;

  TypeCB.ItemIndex := 0;
  Dataset.GetFieldNames(lFieldCB.Items);
  frGetComponents(DataSet.Owner, TDataSet, lDataSetCB.Items, DataSet);
end;

procedure TfrDBLookupFieldForm.Button1Click(Sender: TObject);
var
  Field: TField;
begin
  ModalResult := mrOk;
  Field := FieldClasses[TypeCB.ItemIndex].Create(Dataset);
  with Field do
  begin
    if Field is TStringField then
      try
        Size := StrToInt(SizeE.Text);
      except
        ModalResult := mrNone;
        Application.MessageBox(SFieldSizeError, SError, [smbOk], smsCritical);
        SizeE.Text := '';
        ActiveControl := SizeE;
        Exit;
      end;
    Lookup := True;
    LookupDataset := FLookup;
    KeyFields := lFieldCB.Text;
    LookupKeyFields := lKeyCB.Text;
    LookupResultField := lResultCB.Text;
    FieldName := NameE.Text;
    Dataset := Self.Dataset;
  end;
end;

procedure TfrDBLookupFieldForm.lDatasetCBChange(Sender: TObject);
begin
  FLookup := frFindComponent(DataSet.Owner, lDatasetCB.Text) as TDataset;
  lKeyCB.Items.Clear;
  lResultCB.Items.Clear;
  if FLookup <> nil then
  begin
    FLookup.GetFieldNames(lKeyCB.Items);
    lResultCB.Items.Assign(lKeyCB.Items);
  end;
  lKeyCB.Text := '';
  lResultCB.Text := '';
end;

procedure TfrDBLookupFieldForm.Localize;
begin
  Font.Name := frDefaultFont;
  Caption := S56070;
  GroupBox1.Caption := S56071;
  Label1.Caption := S56072;
  Label2.Caption := S56073;
  Label3.Caption := S56074;
  GroupBox2.Caption := S56075;
  Label4.Caption := S56076;
  Label5.Caption := S56077;
  Label6.Caption := S56078;
  Label7.Caption := S56079;
  Button1.Caption := (SOk);
  Button2.Caption := (SCancel);
end;

procedure TfrDBLookupFieldForm.FormCreate(Sender: TObject);
begin
  Localize;
end;

end.

