
{******************************************}
{                                          }
{   FastReport CLX v2.4 - DB components    }
{              Field editor                }
{                                          }
{Copyright(c) 1998-2003 by FastReports Inc.}
{                                          }
{******************************************}

unit fr_dbfldeditor;

interface

{$I fr.inc}

uses
  Types, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, DB;

type
  TfrDBFieldsEditorForm = class(TForm)
    FieldsL: TListBox;
    AddFieldsB: TButton;
    AddLookupB: TButton;
    SelAllB: TButton;
    DeleteB: TButton;
    ExitB: TButton;
    procedure FormShow(Sender: TObject);
    procedure AddFieldsBClick(Sender: TObject);
    procedure SelAllBClick(Sender: TObject);
    procedure DeleteBClick(Sender: TObject);
    procedure AddLookupBClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure FillList;
    procedure Localize;
  public
    { Public declarations }
    DataSet: TDataSet;
    DisableLookups: Boolean;
  end;


implementation

uses fr_class, fr_const, fr_dbfldlist, fr_dbnewlookup, fr_utils;

{$R *.xfm}

procedure TfrDBFieldsEditorForm.FillList;
var
  i: Integer;
begin
  FieldsL.Items.Clear;
  with DataSet do
  for i := 0 to FieldCount - 1 do
    FieldsL.Items.Add(Fields[i].FieldName);
end;

procedure TfrDBFieldsEditorForm.FormShow(Sender: TObject);
begin
  Caption := DataSet.Name + ' ' + (SFields);
  FillList;
  AddLookupB.Enabled := not DisableLookups;
end;

procedure TfrDBFieldsEditorForm.AddFieldsBClick(Sender: TObject);
begin
  try
    DataSet.FieldDefs.Update;
    with TfrDBFieldsListForm.Create(nil) do
    begin
      DataSet := Self.DataSet;
      if ShowModal = mrOk then
        FillList;
      Free;
    end;
  finally;
  end;
end;

procedure TfrDBFieldsEditorForm.SelAllBClick(Sender: TObject);
var
  i: Integer;
begin
  for i := 0 to FieldsL.Items.Count - 1 do
    FieldsL.Selected[i] := True;
end;

procedure TfrDBFieldsEditorForm.DeleteBClick(Sender: TObject);
var
  i: Integer;
begin
  for i := 0 to FieldsL.Items.Count - 1 do
    if FieldsL.Selected[i] then
      DataSet.FindField(FieldsL.Items[i]).Free;
  FillList;
end;

procedure TfrDBFieldsEditorForm.AddLookupBClick(Sender: TObject);
begin
  with TfrDBLookupFieldForm.Create(nil) do
  begin
    Dataset := Self.Dataset;
    if ShowModal = mrOk then
      FillList;
    Free;
  end;
end;

procedure TfrDBFieldsEditorForm.Localize;
begin
  Font.Name := frDefaultFont;
  AddFieldsB.Caption := S56040;
  AddLookupB.Caption := S56041;
  SelAllB.Caption := S56042;
  DeleteB.Caption := S56043;
  ExitB.Caption := S56044;
end;

procedure TfrDBFieldsEditorForm.FormCreate(Sender: TObject);
begin
  Localize;
end;

end.

