// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'fr_class.pas' rev: 6.00

#ifndef fr_classHPP
#define fr_classHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <IniFiles.hpp>	// Pascal unit
#include <fr_const.hpp>	// Pascal unit
#include <fr_api.hpp>	// Pascal unit
#include <fr_dbrel.hpp>	// Pascal unit
#include <fr_dbset.hpp>	// Pascal unit
#include <fr_dset.hpp>	// Pascal unit
#include <fr_intrp.hpp>	// Pascal unit
#include <fr_pars.hpp>	// Pascal unit
#include <fr_view.hpp>	// Pascal unit
#include <fr_progr.hpp>	// Pascal unit
#include <Variants.hpp>	// Pascal unit
#include <DB.hpp>	// Pascal unit
#include <QButtons.hpp>	// Pascal unit
#include <QMenus.hpp>	// Pascal unit
#include <QDialogs.hpp>	// Pascal unit
#include <QComCtrls.hpp>	// Pascal unit
#include <QStdCtrls.hpp>	// Pascal unit
#include <QForms.hpp>	// Pascal unit
#include <Qt.hpp>	// Pascal unit
#include <QControls.hpp>	// Pascal unit
#include <QPrinters.hpp>	// Pascal unit
#include <QGraphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Types.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Fr_class
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TfrDocMode { dmDesigning, dmPrinting };
#pragma option pop

#pragma option push -b-
enum TfrDrawMode { drAll, drAfterCalcHeight, drPart };
#pragma option pop

#pragma option push -b-
enum TfrBandType { btReportTitle, btReportSummary, btPageHeader, btPageFooter, btMasterHeader, btMasterData, btMasterFooter, btDetailHeader, btDetailData, btDetailFooter, btSubDetailHeader, btSubDetailData, btSubDetailFooter, btOverlay, btColumnHeader, btColumnFooter, btGroupHeader, btGroupFooter, btCrossHeader, btCrossData, btCrossFooter, btChild, btNone };
#pragma option pop

#pragma option push -b-
enum TfrPageType { ptReport, ptDialog };
#pragma option pop

#pragma option push -b-
enum TfrDataSetPosition { psLocal, psGlobal };
#pragma option pop

#pragma option push -b-
enum TfrPageMode { pmNormal, pmBuildList };
#pragma option pop

#pragma option push -b-
enum TfrBandRecType { rtShowBand, rtFirst, rtNext };
#pragma option pop

#pragma option push -b-
enum TfrRgnType { rtNormal, rtExtended };
#pragma option pop

#pragma option push -b-
enum TfrReportType { rtSimple, rtMultiple };
#pragma option pop

#pragma option push -b-
enum TfrDataType { frdtString, frdtInteger, frdtFloat, frdtBoolean, frdtColor, frdtEnum, frdtHasEditor, frdtSize, frdtOneObject };
#pragma option pop

typedef Set<TfrDataType, frdtString, frdtOneObject>  TfrDataTypes;

#pragma option push -b-
enum TfrPrintPages { frAll, frOdd, frEven };
#pragma option pop

typedef void __fastcall (__closure *TDetailEvent)(const AnsiString ParName, Variant &ParValue);

class DELPHICLASS TfrView;
typedef void __fastcall (__closure *TEnterRectEvent)(Classes::TStringList* Memo, TfrView* View);

typedef void __fastcall (__closure *TBeginDocEvent)(void);

typedef void __fastcall (__closure *TEndDocEvent)(void);

typedef void __fastcall (__closure *TBeginPageEvent)(int pgNo);

typedef void __fastcall (__closure *TEndPageEvent)(int pgNo);

class DELPHICLASS TfrBand;
typedef void __fastcall (__closure *TBeginBandEvent)(TfrBand* Band);

typedef void __fastcall (__closure *TEndBandEvent)(TfrBand* Band);

typedef void __fastcall (__closure *TProgressEvent)(int n);

typedef void __fastcall (__closure *TBeginColumnEvent)(TfrBand* Band);

typedef void __fastcall (__closure *TPrintColumnEvent)(int ColNo, int &Width);

class DELPHICLASS TfrPage;
typedef void __fastcall (__closure *TManualBuildEvent)(TfrPage* Page);

typedef void __fastcall (__closure *TObjectClickEvent)(TfrView* View);

typedef void __fastcall (__closure *TMouseOverObjectEvent)(TfrView* View, Qcontrols::TCursor &Cursor);

typedef void __fastcall (__closure *TBeforeExportEvent)(AnsiString &FileName, bool &bContinue);

typedef void __fastcall (__closure *TAfterExportEvent)(const AnsiString FileName);

typedef void __fastcall (__closure *TPrintReportEvent)(void);

typedef void __fastcall (__closure *TLocalizeEvent)(int StringID, AnsiString &ResultString);

#pragma pack(push, 1)
struct TfrHighlightAttr
{
	Word FontStyle;
	Qgraphics::TColor FontColor;
	Qgraphics::TColor FillColor;
} ;
#pragma pack(pop)

#pragma pack(push, 4)
struct TfrPrnInfo
{
	int PPgw;
	int PPgh;
	int Pgw;
	int Pgh;
	int POfx;
	int POfy;
	int Ofx;
	int Ofy;
	int PPw;
	int PPh;
	int Pw;
	int Ph;
} ;
#pragma pack(pop)

struct TfrPageInfo;
typedef TfrPageInfo *PfrPageInfo;

#pragma pack(push, 1)
struct TfrPageInfo
{
	Types::TRect R;
	Word pgSize;
	int pgWidth;
	int pgHeight;
	Qprinters::TPrinterOrientation pgOr;
	int pgBin;
	bool UseMargins;
	Types::TRect pgMargins;
	TfrPrnInfo PrnInfo;
	bool Visible;
	Classes::TMemoryStream* Stream;
	TfrPage* Page;
} ;
#pragma pack(pop)

struct TfrBandRec;
typedef TfrBandRec *PfrBandRec;

#pragma pack(push, 1)
struct TfrBandRec
{
	TfrBand* Band;
	TfrBandRecType Action;
} ;
#pragma pack(pop)

struct TfrPropRec;
typedef TfrPropRec *PfrPropRec;

struct TfrPropRec
{
	System::SmallString<32>  PropName;
	TfrDataTypes PropType;
	Classes::TStringList* Enum;
	Variant EnumValues;
	Classes::TNotifyEvent PropEditor;
} ;

class DELPHICLASS TfrObject;
class PASCALIMPLEMENTATION TfrObject : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	Classes::TList* PropList;
	void __fastcall ClearPropList(void);
	void __fastcall AddProperty(AnsiString PropName, TfrDataTypes PropType, Classes::TNotifyEvent PropEditor);
	void __fastcall AddEnumProperty(AnsiString PropName, AnsiString Enum, const Variant * EnumValues, const int EnumValues_Size);
	void __fastcall DelProperty(AnsiString PropName);
	virtual void __fastcall SetPropValue(AnsiString Index, const Variant &Value);
	virtual Variant __fastcall GetPropValue(AnsiString Index);
	PfrPropRec __fastcall GetPropRec(AnsiString Index);
	virtual Variant __fastcall DoMethod(AnsiString MethodName, const Variant &Par1, const Variant &Par2, const Variant &Par3);
	void __fastcall SetFontProp(Qgraphics::TFont* Font, AnsiString Prop, const Variant &Value);
	Variant __fastcall GetFontProp(Qgraphics::TFont* Font, AnsiString Prop);
	Variant __fastcall LinesMethod(Classes::TStrings* Lines, AnsiString MethodName, AnsiString LinesName, const Variant &Par1, const Variant &Par2, const Variant &Par3);
	
public:
	__fastcall TfrObject(void);
	__fastcall virtual ~TfrObject(void);
	virtual void __fastcall DefineProperties(void);
	__property Variant Prop[AnsiString Index] = {read=GetPropValue, write=SetPropValue};
	__property PfrPropRec PropRec[AnsiString Index] = {read=GetPropRec};
};


#pragma option push -b-
enum fr_class__3 { smFRF, smFRP };
#pragma option pop

class PASCALIMPLEMENTATION TfrView : public TfrObject 
{
	typedef TfrObject inherited;
	
private:
	bool Flag1;
	int olddy;
	void __fastcall P1Click(System::TObject* Sender);
	
protected:
	TfrBand* Parent;
	TfrPage* ParentPage;
	int SaveX;
	int SaveY;
	int SaveDX;
	int SaveDY;
	int SaveGX;
	int SaveGY;
	float SaveFW;
	AnsiString BaseName;
	Qgraphics::TCanvas* Canvas;
	#pragma pack(push, 1)
	Types::TRect DRect;
	#pragma pack(pop)
	
	Classes::TStringList* Memo1;
	Fr_dbrel::TfrTDataSet* FDataSet;
	AnsiString FField;
	fr_class__3 StreamMode;
	virtual void __fastcall ShowBackground(void);
	virtual void __fastcall ShowFrame(void);
	void __fastcall BeginDraw(Qgraphics::TCanvas* ACanvas);
	virtual void __fastcall GetBlob(Fr_dbrel::TfrTField* b);
	virtual void __fastcall OnHook(TfrView* View);
	void __fastcall ExpandVariables(AnsiString &s);
	virtual void __fastcall SetPropValue(AnsiString Index, const Variant &Value);
	virtual Variant __fastcall GetPropValue(AnsiString Index);
	virtual void __fastcall Loaded(void);
	virtual Variant __fastcall DoMethod(AnsiString MethodName, const Variant &Par1, const Variant &Par2, const Variant &Par3);
	TfrView* __fastcall ParentBand(void);
	
public:
	AnsiString Name;
	Byte Typ;
	Byte HVersion;
	Byte LVersion;
	int ID;
	bool Selected;
	#pragma pack(push, 1)
	Types::TRect OriginalRect;
	#pragma pack(pop)
	
	double ScaleX;
	double ScaleY;
	int OffsX;
	int OffsY;
	bool IsPrinting;
	int x;
	int y;
	int dx;
	int dy;
	Word Flags;
	Word FrameTyp;
	float FrameWidth;
	Qgraphics::TColor FrameColor;
	Word FrameStyle;
	Qgraphics::TColor FillColor;
	int Format;
	AnsiString FormatStr;
	Word Visible;
	int gapx;
	int gapy;
	Word Restrictions;
	AnsiString Tag;
	Classes::TStringList* Memo;
	Classes::TStringList* Script;
	Byte BandAlign;
	__fastcall virtual TfrView(void);
	__fastcall virtual ~TfrView(void);
	void __fastcall Assign(TfrView* From);
	virtual void __fastcall CalcGaps(void);
	virtual void __fastcall RestoreCoord(void);
	virtual void __fastcall Draw(Qgraphics::TCanvas* Canvas) = 0 ;
	virtual void __fastcall StreamOut(Classes::TStream* Stream);
	virtual void __fastcall ExportData(void);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToFR3Stream(Classes::TStream* Stream);
	virtual void __fastcall Resized(void);
	virtual void __fastcall DefinePopupMenu(Qmenus::TPopupMenu* Popup);
	virtual Qt::QRegionH* __fastcall GetClipRgn(TfrRgnType rt);
	void __fastcall CreateUniqueName(void);
	void __fastcall SetBounds(int Left, int Top, int Width, int Height);
	virtual void __fastcall DefineProperties(void);
	virtual void __fastcall ShowEditor(void);
};


class DELPHICLASS TfrControl;
class PASCALIMPLEMENTATION TfrControl : public TfrView 
{
	typedef TfrView inherited;
	
protected:
	Qcontrols::TControl* FControl;
	virtual void __fastcall PaintDesignControl(void);
	virtual void __fastcall SetPropValue(AnsiString Index, const Variant &Value);
	
public:
	__fastcall virtual TfrControl(void);
	__fastcall virtual ~TfrControl(void);
	virtual void __fastcall DefineProperties(void);
	void __fastcall PlaceControl(Qforms::TForm* Form);
	virtual void __fastcall Draw(Qgraphics::TCanvas* Canvas);
	virtual void __fastcall DefinePopupMenu(Qmenus::TPopupMenu* Popup);
	__property Qcontrols::TControl* Control = {read=FControl};
};


class DELPHICLASS TfrNonVisualControl;
class PASCALIMPLEMENTATION TfrNonVisualControl : public TfrControl 
{
	typedef TfrControl inherited;
	
protected:
	Qgraphics::TBitmap* Bmp;
	Classes::TComponent* Component;
	Fr_pars::TfrVariables* FFixupList;
	virtual void __fastcall SetPropValue(AnsiString Index, const Variant &Value);
	virtual void __fastcall PaintDesignControl(void);
	
public:
	__fastcall virtual TfrNonVisualControl(void);
	__fastcall virtual ~TfrNonVisualControl(void);
	virtual void __fastcall DefineProperties(void);
	HIDESBASE void __fastcall PlaceControl(Qforms::TForm* Form);
	virtual void __fastcall Draw(Qgraphics::TCanvas* Canvas);
};


class DELPHICLASS TfrStretcheable;
class PASCALIMPLEMENTATION TfrStretcheable : public TfrView 
{
	typedef TfrView inherited;
	
protected:
	TfrDrawMode DrawMode;
	virtual Variant __fastcall DoMethod(AnsiString MethodName, const Variant &Par1, const Variant &Par2, const Variant &Par3);
	virtual int __fastcall CalcHeight(void) = 0 ;
	virtual int __fastcall MinHeight(void) = 0 ;
	virtual int __fastcall LostSpace(void) = 0 ;
public:
	#pragma option push -w-inl
	/* TfrView.Create */ inline __fastcall virtual TfrStretcheable(void) : TfrView() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TfrView.Destroy */ inline __fastcall virtual ~TfrStretcheable(void) { }
	#pragma option pop
	
};


class DELPHICLASS TfrMemoView;
class PASCALIMPLEMENTATION TfrMemoView : public TfrStretcheable 
{
	typedef TfrStretcheable inherited;
	
private:
	Qgraphics::TFont* FFont;
	AnsiString LastValue;
	bool FWrapped;
	int VHeight;
	HIDESBASE void __fastcall P1Click(System::TObject* Sender);
	void __fastcall P2Click(System::TObject* Sender);
	void __fastcall P3Click(System::TObject* Sender);
	void __fastcall P5Click(System::TObject* Sender);
	void __fastcall P6Click(System::TObject* Sender);
	void __fastcall P8Click(System::TObject* Sender);
	void __fastcall P9Click(System::TObject* Sender);
	void __fastcall P10Click(System::TObject* Sender);
	void __fastcall P11Click(System::TObject* Sender);
	void __fastcall SetFont(Qgraphics::TFont* Value);
	
protected:
	bool Streaming;
	int TextHeight;
	int CurStrNo;
	bool Exporting;
	void __fastcall ExpandMemoVariables(void);
	void __fastcall AssignFont(Qgraphics::TCanvas* Canvas);
	void __fastcall WrapMemo(void);
	void __fastcall ShowMemo(void);
	void __fastcall ShowUnderLines(void);
	int __fastcall CalcWidth(Classes::TStringList* Memo);
	virtual int __fastcall CalcHeight(void);
	virtual int __fastcall MinHeight(void);
	virtual int __fastcall LostSpace(void);
	virtual void __fastcall GetBlob(Fr_dbrel::TfrTField* b);
	virtual void __fastcall SetPropValue(AnsiString Index, const Variant &Value);
	virtual Variant __fastcall GetPropValue(AnsiString Index);
	virtual Variant __fastcall DoMethod(AnsiString MethodName, const Variant &Par1, const Variant &Par2, const Variant &Par3);
	
public:
	int Alignment;
	#pragma pack(push, 1)
	TfrHighlightAttr Highlight;
	#pragma pack(pop)
	
	AnsiString HighlightStr;
	int LineSpacing;
	int CharacterSpacing;
	__fastcall virtual TfrMemoView(void);
	__fastcall virtual ~TfrMemoView(void);
	virtual void __fastcall Draw(Qgraphics::TCanvas* Canvas);
	virtual void __fastcall StreamOut(Classes::TStream* Stream);
	virtual void __fastcall ExportData(void);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToFR3Stream(Classes::TStream* Stream);
	virtual void __fastcall DefinePopupMenu(Qmenus::TPopupMenu* Popup);
	virtual void __fastcall DefineProperties(void);
	virtual void __fastcall ShowEditor(void);
	__property Qgraphics::TFont* Font = {read=FFont, write=SetFont};
};


class DELPHICLASS TfrBandView;
class PASCALIMPLEMENTATION TfrBandView : public TfrView 
{
	typedef TfrView inherited;
	
private:
	HIDESBASE void __fastcall P1Click(System::TObject* Sender);
	void __fastcall P2Click(System::TObject* Sender);
	void __fastcall P3Click(System::TObject* Sender);
	void __fastcall P4Click(System::TObject* Sender);
	void __fastcall P5Click(System::TObject* Sender);
	void __fastcall P6Click(System::TObject* Sender);
	void __fastcall P7Click(System::TObject* Sender);
	TfrBandType __fastcall GetBandType(void);
	void __fastcall SetBandType(const TfrBandType Value);
	int __fastcall GetRectangleWidth(void);
	
protected:
	virtual void __fastcall SetPropValue(AnsiString Index, const Variant &Value);
	virtual Variant __fastcall GetPropValue(AnsiString Index);
	virtual Variant __fastcall DoMethod(AnsiString MethodName, const Variant &Par1, const Variant &Par2, const Variant &Par3);
	
public:
	AnsiString ChildBand;
	AnsiString Master;
	int Columns;
	int ColumnWidth;
	int ColumnGap;
	int NewColumnAfter;
	__fastcall virtual TfrBandView(void);
	virtual void __fastcall Draw(Qgraphics::TCanvas* Canvas);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToFR3Stream(Classes::TStream* Stream);
	virtual void __fastcall DefinePopupMenu(Qmenus::TPopupMenu* Popup);
	virtual void __fastcall DefineProperties(void);
	virtual Qt::QRegionH* __fastcall GetClipRgn(TfrRgnType rt);
	__property TfrBandType BandType = {read=GetBandType, write=SetBandType, nodefault};
	__property AnsiString DataSet = {read=FormatStr, write=FormatStr};
	__property AnsiString GroupCondition = {read=FormatStr, write=FormatStr};
public:
	#pragma option push -w-inl
	/* TfrView.Destroy */ inline __fastcall virtual ~TfrBandView(void) { }
	#pragma option pop
	
};


class DELPHICLASS TfrSubReportView;
class PASCALIMPLEMENTATION TfrSubReportView : public TfrView 
{
	typedef TfrView inherited;
	
public:
	int SubPage;
	__fastcall virtual TfrSubReportView(void);
	virtual void __fastcall Draw(Qgraphics::TCanvas* Canvas);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToFR3Stream(Classes::TStream* Stream);
	virtual void __fastcall DefinePopupMenu(Qmenus::TPopupMenu* Popup);
public:
	#pragma option push -w-inl
	/* TfrView.Destroy */ inline __fastcall virtual ~TfrSubReportView(void) { }
	#pragma option pop
	
};


class DELPHICLASS TfrPictureView;
class PASCALIMPLEMENTATION TfrPictureView : public TfrView 
{
	typedef TfrView inherited;
	
private:
	HIDESBASE void __fastcall P1Click(System::TObject* Sender);
	void __fastcall P2Click(System::TObject* Sender);
	
protected:
	virtual void __fastcall SetPropValue(AnsiString Index, const Variant &Value);
	virtual Variant __fastcall GetPropValue(AnsiString Index);
	virtual Variant __fastcall DoMethod(AnsiString MethodName, const Variant &Par1, const Variant &Par2, const Variant &Par3);
	virtual void __fastcall GetBlob(Fr_dbrel::TfrTField* b);
	
public:
	Qgraphics::TPicture* Picture;
	Byte BlobType;
	__fastcall virtual TfrPictureView(void);
	__fastcall virtual ~TfrPictureView(void);
	virtual void __fastcall Draw(Qgraphics::TCanvas* Canvas);
	virtual void __fastcall LoadFromStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToStream(Classes::TStream* Stream);
	virtual void __fastcall SaveToFR3Stream(Classes::TStream* Stream);
	virtual void __fastcall DefinePopupMenu(Qmenus::TPopupMenu* Popup);
	virtual void __fastcall DefineProperties(void);
	virtual void __fastcall ShowEditor(void);
};


class DELPHICLASS TfrLineView;
class PASCALIMPLEMENTATION TfrLineView : public TfrStretcheable 
{
	typedef TfrStretcheable inherited;
	
private:
	int FHeight;
	
public:
	__fastcall virtual TfrLineView(void);
	virtual void __fastcall Draw(Qgraphics::TCanvas* Canvas);
	virtual void __fastcall StreamOut(Classes::TStream* Stream);
	virtual int __fastcall CalcHeight(void);
	virtual int __fastcall MinHeight(void);
	virtual int __fastcall LostSpace(void);
	virtual Qt::QRegionH* __fastcall GetClipRgn(TfrRgnType rt);
	virtual void __fastcall DefineProperties(void);
	virtual void __fastcall SaveToFR3Stream(Classes::TStream* Stream);
public:
	#pragma option push -w-inl
	/* TfrView.Destroy */ inline __fastcall virtual ~TfrLineView(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TfrBand : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TfrPage* Parent;
	TfrBandView* View;
	Word Flags;
	TfrBand* Next;
	TfrBand* Prev;
	TfrBand* NextGroup;
	TfrBand* PrevGroup;
	TfrBand* FirstGroup;
	TfrBand* LastGroup;
	TfrBand* Child;
	TfrBand* AggrBand;
	int SubIndex;
	int MaxY;
	bool EOFReached;
	bool EOFArr[63];
	int Positions[2];
	Variant LastGroupValue;
	TfrBand* HeaderBand;
	TfrBand* FooterBand;
	TfrBand* DataBand;
	TfrBand* LastBand;
	Fr_pars::TfrVariables* Values;
	int Count;
	bool DisableInit;
	int CalculatedHeight;
	int CurColumn;
	int SaveXAdjust;
	bool SaveCurY;
	int CallNewPage;
	int CallNewColumn;
	int MaxColumns;
	bool DisableBandScript;
	void __fastcall InitDataSet(AnsiString Desc);
	void __fastcall FreeDataSet(void);
	int __fastcall CalcHeight(void);
	void __fastcall StretchObjects(int MaxHeight);
	void __fastcall UnStretchObjects(void);
	void __fastcall DrawObject(TfrView* t);
	void __fastcall PrepareSubReports(void);
	void __fastcall DoSubReports(void);
	bool __fastcall DrawObjects(void);
	void __fastcall DrawCrossCell(TfrBand* Parnt, int CurX);
	void __fastcall DrawCross(void);
	bool __fastcall CheckPageBreak(int y, int dy, bool PBreak);
	void __fastcall DrawPageBreak(void);
	bool __fastcall HasCross(void);
	int __fastcall DoCalcHeight(void);
	void __fastcall DoDraw(void);
	bool __fastcall Draw(void);
	void __fastcall InitValues(void);
	void __fastcall DoAggregate(void);
	AnsiString __fastcall ExtractField(const AnsiString s, int FieldNo);
	void __fastcall AddAggregateValue(AnsiString s, const Variant &v);
	Variant __fastcall GetAggregateValue(AnsiString s);
	
public:
	int x;
	int y;
	int dx;
	int dy;
	int maxdy;
	TfrBandType Typ;
	AnsiString Name;
	bool PrintIfSubsetEmpty;
	bool NewPageAfter;
	bool Stretched;
	bool PageBreak;
	bool PrintChildIfInvisible;
	bool Visible;
	Classes::TList* Objects;
	Classes::TStringList* Memo;
	Classes::TStringList* Script;
	Fr_dset::TfrDataset* DataSet;
	bool IsVirtualDS;
	Fr_dset::TfrDataset* VCDataSet;
	bool IsVirtualVCDS;
	AnsiString GroupCondition;
	__fastcall TfrBand(TfrBandType ATyp, TfrPage* AParent);
	__fastcall virtual ~TfrBand(void);
};


class PASCALIMPLEMENTATION TfrPage : public TfrObject 
{
	typedef TfrObject inherited;
	
private:
	TfrBand* Bands[23];
	bool Skip;
	bool InitFlag;
	int CurColumn;
	int LastStaticColumnY;
	int XAdjust;
	Classes::TList* List;
	TfrPageMode Mode;
	int PlayFrom;
	TfrBand* LastBand;
	int ColPos;
	int CurPos;
	TfrBand* WasBand;
	bool DisableRepeatHeader;
	void __fastcall DonePage(void);
	void __fastcall TossObjects(void);
	void __fastcall PrepareObjects(void);
	void __fastcall FormPage(void);
	void __fastcall AddRecord(TfrBand* b, TfrBandRecType rt);
	void __fastcall ClearRecList(void);
	bool __fastcall PlayRecList(void);
	void __fastcall DrawPageFooters(void);
	bool __fastcall BandExists(TfrBand* b);
	void __fastcall AfterPrint(void);
	void __fastcall LoadFromStream(Classes::TStream* Stream);
	void __fastcall SaveToStream(Classes::TStream* Stream);
	void __fastcall ShowBand(TfrBand* b);
	int __fastcall LeftOffset(void);
	void __fastcall DoScript(Classes::TStrings* Script);
	void __fastcall DialogFormActivate(System::TObject* Sender);
	void __fastcall ResetPosition(TfrBand* b, int ResetTo);
	
protected:
	void __fastcall InitPage(void);
	virtual void __fastcall SetPropValue(AnsiString Index, const Variant &Value);
	virtual Variant __fastcall GetPropValue(AnsiString Index);
	
public:
	int pgSize;
	int pgWidth;
	int pgHeight;
	#pragma pack(push, 1)
	Types::TRect pgMargins;
	#pragma pack(pop)
	
	Qprinters::TPrinterOrientation pgOr;
	int pgBin;
	Word PrintToPrevPage;
	Word UseMargins;
	TfrPrnInfo PrnInfo;
	int ColCount;
	int ColWidth;
	int ColGap;
	TfrPageType PageType;
	Classes::TList* Objects;
	int CurY;
	int CurBottomY;
	AnsiString Name;
	Byte BorderStyle;
	AnsiString Caption;
	Qgraphics::TColor Color;
	int Left;
	int Top;
	int Width;
	int Height;
	Byte Position;
	Qforms::TForm* Form;
	Classes::TStringList* Script;
	bool Visible;
	int PageNumber;
	__fastcall virtual TfrPage(int ASize, int AWidth, int AHeight, int ABin, Qprinters::TPrinterOrientation AOr);
	__fastcall virtual ~TfrPage(void);
	virtual void __fastcall DefineProperties(void);
	void __fastcall CreateUniqueName(void);
	int __fastcall TopMargin(void);
	int __fastcall BottomMargin(void);
	int __fastcall LeftMargin(void);
	int __fastcall RightMargin(void);
	void __fastcall Clear(void);
	void __fastcall Delete(int Index);
	int __fastcall FindObjectByID(int ID);
	TfrView* __fastcall FindObject(AnsiString Name);
	void __fastcall ChangePaper(int ASize, int AWidth, int AHeight, int ABin, Qprinters::TPrinterOrientation AOr);
	void __fastcall ShowBandByName(AnsiString s);
	void __fastcall ShowBandByType(TfrBandType bt);
	void __fastcall NewPage(void);
	void __fastcall NewColumn(TfrBand* Band);
	void __fastcall ScriptEditor(System::TObject* Sender);
};


class DELPHICLASS TfrPages;
class DELPHICLASS TfrReport;
class DELPHICLASS TfrEMFPages;
class PASCALIMPLEMENTATION TfrEMFPages : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	PfrPageInfo operator[](int Index) { return Pages[Index]; }
	
private:
	Classes::TList* FPages;
	TfrReport* Parent;
	int __fastcall GetCount(void);
	PfrPageInfo __fastcall GetPages(int Index);
	void __fastcall ExportData(int Index);
	
public:
	__fastcall TfrEMFPages(TfrReport* AParent);
	__fastcall virtual ~TfrEMFPages(void);
	void __fastcall Clear(void);
	void __fastcall Draw(int Index, Qgraphics::TCanvas* Canvas, const Types::TRect &DrawRect);
	void __fastcall Add(TfrPage* APage);
	void __fastcall Insert(int Index, TfrPage* APage);
	void __fastcall Delete(int Index);
	void __fastcall LoadFromStream(Classes::TStream* AStream);
	void __fastcall SaveToStream(Classes::TStream* AStream);
	bool __fastcall DoClick(int Index, const Types::TPoint &pt, bool Click, Qcontrols::TCursor &Cursor, AnsiString &mess);
	__property PfrPageInfo Pages[int Index] = {read=GetPages/*, default*/};
	__property int Count = {read=GetCount, nodefault};
	__property Classes::TList* List = {read=FPages, write=FPages};
	void __fastcall PageToObjects(int Index);
	void __fastcall ObjectsToPage(int Index);
};


class DELPHICLASS TfrDataDictionary;
class PASCALIMPLEMENTATION TfrDataDictionary : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TStringList* Cache;
	Variant __fastcall GetValue(AnsiString VarName);
	AnsiString __fastcall GetRealFieldName(AnsiString ItemName);
	AnsiString __fastcall GetRealDataSetName(AnsiString ItemName);
	AnsiString __fastcall GetRealDataSourceName(AnsiString ItemName);
	AnsiString __fastcall GetAliasName(AnsiString ItemName);
	void __fastcall AddCacheItem(AnsiString VarName, Fr_dbrel::TfrTDataSet* DataSet, AnsiString DataField);
	void __fastcall ClearCache(void);
	
public:
	Fr_pars::TfrVariables* Variables;
	Fr_pars::TfrVariables* FieldAliases;
	Fr_pars::TfrVariables* BandDatasources;
	Classes::TStringList* DisabledDatasets;
	__fastcall TfrDataDictionary(void);
	__fastcall virtual ~TfrDataDictionary(void);
	void __fastcall Clear(void);
	void __fastcall LoadFromStream(Classes::TStream* Stream);
	void __fastcall SaveToStream(Classes::TStream* Stream);
	void __fastcall LoadFromFile(AnsiString FName);
	void __fastcall SaveToFile(AnsiString FName);
	void __fastcall ExtractFieldName(AnsiString ComplexName, AnsiString &DSName, AnsiString &FieldName);
	bool __fastcall IsVariable(AnsiString VarName);
	bool __fastcall DatasetEnabled(AnsiString DatasetName);
	void __fastcall GetDatasetList(Classes::TStrings* List);
	void __fastcall GetFieldList(AnsiString DSName, Classes::TStrings* List);
	void __fastcall GetBandDatasourceList(Classes::TStrings* List);
	void __fastcall GetCategoryList(Classes::TStrings* List);
	void __fastcall GetVariablesList(AnsiString Category, Classes::TStrings* List);
	__property Variant Value[AnsiString Index] = {read=GetValue};
	__property AnsiString RealDataSetName[AnsiString Index] = {read=GetRealDataSetName};
	__property AnsiString RealDataSourceName[AnsiString Index] = {read=GetRealDataSourceName};
	__property AnsiString RealFieldName[AnsiString Index] = {read=GetRealFieldName};
	__property AnsiString AliasName[AnsiString Index] = {read=GetAliasName};
};


class DELPHICLASS TfrExportFilter;
class PASCALIMPLEMENTATION TfrExportFilter : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
protected:
	AnsiString FileName;
	Classes::TStream* Stream;
	Classes::TList* Lines;
	bool FShowDialog;
	bool FDefault;
	TBeforeExportEvent FOnBeforeExport;
	TAfterExportEvent FOnAfterExport;
	virtual void __fastcall ClearLines(void);
	
public:
	__fastcall virtual TfrExportFilter(Classes::TComponent* AOwner);
	__fastcall virtual ~TfrExportFilter(void);
	virtual Word __fastcall ShowModal(void);
	virtual void __fastcall OnBeginDoc(void);
	virtual void __fastcall OnEndDoc(void);
	virtual void __fastcall OnBeginPage(void);
	virtual void __fastcall OnEndPage(void);
	virtual void __fastcall OnData(int x, int y, TfrView* View);
	virtual void __fastcall OnText(const Types::TRect &DrawRect, int x, int y, const AnsiString text, int FrameTyp, TfrView* View);
	
__published:
	__property bool Default = {read=FDefault, write=FDefault, default=0};
	__property bool ShowDialog = {read=FShowDialog, write=FShowDialog, default=1};
	__property TBeforeExportEvent OnBeforeExport = {read=FOnBeforeExport, write=FOnBeforeExport};
	__property TAfterExportEvent OnAfterExport = {read=FOnAfterExport, write=FOnAfterExport};
};


class PASCALIMPLEMENTATION TfrReport : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TfrPages* FPages;
	TfrEMFPages* FEMFPages;
	TfrDataDictionary* FDictionary;
	Fr_dset::TfrDataset* FDataset;
	bool FGrayedButtons;
	TfrReportType FReportType;
	AnsiString FTitle;
	bool FShowProgress;
	bool FModalPreview;
	bool FModifyPrepared;
	bool FStoreInDFM;
	Fr_view::TfrPreview* FPreview;
	Fr_view::TfrPreviewButtons FPreviewButtons;
	Fr_view::TfrPreviewZoom FInitialZoom;
	TBeginDocEvent FOnBeginDoc;
	TEndDocEvent FOnEndDoc;
	TBeginPageEvent FOnBeginPage;
	TEndPageEvent FOnEndPage;
	TBeginBandEvent FOnBeginBand;
	TEndBandEvent FOnEndBand;
	TDetailEvent FOnGetValue;
	TEnterRectEvent FOnEnterRect;
	TProgressEvent FOnProgress;
	Fr_pars::TFunctionEvent FOnFunction;
	TBeginColumnEvent FOnBeginColumn;
	TPrintColumnEvent FOnPrintColumn;
	TManualBuildEvent FOnManualBuild;
	TObjectClickEvent FObjectClick;
	TMouseOverObjectEvent FMouseOverObject;
	TPrintReportEvent FOnPrintReportEvent;
	TfrExportFilter* FCurrentFilter;
	AnsiString FPageNumbers;
	int FCopies;
	bool FCollate;
	TfrPrintPages FPrintPages;
	TfrPage* FCurPage;
	bool _DoublePass;
	bool FMDIPreview;
	int FDefaultCopies;
	bool FDefaultCollate;
	AnsiString FPrnName;
	Classes::TStream* FDFMStream;
	bool FPrintIfEmpty;
	bool FShowPrintDialog;
	TBeginDocEvent FOnCrossBeginDoc;
	Classes::TNotifyEvent FOnCustomizeObject;
	bool FRebuildPrinter;
	bool FUseDefaultDataSetName;
	AnsiString __fastcall FormatValue(const Variant &V, int Format, const AnsiString FormatStr);
	void __fastcall BuildBeforeModal(System::TObject* Sender);
	void __fastcall ExportBeforeModal(System::TObject* Sender);
	void __fastcall PrintBeforeModal(System::TObject* Sender);
	bool __fastcall DoPrepareReport(void);
	virtual void __fastcall DoBuildReport(void);
	void __fastcall SetPrinterTo(AnsiString PrnName);
	void __fastcall GetIntrpValue(const AnsiString Name, Variant &Value);
	void __fastcall GetIntrpFunction(const AnsiString Name, const Variant &p1, const Variant &p2, const Variant &p3, Variant &Val);
	void __fastcall ClearAttribs(void);
	
protected:
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	void __fastcall ReadBinaryData(Classes::TStream* Stream);
	void __fastcall WriteBinaryData(Classes::TStream* Stream);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	virtual void __fastcall DoPrintReport(AnsiString PageNumbers, int Copies, bool Collate, TfrPrintPages PrintPages);
	virtual void __fastcall Loaded(void);
	
public:
	bool CanRebuild;
	bool Terminated;
	Word PrintToDefault;
	Word DoublePass;
	bool FinalPass;
	AnsiString FileName;
	bool Modified;
	bool ComponentModified;
	bool MixVariablesAndDBFields;
	bool FR3Stream;
	AnsiString ReportComment;
	AnsiString ReportName;
	AnsiString ReportAutor;
	System::TDateTime ReportCreateDate;
	System::TDateTime ReportLastChange;
	AnsiString ReportVersionMajor;
	AnsiString ReportVersionMinor;
	AnsiString ReportVersionRelease;
	AnsiString ReportVersionBuild;
	bool ReportPasswordProtected;
	AnsiString ReportPassword;
	Byte ReportGeneratorVersion;
	__fastcall virtual TfrReport(Classes::TComponent* AOwner);
	__fastcall virtual ~TfrReport(void);
	void __fastcall Clear(void);
	__property TBeginDocEvent OnCrossBeginDoc = {read=FOnCrossBeginDoc, write=FOnCrossBeginDoc};
	void __fastcall InternalOnEnterRect(Classes::TStringList* Memo, TfrView* View);
	void __fastcall InternalOnExportData(TfrView* View);
	void __fastcall InternalOnExportText(const Types::TRect &DrawRect, int x, int y, const AnsiString text, int FrameTyp, TfrView* View);
	void __fastcall InternalOnGetValue(AnsiString ParName, AnsiString &ParValue);
	void __fastcall InternalOnProgress(int Percent);
	void __fastcall InternalOnBeginColumn(TfrBand* Band);
	void __fastcall InternalOnPrintColumn(int ColNo, int &ColWidth);
	void __fastcall GetVariableValue(const AnsiString s, Variant &v);
	void __fastcall OnGetParsFunction(const AnsiString name, const Variant &p1, const Variant &p2, const Variant &p3, Variant &val);
	TfrView* __fastcall FindObject(AnsiString Name);
	void __fastcall LoadFromStream(Classes::TStream* Stream);
	void __fastcall SaveToStream(Classes::TStream* Stream);
	bool __fastcall LoadFromFile(AnsiString FName);
	void __fastcall SaveToFile(AnsiString FName);
	void __fastcall SaveToFR3File(AnsiString FName);
	void __fastcall LoadFromDB(Db::TDataSet* Table, int DocN);
	void __fastcall SaveToDB(Db::TDataSet* Table, int DocN);
	void __fastcall SaveToBlobField(Db::TField* Blob);
	void __fastcall LoadFromBlobField(Db::TField* Blob);
	void __fastcall LoadFromResourceName(unsigned Instance, const AnsiString ResName);
	void __fastcall LoadFromResourceID(unsigned Instance, int ResID);
	void __fastcall LoadTemplate(AnsiString fname, Classes::TStrings* comm, Qgraphics::TBitmap* Bmp, bool Load);
	void __fastcall SaveTemplate(AnsiString fname, Classes::TStrings* comm, Qgraphics::TBitmap* Bmp);
	void __fastcall LoadPreparedReport(AnsiString FName);
	void __fastcall SavePreparedReport(AnsiString FName);
	Qforms::TModalResult __fastcall DesignReport(void);
	bool __fastcall PrepareReport(void);
	void __fastcall ExportTo(TfrExportFilter* Filter, AnsiString FileName);
	void __fastcall ShowReport(void);
	void __fastcall ShowPreparedReport(void);
	void __fastcall PrintPreparedReportDlg(void);
	void __fastcall PrintPreparedReport(AnsiString PageNumbers, int Copies, bool Collate, TfrPrintPages PrintPages);
	bool __fastcall ChangePrinter(int OldIndex, int NewIndex);
	void __fastcall EditPreparedReport(int PageIndex);
	__property TfrPages* Pages = {read=FPages};
	__property TfrEMFPages* EMFPages = {read=FEMFPages, write=FEMFPages};
	__property TfrDataDictionary* Dictionary = {read=FDictionary, write=FDictionary};
	
__published:
	__property Fr_dset::TfrDataset* Dataset = {read=FDataset, write=FDataset};
	__property int DefaultCopies = {read=FDefaultCopies, write=FDefaultCopies, default=1};
	__property bool DefaultCollate = {read=FDefaultCollate, write=FDefaultCollate, default=1};
	__property bool GrayedButtons = {read=FGrayedButtons, write=FGrayedButtons, default=0};
	__property Fr_view::TfrPreviewZoom InitialZoom = {read=FInitialZoom, write=FInitialZoom, nodefault};
	__property bool MDIPreview = {read=FMDIPreview, write=FMDIPreview, default=0};
	__property bool ModalPreview = {read=FModalPreview, write=FModalPreview, default=1};
	__property bool ModifyPrepared = {read=FModifyPrepared, write=FModifyPrepared, default=1};
	__property Fr_view::TfrPreview* Preview = {read=FPreview, write=FPreview};
	__property Fr_view::TfrPreviewButtons PreviewButtons = {read=FPreviewButtons, write=FPreviewButtons, nodefault};
	__property bool PrintIfEmpty = {read=FPrintIfEmpty, write=FPrintIfEmpty, default=1};
	__property TfrReportType ReportType = {read=FReportType, write=FReportType, default=0};
	__property bool ShowPrintDialog = {read=FShowPrintDialog, write=FShowPrintDialog, default=1};
	__property bool ShowProgress = {read=FShowProgress, write=FShowProgress, default=1};
	__property bool StoreInDFM = {read=FStoreInDFM, write=FStoreInDFM, default=0};
	__property AnsiString Title = {read=FTitle, write=FTitle};
	__property bool RebuildPrinter = {read=FRebuildPrinter, write=FRebuildPrinter, nodefault};
	__property bool UseDefaultDataSetName = {read=FUseDefaultDataSetName, write=FUseDefaultDataSetName, default=0};
	__property TBeginDocEvent OnBeginDoc = {read=FOnBeginDoc, write=FOnBeginDoc};
	__property TEndDocEvent OnEndDoc = {read=FOnEndDoc, write=FOnEndDoc};
	__property TBeginPageEvent OnBeginPage = {read=FOnBeginPage, write=FOnBeginPage};
	__property TEndPageEvent OnEndPage = {read=FOnEndPage, write=FOnEndPage};
	__property TBeginBandEvent OnBeginBand = {read=FOnBeginBand, write=FOnBeginBand};
	__property TEndBandEvent OnEndBand = {read=FOnEndBand, write=FOnEndBand};
	__property TDetailEvent OnGetValue = {read=FOnGetValue, write=FOnGetValue};
	__property TEnterRectEvent OnBeforePrint = {read=FOnEnterRect, write=FOnEnterRect};
	__property Fr_pars::TFunctionEvent OnUserFunction = {read=FOnFunction, write=FOnFunction};
	__property TProgressEvent OnProgress = {read=FOnProgress, write=FOnProgress};
	__property TBeginColumnEvent OnBeginColumn = {read=FOnBeginColumn, write=FOnBeginColumn};
	__property TPrintColumnEvent OnPrintColumn = {read=FOnPrintColumn, write=FOnPrintColumn};
	__property TManualBuildEvent OnManualBuild = {read=FOnManualBuild, write=FOnManualBuild};
	__property TObjectClickEvent OnObjectClick = {read=FObjectClick, write=FObjectClick};
	__property TMouseOverObjectEvent OnMouseOverObject = {read=FMouseOverObject, write=FMouseOverObject};
	__property TPrintReportEvent OnPrintReport = {read=FOnPrintReportEvent, write=FOnPrintReportEvent};
	__property Classes::TNotifyEvent OnCustomizeObject = {read=FOnCustomizeObject, write=FOnCustomizeObject};
};


class PASCALIMPLEMENTATION TfrPages : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TfrPage* operator[](int Index) { return Pages[Index]; }
	
private:
	Classes::TList* FPages;
	TfrReport* Parent;
	int __fastcall GetCount(void);
	TfrPage* __fastcall GetPages(int Index);
	void __fastcall RefreshObjects(void);
	
public:
	__fastcall TfrPages(TfrReport* AParent);
	__fastcall virtual ~TfrPages(void);
	void __fastcall Clear(void);
	void __fastcall Add(void);
	void __fastcall Delete(int Index);
	void __fastcall Move(int OldIndex, int NewIndex);
	void __fastcall LoadFromStream(Classes::TStream* Stream);
	void __fastcall SaveToStream(Classes::TStream* Stream);
	__property TfrPage* Pages[int Index] = {read=GetPages/*, default*/};
	__property int Count = {read=GetCount, nodefault};
};


struct TfrCacheItem;
typedef TfrCacheItem *PfrCacheItem;

#pragma pack(push, 4)
struct TfrCacheItem
{
	Fr_dbrel::TfrTDataSet* DataSet;
	AnsiString DataField;
} ;
#pragma pack(pop)

class DELPHICLASS TfrCompositeReport;
class PASCALIMPLEMENTATION TfrCompositeReport : public TfrReport 
{
	typedef TfrReport inherited;
	
private:
	virtual void __fastcall DoBuildReport(void);
	
public:
	Classes::TList* Reports;
	HIDESBASE void __fastcall Clear(void);
	__fastcall virtual TfrCompositeReport(Classes::TComponent* AOwner);
	__fastcall virtual ~TfrCompositeReport(void);
	
__published:
	__property Word DoublePassReport = {read=DoublePass, write=DoublePass, nodefault};
};


class DELPHICLASS TfrReportDesigner;
class PASCALIMPLEMENTATION TfrReportDesigner : public Qforms::TForm 
{
	typedef Qforms::TForm inherited;
	
protected:
	bool FirstInstance;
	virtual bool __fastcall GetModified(void) = 0 ;
	virtual void __fastcall SetModified(bool Value) = 0 ;
	
public:
	TfrPage* Page;
	__fastcall virtual TfrReportDesigner(bool AFirstInstance);
	virtual void __fastcall BeforeChange(void) = 0 ;
	virtual void __fastcall AfterChange(void) = 0 ;
	virtual void __fastcall RedrawPage(void) = 0 ;
	virtual void __fastcall SelectObject(AnsiString ObjName) = 0 ;
	virtual AnsiString __fastcall InsertDBField(void) = 0 ;
	virtual AnsiString __fastcall InsertExpression(void) = 0 ;
	__property bool Modified = {read=GetModified, write=SetModified, nodefault};
public:
	#pragma option push -w-inl
	/* TCustomForm.Create */ inline __fastcall virtual TfrReportDesigner(Classes::TComponent* AOwner) : Qforms::TForm(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomForm.CreateNew */ inline __fastcall virtual TfrReportDesigner(Classes::TComponent* AOwner, int Dummy) : Qforms::TForm(AOwner, Dummy) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomForm.Destroy */ inline __fastcall virtual ~TfrReportDesigner(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWidgetControl.CreateParented */ inline __fastcall TfrReportDesigner(Qt::QWidgetH* ParentWidget) : Qforms::TForm(ParentWidget) { }
	#pragma option pop
	
};


class DELPHICLASS TfrObjEditorForm;
class PASCALIMPLEMENTATION TfrObjEditorForm : public Qforms::TForm 
{
	typedef Qforms::TForm inherited;
	
public:
	virtual Qforms::TModalResult __fastcall ShowEditor(TfrView* View);
public:
	#pragma option push -w-inl
	/* TCustomForm.Create */ inline __fastcall virtual TfrObjEditorForm(Classes::TComponent* AOwner) : Qforms::TForm(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomForm.CreateNew */ inline __fastcall virtual TfrObjEditorForm(Classes::TComponent* AOwner, int Dummy) : Qforms::TForm(AOwner, Dummy) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomForm.Destroy */ inline __fastcall virtual ~TfrObjEditorForm(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWidgetControl.CreateParented */ inline __fastcall TfrObjEditorForm(Qt::QWidgetH* ParentWidget) : Qforms::TForm(ParentWidget) { }
	#pragma option pop
	
};


class DELPHICLASS TfrFunctionLibrary;
class PASCALIMPLEMENTATION TfrFunctionLibrary : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	Classes::TStringList* List;
	__fastcall virtual TfrFunctionLibrary(void);
	__fastcall virtual ~TfrFunctionLibrary(void);
	virtual bool __fastcall OnFunction(const AnsiString FName, const Variant &p1, const Variant &p2, const Variant &p3, Variant &val);
	virtual void __fastcall DoFunction(int FNo, const Variant &p1, const Variant &p2, const Variant &p3, Variant &val) = 0 ;
	void __fastcall AddFunctionDesc(AnsiString FuncName, AnsiString Category, AnsiString Description);
};


class DELPHICLASS TfrCompressor;
class PASCALIMPLEMENTATION TfrCompressor : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	bool Enabled;
	__fastcall virtual TfrCompressor(void);
	virtual void __fastcall Compress(Classes::TStream* StreamIn, Classes::TStream* StreamOut);
	virtual void __fastcall DeCompress(Classes::TStream* StreamIn, Classes::TStream* StreamOut);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TfrCompressor(void) { }
	#pragma option pop
	
};


class DELPHICLASS TfrInstalledFunctions;
class PASCALIMPLEMENTATION TfrInstalledFunctions : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TList* FList;
	void __fastcall UnRegisterFunctionLibrary(TfrFunctionLibrary* FunctionLibrary);
	
public:
	__fastcall TfrInstalledFunctions(void);
	__fastcall virtual ~TfrInstalledFunctions(void);
	void __fastcall Add(TfrFunctionLibrary* FunctionLibrary, AnsiString FuncName, AnsiString Category, AnsiString Description);
	AnsiString __fastcall GetFunctionDesc(AnsiString FuncName);
	void __fastcall GetCategoryList(Classes::TStrings* List);
	void __fastcall GetFunctionList(AnsiString Category, Classes::TStrings* List);
};


class DELPHICLASS TDatabaseFunctionLibrary;
class PASCALIMPLEMENTATION TDatabaseFunctionLibrary : public TfrFunctionLibrary 
{
	typedef TfrFunctionLibrary inherited;
	
public:
	__fastcall virtual TDatabaseFunctionLibrary(void);
	virtual void __fastcall DoFunction(int FNo, const Variant &p1, const Variant &p2, const Variant &p3, Variant &val);
public:
	#pragma option push -w-inl
	/* TfrFunctionLibrary.Destroy */ inline __fastcall virtual ~TDatabaseFunctionLibrary(void) { }
	#pragma option pop
	
};


class DELPHICLASS TfrGlobals;
class PASCALIMPLEMENTATION TfrGlobals : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	__fastcall TfrGlobals(void);
	__fastcall virtual ~TfrGlobals(void);
	void __fastcall Localize(void);
};


typedef AnsiString fr_class__72[9];

typedef AnsiString fr_class__82[9];

typedef AnsiString fr_class__92[42];

typedef AnsiString fr_class__03[23];

typedef AnsiString fr_class__13[4];

typedef AnsiString fr_class__23[4];

struct TfrTextRec;
typedef TfrTextRec *PfrTextRec;

#pragma pack(push, 4)
struct TfrTextRec
{
	TfrTextRec *Next;
	int X;
	int Y;
	AnsiString Text;
	System::SmallString<32>  FontName;
	int FontSize;
	int FontStyle;
	int FontColor;
	int FontCharset;
	int FillColor;
	Types::TRect DrawRect;
	int FrameTyp;
	int FrameWidth;
	int FrameColor;
	int Alignment;
} ;
#pragma pack(pop)

#pragma pack(push, 4)
struct TfrAddInObjectInfo
{
	TMetaClass* ClassRef;
	Qgraphics::TBitmap* ButtonBmp;
	AnsiString ButtonHint;
	bool IsControl;
} ;
#pragma pack(pop)

#pragma pack(push, 4)
struct TfrExportFilterInfo
{
	TfrExportFilter* Filter;
	AnsiString FilterDesc;
	AnsiString FilterExt;
} ;
#pragma pack(pop)

#pragma pack(push, 4)
struct TfrFunctionInfo
{
	TfrFunctionLibrary* FunctionLibrary;
} ;
#pragma pack(pop)

struct TfrToolsInfo
{
	AnsiString Caption;
	Qgraphics::TBitmap* ButtonBmp;
	Classes::TNotifyEvent OnClick;
} ;

typedef TfrAddInObjectInfo fr_class__33[64];

typedef TfrExportFilterInfo fr_class__43[64];

typedef TfrToolsInfo fr_class__53[64];

//-- var, const, procedure ---------------------------------------------------
static const Shortint flStretched = 0x1;
static const Shortint flWordWrap = 0x2;
static const Shortint flWordBreak = 0x4;
static const Shortint flAutoSize = 0x8;
static const Shortint flTextOnly = 0x10;
static const Shortint flSuppressRepeated = 0x20;
static const Shortint flHideZeros = 0x40;
static const Byte flUnderlines = 0x80;
static const Word flRTLReading = 0x100;
static const Shortint flBandNewPageAfter = 0x2;
static const Shortint flBandPrintifSubsetEmpty = 0x4;
static const Shortint flBandBreaked = 0x8;
static const Shortint flBandOnFirstPage = 0x10;
static const Shortint flBandOnLastPage = 0x20;
static const Shortint flBandRepeatHeader = 0x40;
static const Byte flBandPrintChildIfInvisible = 0x80;
static const Shortint flPictCenter = 0x2;
static const Shortint flPictRatio = 0x4;
static const Word flWantHook = 0x8000;
static const Word flDontUndo = 0x4000;
static const Word flOnePerPage = 0x2000;
static const Shortint gtMemo = 0x0;
static const Shortint gtPicture = 0x1;
static const Shortint gtBand = 0x2;
static const Shortint gtSubReport = 0x3;
static const Shortint gtLine = 0x4;
static const Shortint gtCross = 0x5;
static const Shortint gtAddIn = 0xa;
static const Shortint frftNone = 0x0;
static const Shortint frftRight = 0x1;
static const Shortint frftBottom = 0x2;
static const Shortint frftLeft = 0x4;
static const Shortint frftTop = 0x8;
static const Shortint frtaLeft = 0x0;
static const Shortint frtaRight = 0x1;
static const Shortint frtaCenter = 0x2;
static const Shortint frtaVertical = 0x4;
static const Shortint frtaMiddle = 0x8;
static const Shortint frtaDown = 0x10;
static const Shortint baNone = 0x0;
static const Shortint baLeft = 0x1;
static const Shortint baRight = 0x2;
static const Shortint baCenter = 0x3;
static const Shortint baWidth = 0x4;
static const Shortint baBottom = 0x5;
static const Shortint baTop = 0x6;
static const Shortint baRest = 0x7;
static const Shortint frrfDontEditMemo = 0x1;
static const Shortint frrfDontEditScript = 0x2;
static const Shortint frrfDontEditContents = 0x4;
static const Shortint frrfDontModify = 0x8;
static const Shortint frrfDontSize = 0x10;
static const Shortint frrfDontMove = 0x20;
static const Shortint frrfDontDelete = 0x40;
static const Shortint psDouble = 0x5;
static const Shortint frtName = 0x4d;
static const Shortint frCurrentVersion = 0x19;
static const Shortint frSpecCount = 0x9;
extern PACKAGE AnsiString frSpecFuncs[9];
static const Shortint frRepInfoCount = 0x9;
extern PACKAGE AnsiString frRepInfo[9];
extern PACKAGE Qgraphics::TColor frColors[42];
extern PACKAGE AnsiString frColorNames[42];
extern PACKAGE AnsiString frBandNames[23];
extern PACKAGE AnsiString frDateFormats[4];
extern PACKAGE AnsiString frTimeFormats[4];
#define frDefaultFont "adobe-helvetica"
extern TfrReportDesigner* frDesigner;
extern TMetaClass* frDesignerClass;
extern Fr_pars::TfrParser* frParser;
extern Fr_intrp::TfrInterpretator* frInterpretator;
extern Fr_pars::TfrVariables* frVariables;
extern Fr_pars::TfrVariables* frConsts;
extern TfrCompressor* frCompressor;
extern Qforms::TForm* frDialogForm;
extern TfrReport* CurReport;
extern TfrReport* MasterReport;
extern TfrView* CurView;
extern TfrBand* CurBand;
extern TfrPage* CurPage;
extern TfrDocMode DocMode;
extern bool DisableDrawing;
extern TfrAddInObjectInfo frAddIns[64];
extern int frAddInsCount;
extern TfrExportFilterInfo frFilters[64];
extern int frFiltersCount;
extern TfrFunctionInfo frFunctions[64];
extern int frFunctionsCount;
extern TfrToolsInfo frTools[64];
extern int frToolsCount;
extern TfrInstalledFunctions* frInstalledFunctions;
extern int PageNo;
extern Byte frCharset;
extern Byte frVersion;
extern bool ErrorFlag;
extern AnsiString ErrorStr;
extern Classes::TStringList* SMemo;
extern PACKAGE bool ShowBandTitles;
extern bool frThreadDone;
extern Fr_progr::TfrProgressForm* frProgressForm;
extern Classes::TNotifyEvent frMemoEditor;
extern Classes::TNotifyEvent frTagEditor;
extern Classes::TNotifyEvent frRestrEditor;
extern Classes::TNotifyEvent frHighlightEditor;
extern Classes::TNotifyEvent frFieldEditor;
extern Classes::TNotifyEvent frDataSourceEditor;
extern Classes::TNotifyEvent frCrossDataSourceEditor;
extern Classes::TNotifyEvent frGroupEditor;
extern Classes::TNotifyEvent frPictureEditor;
extern Classes::TNotifyEvent frFontEditor;
extern TfrGlobals* frGlobals;
extern Inifiles::TMemIniFile* frIni;
extern bool frDesignerDoneModal;
extern bool frDesigner1DoneModal;
extern PACKAGE TfrView* __fastcall frCreateObject(Byte Typ, const AnsiString ClassName);
extern PACKAGE void __fastcall frRegisterObject(TMetaClass* ClassRef, Qgraphics::TBitmap* ButtonBmp, const AnsiString ButtonHint);
extern PACKAGE void __fastcall frRegisterControl(TMetaClass* ClassRef, Qgraphics::TBitmap* ButtonBmp, const AnsiString ButtonHint);
extern PACKAGE void __fastcall frUnRegisterObject(TMetaClass* ClassRef);
extern PACKAGE void __fastcall frRegisterExportFilter(TfrExportFilter* Filter, const AnsiString FilterDesc, const AnsiString FilterExt);
extern PACKAGE void __fastcall frUnRegisterExportFilter(TfrExportFilter* Filter);
extern PACKAGE void __fastcall frRegisterFunctionLibrary(TMetaClass* ClassRef);
extern PACKAGE void __fastcall frUnRegisterFunctionLibrary(TMetaClass* ClassRef);
extern PACKAGE void __fastcall frRegisterTool(AnsiString MenuCaption, Qgraphics::TBitmap* ButtonBmp, Classes::TNotifyEvent OnClick);
extern PACKAGE void __fastcall frAddFunctionDesc(TfrFunctionLibrary* FuncLibrary, AnsiString FuncName, AnsiString Category, AnsiString Description);
extern PACKAGE Fr_dbrel::TfrTDataSet* __fastcall GetDefaultDataSet(void);

}	/* namespace Fr_class */
using namespace Fr_class;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// fr_class
