/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
VSPageA.h
*********************************************************************/

#ifndef VSPageA_H
#define VSPageA_H /* Page API routines module */

#ifndef __GNUC__ /* suppress gcc warning */
#pragma once
#endif /* __GNUC__ */ 

#include "VSTypes.h"

/* Page Rotation Angle. The number of degrees by which the page should
be rotated clockwise when displayed or printed. The value must be a multiple
of 90. Default value: 0. */
typedef enum {
    pra0 = 0,   /*   0 deg. - rotation angle */
    pra90,      /*  90 deg. - rotation angle */
    pra180,     /* 180 deg. - rotation angle */
    pra270      /* 270 deg. - rotation angle */
} TPDFPageRotateAngle;

/* Page Box Type */
typedef enum {
    pbnMediaBox, /* A rectangle, expressed in default user space units, defining the boundaries
                 of the physical medium on which the page is intended to be displayed or printed */
    pbnCropBox,  /* A rectangle, expressed in default user space units, defining the visible region
                 of default user space. When the page is displayed or printed, its contents are to
                 be clipped (cropped) to this rectangle and then imposed on the output medium in
                 some implementation defined manner. */
    pbnBleedBox, /* A rectangle, expressed in default user space units, defining the region to which
                 the contents of the page should be clipped when output in a production environment */
    pbnTrimBox,  /* A rectangle, expressed in default user space units, defining the intended
                 dimensions of the finished page after trimming */
    pbnArtBox    /* A rectangle, expressed in default user space units, defining the extent of the
                 pages meaningful content (including potential white space) as intended by the
                 pages creator */
} TPDFPageBoxType;

#ifdef __cplusplus
    extern "C"{
#endif

    /************************************************************************
    Description :
        Get Page Content Streams Count.
    Parameters :
        Doc     - [in] PDF Document Handle.
        Page    - [in] Page Index in PDF Document.
    Returns :
        Page Content Streams Count.
    ************************************************************************/
    ppInt32 PDFPageGetContentCount( PDFDocHandle Doc, ppInt32 Page );
    /************************************************************************
    Description :
        Get Page Object Handle.
    Parameters :
        Doc     - [in] PDF Document Handle.
        Page    - [in] Page Index in PDF Document.
    Returns :
        Page Object Handle.
    ************************************************************************/
    PDFCosHandle PDFPageGetCosObject( PDFDocHandle Doc, ppInt32 Page );
    /* Description
       Set Rotation Angle of Page.
       Parameters
       Doc :     [in] PDF Document Handle.
       Page :    [in] Page Index in PDF Document.
       Rotate :  [in] Page Rotation Angle by which the page displayed
                 or printed should be rotated clockwise 
       Returns
       None.
       See Also
       PDFPageGetRotateAngle                                          */
    void PDFPageSetRotateAngle( PDFDocHandle Doc, ppInt32 Page, TPDFPageRotateAngle Rotate );
    /* Description
       Get Rotation Angle of Page.
       Parameters
       Doc :   [in] PDF Document Handle.
       Page :  [in] Page Index in PDF Document.
       Returns
       Page Rotation Angle by which the page displayed or printed
       should be rotated clockwise.
       See Also
       PDFPageSetRotateAngle                                      */
    TPDFPageRotateAngle PDFPageGetRotateAngle( PDFDocHandle Doc, ppInt32 Page );
    /* Description
       Get Typed Rectangle PageBox.
       Parameters
       Doc :   [in] PDF Document Handle.
       Page :  [in] Page Index in PDF Document.
       Type :  [in] PageBox Type for request.
       Returns
       PageBox Typed Rectangle.
       See Also
       PDFPageSetBox                            */
    TPDFRect PDFPageGetBox( PDFDocHandle Doc, ppInt32 Page, TPDFPageBoxType Type );
    /* Description
       Set Typed Rectangle PageBox.
       Parameters
       Doc :   [in] PDF Document Handle.
       Page :  [in] Page Index in PDF Document.
       Type :  [in] PageBox Type for setting.
       Rect :  [in] PageBox Rectangle.
       Returns
       None.
       See Also
       PDFPageGetBox                            */
    void PDFPageSetBox( PDFDocHandle Doc, ppInt32 Page, TPDFPageBoxType Type, TPDFRect Rect );
    /************************************************************************
    Description :
        Add void Content to Page Content Streams.
    Parameters :
        Doc     - [in] PDF Document Handle.
        Page    - [in] Page Index in PDF Document.
    Returns :
        Page Content Streams Count..
    See also :
        PDFPageGetContentCount
    ************************************************************************/
    ppInt32 PDFPageAddContent( PDFDocHandle Doc, ppInt32 Page );
    /************************************************************************
    Description :
        Insert void Content to Page Content Streams in Indexed Site.
    Parameters :
        Doc     - [in] PDF Document Handle.
        Page    - [in] Page Index in PDF Document.
        Index   - [in] Content Index for inserting.
    Returns :
        Index of void Page Content in Content Streams.
    See also :
        PDFPageRemoveContent
    ************************************************************************/
    ppInt32 PDFPageInsertContent( PDFDocHandle Doc, ppInt32 Page, ppInt32 Index );
    /* Description
       Remove Content from Page Content Streams according to index.
       Parameters
       Doc :    [in] PDF Document Handle.
       Page :   [in] Page Index in PDF Document.
       Index :  [in] Content Index for deleting.
       Returns
       None.
       See Also
       PDFPageInsertContent                                         */
    void PDFPageRemoveContent( PDFDocHandle Doc, ppInt32 Page, ppInt32 Index );
    /************************************************************************
    Description :
        Create Paint Box for Last Page Content with defined resolution.
    Parameters :
        Doc     - [in] PDF Document Handle.
        Page    - [in] Page Index in PDF Document.
        Resolution - [in] Points per inch (dpi).
    Returns :
        Paint Box Handle.
    See also :
        PDFPageContentCreatePaintBox
    ************************************************************************/
    PBXHandle PDFPageCreatePaintBox( PDFDocHandle Doc, ppInt32 Page, ppInt32 Resolution );
    /* Description
       Create Paint Box for Page Content according to index with
       defined resolution.
       Parameters
       Doc :         [in] PDF Document Handle.
       Page :        [in] Page Index in PDF Document.
       Index :       [in] Content's Index in Page Content Streams.
       Resolution :  [in] Points per inch (dpi).
       Returns
       Paint Box Handle.
       See Also
       PDFPageCreatePaintBox                                       */
    PBXHandle PDFPageContentCreatePaintBox( PDFDocHandle Doc, ppInt32 Page, ppInt32 Index,
                                           ppInt32 Resolution );

#ifdef __cplusplus
}
#endif

#endif /* #ifndef VSPageA_H */
