/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
VSLibA.h
*********************************************************************/

#ifndef VSLibA_H
#define VSLibA_H
#ifndef __GNUC__ /* suppress gcc warning */
#pragma once
#endif /* __GNUC__ */

#include "VSTypes.h"

#ifdef __cplusplus
extern "C"{
#endif

	/* Description
	   Initialize VersyPDF library for current username and
	   registration key. Prepare and fill in all library structures.
	   Returns
	   None.                                                         */
    PDFLibHandle InitPDFLibrary(char *username, char *key);

	/* Description
	        Close VersyPDF library.
	   Parameters
	        lib :  [ in ] Handle to created VersyPDF library.
	   Returns
	        None.                                             */
    void DonePDFLibrary(PDFLibHandle *lib);

#ifdef __cplusplus
}
#endif

#endif /* #ifndef VSLibA_H */
