/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
VSImageA.h
*********************************************************************/

#ifndef VSImageA_H
#define VSImageA_H
#ifndef __GNUC__ /* suppress gcc warning */
#pragma once
#endif /* __GNUC__ */

#ifdef __cplusplus
extern "C"{
#endif

#include "VSTypes.h"

/* Available image compression types */
typedef enum _t_TImageCompressionType {
#ifdef VSPDF_JBIG2_SUPPORT
		itcJBIG2,            /* JBIG2 compression */
#endif
		itcFlate,            /* FLATE compression */
#ifdef VSPDF_JPEG_SUPPORT
		itcJPEG,             /* JPEG compression */
#endif
		itcCCITT42D          /* CCITT 4 compression */
}TImageCompressionType;

/* Available black and white compressions */
typedef enum _t_TPDFImageCompression {
		pdfiCCITT,          /* CCITT compression */
#ifdef VSPDF_JBIG2_SUPPORT
		pdfiJbig2,          /* JBIG2 compression */
#endif
		pdfiFlate            /* FLATE compression */
} TPDFImageCompression;

#ifdef WINDOWS_PLATFORM

#include "windows.h"

	/********************************************************************
    Description:
        Append image to document from bitmap handle.
    Parameters:
           Doc                  - [ in ] Current PDF document.
		   Bitmap             	- [ in ] Bitmap handle.
		   ImageCompressionType	- [ in ] Image compression type.
    Returns:
        Pdf image index.
    *********************************************************************/
    ppInt32 PDFDocAppentImageFromBitmapHandle ( PDFDocHandle Doc, HBITMAP Bitmap, TImageCompressionType ImageCompressionType );

#endif

#ifdef VSPDF_JPEG_SUPPORT

	/********************************************************************
    Description:
        Append image to document from JPEG file.
    Parameters:
           Doc                  - [ in ] Current PDF document.
		   filename            	- [ in ] JPEG filename.
		   ImageCompressionType	- [ in ] Image compression type.
    Returns:
        Pdf image index.
    *********************************************************************/
    ppInt32 PDFDocAppentImageFromJPEGFile ( PDFDocHandle Doc, char *filename, TImageCompressionType ImageCompressionType );

	/********************************************************************
    Description:
        Append image to document from JPEG buffer.
    Parameters:
           Doc                  - [ in ] Current PDF document.
		   size                 - [ in ] Size of JPEG image buffer.
		   buffer            	- [ in ] Pointer to JPEG image buffer.
		   ImageCompressionType	- [ in ] Image compression type.
    Returns:
        Pdf image index.
    *********************************************************************/
	ppInt32 PDFDocAppentImageFromJPEGMemoryBuffer ( PDFDocHandle Doc, int size, char * buffer, TImageCompressionType ImageCompressionType );

#endif

#ifdef VSPDF_TIFF_SUPPORT

	/* Description
	   Append image to document from TIFF file.
	   Parameters
	   Doc :                   [ in ] Current PDF document.
	   filename :              [ in ] TIFF filename.
	   ImageIndex :            [ in, out] Image index in TIFF file ( if
	                           ImageIndex = \-1 returns count of images in
	                           \file )
	   ImageCompressionType :  [ in ] Image compression type.
	   Returns
	   Pdf image index.                                                    */
	ppInt32 PDFDocAppentImageFromTIFFFile ( PDFDocHandle Doc, char *filename, ppInt32 * ImageIndex, TImageCompressionType ImageCompressionType );

#endif

#ifdef VSPDF_PNG_SUPPORT

	/********************************************************************
    Description:
        Append image to document from PNG file.
    Parameters:
           Doc                  - [ in ] Current PDF document.
		   filename            	- [ in ] PNG filename.
		   ImageCompressionType	- [ in ] Image compression type.
    Returns:
        Pdf image index.
    *********************************************************************/
	ppInt32 PDFDocAppentImageFromPNGFile ( PDFDocHandle Doc, char *filename, TImageCompressionType ImageCompressionType );

#endif

#ifdef __cplusplus
}
#endif

#endif /* #ifndef VSImageA_H */