/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
VSError.h
*********************************************************************/

#ifndef VSError_H
#define VSError_H /* All errors list module */

#ifndef __GNUC__ /* suppress gcc warning */
#pragma once
#endif /* __GNUC__ */

#include "VSTypes.h"

#define PDF_ERR_LEVEL_MASK      0x0FFF0000 /* Error level mask in full error code */
#define PDF_ERR_ERROR_MASK      0x0000FFFF /* Error type mask in full error code */
#define PDF_ERR_LEVEL_SHIFT     16         /* Shift of error level in full error code */
#define PDF_ERR_ERROR_SHIFT     0          /* Shift of error type in full error code */

#define PDFBuildErrCode(xlevel,xerror) \
    ((((ppUns32)xlevel) << PDF_ERR_LEVEL_SHIFT ) | \
    ((((ppUns32)xerror) << PDF_ERR_ERROR_SHIFT) & PDF_ERR_ERROR_MASK )) /* Create full error code */

#define PDFGetErrLevel(errcode) (((ppUns32)errcode & PDF_ERR_LEVEL_MASK) >> PDF_ERR_LEVEL_SHIFT) /* Take only error level from full error code */

#define PDFGetErrError(errcode) (((ppUns32)errcode & PDF_ERR_ERROR_MASK) >> PDF_ERR_ERROR_SHIFT) /* Take only error type from full error code */


    /************************************************************************
    Description :
        Error Level Type in fault situations.
    ************************************************************************/
    typedef enum {
        ErrGeneralLevel = 0,    /* General Level of Error in fault situations       */
        ErrCosLevel,            /* Data Object's Level of Error in fault situations */
        ErrFileLevel,           /* File System's Level of Error in fault situations */
        ErrPageLevel,           /* Page's Level of Error in fault situations        */
        ErrDocumentLevel,       /* Document's Level of Error in fault situations    */
        ErrSignLevel,           /* Signature's Level of Error in fault situations   */
    } PDFErrLevels;
    /************************************************************************
    Description :
        Error Type of General Level of fault situations. When we are working
        with any programming code.
    ************************************************************************/
    typedef enum {
        gleNoError = 0,                 /* No Error */
        gleOtherError,                  /* Other Error */
        gleNotEnoughMemoryError,        /* Not Enough Memory */
        gleCannotOpenFileError,         /* Cannot Open File */
        gleCannotReceiveFileSizeError,  /* Cannot Receive File Size */
        gleCannotCreateMapFileError,    /* Cannot Create Map File */
        gleOutOfBoundError,             /* Out Of Bound */
        gleCannotChangeCapacityError,   /* Cannot Change Capacity */
        gleCannotReceiveFontDataError,  /* Cannot Receive Font Data */
        gleCannotSaveBufferToFileError, /* Cannot Save Buffer To File */
        gleWindowsGDIError,             /* Windows GDI */
		gleInvalidBitmapError,          /* Invalid Bitmap */
        gleInvalidJpegQualityError,     /* Invalid ipeg-image Quality */
		gleInvalidPNGInfoError,         /* Invalid PNG Info */
		gleLoadTIFFError                /* Load TIFF */
    } PDFGeneralLevelErrors;
    /************************************************************************
    Description :
        Error Type of Document Level of fault situations. When we are working
        with PDF Document.
    ************************************************************************/
    typedef enum {
        dleNoError = 0,                     /* No Error */
        dleOtherError,                      /* Other Error */
        dleCannotUseThisColorDeviceError,   /* Cannot Use This Color Device */
        dleCannotUseBookmarkRootError,      /* Cannot Use Bookmark Root */
        dleCannotFindFirstBeadError,        /* Cannot Find First Bead */
        dleCannotFindThreadForBeadError,    /* Cannot Find Thread For Bead */
        dleCannotFindCurrentBeadError,      /* Cannot Find Current Bead */
        dleCannotFindBeadRectError,         /* Cannot Find Bead Rectangle */
        dleCannotInsertNameToNameTreeError, /* Cannot Insert Name To Name Tree */
        dleUncompatibleActionError,         /* Not Compatible Action */
        dleInvalidHandleUsingError,         /* Invalid Handle Using */
        dleUnknowDestinationTypeError,      /* Unknown Destination Type */
        dleIvalidAnnotItemError             /* Invalid Annotation Item */
    } PDFDocumentLevelErrors;
    /************************************************************************
    Description :
        Error Type of Page Level of fault situations. When we are working
        with Pages API function of PDF Document.
    ************************************************************************/
    typedef enum {
        pleNoError = 0,                     /* No Error */
        pleOtherError,                      /* Other Error */
        pleInvalidRectangleValueError,      /* Invalid Rectangle Value */
        pleUnicodeAvailableForTrueTypeFontOnlyError,/* Unicode Available For TrueType Font Only */
		pleCannotCreateEMFFileError         /* Cannot Create EMF File */
    } PDFPageLevelErrors;
    /************************************************************************
    Description :
        Error Type of File Level of fault situations. When we are working
        with File System, File API functions. Storage of PDF Document.
    ************************************************************************/
    typedef enum {
        fleNoError = 0,                     /* No Error */
        fleOtherError,                      /* Other Error */
        fleUncryptedFileError,              /* Decrypted File */
        fleCorruptedTrailerError,           /* Corrupted Trailer */
        fleCannotLoadPagesError,            /* Cannot Load Pages */
        fleDocumentNotContainPagesError,    /* Document Not Contain Pages */
        fleCorruptedFile                    /* Corrupted File */
    } PDFFileLevelErrors;
    /************************************************************************
    Description :
        Error Type of Cos Object Level of fault situations. When we are working
        with PDF Data Objects.
    ************************************************************************/
    typedef enum {
        cleNoError = 0,                         /* No Error */
        cleOtherError,                          /* Other Error */
        cleInvalidObjError,                     /* Invalid Object */
        cleNotCosObjError,                      /* Not Cos Object */
        cleArrayBoundsError,                    /* Array Bounds */
        cleUnterminatedStringError,             /* Unterminated String */
        cleIllegalCharacterInHexCharInNameError,/* Illegal Hex Character In Name */
        cleNameTokenTooLongError,               /* Name Token Too Long */
        cleIllegalCharacterError,               /* Illegal Character */
        cleIllegalCharacterInHexStringError,    /* Illegal Character In Hex String */
        cleCommandTokenTooLongError,            /* Command Token Too Long */
        cleEOFWasFoundError,                    /* EOF Was Found */
        cleUnknowTokenWasFoundError,            /* Unknown Token Was Found */
        cleDictKeyNotNameError,                 /* Dictionary Key Have Not Name */
        cleUnknowStreamLength,                  /* Unknown Stream Length */
        cleDataReadError,                       /* Data Read */
        cleCannotFindEndOfStreamError,          /* Cannot Find End Of Stream */
        cleIllegalCosObjectWasFoundError,       /* Illegal Cos Object Was Found */
        cleNoHeaderError,                       /* No Header */
        cleUnsupportedVersionError,             /* Unsupported Version */
        cleNoStartXRefError,                    /* No Start XRef */
        cleNoStartAddressError,                 /* No Start Address */
        cleBadXrefError,                        /* Bad XRef */
        cleBadTrailerError,                     /* Bad Trailer */
        cleUnexpectedEndStreamError,            /* Unexpected End of Stream */
        cleCorruptedXRefStreamError,            /* Corrupted XRef of Stream */
        cleInvalidEncryptInformationError,      /* Invalid Encrypt Information */
        cleUnsupportedErcryptAlgorithmError,    /* Unsupported encrypt Algorithm */
        cleFlateError,                          /* Flate */
        cleASCIIHexError,                       /* ASCII Hex */
        cleASCII85Error,                        /* ASCII 85 */
        cleUnsupporterFilterDecodeError,        /* Unsupported Filter Decode */
        cleUnfilteredStreamWasFoundError,       /* Unfiltered Stream Was Found */
        cleInvalidObjectStreamDictionaryError,  /* Invalid Object Stream Dictionary */
        cleInvalidObjectStreamError,            /* Invalid Object Stream */
        cleInvalidImageFormat,                  /* Invalid Image Format */
		cleInvalidFontFormat,                   /* Invalid Font Format */
        cleCannotInsertObjectWithParrentError,  /* Cannot Insert Object With Parrent */
        cleCannotInsertObjectFromOtherDocumentError,/* Cannot Insert Object From Other Document */
        cleDirectObjectWasFoundError            /* Direct Object Was Found */
    } PDFCosLevelErrors;
    /************************************************************************
    Description :
        Error Type of Digital Signature Level of fault situations. When we are
        working with PDF Signatures.
    ************************************************************************/
    typedef enum {
        sleNoError = 0,         /* No Error */
        sleOtherError,          /* Other Error */
        sleInvalidObjError,     /* Invalid Object */
        sleBadAsn1HeaderError,  /* Bad ASN1 Header */
        sleWrongAsn1TagError,   /* Bad ASN1 Tag */
        sleLengthMismatchError, /* Length Mismatch */
        sleNotImplementedError, /* Not Implemented */
        sleBadPasswordError     /* Bad Password */
    } PDFSignLevelErrors;

#endif /* #ifndef VSError_H */
