/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSAnnotA.h"

int main( void )
{
	PDFDocHandle doc = NULL;                      /* Document variable description */
	ppInt32 PageCount;                            /* Page count variable description */
	TTextAnnotDict TextAnnotation;  /* Text annotation variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/Empty.pdf");  /* Document loading */
		PDFDocSetAutoLaunch( doc, true );             /* Launch destination PDF file after work */
		PageCount = PDFDocGetPageCount( doc );                      /* Page count calculating */
		if ( PageCount >0 )
		{
			TextAnnotation.Contents = "Key text annotation"; /* Annotation content filling */
			TextAnnotation.ContLength = 19;
			TextAnnotation.IconName = anKey;                 /* Setting annotation style as Key */ 
			TextAnnotation.Open = true;                      /* Set open property to true */
			TextAnnotation.BSDict = NULL;                    /* Zeroizing unused properties */
			TextAnnotation.DateTime = NULL;
			TextAnnotation.Action = CosNewNull ( doc );      
			TextAnnotation.AdditAction = CosNewNull ( doc );
			TextAnnotation.Popup = CosNewNull ( doc );
			TextAnnotation.AnFlags = 0;
			TextAnnotation.Transparency = 1;
			TextAnnotation.Rectangle.pt1.X = 200;              /* Setting annotation sizes */
			TextAnnotation.Rectangle.pt1.Y = 800;
			TextAnnotation.Rectangle.pt2.X = 400;
			TextAnnotation.Rectangle.pt2.Y = 600;
			TextAnnotation.Color.blue = 0.0;                   /* Setting annotation color to yellow */ 
			TextAnnotation.Color.red = 1.0;
			TextAnnotation.Color.green = 1.0;
			TextAnnotation.TitleText = "Text title";   /* Setting annotation title */
			TextAnnotation.TTLength = 10;
			PDFPageAddTextAnnotation( doc, 0, TextAnnotation ); /* Adding annotation to the document */ 
			PDFDocSaveToFile( doc, "../Data/out/SquareAnnotationTest.pdf" );      /* Saving the document */ 
		}
	} PDFFINALLY( PDFLibrary ){                                       /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}