/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSAnnotA.h"

int main( void )
{
	PDFDocHandle doc = NULL;                      /* Document variable description */
	ppInt32 PageCount;                            /* Page count variable description */
	TSoundAnnotDict SoundAttachAnnotation;        /* Sound annotation variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocLoadFromFile( PDFLibrary, "../Data/in/Empty.pdf");  /* Document loading */
		PDFDocSetAutoLaunch( doc, true );             /* Launch destination PDF file after work */
		PageCount = PDFDocGetPageCount( doc );                      /* Page count calculating */
		if ( PageCount >0 )
		{
			SoundAttachAnnotation.Contents = "Sound annotation";   /* Annotation content filling */
			SoundAttachAnnotation.ContLength = 16;
			SoundAttachAnnotation.Open = true;                      /* Set open property to true */
			SoundAttachAnnotation.DateTime = NULL;                  /* Zeroizing unused properties */
            SoundAttachAnnotation.AnFlags = 0;
            SoundAttachAnnotation.Transparency = 1;
			SoundAttachAnnotation.Rectangle.pt1.X = 200;            /* Setting annotation sizes */
			SoundAttachAnnotation.Rectangle.pt1.Y = 800;
			SoundAttachAnnotation.Rectangle.pt2.X = 400;
			SoundAttachAnnotation.Rectangle.pt2.Y = 600;
			SoundAttachAnnotation.Filename = "../Data/in/sound.wav";  /* Set sound filename */    
			SoundAttachAnnotation.FNLength = 12;
			SoundAttachAnnotation.Color.blue = 0.0;                 /* Setting annotation color to yellow */ 
			SoundAttachAnnotation.Color.red = 1.0;
			SoundAttachAnnotation.Color.green = 1.0;
			PDFPageAddSoundAnnotationFromFile( doc, 0, SoundAttachAnnotation, 11025, 1, 16,  sefSigned );  /* Adding annotation to the document using the 
																										   ampling rate = 11025, sound channels = 1, bits per sample = 8, encoding format = Signed  */ 
			PDFDocSaveToFile( doc, "../Data/out/SoundAnnotationTest.pdf" );      /* Saving the document */ 
		}
	} PDFFINALLY( PDFLibrary ){                                       /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}
