/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "windows.h"
#include "VSTypes.h"
#include "VSDocA.h"
#include "VSExcept.h"
#include "VSError.h" 
#include "VSLibA.h"
#include "VSPageA.h"
#include "VSCanvasA.h"
#include "VSImageA.h"
#include "VSGStateA.h"
#include "VSFontA.h"

int main( void )
{
	int GraphicState;                             /* Graphic state index */
	int Page;                                     /* Page index variable description */
	PBXHandle PB;                                 /* Paint box variable description */ 
	PDFDocHandle doc = NULL;                      /* Document variable description */
	PDFLibHandle	PDFLibrary;                   /* VERSYPDF  variable description */
	PDFLibrary=InitPDFLibrary( NULL,NULL );       /* Library initializing */
	PDFTRY(PDFLibrary){
		doc = PDFDocCreate( PDFLibrary );                     /* Create new PDF file */
		PDFDocSetAutoLaunch( doc, true );                     /* Launch destination PDF file after work */
		PDFDocSetPacked( doc, false );                          /* Disable stream packing */
		PDFDocSetLinearized( doc, false );                      /* Disable document linearizing */
		Page = PDFDocAppendPage2( doc, psA4, poPagePortrait );  /* Insert new page into document */
		PB = PDFPageCreatePaintBox( doc, Page, 72 );            /* Create paintbox */
		GraphicState = PDFExtGraphicStateCreate( doc );       /* Create Graphic state */
		PDFExtGraphicStateSetAlphaFill( doc, GraphicState, 0.5 );     /* Set fill alpha blending to 50 % */
		PDFExtGraphicStateSetAlphaStroke( doc, GraphicState, 0.5 );   /* Set lines alpha blending to 50 % */
		PDFExtGraphicStateSetAlphaIsShape( doc, GraphicState, true );  /* Set alpha blending to shapes */
		PBXSetGState ( PB, GraphicState);                      /* Set graphic state as current */
		PBXSetColor( PB, ULRGBToColor( 1.0, 0.0, 0.0 ) );     /* Set line color as red */
		PBXSetFillColor( PB, ULRGBToColor( 1.0, 0.0, 0.0 ) ); /* Set fill color as red */
		PBXRectangle( PB, 100, 100, 300, 300 );                 /* Draw rectangle */
		PBXFillAndStroke( PB );                                 /* Close and fill rectangle */
		PBXSetColor( PB, ULRGBToColor( 1.0, 1.0, 0.0 ) );     /* Set line color as yellow  */
		PBXSetFillColor( PB, ULRGBToColor( 0.0, 0.0, 1.0 ) ); /* Set fill color as blue  */
		PBXRectangle( PB, 150, 150, 350, 350 );                 /* Draw rectangle */
		PBXFillAndStroke( PB );                                 /* Close and fill rectangle */
		PBXClose( PB, false );                                /* Close paintbox */
		PDFDocSaveToFile( doc, "../Data/out/AlphaTest.pdf" );  /* Saving the document */ 
	} PDFFINALLY( PDFLibrary ){                               /* Closing the library */
		if ( doc ) PDFDocClose ( doc );
		PDFLASTERROR( PDFLibrary );
		DonePDFLibrary( &PDFLibrary );
	}
	PDFTRYEND( PDFLibrary );
	return 0;
}

