/*********************************************************************

SYBREX SYSTEMS INCORPORATED
Copyright (C) 2005 Sybrex Systems Incorporated
All rights reserved.

NOTICE: Sybrex permits you to use, modify, and distribute this file
in accordance with the terms of the Sybrex license agreement
accompanying it. If you have received this file from a source other
than Sybrex, then your use, modification, or distribution of it
requires the prior written permission of Sybrex.

----------------------------------------------------------------------
main.c
*********************************************************************/

#include "VSLibA.h"         /* Use Versy PDF Library */
#include "VSExcept.h"       /* Use Exceptions API */
#include "VSError.h"        /* Use Errors API */
#include "VSTypes.h"        /* Use Versy Type Definitions */
#include "VSDocA.h"         /* Use PDF Document API */
#include "VSPageA.h"        /* Use PDF Page Document API */

#include "VSAcroObjects.h"  /* Use Acro Objects API */

#define PageWidth   1000    /* Page width definition */
#define PageHeight  1000    /* Page height definition */
/* Determination of graphics objects coordinates, normalized to 100 */
#define cx(x) (PageWidth*x/100)
#define cy(x) (PageHeight*x/100)
/* Approximate Size of graphics primitives */
#define Radius (cx(10) + cy(10))/2

int main()
{
    PDFLibHandle	PDFLibrary;     /* PDF Library Handle */
	PDFDocHandle	Doc = NULL;     /* PDF Document Handle */
    PBXHandle       PaintBox;       /* Handle of Paint Box for Content Drawing */

    ppInt32         ErrorCode;      /* Check Error Code */
    ppInt32         i;              /* Variable counter */

    PDFLibrary = InitPDFLibrary( NULL, NULL );/* Initialize PDF Library */
    PDFTRY( PDFLibrary )/* On error keep exception */

        Doc = PDFDocCreate( PDFLibrary ); /* Create new destination PDF file */
        PDFDocSetAutoLaunch( Doc, true );/* Launch destination PDF file after work */

        i = PDFDocAppendPage( Doc, PageWidth, PageHeight ); /* Create new page in PDF document */
        PaintBox = PDFPageCreatePaintBox( Doc, i, 72 ); /* Create Page Content PaintBox with default resolution ( 72 dpi )*/

        /* Save the current graphics state on the graphics state stack. */
        PBXStateStore( PaintBox );
        /* Set the line 1 point width. */
        PBXSetLineWidth( PaintBox, 1 );
        /* Set the line cap style in the graphics state. */
        PBXSetLineCap( PaintBox, 1 );
        /* Set the line join style in the graphics state. */
        PBXSetLineJoin( PaintBox, 1 );
        /* Set the filling Color space to DeviceRGB and Color as White to use for filling operations */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.92, 0.95, 0.98 ) );
        /* Append a rectangle to the current path as all active area. */
        PBXRectangle( PaintBox, cx(0), cy(0), cx(100), cy(100) );
        /* Fill the path, using the nonzero winding number rule to determine the region to fill.
        Any subpaths that are open are implicitly closed before being filled.*/
        PBXFill( PaintBox );
        /* Set the stroking Color as Dark Blue */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.3 ) );
        /* Set Rectangle Border around whole area */
        PBXRectangle( PaintBox, cx(0), cy(0), cx(100), cy(100) );
        /* Draw Rectangle Border */
        PBXStroke( PaintBox );
        /* Set the stroking Color as Medium Blue */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.6 ) );
        /* Set Rectangle Border in previous Rectangle */
        PBXRectangle( PaintBox, cx(1), cy(1), cx(99), cy(99) );
        /* Draw Rectangle Border */
        PBXStroke( PaintBox );
        /* Set the stroking Color as Light Blue */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 1.0 ) );
        /* Set Rectangle Border in previous Rectangle */
        PBXRectangle( PaintBox, cx(2), cy(2), cx(98), cy(98) );
        /* Draw Rectangle Border */
        PBXStroke( PaintBox );

        /* Set the text font as Helvetica Oblique, size is 2,5% of page height, and underline text */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelveticaOblique, etStandardEncoding ),
            cy(2.5), true, false );
        /* Text Color set a dark brown */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.1, 0.1, 0.0 ) );
        /* Output text of title in upper-left corner of page */
        PBXTextOut( PaintBox, cx(3), cy(3), 0, "Graphics Primitives. Figures." );

        /* Border color is dark maroon */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.3, 0.0, 0.0 ) );
        /* Filling color is light rose */
        PBXSetFillColor( PaintBox, ULRGBToColor( 1.0, 0.9, 0.9 ) );
        /* Set circle centered at ( 50% of page, 25% of page) with radius as "Radius" */
        PBXCircle( PaintBox, cx(50), cy(25), Radius );
        /* Draw circle */
        PBXFillAndStroke( PaintBox );

        /* Set the text font as Helvetica, size is 4% of page height */
        PBXSetActiveFont( PaintBox, PDFFontAppend14Standard( Doc, stdfHelvetica, etStandardEncoding ),
            cy(4), false, false );
        /* Text Color set a maroon */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.5, 0.0, 0.0 ) );
        /* Output caption in center of circle */
        PBXTextOut( PaintBox, cx(50) - Radius / 2, cy(23) , 0, "Circle" );

        /* Border color is dark green */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.3, 0.0 ) );
        /* Filling color is light green */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.9, 1.0, 0.9 ) );
        /* Set rectangle centered at ( 25% of page, 50% of page) with side as double "Radius" */
        PBXRectangle( PaintBox, cx(25) - Radius, cy(50) - Radius, cx(25) + Radius, cy(50) + Radius );
        /* Draw rectangle */
        PBXFillAndStroke( PaintBox );

        /* Text Color set a dark green */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.5, 0.0 ) );
        /* Output caption set on left of left-bottom corner of rectangle */
        PBXTextOut( PaintBox, cx(25) - Radius - 2, cy(51), -90, "Rect" );
        /* Output caption set on bottom of left-bottom corner of rectangle */
        PBXTextOut( PaintBox, cx(25) - Radius, cy(50) + Radius + 2, 0, "angle" );

        /* Border color is dark blue */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.3 ) );
        /* Filling color is light blue */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.9, 0.9, 1.0 ) );
        /* Set pie centered at ( 75% of page, 50% of page) with radius as "Radius",
        starting angle is 45 degrees, ending angle is -45 degrees */
        PBXPie2( PaintBox, cx(75) - Radius, cy(50) - Radius, cx(75) + Radius, cy(50) + Radius, 45, -45 );
        /* Draw pie */
        PBXFillAndStroke( PaintBox );

        /* Text Color set a dark blue */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.0, 0.5 ) );
        /* Output caption set on right of pie center, and rotate text on 45 degree */
        PBXTextOut( PaintBox, cx(75) + Radius / 2, cy(50), 45, "Pie" );

        /* Border color is dark brown */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.3, 0.3, 0.0 ) );
        /* Filling color is light yellow */
        PBXSetFillColor( PaintBox, ULRGBToColor( 1.0, 1.0, 0.9 ) );
        /* Set start of path to upper top of triangle */
        PBXMoveTo( PaintBox, cx(50), cy(75) - 0.866 * Radius );
        /* Move path cursor to right top of triangle */
        PBXLineTo( PaintBox, cx(50) + Radius, cy(75) + 0.866 * Radius );
        /* Move path cursor to left top of triangle */
        PBXLineTo( PaintBox, cx(50) - Radius, cy(75) + 0.866 * Radius );
        /* Return path cursor to upper top of triangle */
        PBXLineTo( PaintBox, cx(50), cy(75) - 0.866 * Radius );
        /* Draw triangle */
        PBXFillAndStroke( PaintBox );

        /* Text Color set a brown */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.5, 0.5, 0.0 ) );
        /* Output caption set on left side of triangle, and rotate text on 60 degree */
        PBXTextOut( PaintBox, cx(50) - Radius, cy(75), 60, "Tri" );
        /* Output caption set on right side of triangle, and rotate text on -60 degree */
        PBXTextOut( PaintBox, cx(50) + Radius / 1.7, cy(75) - Radius / 1.7, -60, "angle" );

        /* Border color is teal */
        PBXSetStrokeColor( PaintBox, ULRGBToColor( 0.0, 0.3, 0.3 ) );
        /* Filling color is light aqua */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.9, 1.0, 1.0 ) );
        /* Set start of path to center of page */
        PBXMoveTo( PaintBox, cx(49), cy(49) );
        /* Add Bezier cubic curve segment to graphics path */
        PBXCurveTo( PaintBox, cx(49) - Radius, cy(49) + Radius, cx(49) - Radius,
            cy(49) - Radius, cx(49) + Radius, cy(49) - Radius );
        /* Draw it */
        PBXClosePath( PaintBox );

        /* Curve is symmetrical for center of page */
        PBXMoveTo( PaintBox, cx(51), cy(51) );
        PBXCurveTo( PaintBox, cx(51) + Radius, cy(51) - Radius, cx(51) + Radius,
            cy(51) + Radius, cx(51) - Radius, cy(51) + Radius );
        PBXClosePath( PaintBox );
        PBXFillAndStroke( PaintBox );

        /* Text Color set a teal */
        PBXSetFillColor( PaintBox, ULRGBToColor( 0.0, 0.5, 0.5 ) );
        /* Output caption set on first curve figure, and rotate text on 45 degree */
        PBXTextOut( PaintBox, cx(49) - Radius / 2, cy(49), 45, "Bezier" );
        /* Output caption set on second curve figure, and rotate text on 45 degree */
        PBXTextOut( PaintBox, cx(51) - Radius / 2, cy(51) + Radius / 2, 45, "curve" );

        /* Draw 40 arcs, with different widths, colors and arc's parameters */
        for ( i = 1; i <= 10; i ++ ) {
            /* With increase line width */
            PBXSetLineWidth( PaintBox , cy( (ppReal)i * i / 20 ) );
            /* Set arc color as red tones */
            PBXSetStrokeColor( PaintBox, ULRGBToColor( 1.0, 1 - (ppReal)i/10, 1 - (ppReal)i/10 ) );
            /* Set graphical path in right-top side of page */
            PBXArc2( PaintBox, cx(5), cy(5), cx(95), cy(95), 4*i, 90 - 4*i );
            /* Draw one arc */
            PBXStroke( PaintBox );
            /* Set arc color as green tones */
            PBXSetStrokeColor( PaintBox, ULRGBToColor( 1 - (ppReal)i/10, 1.0, 1 - (ppReal)i/10 ) );
            /* Set graphical path in left-top side of page */
            PBXArc2( PaintBox, cx(5), cy(5), cx(95), cy(95), 90 + 4*i, 180 - 4*i );
            /* Draw one arc */
            PBXStroke( PaintBox );
            /* Set arc color as yellow tones */
            PBXSetStrokeColor( PaintBox, ULRGBToColor( 1.0, 1.0, 1 - (ppReal)i/10 ));
            /* Set graphical path in left-bottom side of page */
            PBXArc2( PaintBox, cx(5), cy(5), cx(95), cy(95), - 180 + 4*i, -90 - 4*i );
            /* Draw one arc */
            PBXStroke( PaintBox );
            /* Set arc color as blue tones */
            PBXSetStrokeColor( PaintBox, ULRGBToColor( 1 - (ppReal)i/10, 1 - (ppReal)i/10, 1.0 ) );
            /* Set graphical path in right-bottom side of page */
            PBXArc2( PaintBox, cx(5), cy(5), cx(95), cy(95), -90 + 4*i, - 4*i );
            /* Draw one arc */
            PBXStroke( PaintBox );
        }
        /* Restore the graphics state by removing the most recently saved state
        from the stack and making it the current state.*/
        PBXStateRestore( PaintBox );
        PBXClose( PaintBox, false ); /* Free PaintBox of Page Content */
        /* Save destination PDF file as "acroform-api-test.pdf" in current path */
        PDFDocSaveToFile( Doc, "../Data/out/DrawFigures.pdf" );
    PDFFINALLY( PDFLibrary ) /* Do further if haven't PDF Library Exceptions */
		if ( Doc ) PDFDocClose ( Doc ); /* Close PDF Document and free memory */
		ErrorCode = PDFLASTERROR( PDFLibrary ); /* Check last error, if 0 then finished successfully */
        DonePDFLibrary( &PDFLibrary );/* Free PDF Library */
    PDFTRYEND( PDFLibrary ); /* End of try...end block */
    return ErrorCode; /* Return Error Code as program result */
}

