/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rchart;

import com.java4less.rchart.Chart;
import com.java4less.rchart.ChartComponent;
import com.java4less.rchart.LineStyle;
import com.java4less.rchart.Plotter;
import com.java4less.rchart.Scale;
import com.java4less.rchart.logScale;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Axis
extends ChartComponent {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int CEROAXIS_LINE = 0;
    public static final int CEROAXIS_NO = 1;
    public static final int CEROAXIS_SCALE = 2;
    public boolean axisFrame = false;
    public String dateLabelFormat = "dd-MMM-yyyy";
    public String dateStep = "d";
    public Date initialDate = null;
    public int realPosition;
    public int visibleSize = 0;
    public int offset;
    public boolean IntegerScale = false;
    public int autoNumberOfTicks = 0;
    public double[] ticks_preferred_Interval = new double[]{0.1, 0.5, 1.0, 5.0, 10.0, 25.0, 50.0, 100.0, 250.0, 500.0, 1000.0, 5000.0, 10000.0, 50000.0, 100000.0, 500000.0, 1000000.0};
    public String scaleLabelFormat = "";
    public boolean logarithmicIntervals = false;
    public Scale scale;
    public boolean bigTicksGrid = false;
    public double scaleTickInterval = 1.0;
    public int bigTickInterval = 1;
    public int[] bigTickIntervalList;
    public int tickPixels = 4;
    public int bigTickPixels = 9;
    public Plotter plot;
    public Axis peerAxis;
    public int ceroAxis = 0;
    public LineStyle ceroAxisStyle = new LineStyle(0.2f, Color.darkGray, 1);
    public boolean tickAtBase = false;
    public boolean verticalLabels = false;
    public LineStyle style = new LineStyle(2.0f, Color.black, 1);
    public LineStyle gridStyle = null;
    public int orientation;
    public boolean rightAxis = false;
    public Color DescColor = Color.black;
    public Font DescFont = new Font("Arial", 0, 10);
    public String[] tickLabels = null;
    public boolean startWithBigTick = false;
    public int tickLabelLength = 1000;

    public Axis(int n, Scale scale) {
        this.orientation = n;
        this.scale = scale;
        if (n == 1) {
            this.scale.reverse = true;
        }
    }

    public void drawForeground(Graphics graphics, Axis axis) {
        this.draw(graphics, axis, true);
    }

    public void drawBackground(Graphics graphics, Axis axis) {
        this.draw(graphics, axis, false);
    }

    private String[] splitText(String string) {
        String[] stringArray = new String[100];
        int n = 0;
        if (this.tickLabelLength == 0) {
            this.tickLabelLength = 1000;
        }
        while (string.indexOf("\\n") > -1 || string.length() > this.tickLabelLength) {
            if (string.indexOf("\\n") > -1 && string.indexOf("\\n") < this.tickLabelLength) {
                stringArray[n] = string.substring(0, string.indexOf("\\n"));
                string = string.substring(string.indexOf("\\n") + 2, string.length());
            } else {
                stringArray[n] = string.substring(0, this.tickLabelLength);
                string = string.substring(this.tickLabelLength, string.length());
            }
            if (++n < stringArray.length) continue;
        }
        stringArray[n] = string;
        String[] stringArray2 = new String[n + 1];
        for (int i = 0; i <= n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    public void draw(Graphics graphics, Axis axis, boolean bl) {
        int n;
        int n2;
        int n3;
        double d = this.scale.max - this.scale.min;
        int n4 = 0;
        int n5 = 0;
        if (this.scale.min < 0.0 && this.scale.max < 0.0) {
            d = (this.scale.min - this.scale.max) * (double)-1;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl2 = true;
        int n9 = this.plot.depth;
        double d2 = this.scaleTickInterval;
        if (this.autoNumberOfTicks > 0) {
            d2 = Math.abs(d / (double)this.autoNumberOfTicks);
            int n10 = 0;
            double d3 = d2;
            if (this.ticks_preferred_Interval != null && this.ticks_preferred_Interval.length > 0) {
                for (n3 = 0; n3 < this.ticks_preferred_Interval.length; ++n3) {
                    if (n10 == 0) {
                        n10 = (int)Math.abs(d / this.ticks_preferred_Interval[n3]);
                    }
                    if (Math.abs((n2 = (int)Math.abs(d / this.ticks_preferred_Interval[n3])) - this.autoNumberOfTicks) >= Math.abs(n10 - this.autoNumberOfTicks)) continue;
                    n10 = n2;
                    d2 = d3 = this.ticks_preferred_Interval[n3];
                }
            }
        }
        if (axis.scale.min < 0.0 && axis.scale.max > 0.0) {
            n8 = axis.scale.getScreenCoord(0.0);
        }
        if (this.orientation == 0) {
            n7 = this.ceroAxis == 2 && n8 != 0 ? n8 : this.realPosition;
            if (bl) {
                this.style.draw(graphics, this.x, n7, this.x + this.visibleSize, n7);
                if (this.axisFrame && axis != null && n9 == 0) {
                    this.style.draw(graphics, this.x, n7 - axis.visibleSize, this.x + this.visibleSize, n7 - axis.visibleSize);
                }
            }
            if (!bl) {
                int[] nArray = new int[4];
                int[] nArray2 = new int[4];
                n = axis.scale.getScreenCoord(axis.scale.min);
                n3 = axis.scale.getScreenCoord(axis.scale.max);
                nArray[0] = this.x + n9 + this.offset;
                nArray2[0] = n7 + axis.offset - n9;
                nArray[1] = this.x + this.visibleSize + n9 + this.offset;
                nArray2[1] = n7 + axis.offset - n9;
                nArray[2] = this.x + this.visibleSize + this.offset;
                nArray2[2] = n7 + axis.offset;
                nArray[3] = this.x + this.offset;
                nArray2[3] = n7 + axis.offset;
                if (!this.rightAxis) {
                    if (n9 != 0) {
                        this.style.draw(graphics, nArray[0], nArray2[0], nArray[1], nArray2[1]);
                    }
                    if (n9 != 0) {
                        this.style.draw(graphics, nArray[2], nArray2[2], nArray[1], nArray2[1]);
                    }
                    if (n9 != 0) {
                        this.style.draw(graphics, nArray[3], nArray2[3], nArray[0], nArray2[0]);
                    }
                    if (n9 != 0) {
                        this.style.draw(graphics, nArray[0], this.plot.y - n9 + axis.offset, nArray[1], this.plot.y - n9 + axis.offset);
                    }
                }
            }
            if (n8 != 0 && this.ceroAxis == 0 && !bl) {
                this.ceroAxisStyle.draw(graphics, this.x, n8, this.x + this.width, n8);
                if (!this.rightAxis) {
                    if (n9 != 0) {
                        this.ceroAxisStyle.draw(graphics, this.x + n9, n8 - n9, this.x + this.width + n9, n8 - n9);
                    }
                    if (n9 != 0) {
                        this.ceroAxisStyle.draw(graphics, this.x, n8, this.x + n9, n8 - n9);
                    }
                    if (n9 != 0) {
                        this.ceroAxisStyle.draw(graphics, this.x + this.width, n8, this.x + this.width + n9, n8 - n9);
                    }
                }
            }
        } else {
            n7 = this.ceroAxis == 2 && n8 != 0 ? n8 : (this.rightAxis ? this.realPosition : this.x + this.width);
            if (bl) {
                this.style.draw(graphics, n7, this.y, n7, this.y + this.visibleSize);
                if (this.axisFrame && axis != null && n9 == 0 && !this.rightAxis) {
                    this.style.draw(graphics, n7 + axis.visibleSize, this.y, n7 + axis.visibleSize, this.y + this.visibleSize);
                }
            }
            if (!bl) {
                int[] nArray = new int[4];
                int[] nArray3 = new int[4];
                int[] nArray4 = new int[4];
                int[] nArray5 = new int[4];
                n2 = axis.scale.getScreenCoord(axis.scale.min);
                int n11 = axis.scale.getScreenCoord(axis.scale.max);
                nArray[0] = n7 + axis.offset + n9;
                nArray3[0] = this.y - n9 + this.offset;
                nArray[1] = n7 + axis.offset + n9;
                nArray3[1] = this.y + this.visibleSize - n9 + this.offset;
                nArray[2] = n7 + axis.offset;
                nArray3[2] = this.y + this.visibleSize + this.offset;
                nArray[3] = n7 + axis.offset;
                nArray3[3] = this.y + this.offset;
                nArray4[0] = n7 + axis.visibleSize + n9 + axis.offset;
                nArray5[0] = nArray3[0];
                nArray4[1] = n7 + axis.visibleSize + n9 + axis.offset;
                nArray5[1] = nArray3[1];
                nArray4[2] = nArray[1];
                nArray5[2] = nArray3[1];
                nArray4[3] = nArray[0];
                nArray5[3] = nArray3[0];
                if (!this.rightAxis) {
                    if (n9 != 0) {
                        this.style.draw(graphics, nArray[0], nArray3[0], nArray[1], nArray3[1]);
                    }
                    if (n9 != 0) {
                        this.style.draw(graphics, nArray[2], nArray3[2], nArray[1], nArray3[1]);
                    }
                    if (n9 != 0) {
                        this.style.draw(graphics, nArray[3], nArray3[3], nArray[0], nArray3[0]);
                    }
                    if (n9 != 0) {
                        this.style.draw(graphics, nArray4[0], nArray5[0], nArray4[1], nArray5[1]);
                    }
                }
            }
            if (n8 != 0 && this.ceroAxis == 0 && !bl) {
                this.ceroAxisStyle.draw(graphics, n8, this.y, n8, this.y + this.height);
                if (!this.rightAxis) {
                    if (n9 != 0) {
                        this.ceroAxisStyle.draw(graphics, n8 + n9, this.y - n9, n8 + n9, this.y + this.height - n9);
                    }
                    if (n9 != 0) {
                        this.ceroAxisStyle.draw(graphics, n8, this.y + this.height, n8 + n9, this.y + this.height - n9);
                    }
                    if (n9 != 0) {
                        this.ceroAxisStyle.draw(graphics, n8, this.y, n8 + n9, this.y - n9);
                    }
                }
            }
        }
        double d4 = this.scale.min;
        n = 0;
        if (this.startWithBigTick) {
            n6 = this.bigTickInterval - 1;
        }
        Date date = null;
        if (this.initialDate != null) {
            date = this.initialDate;
        }
        double d5 = d4;
        while (d5 <= this.scale.max && n <= 1000) {
            int n12;
            if (++n > 1 || this.tickAtBase) {
                int n13;
                ++n5;
                int n14 = this.scale.getScreenCoord(d5);
                n12 = 0;
                if (this.bigTickIntervalList == null && ++n6 == this.bigTickInterval) {
                    n12 = 1;
                }
                if (this.bigTickIntervalList != null) {
                    for (int i = 0; i < this.bigTickIntervalList.length; ++i) {
                        if (n5 != this.bigTickIntervalList[i]) continue;
                        n12 = 1;
                    }
                }
                if (n12 != 0) {
                    n6 = 0;
                    n13 = this.bigTickPixels;
                } else {
                    n13 = this.tickPixels;
                }
                bl2 = true;
                if (!(!bl2 || d5 == this.scale.min || bl || this.gridStyle == null || n6 != 0 && this.bigTicksGrid || this.ceroAxis == 0 && d5 == 0.0)) {
                    if (this.orientation == 0) {
                        if (n9 != 0) {
                            this.gridStyle.draw(graphics, n14, this.plot.y + this.plot.height, n14 + n9, this.plot.y + this.plot.height - n9);
                        }
                        this.gridStyle.draw(graphics, n14 + n9, this.plot.y - n9, n14 + n9, this.plot.y + this.plot.height - n9);
                    } else {
                        this.gridStyle.draw(graphics, this.plot.x + n9, n14 - n9, this.plot.x + this.plot.width + n9, n14 - n9);
                        if (n9 != 0) {
                            this.gridStyle.draw(graphics, this.plot.x, n14, this.plot.x + n9, n14 - n9);
                        }
                    }
                }
                if (bl) {
                    if (bl2) {
                        if (this.orientation == 0) {
                            if (n14 - this.offset >= this.x && n14 - this.offset <= this.visibleSize + this.x) {
                                this.style.draw(graphics, n14 - this.offset, n7, n14 - this.offset, n7 + n13);
                            }
                        } else if (this.rightAxis) {
                            if (n14 - this.offset >= this.y && n14 - this.offset <= this.visibleSize + this.y) {
                                this.style.draw(graphics, n7, n14 - this.offset, n7 + n13, n14 - this.offset);
                            }
                        } else if (n14 - this.offset >= this.y && n14 - this.offset <= this.visibleSize + this.y) {
                            this.style.draw(graphics, n7 - n13, n14 - this.offset, n7, n14 - this.offset);
                        }
                    }
                    if (n6 == 0) {
                        int n15;
                        ++n4;
                        graphics.setColor(this.DescColor);
                        graphics.setFont(this.DescFont);
                        String string = new Double(d5).toString();
                        if (this.scaleLabelFormat.length() > 0) {
                            DecimalFormat decimalFormat = new DecimalFormat(this.scaleLabelFormat);
                            string = decimalFormat.format(new Double(d5));
                        }
                        if (this.IntegerScale) {
                            string = new Integer((int)d5).toString();
                        }
                        if (date != null) {
                            string = new SimpleDateFormat(this.dateLabelFormat).format(date);
                        }
                        if (this.tickLabels != null) {
                            string = " ";
                            if (this.tickLabels.length >= n4 && this.tickLabels[n4 - 1] != null) {
                                string = this.tickLabels[n4 - 1];
                            }
                        }
                        boolean bl3 = false;
                        if (this.verticalLabels && this.orientation == 0 && n14 - this.offset >= this.x && n14 - this.offset <= this.visibleSize + this.x) {
                            bl3 = Chart.drawVerticalText(graphics, this.DescFont, this.DescColor, string, n14 - this.offset, this.realPosition + n13, false);
                        }
                        if (this.verticalLabels && this.orientation == 1 && n14 - this.offset >= this.y && n14 - this.offset <= this.visibleSize + this.y) {
                            int n16 = 0;
                            n15 = 0;
                            n16 = this.rightAxis ? this.realPosition + n13 + 1 : this.x + this.width - n13 - graphics.getFontMetrics().getHeight();
                            n15 = n14 - graphics.getFontMetrics().stringWidth(string) / 2;
                            bl3 = Chart.drawVerticalText(graphics, this.DescFont, this.DescColor, string, n16, n15 - this.offset, false);
                        }
                        if (!bl3 && bl2) {
                            int n17;
                            int n18;
                            String[] stringArray = this.splitText(string);
                            n15 = graphics.getFontMetrics().stringWidth(stringArray[0]);
                            int n19 = graphics.getFontMetrics().getHeight();
                            int n20 = 0;
                            int n21 = 0;
                            if (this.orientation == 1) {
                                n20 = this.rightAxis ? this.realPosition + n13 + 1 : this.x + this.width - n13 - n15;
                                n21 = n14;
                                if (n21 - this.offset >= this.y && n21 - this.offset <= this.visibleSize + this.y) {
                                    graphics.drawString(stringArray[0], n20, n21 - this.offset);
                                }
                                for (n18 = 1; n18 < stringArray.length; ++n18) {
                                    n17 = graphics.getFontMetrics().stringWidth(stringArray[n18]);
                                    n20 = this.rightAxis ? this.realPosition + n13 + 1 : this.x + this.width - n13 - n17;
                                    if (n21 - this.offset < this.y || n21 - this.offset > this.visibleSize + this.y) continue;
                                    graphics.drawString(stringArray[n18], n20, n21 - this.offset + n19 * n18);
                                }
                            } else {
                                n20 = n14 - n15 / 2;
                                n21 = this.realPosition + n13 + n19;
                                if (n14 - this.offset >= this.x && n14 - this.offset <= this.visibleSize + this.x) {
                                    graphics.drawString(stringArray[0], n20 - this.offset, n21);
                                }
                                for (n18 = 1; n18 < stringArray.length; ++n18) {
                                    n17 = graphics.getFontMetrics().stringWidth(stringArray[n18]);
                                    n20 = n14 - n17 / 2;
                                    if (n14 - this.offset < this.x || n14 - this.offset > this.visibleSize + this.x) continue;
                                    graphics.drawString(stringArray[n18], n20 - this.offset, n21 + n19 * n18);
                                }
                            }
                        }
                    }
                }
            }
            if (this.logarithmicIntervals && this.scale instanceof logScale) {
                if (d5 == 0.0) {
                    d5 = 1.0;
                }
                d5 *= ((logScale)this.scale).base;
                continue;
            }
            d5 += d2;
            if (date == null) continue;
            n12 = 1;
            if (this.dateStep.length() > 1) {
                n12 = new Integer(this.dateStep.substring(1, this.dateStep.length()));
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            if (this.dateStep.toLowerCase().compareTo("d") == 0) {
                calendar.add(5, n12);
            }
            if (this.dateStep.toLowerCase().compareTo("m") == 0) {
                calendar.add(2, n12);
            }
            if (this.dateStep.toLowerCase().compareTo("w") == 0) {
                calendar.add(5, n12 * 7);
            }
            if (this.dateStep.toLowerCase().compareTo("y") == 0) {
                calendar.add(1, n12);
            }
            date = calendar.getTime();
        }
    }
}

