/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{

class LoadCompletionListener : public ImagePool::Listener
{
public:
	ImageView* view;
public:
	LoadCompletionListener(ImageView* t)
	:view(t)
	{	}
protected:
	virtual void Completed()
	{
		// all images have been loaded
	}
	virtual void Completed(const FileName& fname, const OffscreenImage& image)
	{
		ImageView* v = view;
		if (v != 0)
		{
			v->SetImage(image, fname);	 // may delete this
			v->Refresh();
		}
	}
	virtual void Failed(const FileName& fname, const Exception& /*err*/)
	{
		ImageView* v = view;
		if (v != 0)
		{   // clear the image currently in the view (failure to load is blank view)
			v->SetImage(OffscreenImage(), fname);	 // may delete this
			v->Refresh();
		}
	}
}; // class SkinLoader



ImageView::ImageView()
: withinDND(false)
{
	SetFocusable(false);
}
ImageView::~ImageView()
{
    if (imageLoader != 0)
    {
    	imageLoader->CancelAllDownloads();
    	imageLoader = 0;
    }
}

void ImageView::SetImage(const OffscreenImage& img)
{
	image = img;
	filename = 0;
}

void ImageView::SetImage(const OffscreenImage& img, const FileName& fnm)
{
	image = img;
	filename = fnm;
    if (imageLoader != 0)
    	imageLoader = 0;
}

void ImageView::LoadNewImage(const FileName& filename)
{
    if (imageLoader != 0)
    	imageLoader->CancelAllDownloads();
    else
		imageLoader = new ImagePool();
	imageLoader->progressListeners.Add(new LoadCompletionListener(this));
	imageLoader->Load(filename);
}



void ImageView::Draw(Graphics& g, const Rect2D& area)
{
	// stretch image to target
	Rect2D src(image.GetSize());
	if (src.isEmpty())
		return;
		
	Rect2D oldClip = g.GetClipRect();
	Rect2D r(GetLocalBounds());

	ViewSkin::owner skin = GetSkin();
	if (skin != 0)
	{
		StateSkin::owner stateSkin = skin->GetStateSkin(GetState());
		stateSkin->Draw(g, r,area);
		r = stateSkin->GetContent(r);
	}
		
	Rect2D clip(area.Intersect(r));
	if (!clip.isEmpty())
	{
		g.SetClipRect(clip);
		g.DrawImage(image, src, r);
		g.SetClipRect(oldClip);
	}
}

void ImageView::HandleDrop(DragDropType::TypeSet& availableTypes, 
						  DragDropType::Effect&  effect,
						  const Point2D& 		 mousePos,
						  bool 					 onlySimulate,
						  DragDropType::FatData& fatData )
{
	// ToDo if threading interferes with this and it probably does,
	// just make an agent who's task is to insert this at (mousePos)
	// and put it into the synchronized queue

	if (IsDisabled())
		effect = 0;
	Rect2D sc(GetSkinContentBounds());
	if (!sc.Contains(mousePos))
		effect = 0;
	if (withinDND)
		effect = 0;
	effect &= DragDropType::Copy;

	DragDropType::TypeSet::iterator e = availableTypes.end();
	if (availableTypes.find(&DragDropType::Image_Native) != e)	
	{
		if (!onlySimulate)
		{
			if (fatData.image == 0)
				effect = 0;
			else
			{
				SetImage( fatData.image );
				Refresh();
			}
		}
	}
	else if (availableTypes.find(&DragDropType::FileName) != e)	
	{
		if (!onlySimulate)
		{
			if (fatData.fileNames.empty())
				effect = 0;
			else
				LoadNewImage( fatData.fileNames.front() );
		}
	}
	else
	{
		effect = 0;
	}
}

bool ImageView::HandleMouseEvent( const UIEvent& ev )
{
	if (IsDisabled())
		return false;
	Rect2D sc(GetSkinContentBounds());
	if (!sc.Contains(ev.mousePos))
		return false;

	switch (ev.origin)
	{
	case UIEvent::MouseDClick:
	case UIEvent::MouseClick:
		if (UIEvent::MouseLeftState == (ev.modifiers & UIEvent::MModifMask))
		{
			StartMouseCapture(this, ev.mousePos);
			return true;
		}
        break;	
	case UIEvent::MouseMove:
		if (IsMouseCapturing())
		{
    		EndMouseCapture(this);
			if (image != 0) // do we have what to drag ?
			{
				DragDropType::TypeSet availableTypes;
				DragDropType::FatData fatData;
				availableTypes.insert(&DragDropType::Image_Native);
				fatData.image = image;
				
				if (filename != 0)
				{
					availableTypes.insert(&DragDropType::FileName);
					fatData.fileNames.push_back(filename);
				}

				DragSource ds;
				ds.Set(fatData, availableTypes);
				DragDropType::Effect effect = DragDropType::Copy;

				withinDND = true;
		        ds.DoDND(effect);
				withinDND = false;
			}
			return true;
        }
		break;
	case UIEvent::MouseUp:
		if (IsMouseCapturing())
		{
    		EndMouseCapture(this);
    		return true;
    	}
		break;		
    } // switch
    return false;
}  // HandleMouseEvent

} // namespace XSP
