/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"

namespace XSP
{

ButtonView::ButtonView()
: styleAutoRepeat(false)
//, style3State (false)
, hotKeyCode(0)
{
	SetFocusable(false);
}

ButtonView::~ButtonView()
{
}

void ButtonView::SetAutoRepeatButton(bool on)
{ 
	styleAutoRepeat = on; 
}

void ButtonView::Set3StateButton(bool on)
{ 
	if (on) StateSetReset(StateHas3RD, 0);
	else	StateSetReset(0, StateHas3RD);
//	style3State = on; 
}
void ButtonView::SetChecked(bool on)
{
	if (on) StateSetReset(State3RD, 0);
	else	StateSetReset(0, State3RD);
}

//void ButtonView::SetStyle(Style s)
//{
//	if (style != s)
//	{
//		 style = s;
//		 Refresh();
//	}					   
//} 

void ButtonView::SetDefaultButton(bool on)
{
	if (on) StateSetReset(StateDefaultButton, 0); // viewState |=  StateDefaultButton;
	else	StateSetReset(0, StateDefaultButton); // viewState &= ~StateDefaultButton;
}


const String& ButtonView::GetText() const
{
	return tData.text;
}

void ButtonView::SetText(const String& t)
{
	tData.SetText(t);
	Refresh();
}

void ButtonView::SetFont(const TextFont& t)
{
	tData.SetFont(t);
	View::SetFont(t);
}

void ButtonView::SetTextColor(const ColorRGB& t)
{
	tData.colr = t;
	Refresh();
}

void ButtonView::SetTextAlign(Rect2D::Alignment al, Rect2D::Alignment ov)
{
	tData.algn = al;
	tData.ovrf = ov;
	Refresh();
}

Size2D ButtonView::GetPreferredSize() 
{
	Size2D z;
	{
		Graphics g;
		z.w = g.MeasureTextWidth(tData.text.begin(), tData.text.end(), tData.font);
		z.h = tData.font.GetHeight();
	}
	ViewSkin::owner skin = GetSkin();
	if (skin != 0)
	{
		StateSkin::owner stateSkin = skin->GetStateSkin(0);
		if (stateSkin != 0)
		{
			Rect2D border = stateSkin->GetContent();
			z.w += border.w;
			z.h += border.h;
		}
	}
	return z;
}


void ButtonView::Draw(Graphics& g, const Rect2D& area)
{
	Rect2D bounds = GetLocalBounds();
//	Rect2D oldClip = g.GetClipRect();
//	g.SetClipRect(area);  //?? bounds
	ViewSkin::owner skin = GetSkin();
	if (skin != 0)
	{
		StateSkin::owner stateSkin = skin->GetStateSkin(GetState());
		stateSkin->Draw(g, bounds,area);
		if (! tData.text.isEmpty())
			tData.Draw(g, stateSkin->GetContent(bounds));
	}
	else
	{
		if (! tData.text.isEmpty())
			tData.Draw(g, bounds);
	}
	
//	g.SetClipRect(oldClip);
}

#if 0
#pragma mark Event_ButtonAutoRepeat
#endif

class Event_ButtonAutoRepeat : public Event_Abstract
{
    refc<ButtonView> button;
    LocalTime 		 when;
public:
	Event_ButtonAutoRepeat(ButtonView* bv)
	: button(bv)
	{
		when = LocalTime::Now()+ sint64(1000000)*450; // initial 
		button->ActionFireButton();
	}
    virtual void Cancel()
    {
    	button = 0;
    }
	virtual void Run()
	{
		if (button == 0)
			return;
		if (!button->IsMouseCapturing() || !button->IsAutoRepeat())
			return;
		
		LocalTime now(LocalTime::Now());
		if (now >= when)
		{
			button->ActionFireButton();
			when = now+ sint64(1000000)*50; // 20 times per sec = 50 ms
		}
		
		// schedule this event again (autorepeat)
		CoreModule::_instance->mainLoop->PostEvent(this, false);
	}
}; // Event_ButtonAutoRepeat

bool ButtonView::HandleMouseEvent( const UIEvent& ev )
{
	if (IsDisabled())
	{
		if (IsMouseCapturing())
		{
			StateSetReset(0,StateDragged); // if it was dragged, it no longer is
			EndMouseCapture(this);
			Refresh();
		}
		return false;
    }
    
	switch (ev.origin)
	{
	case UIEvent::MouseDClick:
	case UIEvent::MouseClick:
		SetFocused();
		if (IsDraggable())
		{
			StartMouseCapture(this, GetBounds().GetNW());
			StateSetReset(StateDragged,0);
		}
		else
		{
			StartMouseCapture(this, ev.mousePos);
		}
		Refresh();
		if (IsAutoRepeat())
		{
			refc<Event_ButtonAutoRepeat> ar(new Event_ButtonAutoRepeat(this));
			ar->Run(); // while it is repeating it owns this button,
		}
		return true;
	case UIEvent::MouseUp:
		if (IsMouseCapturing())
		{
			bool within = GetLocalBounds().Contains(ev.mousePos);
			bool action = IsDragged() || (within && !IsAutoRepeat());
			StateSetReset(0,StateDragged); // if it was dragged, it no longer is
			EndMouseCapture(this);
			Refresh();
			if (action)
				ActionFireButton();
		}
		return true;
	case UIEvent::MouseMove:
		if (IsMouseCapturing() && IsDraggable() && IsDragged())
		{
			Rect2D b(GetBounds());
			b.x = ev.mousePos.x;
			b.y = ev.mousePos.y;
			SetBounds(b);
			ActionFireButton();
		}
		return true;
	}; // switch
	return false;
}


bool ButtonView::HandleKeyEvent( const UIEvent& ev )
{
	// Button policy = any matching key is eaten, action may not be performed

	if ((ev.origin == UIEvent::HotKey) && 
		(ev.code == hotKeyCode))
	{
		Refresh();
		ActionFireButton(); // consumed !!
		return true;
    }
	if ((ev.origin == UIEvent::KeyDown) && 
		(ev.code == VK_SPACE))
	{
		Refresh();
		ActionFireButton();
		return true;
    }
	// VK_RETURN is only handled by the default button !!
	if (IsDefaultButton())
	{
		if ((ev.origin == UIEvent::HotKey) &&
		  	(ev.code == VK_RETURN) )
		{
			Refresh();
			ActionFireButton();
			return true;
		}	   
	}
	return false;
}

void ButtonView::AddActionListener(const ActionListener::owner& l)
{
	actionListeners.Add(l);
}

bool ButtonView::ActionFireButton()
{
//	#if DEBUG
//	UnitTest::Log("Action on %s", tData.text.c_str());
//	#endif

	if (Is3StateButton())
		SetChecked(!IsChecked());

	for (ActionListener::each e(actionListeners); !e.empty(); e.pop()) 
		if (! e->IsCanceled())
			e->ActionPerform(this);
	return true;
}


} // namespace XSP
