/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{
#if 0
#pragma mark MeasuredText
#endif

class MeasuredText
{
public:
	uint32	 wdth;
	TextFont font;
	ColorRGB colr;
	String   text;
public:
	MeasuredText();
	~MeasuredText();
	MeasuredText(const MeasuredText& t);
	MeasuredText& operator = (const MeasuredText& t);
	
	void SetText(const String& t);
	void SetFont(const TextFont& t);
	
	void Measure(Graphics& g);
	void Draw(Graphics& g, const Point2D& target);
}; // class MeasuredText

#if 0
#pragma mark AlignedText
#endif

class AlignedText : public MeasuredText
{
public:
	Rect2D::Alignment algn;
	Rect2D::Alignment ovrf;
public:
	AlignedText();
	~AlignedText();
	AlignedText(const AlignedText& t);
	AlignedText& operator = (const AlignedText& t);
	
	void Draw(Graphics& g, const Rect2D& target);
}; // class AlignedText

#if 0
#pragma mark TextLine
#endif

class TextLine
{
	uint32 refcount;
public:
	sint32 y;
	sint32 h;
public:	
	void addref() { ++refcount; }
	void release() { if (--refcount == 0) delete this; }
	TextLine();
protected:
	~TextLine();
};

#if 0
#pragma mark TextId
#endif

class TextId
{
	uint32 refcount;
public:	
	void addref() { ++refcount; }
	void release() { if (--refcount == 0) delete this; }
	TextId();
protected:
	virtual ~TextId();
};

#if 0
#pragma mark TextPiece
#endif

class TextPiece 
{
private:
	uint32   refcount;
public:
	void addref() { ++refcount; }
	void release() { if (--refcount == 0) delete this; }
public:
	enum Flags 
	{ 
		Selected=1, // the piece is part of the current selection
		NewLine=2,   // this piece is the first in a line, creating the line
		CannotLineBreak=4, // this piece can be split to fit the line
		Atomic=8  // this piece cannot be merged/split/inserted into
	};
	uint16   flgs; // flags for the piece, selected = 1
public:
	uint16	 wdth;
	TextFont font;
 	ColorRGB colr;
	String   text;
	Point2D  pos;
	
	refc<TextLine> textline;
	refc<TextId>   textId;  // hyperlink = a bunch of pieces with hyperlink identity
	OffscreenImage image;
protected:
	~TextPiece();
public:
	TextPiece();
	TextPiece(const TextPiece& t);
	TextPiece& operator= (const TextPiece& t);
	// split an empty piece out of this piece
	refc<TextPiece> SplitEmpty(); 
	// splits at that char with the precalculated width
	refc<TextPiece> SplitAtChar(String::iterator cp, uint32 rdx);
	// split at (x= absolute pos) or before that where a whitespace is found
	refc<TextPiece> SplitAtLineEnd(Graphics& g, sint32 x);
	// split at that exact position, x= absolute pos
	refc<TextPiece> SplitAt(Graphics& g, sint32 x);
	// merge the 2  pieces if possible
	bool MergeWith(const refc<TextPiece>& t);
	void clear();
	bool isEmpty() const;

	void TurnIntoNewLine();
	
	Rect2D GetBounds();	      // must measure first
	Rect2D GetBoundsInLine(); // the width of the piece, the height of the line
    sint32 GetAscent() const; 
    sint32 GetDescent() const;
				   
	void SetText(const String& t);
	void SetFont(const TextFont& t);
	void SetImage(OffscreenImage& img);
	
	void Measure(Graphics& g);
	void MeasureEachCharWidth(Graphics& g, std::vector<uint32> & results);
	void Draw(Graphics& g);
}; // class TextPiece

#if 0
#pragma mark TextDocument
#endif

class TextDocument : public ref_obj
{
public:
	typedef refc<TextPiece> Piece;
	typedef std::vector<Piece> Pieces;
	class PageOrder
	{
		sint32 h;
	public: PageOrder(sint32 pageHeight);
	public:	bool operator () (Piece& p, sint32 y);
	public:	bool operator () (sint32 y, Piece& p);
	};
	class LineOrder
	{
	public:	bool operator () (Piece& p, sint32 y);
	public:	bool operator () (sint32 y, Piece& p);
	};
	class PieceInLineOrder
	{
	public:	bool operator () (Piece& p, sint32 x);
	public:	bool operator () (sint32 x, Piece& p);
	};
	class PieceOrder
	{
	public:	bool operator () (Piece& piece, const Point2D& point);
	public:	bool operator () (const Point2D& point, Piece& piece);
	};

	class TextPos
	{
	public:
	    void LocatePosition(Pieces& pieces, Graphics& g,
	    					sint32 x, sint32 y, sint32 nc, sint32 nl,
	    					bool forwardCaret=false);
		void AdjustAfterResize(Pieces::iterator old_p, Pieces& newpieces);

		sint32 x,y;
		Pieces::iterator piecesB, piecesE;
		Pieces::iterator lineB, lineE;
		Pieces::iterator pieceP;
		uint32 charNum;
	    std::vector<uint32> charPlacements; 
	};  // class TextPos

	Pieces pieces;
	Size2D docSize;

	// this is the insertion point into the document
    Rect2D  caretRect;
    /* if the caret is in between pieces 
    forward says it's on the piece at the left
    !forward says  it's at the piece at the right */
    bool	forwardCaret;

    /* when scrolling up down the caret is adjusted	to the actual char 
    boundaries, to prevent the caret from sliding laterally whe must 
    remember the virtual position */
    Point2D caretVPos; 

	/* this is set while we are doing a DND operation, during the drop it is 
	used to determine if the operation is a local one and special handling is 
	needed */
	bool withinDND;

	/* to select one needs 2 points, one is the current caret position
	the other one is the old caret position (stored here as the selectionTail) */
	Point2D		selectionTail; 
	Point2D		selectionHead; 

	// the selected pieces 
	uint32 		selectionFirst,selectionSize;

	// remember the colors to be used for selection
	ColorRGB	selColor;
	ColorRGB	selBgColor;

	bool 		acceptKeyENTER;
	bool 		acceptKeyTAB;
	
	// cached vector for char placement measurements
	//std::vector<uint32> charPlacements;
	
private:	
	~TextDocument();
	void Populate();

public:		 
	TextDocument();
	void SetSingleLineMode();
	void DiscardRendering();
	
	void Draw(Graphics& g, const Rect2D& area);
//	bool FindLine(sint32 y, sint32 nl, Pieces::iterator& b, Pieces::iterator& e);
//	bool FindPiece(sint32 x, Pieces::iterator& b, Pieces::iterator& e);

	// move the caret by the specified amount then adjust to the text around
	bool MoveCaretTo(sint32 x, sint32 y, sint32 nc, sint32 nl);
	bool IsCaretAtEOL(); // line
	bool IsCaretAtBOL();
	bool IsCaretAtEOP(); // paragraph
	bool IsCaretAtBOP();
	bool IsCaretAtBOF(); // file,document
	bool IsCaretAtEOF();
	// insert at the current carret pos
	void InsertText(const char* sb, const char* se);
	void InsertPieces(Pieces& newPieces);
    void SetDocumentWidth(uint32 w);
	String GetText();
public:
	bool Selection_Empty() const { return selectionSize == 0; }
	bool Selection_Contains(const Point2D& point);
	void Selection_SelectAll();
	void Selection_MarkTail();
	bool Selection_CreateNew();
	bool Selection_Unselect();
	void Selection_DeleteText(bool preserveCaret=false);
private:
	void Selection_PrepareForPaste(DragDropType::Effect&  effect,
								   bool onlySimulate);

public:
	void PasteToDocument(DragDropType::TypeSet& availableTypes, 
			      DragDropType::Effect&  effect,
				  bool 				   onlySimulate,
				  DragDropType::FatData& fatData );
	void CopyFromDocument (DragDropType::TypeSet& availableTypes, 
				  DragDropType::FatData& fatData );

private:
//	Pieces::iterator _GetPieceAt(sint32 x, sint32 y, sint32 nl);
//	Pieces::iterator _GetPieceAtCaret();

	void _MeasurePieces(Graphics& g);
//	void _RenderPieces();
	void _RenderPieces(Pieces::iterator b);
	void _InsertPiece(Pieces::iterator where, Piece& whatPiece);
	void _InsertPieces(Pieces::iterator where, Pieces::iterator b, Pieces::iterator e);
	bool _SplitRange( Point2D pointA, Point2D pointB,
					 Pieces::iterator& b, Pieces::iterator& e );
	void _MergeNeighbours(Pieces::iterator sb);

	bool Selection_UnselectPieceRange(Point2D pointA, Point2D pointB);
	bool Selection_SelectPieceRange(Point2D pointA, Point2D pointB);
}; // class TextDocument



#if 0
#pragma mark TextView
#endif

class TextView : public View
{
public:
	TextView();
	~TextView();
	void SetSingleLineMode();
	
public:
	virtual void SetBounds(const Rect2D& bounds);
protected:
	virtual void Draw(Graphics& g, const Rect2D& area);
	virtual bool HandleMouseEvent( const UIEvent& ev );
	virtual bool HandleKeyEvent( const UIEvent& ev );
	virtual void HandleDrop(DragDropType::TypeSet& availableTypes, 
							DragDropType::Effect&  effect,
							const Point2D& 		   mousePos,
							bool 				   onlySimulate,
							DragDropType::FatData& theFatData );
	// show the mouse cursor as an "I beam" when on top of text 
	virtual void MouseCursorSetup();
	virtual void MouseCaptureBroken();
    virtual void HandleFocused(bool on);
    // set the caret to the specified position on the screen
	virtual void SetCaret(const Rect2D& r);

	// scroll the visible area around the document 
	bool ScrollTo(sint32 x, sint32 y, bool rfsh=true);
	// move the caret by the specified amount then adjust to the text around
	bool MoveCaretTo(sint32 x, sint32 y, sint32 nc, sint32 nl);
	// coordinate transforms
	Rect2D View2Document(const Rect2D& vr);
	Rect2D Document2View(const Rect2D& dr);
	// bring the visible area so that the caret is within the screen
	void GoToVisibleCaret(bool rfsh=true);
private:
	// the document we are trying to view
	refc<TextDocument> document;
	// the virtual position of this view in the document
    Point2D docPos;
    bool anchorDocumentWidth;

 	enum MouseDragState { None, DragToScroll, DragToSelect, DragSelection };
 	MouseDragState mouseDragState;

	class ScrollListener;
	friend class ScrollListener;
	ViewListener::owner scrollListener; // helps this view react to scroll events

public:
	void Action_Up();
	void Action_Down();
	void Action_Left();
	void Action_Right();
	void Action_PageUp();
	void Action_PageDown();
	void Action_LineBegin();
	void Action_LineEnd();

	void Action_SelectAll();
	void Action_SelectUp();
	void Action_SelectDown();
	void Action_SelectLeft();
	void Action_SelectRight();
	void Action_SelectPageUp();
	void Action_SelectPageDown();
	void Action_SelectPageLeft();
	void Action_SelectPageRight();

	bool Action_ScrollUp();
	bool Action_ScrollDown();
	bool Action_ScrollLeft();
	bool Action_ScrollRight();
	bool Action_ScrollPageUp();
	bool Action_ScrollPageDown();
	bool Action_ScrollPageLeft();
	bool Action_ScrollPageRight();

	void Action_Delete();
	void Action_DeleteBack();

	void Action_Paste();
	void Action_Copy();
	void Action_Cut();

	void DemoPopulate();
	void SetDocumentWidth(uint32 w);
	void AnchorDocumentWidth();
	const refc<TextDocument>& GetDocument() { return document; }

	void SetText(const String& text);
	String GetText();


	// attach a scrollbar to this textview, make sure to call the equivalent function 
	// on the scrollbar too :-)
	void ListenToScrollNotificationsFrom(const View::owner& view);
	void CancelListenToScrollNotifications();

}; // class TextView



} // namespace XSP
