/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Aug27-GiuseppeG: code write
*/

namespace XSP
{
class DialogButtonListener;

class DialogWindow : public ref_obj
{
public:
	DialogWindow();

protected:
	virtual ~DialogWindow();

public:
	virtual void DialogEventOk();
	virtual void DialogEventCancel();
	virtual void DialogEventApply();
	virtual void DoLayout( ); // position the components within the window

public:	 

	enum DialogStyle 
	{ 
		DialogClose=0, 
		DialogOk=1, 
		DialogCancel=2, 
		DialogOkCancel=DialogOk | DialogCancel, 
		DialogApply=4,
		DialogApplyCancel=DialogApply | DialogCancel,
		DialogApplyOkCancel=DialogApply | DialogOk | DialogCancel 
	};

	void CreateFrame(Window& pW); // set the parent and create the frame
	void CreateFrame(WinMgr& mgr);
	void SetTitle(const String& title);
	void SetContentBoundsOnScreen(const Rect2D& lr);
	void SetSkin(const ViewSkin::owner& skin,
				 const TextFont& font );
	void Populate( DialogStyle ds); // add buttonBar with apply,ok,cancel
	void Show();

protected:
	void AddDlgButton(const refc<ButtonView>& bt, 
					  const ButtonView::ActionListener::owner& dbl,
					  const String& text );
	void AddToolButton(const refc<ButtonView>& bt, 
					   const ButtonView::ActionListener::owner& dbl,
					   const String& text );

public:
	Window 			  parentW; // may be null, when the dialog is standalone
	Window 			  dialogW; // the window for this dialog

	ViewSkin::owner   dlgSkin;
	TextFont		  dlgFont;
	
	refc<ButtonView>  buttonOk;
	refc<ButtonView>  buttonCancel;
	refc<ButtonView>  buttonApply;
	
}; // class DialogWindow


} // namespace XSP
