/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Sep03-GiuseppeG: code write
	
Description:
	This file is common to all the demos. It builds the skin needed by the demo apps.
	The SkinBuilder class loads the needed images, and turns them into the desired skin.
	The generated application skin contains all skins needed by the views in the app.
	The generated skin (common to all the demos) contains more skins that are required 
	by any particular demo. This is a waste of resources but since these are just sample 
	applications we considered it is better not to let the skin creation interfere with 
	the actual code of the app. 

	The images are loaded from a folder called "Skin.rsrc". This folder is located within 
	any of the parent folders of the application launched. This allows various apps to be 
	deployed in separate folders but grouped together inside the same parent folder. By 
	placing the skin resources within that same parent folder we allow for the sharing 
	of the skin resources.

	To load images we use an ImagePool object. ImagePool is an agent with the ability to 
	sequentially load a bunch of images (PNG only at the time of this writing) and send 
	completion notifications to its master controller. The class ImageLoader is the proxy 
	that listens to the notifications generated by the ImagePool and resends them to the 
	SkinBuilder class.

	Once all the images have been loaded the SkinBuilder reacts to the notification 
	"ImagesLoaded()" and starts synchronously building the needed skins.
	For now ImagePool loads images and stores them into a vector. Addressing each 
	individual image can be done by the vector index only. This will change in the near 
	future once we transfer all the functionality in this file into an XML based skin 
	configuration file. At that point various skins and images used by it will have 
	customizable string names.

	The creation of each skin consists of 2 steps: 
		1) associating a state to a particular background image "AddStateSkin()"
		   Unless you know really well what you are doing, the default state 
		   (identified by both mask and value zero) should always be defined so 
		   that the view can always draw a background. There is one view where we 
		   commonly do not define any skin states: the label. For labels we simply 
		   do not want a background drawn, and rely on the background of the container.
		   You may choose to think differently :-)
		2) agregating any number of skin definitions as components of a larges skin
		   "AddPart()". If the skin is to be used on a view that does not have 
		   agregated children then there is no need to define any agregate skins.
		   Each agregated skin part has a part-name. The part name is used by the view 
		   to identify  which skin part goes to which child.

	Take a look at "CreateTabSkin()" as a demo. 
    	1) For the tabs the states hovered, selected and default are defined.
		   The images we draw for these states will make the tab look similar to a 
		   raised button. 
		2) The tab skin is agregated with the name "tab" into the bar skin
		   For the bar itself only the default state is defined (an inanimate background)
		3) The bar skin is agregated with the name "bar" into the tab skin.
		   for the entire tab page we did not define a background and rely on the content 
		   of the page to draw something or for the parent container of the tab to do it.
		   It is frequently a good ideea to just omit assigning a background to containers
		   (as tab page) because this will avoid drawing one background (the child) on top 
		   of another (the parent) and waste precious drawing time.
		4) Notice that for each state skin we assign an image but also add a rectangle.
		   The purpose of the rectangle is to define a "content" region to the view. This 
		   allows the skin designer to define where the content goes instead of requiring 
		   the programer to hard code such things. Of course as of now, no XML skin 
		   configuration is available so the feature is not plainly helpfull.
		   During the drawing of the skin the content area gets stretched to cover most of 
		   the view's bounding rectangle. The edges outside of the content area will have 
		   fixed width / height. This is all you need to draw fancy looking borders.
	
	Once the process of building the skins is complete the SkinBuilder broadcasts the 
	appropriate	notification (SkinBuildComplete or SkinBuildFailed) to the listening 
	application. 
*/

#include "XSP_Core.h"
#include "XSP_File.h"
#include "XSP_GUI.h"
#include "XSP_Codecs.h"
using namespace XSP;
#include "CreateSkin.h"

#if 0
#pragma mark class ImageLoader		    
#endif

class ImageLoader : public ImagePool::Listener
{
	SkinBuilder* sb;
public:
	ImageLoader(SkinBuilder* t)
	:sb(t)
	{}
protected:
	virtual void Completed()
	{
		sb->ImagesLoaded();
	}
	virtual void Completed(const FileName& /*fname*/, const OffscreenImage& /*image*/)
	{
		// we ignore individual image notifications
	}
	virtual void Failed(const FileName& /*fname*/, const Exception& err)
	{
		sb->ImageFailed(err);
	}
}; // class ImageLoader

#if 0
#pragma mark -
#endif


SkinBuilder::SkinBuilder()
{
}
SkinBuilder::~SkinBuilder()
{
}

void SkinBuilder::LoadImages()
{
	CreateComic10Font();
	CreateArial8Font();
	CreateTimes8BoldFont();
	CreateTahoma8Font();

	appSkin = new ViewSkin();

	images = new ImagePool();
	images->progressListeners.Add(new ImageLoader(this));

	FileName dir(FileModule::_instance->specialFileNames[SpecialFileNames::AppDir]);
	for(;;) // search for the resoursces folder up the file hierarchy
	{
		FileName rsrc = FileName::From(dir,String::From_c_str("Skin.rsrc"));
		if (rsrc.IsDir())
		{
			dir = rsrc;
			break;
		}
		if (!dir.HasParent())
		{
			dir = FileModule::_instance->specialFileNames[SpecialFileNames::AppDir];
			break;
		}
		dir = dir.GetParent();
	}
	images->Load(FileName::From(dir,String::From_c_str("BackgroundScape.png"))); //0

	FileName dir1 = FileName::From(dir,String::From_c_str("Orange"));
	images->Load(FileName::From(dir1,String::From_c_str("Image.png")));			 //1
	images->Load(FileName::From(dir1,String::From_c_str("ButtonPressed.png")));	 //2
	images->Load(FileName::From(dir1,String::From_c_str("ButtonFlat.png")));	 //3
	images->Load(FileName::From(dir1,String::From_c_str("ButtonRaised.png")));	 //4
	images->Load(FileName::From(dir1,String::From_c_str("ButtonFocused.png")));	 //5

	dir1 = FileName::From(dir,String::From_c_str("Grey"));
	images->Load(FileName::From(dir1,String::From_c_str("ButtonPushed.png")));	 //6
	images->Load(FileName::From(dir1,String::From_c_str("ButtonRaised.png")));	 //7

	dir1 = FileName::From(dir,String::From_c_str("Skin1"));
	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowDown.png")));	 	 //8
	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowDownHover.png")));	 //9
	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowDownPress.png")));	 //10
	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowDownDisable.png")));//11

	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowLeft.png")));	 	 //12
	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowLeftHover.png")));	 //13
	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowLeftPress.png")));	 //14
	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowLeftDisable.png")));//15

	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowRight.png")));	 	 //16
	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowRightHover.png"))); //17
	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowRightPress.png"))); //18
	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowRightDisable.png")));//19

	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowUp.png")));	 	//20
	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowUpHover.png"))); 	//21
	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowUpPress.png"))); 	//22
	images->Load(FileName::From(dir1,String::From_c_str("ScrArrowUpDisable.png")));	//23

	images->Load(FileName::From(dir1,String::From_c_str("ScrBkgdLeft.png")));	//24
	images->Load(FileName::From(dir1,String::From_c_str("ScrBkgdRight.png")));	//25
	images->Load(FileName::From(dir1,String::From_c_str("ScrBkgdTop.png")));	//26
	images->Load(FileName::From(dir1,String::From_c_str("ScrBkgdBottom.png")));	//27

	images->Load(FileName::From(dir1,String::From_c_str("ScrHndl-HRaised.png")));		//28
	images->Load(FileName::From(dir1,String::From_c_str("ScrHndl-HRaisedHover.png")));	//29
	images->Load(FileName::From(dir1,String::From_c_str("ScrHndl-HPress.png")));		//30
	images->Load(FileName::From(dir1,String::From_c_str("ScrHndl-HDisable.png")));		//31

	images->Load(FileName::From(dir1,String::From_c_str("ScrHndl-VRaised.png")));		//32
	images->Load(FileName::From(dir1,String::From_c_str("ScrHndl-VRaisedHover.png")));	//33
	images->Load(FileName::From(dir1,String::From_c_str("ScrHndl-VPress.png")));		//34
	images->Load(FileName::From(dir1,String::From_c_str("ScrHndl-VDisable.png")));		//35


	images->Load(FileName::From(dir1,String::From_c_str("BtnPress.png")));//36
	images->Load(FileName::From(dir1,String::From_c_str("BtnRaise.png")));//37
	images->Load(FileName::From(dir1,String::From_c_str("BtnDisable.png")));//38
	images->Load(FileName::From(dir1,String::From_c_str("BtnRaiseFocus.png")));//39
	images->Load(FileName::From(dir1,String::From_c_str("BtnRaiseHover.png")));//40
	images->Load(FileName::From(dir1,String::From_c_str("BtnRaiseFocusHover.png")));//41
	images->Load(FileName::From(dir1,String::From_c_str("BtnSelect.png")));//42
	images->Load(FileName::From(dir1,String::From_c_str("BtnSelectDisable.png")));//43
	images->Load(FileName::From(dir1,String::From_c_str("BtnSelectFocus.png")));//44
	images->Load(FileName::From(dir1,String::From_c_str("BtnSelectHover.png")));//45
	images->Load(FileName::From(dir1,String::From_c_str("BtnSelectFocusHover.png")));//46

	images->Load(FileName::From(dir1,String::From_c_str("Tab.png")));//47
	images->Load(FileName::From(dir1,String::From_c_str("TabDisable.png")));//48
	images->Load(FileName::From(dir1,String::From_c_str("TabHover.png")));//49
	images->Load(FileName::From(dir1,String::From_c_str("MenuBkgd.png")));//50
	images->Load(FileName::From(dir1,String::From_c_str("DropdownBkgd.png")));//51
	images->Load(FileName::From(dir1,String::From_c_str("Tool-Disabled.png")));//52

	images->Load(FileName::From(dir1,String::From_c_str("tool1.png")));//53
	images->Load(FileName::From(dir1,String::From_c_str("tool2.png")));//54
	images->Load(FileName::From(dir1,String::From_c_str("tool3.png")));//55
	images->Load(FileName::From(dir1,String::From_c_str("tool4.png")));//56
	images->Load(FileName::From(dir1,String::From_c_str("tool5.png")));//57

	images->Load(FileName::From(dir1,String::From_c_str("ListCell.png")));//58
	images->Load(FileName::From(dir1,String::From_c_str("ListCellBkg.png")));//59
	images->Load(FileName::From(dir1,String::From_c_str("ListCellDisable.png")));//60
	images->Load(FileName::From(dir1,String::From_c_str("ListCellFocus.png")));//61
	images->Load(FileName::From(dir1,String::From_c_str("ListCellFocusHover.png")));//62
	images->Load(FileName::From(dir1,String::From_c_str("ListCellFocusPress.png")));//63
	images->Load(FileName::From(dir1,String::From_c_str("ListCellHover.png")));//64
	images->Load(FileName::From(dir1,String::From_c_str("ListCellSelected.png")));//65
}

void SkinBuilder::ImageFailed(const Exception& err)
{
	#if DEBUG
		UnitTest::Log("SkinLoader error: %s", err.FormatMessageToString().c_str());
	#endif	

	images->CancelAllDownloads();

	for (Listener::each e(listeners); !e.empty(); e.pop()) 
		if (! e->IsCanceled())
			e->SkinBuildFailed(err);
}

void SkinBuilder::ImagesLoaded()
{
	#if DEBUG
		UnitTest::Log("Loaded: %d images", images->ImageCount());
	#endif

	CreateButtonSkin();
	CreateTabSkin();
	CreateScrollPageSkin();
	CreateListSkin();
	CreateComboSkin();
	CreateDialogSkin();
	CreateOrangeSkin();
	CreateGreySkin();
	CreateToolbarSkin();
	CreateToolSkins();
	CreateFilePickSkin();

	for (Listener::each e(listeners); !e.empty(); e.pop()) 
		if (! e->IsCanceled())
			e->SkinBuildComplete();
}

#if 0
#pragma mark -
#endif

void SkinBuilder::CreateButtonSkin()
{
	Rect2D r;
	refc<ViewSkin> skin(new ViewSkin());
    r.x=4; r.y=2; r.w=8; r.h=4;

	skin->AddStateSkin( View::StateCapturing, 
						View::StateCapturing,
						new ImageSkin(images->GetImage(36), r));

	skin->AddStateSkin( ButtonView::State3RD|View::StateDisabled, 
						View::StateDisabled, 
						new ImageSkin(images->GetImage(38), r));
	skin->AddStateSkin( ButtonView::State3RD|View::StateHovered|View::StateFocused, 
						View::StateHovered, 
						new ImageSkin(images->GetImage(40), r));
	skin->AddStateSkin( ButtonView::State3RD|View::StateHovered|View::StateFocused, 
						View::StateFocused, 
						new ImageSkin(images->GetImage(39), r));
	skin->AddStateSkin( ButtonView::State3RD|View::StateHovered|View::StateFocused, 
						View::StateHovered|View::StateFocused, 
						new ImageSkin(images->GetImage(41), r));


    r.x=18; r.y=2; r.w=20; r.h=4;
	skin->AddStateSkin( ButtonView::State3RD|View::StateDisabled, 
						ButtonView::State3RD|View::StateDisabled, 
						new ImageSkin(images->GetImage(43), r));
	skin->AddStateSkin( ButtonView::State3RD|View::StateHovered|View::StateFocused, 
						ButtonView::State3RD|View::StateHovered, 
						new ImageSkin(images->GetImage(45), r));
	skin->AddStateSkin( ButtonView::State3RD|View::StateHovered|View::StateFocused, 
						ButtonView::State3RD|View::StateFocused, 
						new ImageSkin(images->GetImage(44), r));
	skin->AddStateSkin( ButtonView::State3RD|View::StateHovered|View::StateFocused, 
						ButtonView::State3RD|View::StateHovered|View::StateFocused, 
						new ImageSkin(images->GetImage(46), r));
	skin->AddStateSkin( ButtonView::State3RD, 
						ButtonView::State3RD, 
						new ImageSkin(images->GetImage(42), r));

    r.x=4; r.y=2; r.w=8; r.h=4;
	skin->AddStateSkin( 0, 0, 
						new ImageSkin(images->GetImage(37), r));

	appSkin->AddPart(String::From_c_str("Button"), skin);
}

void SkinBuilder::CreateTabSkin()
{
	Rect2D r;
	refc<ViewSkin> skin(new ViewSkin());
    r.x=4; r.y=4; r.w=8; r.h=6;

	skin->AddStateSkin( ButtonView::State3RD|View::StateHovered, 
						ButtonView::State3RD, 
						new ImageSkin(images->GetImage(47), r));
	skin->AddStateSkin( ButtonView::State3RD|View::StateHovered, 
						ButtonView::State3RD|View::StateHovered, 
						new ImageSkin(images->GetImage(49), r));
	skin->AddStateSkin( 0, 0, 
						new ImageSkin(images->GetImage(48), r));

	refc<ViewSkin> bar(new ViewSkin());
	bar->AddStateSkin( 0, 0, 
					   new ImageSkin(images->GetImage(50), r));
	bar->AddPart(String::From_c_str("tab"), skin);

	refc<ViewSkin> tabview(new ViewSkin());
    r.x=0; r.y=0; r.w=0; r.h=0;
	tabview->AddStateSkin( 0, 0, 
					   new ImageSkin(images->GetImage(51), r));
	tabview->AddPart(String::From_c_str("bar"), bar);

	appSkin->AddPart(String::From_c_str("Tab"), tabview);
}

void SkinBuilder::CreateToolbarSkin()
{
	Rect2D r;
	refc<ViewSkin> skin(new ViewSkin());
    r.x=8; r.y=8; r.w=16; r.h=16;
	skin->AddStateSkin( 0, 0, 
						new ImageSkin(images->GetImage(52), r));

	refc<ViewSkin> bar(new ViewSkin());
    r.x=3; r.y=3; r.w=6; r.h=6;
	bar->AddStateSkin( 0, 0, 
					   new ImageSkin(images->GetImage(50), r));
	bar->AddPart(String::From_c_str("Tool"), skin);

	appSkin->AddPart(String::From_c_str("Toolbar"), bar);
}
refc<ViewSkin> SkinBuilder::CreateToolSkin(uint32 imgNo)
{
	Rect2D r;

	OffscreenImage src = images->GetImage(imgNo);
	Size2D z = src.GetSize();
	OffscreenImage psh(z.w, z.h, OffscreenImage::RGBA32);
	{   // pushed rect
		Graphics g(psh);
		r.x=0; r.y=0; r.w = z.w; r.h = z.h;  g.DrawImage(src,r,r); 
		ColorRGB rgbBlack(60,60,60);
		r.x=0; r.y=0; r.w=z.w; r.h=1;	g.FillRect(rgbBlack,r); 
		r.x=0; r.y=0; r.w=1; r.h=z.h;	g.FillRect(rgbBlack,r); 
		ColorRGB rgbWhite(255,255,255);
		r.x=z.w-1; r.y=1; r.w=1; r.h=z.h-1;	g.FillRect(rgbWhite,r); 
		r.x=1; r.y=z.h-1; r.w=z.w-1; r.h=1;	g.FillRect(rgbWhite,r); 
	}
	OffscreenImage rai(z.w, z.h, OffscreenImage::RGBA32);
	{   // raised rect
		Graphics g(rai);
		r.x=0; r.y=0; r.w = z.w; r.h = z.h;  g.DrawImage(src,r,r); 
		ColorRGB rgbWhite(255,255,255);
		r.x=0; r.y=0; r.w=z.w; r.h=1;	g.FillRect(rgbWhite,r); 
		r.x=0; r.y=0; r.w=1; r.h=z.h;	g.FillRect(rgbWhite,r); 
		ColorRGB rgbBlack(60,60,60);
		r.x=z.w-1; r.y=1; r.w=1; r.h=z.h-1;	g.FillRect(rgbBlack,r); 
		r.x=1; r.y=z.h-1; r.w=z.w-1; r.h=1;	g.FillRect(rgbBlack,r); 
	}
	
	refc<ViewSkin> skin(new ViewSkin());
    r.x=1; r.y=1; r.w=2; r.h=2;
	// pushed
	skin->AddStateSkin( View::StateCapturing, View::StateCapturing,	new ImageSkin(psh, r));
	//raised
	skin->AddStateSkin( View::StateHovered, View::StateHovered,	new ImageSkin(rai, r));
	// flat
    r.x=0; r.y=0; r.w=0; r.h=0;
	skin->AddStateSkin( 0, 0, new ImageSkin(src, r));
	return skin;
}

void SkinBuilder::CreateToolSkins()
{
	appSkin->AddPart(String::From_c_str("Tool1"), CreateToolSkin(53));
	appSkin->AddPart(String::From_c_str("Tool2"), CreateToolSkin(54));
	appSkin->AddPart(String::From_c_str("Tool3"), CreateToolSkin(55));
	appSkin->AddPart(String::From_c_str("Tool4"), CreateToolSkin(56));
	appSkin->AddPart(String::From_c_str("Tool5"), CreateToolSkin(57));
}


void SkinBuilder::CreateListSkin()
{
	Rect2D r;    

	refc<ViewSkin> partI(new ViewSkin());
    r.x=3; r.y=2; r.w=6; r.h=4;

	partI->AddStateSkin( View::StateCapturing, 
						 View::StateCapturing,
						 new ImageSkin(images->GetImage(63), r));
	partI->AddStateSkin( View::StateDisabled, 
						 View::StateDisabled,
						 new ImageSkin(images->GetImage(60), r));
	partI->AddStateSkin( ButtonView::State3RD, 
						 ButtonView::State3RD,
						 new ImageSkin(images->GetImage(65), r)); 
	partI->AddStateSkin( View::StateFocused | View::StateHovered, 
						 View::StateFocused | View::StateHovered,
						 new ImageSkin(images->GetImage(62), r));
	partI->AddStateSkin( View::StateFocused, 
						 View::StateFocused,
						 new ImageSkin(images->GetImage(61), r));
	partI->AddStateSkin( View::StateHovered, 
						 View::StateHovered, 
						 new ImageSkin(images->GetImage(64), r));
	partI->AddStateSkin( 0, 0, 
						 new ImageSkin(images->GetImage(58), r));

	refc<ViewSkin> skin(new ViewSkin());
	skin->AddStateSkin( 0,0, 
						new ImageSkin(images->GetImage(59), r)); 
	skin->AddPart(String::From_c_str("Item"), partI);
	appSkin->AddPart(String::From_c_str("List"), skin);
}


void SkinBuilder::CreateComboSkin()
{
	Rect2D r;    
	refc<ViewSkin> skin(new ViewSkin());
    r.x=2; r.y=2; r.w=4; r.h=4;	  // like a pushed button
	skin->AddStateSkin( 0,0, new ImageSkin(images->GetImage(36), r)); 

	skin->AddPart(String::From_c_str("Content"), 
					appSkin->GetPart(String::From_c_str("Sys.Edit")));
	skin->AddPart(String::From_c_str("Activate"), 
					appSkin->GetPart(String::From_c_str("ScrollPage"))
						   ->GetPart(String::From_c_str("vertical"))
						   ->GetPart(String::From_c_str("b2")));
	skin->AddPart(String::From_c_str("List"), 
					appSkin->GetPart(String::From_c_str("List")));
	skin->AddPart(String::From_c_str("ScrollPage"), 
					appSkin->GetPart(String::From_c_str("ScrollPage")));
	appSkin->AddPart(String::From_c_str("Combo"), skin);
}

refc<ViewSkin> SkinBuilder::CreateScrollVSkin()
{
	Rect2D r;
    r.x=2; r.y=3; r.w=4; r.h=6;	 
	refc<ViewSkin> parts1(new ViewSkin());
	parts1->AddStateSkin( 0, 0, 
						  new ImageSkin(images->GetImage(26), r));
	refc<ViewSkin> parts2(new ViewSkin());
	parts2->AddStateSkin( 0, 0, 
						  new ImageSkin(images->GetImage(27), r));

	refc<ViewSkin> partth(new ViewSkin());
	partth->AddStateSkin( View::StateCapturing, View::StateCapturing,
						  new ImageSkin(images->GetImage(34), r));
	partth->AddStateSkin( View::StateDisabled, View::StateDisabled, 
						  new ImageSkin(images->GetImage(35), r));
	partth->AddStateSkin( View::StateHovered, View::StateHovered, 
						  new ImageSkin(images->GetImage(33), r));
	partth->AddStateSkin( 0, 0, 
						  new ImageSkin(images->GetImage(32), r));

    r.x=0; r.y=0; r.w=0; r.h=0;	 
	refc<ViewSkin> partb1(new ViewSkin());
	partb1->AddStateSkin( View::StateCapturing, View::StateCapturing,
						  new ImageSkin(images->GetImage(22), r));
	partb1->AddStateSkin( View::StateDisabled, View::StateDisabled, 
						  new ImageSkin(images->GetImage(23), r));
	partb1->AddStateSkin( View::StateHovered, View::StateHovered, 
						  new ImageSkin(images->GetImage(21), r));
	partb1->AddStateSkin( 0, 0, 
						  new ImageSkin(images->GetImage(20), r));

	refc<ViewSkin> partb2(new ViewSkin());
	partb2->AddStateSkin( View::StateCapturing, View::StateCapturing,
						  new ImageSkin(images->GetImage(10), r));
	partb2->AddStateSkin( View::StateDisabled, View::StateDisabled, 
						  new ImageSkin(images->GetImage(11), r));
	partb2->AddStateSkin( View::StateHovered, View::StateHovered, 
						  new ImageSkin(images->GetImage(9), r));
	partb2->AddStateSkin( 0, 0, 
						  new ImageSkin(images->GetImage(8), r));

	refc<ViewSkin> skin(new ViewSkin());
	skin->AddPart(String::From_c_str("s1"), parts1);
	skin->AddPart(String::From_c_str("s2"), parts2);
	skin->AddPart(String::From_c_str("thumb"), partth);
	skin->AddPart(String::From_c_str("b1"), partb1);
	skin->AddPart(String::From_c_str("b2"), partb2);
	return skin;
}
refc<ViewSkin> SkinBuilder::CreateScrollHSkin()
{
	Rect2D r;
    r.x=3; r.y=2; r.w=6; r.h=4;	  // like a pushed button
	refc<ViewSkin> parts1(new ViewSkin());
	parts1->AddStateSkin( 0, 0, 
						  new ImageSkin(images->GetImage(24), r));

	refc<ViewSkin> parts2(new ViewSkin());
	parts2->AddStateSkin( 0, 0, 
						  new ImageSkin(images->GetImage(25), r));

	refc<ViewSkin> partth(new ViewSkin());
	partth->AddStateSkin( View::StateCapturing, View::StateCapturing,
						  new ImageSkin(images->GetImage(30), r));
	partth->AddStateSkin( View::StateDisabled, View::StateDisabled, 
						  new ImageSkin(images->GetImage(31), r));
	partth->AddStateSkin( View::StateHovered, View::StateHovered, 
						  new ImageSkin(images->GetImage(29), r));
	partth->AddStateSkin( 0, 0, 
						  new ImageSkin(images->GetImage(28), r));

    r.x=0; r.y=0; r.w=0; r.h=0;	 
	refc<ViewSkin> partb1(new ViewSkin());
	partb1->AddStateSkin( View::StateCapturing, View::StateCapturing,
						  new ImageSkin(images->GetImage(14), r));
	partb1->AddStateSkin( View::StateDisabled, View::StateDisabled, 
						  new ImageSkin(images->GetImage(15), r));
	partb1->AddStateSkin( View::StateHovered, View::StateHovered, 
						  new ImageSkin(images->GetImage(13), r));
	partb1->AddStateSkin( 0, 0, 
						  new ImageSkin(images->GetImage(12), r));

	refc<ViewSkin> partb2(new ViewSkin());
	partb2->AddStateSkin( View::StateCapturing, View::StateCapturing,
						  new ImageSkin(images->GetImage(18), r));
	partb2->AddStateSkin( View::StateDisabled, View::StateDisabled, 
						  new ImageSkin(images->GetImage(19), r));
	partb2->AddStateSkin( View::StateHovered, View::StateHovered, 
						  new ImageSkin(images->GetImage(17), r));
	partb2->AddStateSkin( 0, 0, 
						  new ImageSkin(images->GetImage(16), r));

	refc<ViewSkin> skin(new ViewSkin());
	skin->AddPart(String::From_c_str("s1"), parts1);
	skin->AddPart(String::From_c_str("s2"), parts2);
	skin->AddPart(String::From_c_str("thumb"), partth);
	skin->AddPart(String::From_c_str("b1"), partb1);
	skin->AddPart(String::From_c_str("b2"), partb2);
	return skin;
}
void SkinBuilder::CreateScrollPageSkin()
{
	refc<ViewSkin> skin(new ViewSkin());
	skin->AddPart(String::From_c_str("horizontal"), CreateScrollHSkin());
	skin->AddPart(String::From_c_str("vertical"), CreateScrollVSkin());
	appSkin->AddPart(String::From_c_str("ScrollPage"), skin);
}

void SkinBuilder::CreateOrangeSkin()
{
	refc<ViewSkin> skin(new ViewSkin());
	Rect2D content(Point2D(4,2), Size2D(8,4));
	// 1=pressed, 2=flat, 3=raised
	skin->AddStateSkin( View::StateCapturing, View::StateCapturing,
					  	new ImageSkin(images->GetImage(2), content));
	skin->AddStateSkin( View::StateHovered,	View::StateHovered,
						new ImageSkin(images->GetImage(3), content));
	skin->AddStateSkin( ButtonView::State3RD,	ButtonView::State3RD,
						new ImageSkin(images->GetImage(6), content));
	skin->AddStateSkin( View::StateFocused,	View::StateFocused,
						new ImageSkin(images->GetImage(5), content));
	skin->AddStateSkin( 0, 0,
						new ImageSkin(images->GetImage(4), content));
	appSkin->AddPart(String::From_c_str("Orange"), skin);
}

void SkinBuilder::CreateGreySkin()
{
	refc<ViewSkin> skin(new ViewSkin());
	Rect2D content(Point2D(2,2), Size2D(4,4));
	skin->AddStateSkin( View::StateCapturing, View::StateCapturing,
						new ImageSkin(images->GetImage(6), content));
	skin->AddStateSkin( 0, 0,
						new ImageSkin(images->GetImage(7), content));
	appSkin->AddPart(String::From_c_str("Grey"), skin);
}

void SkinBuilder::CreateDialogSkin()
{
	Rect2D r;    
	refc<ViewSkin> buttonbar(new ViewSkin());
//    r.x=0; r.y=0; r.w=0; r.h=0;
    r.x=4; r.y=2; r.w=8; r.h=4;
	buttonbar->AddStateSkin( 0, 0, 
					   new ImageSkin(images->GetImage(36), r)); // 51, 50

	refc<ViewSkin> skin(new ViewSkin());
	skin->AddPart(String::From_c_str("Content"), 
					appSkin->GetPart(String::From_c_str("Sys.Edit")));
	skin->AddPart(String::From_c_str("ButtonBar"), 
					buttonbar);
	skin->AddPart(String::From_c_str("Button"), 
					appSkin->GetPart(String::From_c_str("Button"))	);

	appSkin->AddPart(String::From_c_str("Dialog"), skin);
}

void SkinBuilder::CreateFilePickSkin()
{
	refc<ViewSkin> skin(new ViewSkin());
//	skin->AddPart(String::From_c_str("Content"), 
//					appSkin->GetPart(String::From_c_str("Sys.Edit")));
	skin->AddPart(String::From_c_str("Button"), 
					appSkin->GetPart(String::From_c_str("Button"))	);
	skin->AddPart(String::From_c_str("Combo"), 
					appSkin->GetPart(String::From_c_str("Combo"))	);
	skin->AddPart(String::From_c_str("Edit"), 
					appSkin->GetPart(String::From_c_str("Sys.Edit"))	);
	skin->AddPart(String::From_c_str("List"), 
					appSkin->GetPart(String::From_c_str("List"))	);
	skin->AddPart(String::From_c_str("ScrollPage"), 
					appSkin->GetPart(String::From_c_str("ScrollPage"))	);
	skin->AddPart(String::From_c_str("Back-Button"), 
					appSkin->GetPart(String::From_c_str("ScrollPage"))
						   ->GetPart(String::From_c_str("horizontal"))
						   ->GetPart(String::From_c_str("b1"))	);
	skin->AddPart(String::From_c_str("Forward-Button"), 
					appSkin->GetPart(String::From_c_str("ScrollPage"))
						   ->GetPart(String::From_c_str("horizontal"))
						   ->GetPart(String::From_c_str("b2"))	);
	skin->AddPart(String::From_c_str("Up-Button"), 
					appSkin->GetPart(String::From_c_str("ScrollPage"))
						   ->GetPart(String::From_c_str("vertical"))
						   ->GetPart(String::From_c_str("b1"))	);
	appSkin->AddPart(String::From_c_str("FilePick"), skin);
}

#if 0
#pragma mark -
#endif

void SkinBuilder::CreateComic10Font()
{
	FontName fn;
	fn.faceName = String::From_c_str("Comic Sans MS");
	fn.fontSize = 10;	
	comic10Font = TextFont(fn);		
}
void SkinBuilder::CreateArial8Font()
{
	FontName fn;
	fn.faceName = String::From_c_str("Arial");
	fn.fontSize = 8;	
	arial8Font = TextFont(fn);		
}
void SkinBuilder::CreateTimes8BoldFont()
{
	FontName fn;
	fn.faceName = String::From_c_str("Times New Roman");
	fn.fontSize = 8;	
	fn.boldFont = true;
	times8boldFont = TextFont(fn);		
}
void SkinBuilder::CreateTahoma8Font()
{
	FontName fn;
	fn.faceName = String::From_c_str("Tahoma");
	fn.fontSize = 8;	
	tahoma8Font = TextFont(fn);		
}



