/*
Copyright (C) 2003 Hotsprings Inc.
For conditions of distribution and use, see copyright notice

Location: 
	www.HotspringsInc.com 

History:
	2003Apr10-GiuseppeG: code write
*/

#include "XSP_Core.h"

static void LocalMain()
{
	try 
	{ 
		XSP::MainEntryPoint();
	}			 
	catch (...) 
	{
		if (XSP::AppExitCode::GetExitCode() == 0)
			XSP::AppExitCode::SetExitCode(1);
	}
}

#if TARGET_API_MAC_OS8 || TARGET_API_MAC_Carbon
	void main(void)
	{
		LocalMain();
	}
#elif TARGET_API_MAC_Mach0 || TARGET_API_Darwin || TARGET_API_Win32_Console || TARGET_API_Linux
	int main(int argc, char* argv[])
	{		
		XSP::AppCmdLine::SetARGC(argc);
		XSP::AppCmdLine::SetARGV(argv);
		LocalMain();
		return XSP::AppExitCode::GetExitCode();
	}
#elif TARGET_API_Win32
	int APIENTRY WinMain(HINSTANCE hInstance,
						 HINSTANCE /* hPrevInstance*/, 
						 LPSTR /* szCmdLine */, 
						 int /* iCmdShow */)
	{
		if (hInstance != ::GetModuleHandle(NULL))
			XSP::AppExitCode::SetExitCode(1);
		else
			LocalMain();
		return XSP::AppExitCode::GetExitCode();
	}
#endif

