// Sample6_ExternalResourcesEmbeddingDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Sample6_ExternalResourcesEmbedding.h"
#include "Sample6_ExternalResourcesEmbeddingDlg.h"
#include ".\sample6_externalresourcesembeddingdlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// Load resource helper
static void LoadResourceHelper( /* in */ LPCTSTR lpszName, 
							    /* in */ LPCTSTR lpszType, 
								/* out */ LPVOID& lpData, 
								/* out */ DWORD& dwSize);

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CSample6_ExternalResourcesEmbeddingDlg dialog



CSample6_ExternalResourcesEmbeddingDlg::CSample6_ExternalResourcesEmbeddingDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSample6_ExternalResourcesEmbeddingDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSample6_ExternalResourcesEmbeddingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CSample6_ExternalResourcesEmbeddingDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(ID_SITE, OnBnClickedSite)
	ON_BN_CLICKED(ID_ORDER, OnBnClickedOrder)
END_MESSAGE_MAP()


// CSample6_ExternalResourcesEmbeddingDlg message handlers

BOOL CSample6_ExternalResourcesEmbeddingDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// FlashPlayerControl creating
	// NOTE: CALL RegisterFlashWindowClass() or RegisterFlashWindowClassEx() before creating!
	// See InitInstance() implementation
	{
		RECT rc;
		GetDlgItem(IDC_STATIC_FPC_PLACE)->GetWindowRect(&rc);
		ScreenToClient(&rc);

		m_hwndFlashPlayerControl = 
			CreateWindow(WC_FLASH, 
						 NULL, 
						 WS_CHILD | WS_VISIBLE, 
						 rc.left, 
						 rc.top, 
						 rc.right - rc.left, 
						 rc.bottom - rc.top, 
						 m_hWnd, 
						 NULL, 
						 NULL, 
						 NULL);
	}

	// Load movie from resource
	FPCPutMovieFromResource(m_hwndFlashPlayerControl, 0, _T("MOVIE"), _T("SWF"));

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSample6_ExternalResourcesEmbeddingDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSample6_ExternalResourcesEmbeddingDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSample6_ExternalResourcesEmbeddingDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

LRESULT CSample6_ExternalResourcesEmbeddingDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
    if (WM_NOTIFY == message)
    {
        LPNMHDR lpNMHDR = (LPNMHDR)lParam;

        if (m_hwndFlashPlayerControl == lpNMHDR->hwndFrom)
            switch (lpNMHDR->code)
            {
                case FPCN_ONPROGRESS:
                {
                    SFPCOnProgressInfoStruct* pInfo = (SFPCOnProgressInfoStruct*)lParam;

                    TRACE(_T("FPCN_ONPROGRESS: percentDone(%d)\n"), pInfo->percentDone);

                    return 1;
                }

                case FPCN_FSCOMMAND:
                {
                    SFPCFSCommandInfoStruct* pInfo = (SFPCFSCommandInfoStruct*)lParam;

                    TRACE(_T("FPCN_FSCOMMAND: command(%s), args(%s)\n"), pInfo->command, pInfo->args);

                    return 1;
                }

                case FPCN_ONREADYSTATECHANGE:
                {
                    SFPCOnReadyStateChangeInfoStruct* pInfo = (SFPCOnReadyStateChangeInfoStruct*)lParam;

                    TRACE(_T("FPCN_ONREADYSTATECHANGE: newState(%d)\n"), pInfo->newState);

                    return 1;
                }

                case FPCN_LOADEXTERNALRESOURCE:
                {
                    LPVOID lpResourceData = NULL;
                    DWORD dwResourceSize = 0;

                    SFPCLoadExternalResource* pInfo = (SFPCLoadExternalResource*)lParam;

                    if (0 == lstrcmpi(pInfo->lpszRelativePath, _T("images/embedded_image1.jpg")))
                    {
                        LoadResourceHelper(_T("IMAGE1"), _T("IMAGE"), lpResourceData, dwResourceSize);

                        ULONG ulWritten;
                        pInfo->lpStream->Write(lpResourceData, dwResourceSize, &ulWritten);
                    }
                    else if (0 == lstrcmpi(pInfo->lpszRelativePath, _T("images/embedded_image2.jpg")))
                    {
                        LoadResourceHelper(_T("IMAGE2"), _T("IMAGE"), lpResourceData, dwResourceSize);

                        ULONG ulWritten;
                        pInfo->lpStream->Write(lpResourceData, dwResourceSize, &ulWritten);
                    }
                    else if (0 == lstrcmpi(pInfo->lpszRelativePath, _T("images/embedded_image3.jpg")))
                    {
                        LoadResourceHelper(_T("IMAGE3"), _T("IMAGE"), lpResourceData, dwResourceSize);

                        ULONG ulWritten;
                        pInfo->lpStream->Write(lpResourceData, dwResourceSize, &ulWritten);
                    }
                    else if (0 == lstrcmpi(pInfo->lpszRelativePath, _T("images/embedded_image4.jpg")))
                    {
                        LoadResourceHelper(_T("IMAGE4"), _T("IMAGE"), lpResourceData, dwResourceSize);

                        ULONG ulWritten;
                        pInfo->lpStream->Write(lpResourceData, dwResourceSize, &ulWritten);
                    }
                    else if (0 == lstrcmpi(pInfo->lpszRelativePath, _T("images/embedded_image5.jpg")))
                    {
                        LoadResourceHelper(_T("IMAGE5"), _T("IMAGE"), lpResourceData, dwResourceSize);

                        ULONG ulWritten;
                        pInfo->lpStream->Write(lpResourceData, dwResourceSize, &ulWritten);
                    }
                    else if (0 == lstrcmpi(pInfo->lpszRelativePath, _T("external_image.jpg")))
                    {
                        CFileDialog dlg(TRUE, 
                                        _T("jpg"), 
                                        _T(""), 
                                        0, 
                                        _T("JPEG (*.jpg, *.jpeg)|*.jpg;*.jpeg|All Files (*.*)|*.*||"), 
                                        this, 
                                        0);

                        if (IDOK == dlg.DoModal())
                        {
                            HANDLE hFile = 
                                CreateFile(dlg.GetPathName(), 
                                           GENERIC_READ, 
                                           FILE_SHARE_READ, 
                                           NULL, 
                                           OPEN_EXISTING, 
                                           0, 
                                           NULL);

                            if (INVALID_HANDLE_VALUE != hFile)
                            {
                                HANDLE hFileMapping = 
                                    CreateFileMapping(hFile, NULL, PAGE_READONLY, 0, 0, NULL);

                                lpResourceData = 
                                    MapViewOfFile(hFileMapping, FILE_MAP_READ, 0, 0, 0);
                                dwResourceSize = 
                                    GetFileSize(hFile, NULL);

                                ULONG ulWritten;
                                pInfo->lpStream->Write(lpResourceData, dwResourceSize, &ulWritten);

                                UnmapViewOfFile(lpResourceData);

                                CloseHandle(hFileMapping);
                            }

                            CloseHandle(hFile);
                        }
                    }
                    else if (0 == lstrcmpi(pInfo->lpszRelativePath, _T("embedded_movie.swf")))
                    {
                        LoadResourceHelper(_T("MOVIE1"), _T("SWF"), lpResourceData, dwResourceSize);

                        ULONG ulWritten;
                        pInfo->lpStream->Write(lpResourceData, dwResourceSize, &ulWritten);
					}
                }
            }
    }

    return CDialog::WindowProc(message, wParam, lParam);
}

// Load resource helper
void LoadResourceHelper( /* in */ LPCTSTR lpszName, 
                         /* in */ LPCTSTR lpszType, 
                         /* out */ LPVOID& lpData, 
                         /* out */ DWORD& dwSize)
{
    HMODULE hModule = GetModuleHandle(NULL);
    HRSRC hResInfo = FindResource(hModule, lpszName, lpszType);
    HGLOBAL hResData = LoadResource(hModule, hResInfo);
    lpData = LockResource(hResData);
    dwSize = SizeofResource(hModule, hResInfo);
}

void CSample6_ExternalResourcesEmbeddingDlg::OnBnClickedSite()
{
	ShellExecute(m_hWnd, NULL, _T("http://www.flashplayercontrol.com/dll/"), NULL, NULL, SW_SHOW);
}

void CSample6_ExternalResourcesEmbeddingDlg::OnBnClickedOrder()
{
	ShellExecute(m_hWnd, NULL, _T("http://www.flashplayercontrol.com/dll/order.html"), NULL, NULL, SW_SHOW);
}
