// VaxSIPUserAgentLib.h: interface for the CVaxSIPUserAgentLib class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VAXSIPUSERAGENTLIB_H__A370F557_2178_4F9E_8B8C_8C2554A94C55__INCLUDED_)
#define AFX_VAXSIPUSERAGENTLIB_H__A370F557_2178_4F9E_8B8C_8C2554A94C55__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CVaxSIPUserAgentObject;

class CVaxSIPUserAgentLib  
{
public:
	CVaxSIPUserAgentLib();
	~CVaxSIPUserAgentLib();

private:

	CVaxSIPUserAgentObject* m_pVaxSIPUserAgentObject;

public:

	BOOL Initialize(UINT nListenPort, int nInputDeviceId, int nOutputDeviceId, LPCTSTR sFromURI, LPCTSTR sSIPOutBoundProxy, LPCTSTR sSIPProxy, LPCTSTR sLoginId, LPCTSTR sLoginPwd);
	void UnInitialize();
	
	BOOL SetLicenceKey(LPCTSTR sLicenceKey);
	DWORD GetVaxObjectError();

	BOOL Connect(LPCTSTR sToURI, LPCTSTR sRTPIP, UINT nRTPPort);
	BOOL Disconnect();

	BOOL AcceptCall(LPCTSTR sRTPIP, UINT nRTPPort);
	BOOL RejectCall();
	
	BOOL RegisterToProxy(int nExpire);
	BOOL UnRegisterToProxy();

	void DeselectAllVoiceCodec();
	void SelectAllVoiceCodec();
	BOOL SelectVoiceCodec(int nCodecNo);
	BOOL DeselectVoiceCodec(int nCodecNo);

	CString GetMyIP();
	BOOL DigitDTMF(LPCTSTR sDigit, int nDuration);

	BOOL MuteMic(BOOL bMute);
	BOOL MuteSpk(BOOL bMute);
	
	int GetMicVolume();
	BOOL SetMicVolume(int nVolume);
	int GetSpkVolume();
	BOOL SetSpkVolume(int nVolume);

	BOOL EnableMicBoost();
	BOOL DisableMicBoost();
	BOOL IsMicBoostEnable();

	BOOL EnableEchoNoiseCancellation();
	BOOL DisableEchoNoiseCancellation();

	BOOL StartRecording();
	BOOL StopRecording();
	BOOL ResetRecording();
	BOOL SaveRecordingToWaveFile(LPCTSTR sFileName);

	BOOL PlayWaveOpen(LPCTSTR sFileName);
	BOOL PlayWaveSkipTo(int nSeconds);
	int PlayWaveTotalTime();
	BOOL PlayWavePause();
	BOOL PlayWaveStart();
	BOOL PlayWaveStop();
	int PlayWavePosition();

	void EnableDonotDisturb();
	void DisableDonotDisturb();

	virtual void OnFailToUnRegister();
	virtual void OnSuccessToUnRegister();
	
	virtual void OnFailToRegister();
	virtual void OnSuccessToRegister();

	virtual void OnFailToConnect();
	virtual void OnSuccessToConnect(int nTxCodecNo);
	virtual void OnConnecting();

	virtual void OnIncomingCall(LPCTSTR sDisplayName, LPCTSTR sUserName, LPCTSTR sFromURI);
	virtual void OnIncomingCallRingingStart();
	virtual void OnIncomingCallRingingStop();
	
	virtual void OnDisconnectCall();
	
	virtual void OnProvisionalResponse(int nStatusCode, LPCTSTR sReasonPhrase);
	virtual void OnRedirectionResponse(int nStatusCode, LPCTSTR sReasonPhrase, LPCTSTR sContact);
	virtual void OnRequestFailureResponse(int nStatusCode, LPCTSTR sReasonPhrase);
	virtual void OnServerFailureResponse(int nStatusCode, LPCTSTR sReasonPhrase);
	virtual void OnGeneralFailureResponse(int nStatusCode, LPCTSTR sReasonPhrase);
};

#endif // !defined(AFX_VAXSIPUSERAGENTLIB_H__A370F557_2178_4F9E_8B8C_8C2554A94C55__INCLUDED_)
