VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "comctl32.ocx"
Object = "{AE632214-519A-4814-9230-ACB5E21AF5D8}#1.0#0"; "VaxSIPUserAgentOCX.ocx"
Begin VB.Form MainForm 
   Caption         =   "VaxSIPUserAgent Visual Basic Sample code [www.vaxvoip.com]"
   ClientHeight    =   6990
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8880
   BeginProperty Font 
      Name            =   "Verdana"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   ScaleHeight     =   6990
   ScaleWidth      =   8880
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame7 
      Caption         =   "Help"
      Height          =   1815
      Left            =   5640
      TabIndex        =   43
      Top             =   120
      Width           =   3135
      Begin VB.Label Label8 
         Caption         =   "4. Make or receive phone call."
         Height          =   255
         Left            =   120
         TabIndex        =   58
         Top             =   1440
         Width           =   2775
      End
      Begin VB.Label Label7 
         Caption         =   "3. Click ""Online"" button."
         Height          =   255
         Left            =   120
         TabIndex        =   57
         Top             =   1080
         Width           =   2055
      End
      Begin VB.Label Label6 
         Caption         =   "2. Enter SIP Proxy Settings."
         Height          =   255
         Left            =   120
         TabIndex        =   56
         Top             =   720
         Width           =   2415
      End
      Begin VB.Label Label5 
         Caption         =   "1. Get ""SIP Proxy Settings"" from IP-Telephony service provider."
         Height          =   375
         Left            =   120
         TabIndex        =   55
         Top             =   240
         Width           =   2895
      End
   End
   Begin VB.Frame Frame6 
      Caption         =   " Supported Voice Codecs "
      Height          =   1455
      Left            =   5640
      TabIndex        =   42
      Top             =   3600
      Width           =   3135
      Begin VB.CheckBox CheckG711U 
         Caption         =   "G711 U-LAW"
         Height          =   255
         Left            =   120
         TabIndex        =   51
         Top             =   1080
         Value           =   1  'Checked
         Width           =   1455
      End
      Begin VB.CheckBox CheckG711A 
         Caption         =   "G711 A-LAW"
         Height          =   255
         Left            =   120
         TabIndex        =   50
         Top             =   840
         Value           =   1  'Checked
         Width           =   1455
      End
      Begin VB.CheckBox CheckiLBC 
         Caption         =   "iLBC"
         Height          =   255
         Left            =   120
         TabIndex        =   49
         Top             =   600
         Value           =   1  'Checked
         Width           =   855
      End
      Begin VB.CheckBox CheckGSM610 
         Caption         =   "GSM 6.10"
         Height          =   255
         Left            =   120
         TabIndex        =   48
         Top             =   360
         Value           =   1  'Checked
         Width           =   1215
      End
      Begin VAXSIPUSERAGENTOCXLib.VaxSIPUserAgentOCX VaxSIPUserAgentOCX 
         Height          =   855
         Left            =   1800
         TabIndex        =   59
         Top             =   360
         Visible         =   0   'False
         Width           =   1215
         _Version        =   65536
         _ExtentX        =   2143
         _ExtentY        =   1508
         _StockProps     =   0
      End
   End
   Begin VB.Frame Frame5 
      Caption         =   " Other Settings "
      Height          =   1455
      Left            =   5640
      TabIndex        =   41
      Top             =   2040
      Width           =   3135
      Begin VB.CheckBox CheckDisturb 
         Caption         =   "Don't disturb"
         Height          =   255
         Left            =   120
         TabIndex        =   54
         Top             =   1080
         Width           =   1455
      End
      Begin VB.CheckBox CheckMicBoost 
         Caption         =   "Mic Boost"
         Height          =   255
         Left            =   120
         TabIndex        =   53
         Top             =   720
         Width           =   2415
      End
      Begin VB.CheckBox CheckEchoCancel 
         Caption         =   "Echo/Noise Cancellation"
         Height          =   255
         Left            =   120
         TabIndex        =   52
         Top             =   360
         Value           =   1  'Checked
         Width           =   2415
      End
   End
   Begin VB.Frame Frame4 
      Caption         =   "Conversation Recording"
      Height          =   1695
      Left            =   5640
      TabIndex        =   35
      Top             =   5160
      Width           =   3135
      Begin VB.CheckBox ChkStartRecording 
         Caption         =   "Start Recording"
         Height          =   255
         Left            =   120
         TabIndex        =   39
         Top             =   360
         Width           =   1695
      End
      Begin VB.CommandButton BtnResetRecordingBuffer 
         Caption         =   "Reset"
         Height          =   495
         Left            =   2160
         TabIndex        =   38
         Top             =   360
         Width           =   855
      End
      Begin VB.TextBox TxtSaveFileName 
         Height          =   315
         Left            =   120
         TabIndex        =   37
         Top             =   1200
         Width           =   1935
      End
      Begin VB.CommandButton BtnSaveToWaveFile 
         Caption         =   "Save"
         Height          =   495
         Left            =   2160
         TabIndex        =   36
         Top             =   1080
         Width           =   855
      End
      Begin VB.Label Label17 
         Caption         =   "File Name: (.wav)"
         Height          =   255
         Left            =   120
         TabIndex        =   40
         Top             =   960
         Width           =   1695
      End
   End
   Begin VB.Frame Frame8 
      Caption         =   " Volume Settings "
      Height          =   1695
      Left            =   120
      TabIndex        =   28
      Top             =   5160
      Width           =   2535
      Begin VB.CheckBox CheckSpkMute 
         Caption         =   "Mute"
         Height          =   255
         Left            =   1680
         TabIndex        =   30
         Top             =   240
         Width           =   735
      End
      Begin VB.CheckBox CheckMuteMic 
         Caption         =   "Mute"
         Height          =   255
         Left            =   1680
         TabIndex        =   29
         Top             =   960
         Width           =   735
      End
      Begin ComctlLib.Slider SliderSpkVol 
         Height          =   255
         Left            =   240
         TabIndex        =   31
         Top             =   600
         Width           =   2055
         _ExtentX        =   3625
         _ExtentY        =   450
         _Version        =   327682
         TickStyle       =   3
         TickFrequency   =   10
      End
      Begin ComctlLib.Slider SliderMicVol 
         Height          =   255
         Left            =   240
         TabIndex        =   32
         Top             =   1320
         Width           =   2055
         _ExtentX        =   3625
         _ExtentY        =   450
         _Version        =   327682
         TickStyle       =   3
         TickFrequency   =   10
      End
      Begin VB.Label LabelSpeakerVol 
         Caption         =   "Speaker:"
         Height          =   255
         Left            =   120
         TabIndex        =   34
         Top             =   240
         Width           =   855
      End
      Begin VB.Label LabelMicVol 
         Caption         =   "Microphone:"
         Height          =   255
         Left            =   120
         TabIndex        =   33
         Top             =   960
         Width           =   1215
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   " Status Log "
      Height          =   3255
      Left            =   2760
      TabIndex        =   27
      Top             =   3600
      Width           =   2775
      Begin VB.CommandButton BtnClearLog 
         Caption         =   "Clear"
         Height          =   470
         Left            =   1560
         TabIndex        =   47
         Top             =   2640
         Width           =   1095
      End
      Begin VB.ListBox ListStatusLog 
         Height          =   2205
         Left            =   120
         TabIndex        =   46
         Top             =   240
         Width           =   2535
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   " Incoming Call "
      Height          =   1455
      Left            =   2760
      TabIndex        =   26
      Top             =   2040
      Width           =   2775
      Begin VB.CommandButton BtnReject 
         Caption         =   "Reject"
         Height          =   470
         Left            =   1560
         TabIndex        =   45
         Top             =   840
         Width           =   1095
      End
      Begin VB.CommandButton BtnAccept 
         Caption         =   "Accept"
         Height          =   470
         Left            =   120
         TabIndex        =   44
         Top             =   840
         Width           =   1095
      End
      Begin VB.Label LabelIncomingCall 
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fixed Single
         Height          =   495
         Left            =   120
         TabIndex        =   60
         Top             =   240
         Width           =   2535
      End
   End
   Begin VB.CommandButton BtnHangUp 
      Caption         =   "HangUp"
      Height          =   470
      Left            =   1560
      TabIndex        =   25
      Top             =   4560
      Width           =   1095
   End
   Begin VB.CommandButton BtnDial 
      Caption         =   "Dial"
      Height          =   470
      Left            =   240
      TabIndex        =   24
      Top             =   4560
      Width           =   1095
   End
   Begin VB.CommandButton BtnDialPadNo 
      Caption         =   "#"
      Height          =   375
      Left            =   1920
      TabIndex        =   23
      Top             =   4080
      Width           =   735
   End
   Begin VB.CommandButton BtnDialPad0 
      Caption         =   "0"
      Height          =   375
      Left            =   1080
      TabIndex        =   22
      Top             =   4080
      Width           =   735
   End
   Begin VB.CommandButton BtnDialPadStar 
      Caption         =   "*"
      Height          =   375
      Left            =   240
      TabIndex        =   21
      Top             =   4080
      Width           =   735
   End
   Begin VB.CommandButton BtnDialPad9 
      Caption         =   "9"
      Height          =   375
      Left            =   1920
      TabIndex        =   20
      Top             =   3600
      Width           =   735
   End
   Begin VB.CommandButton BtnDialPad8 
      Caption         =   "8"
      Height          =   375
      Left            =   1080
      TabIndex        =   19
      Top             =   3600
      Width           =   735
   End
   Begin VB.CommandButton BtnDialPad7 
      Caption         =   "7"
      Height          =   375
      Left            =   240
      TabIndex        =   18
      Top             =   3600
      Width           =   735
   End
   Begin VB.CommandButton BtnDialPad6 
      Caption         =   "6"
      Height          =   375
      Left            =   1920
      TabIndex        =   17
      Top             =   3120
      Width           =   735
   End
   Begin VB.CommandButton BtnDialPad5 
      Caption         =   "5"
      Height          =   375
      Left            =   1080
      TabIndex        =   16
      Top             =   3120
      Width           =   735
   End
   Begin VB.CommandButton BtnDialPad4 
      Caption         =   "4"
      Height          =   375
      Left            =   240
      TabIndex        =   15
      Top             =   3120
      Width           =   735
   End
   Begin VB.CommandButton BtnDialPad3 
      Caption         =   "3"
      Height          =   375
      Left            =   1920
      TabIndex        =   14
      Top             =   2640
      Width           =   735
   End
   Begin VB.CommandButton BtnDialPad2 
      Caption         =   "2"
      Height          =   375
      Left            =   1080
      TabIndex        =   13
      Top             =   2640
      Width           =   735
   End
   Begin VB.CommandButton BtnDialPad1 
      Caption         =   "1"
      Height          =   375
      Left            =   240
      TabIndex        =   12
      Top             =   2640
      Width           =   735
   End
   Begin VB.TextBox EditPhoneNo 
      Height          =   315
      Left            =   240
      TabIndex        =   11
      Top             =   2160
      Width           =   2415
   End
   Begin VB.Frame Frame1 
      Caption         =   " SIP Proxy Settings "
      Height          =   1815
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   5415
      Begin VB.CommandButton BtnSample 
         Caption         =   "Help"
         Height          =   525
         Left            =   4200
         TabIndex        =   61
         Top             =   1200
         Width           =   1095
      End
      Begin VB.CommandButton BtnOffline 
         Caption         =   "Offline"
         Height          =   405
         Left            =   4200
         TabIndex        =   10
         Top             =   720
         Width           =   1095
      End
      Begin VB.CommandButton BtnOnline 
         Caption         =   "Online"
         Height          =   405
         Left            =   4200
         TabIndex        =   9
         Top             =   240
         Width           =   1095
      End
      Begin VB.TextBox EditOutBoundProxy 
         Height          =   315
         Left            =   2040
         TabIndex        =   8
         Top             =   1320
         Width           =   1935
      End
      Begin VB.TextBox EditSIPProxy 
         Height          =   315
         Left            =   2040
         TabIndex        =   7
         Top             =   480
         Width           =   1935
      End
      Begin VB.TextBox EditLoginPwd 
         Height          =   315
         Left            =   120
         TabIndex        =   6
         Top             =   1320
         Width           =   1575
      End
      Begin VB.TextBox EditLoginId 
         Height          =   315
         Left            =   120
         TabIndex        =   5
         Top             =   480
         Width           =   1575
      End
      Begin VB.Label Label4 
         Caption         =   "Outbound Proxy:"
         Height          =   255
         Left            =   2040
         TabIndex        =   4
         Top             =   1080
         Width           =   1575
      End
      Begin VB.Label Label3 
         Caption         =   "SIP Proxy:"
         Height          =   255
         Left            =   2040
         TabIndex        =   3
         Top             =   240
         Width           =   1095
      End
      Begin VB.Label Label2 
         Caption         =   "Login Pwd:"
         Height          =   255
         Left            =   120
         TabIndex        =   2
         Top             =   1080
         Width           =   1335
      End
      Begin VB.Label Label1 
         Caption         =   "Login Id:"
         Height          =   255
         Left            =   120
         TabIndex        =   1
         Top             =   240
         Width           =   1335
      End
   End
End
Attribute VB_Name = "MainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Sub BtnClearLog_Click()
    ListStatusLog.Clear
End Sub

Private Sub BtnDialPad0_Click()
    Dim Result
    EditPhoneNo = EditPhoneNo + "0"
    Result = VaxSIPUserAgentOCX.DigitDTMF("0", 250)
End Sub

Private Sub BtnDialPad1_Click()
    Dim Result
    EditPhoneNo = EditPhoneNo + "1"
    Result = VaxSIPUserAgentOCX.DigitDTMF("1", 250)
End Sub

Private Sub BtnDialPad2_Click()
    Dim Result
    EditPhoneNo = EditPhoneNo + "2"
    Result = VaxSIPUserAgentOCX.DigitDTMF("2", 250)
End Sub

Private Sub BtnDialPad3_Click()
    Dim Result
    EditPhoneNo = EditPhoneNo + "3"
    Result = VaxSIPUserAgentOCX.DigitDTMF("3", 250)
End Sub

Private Sub BtnDialPad4_Click()
    Dim Result
    EditPhoneNo = EditPhoneNo + "4"
    Result = VaxSIPUserAgentOCX.DigitDTMF("4", 250)
End Sub

Private Sub BtnDialPad5_Click()
    Dim Result
    EditPhoneNo = EditPhoneNo + "5"
    Result = VaxSIPUserAgentOCX.DigitDTMF("5", 250)
End Sub

Private Sub BtnDialPad6_Click()
    Dim Result
    EditPhoneNo = EditPhoneNo + "6"
    Result = VaxSIPUserAgentOCX.DigitDTMF("6", 250)
End Sub

Private Sub BtnDialPad7_Click()
    Dim Result
    EditPhoneNo = EditPhoneNo + "7"
    Result = VaxSIPUserAgentOCX.DigitDTMF("7", 250)
End Sub

Private Sub BtnDialPad8_Click()
    Dim Result
    EditPhoneNo = EditPhoneNo + "8"
    Result = VaxSIPUserAgentOCX.DigitDTMF("8", 250)
End Sub

Private Sub BtnDialPad9_Click()
    Dim Result
    EditPhoneNo = EditPhoneNo + "9"
    Result = VaxSIPUserAgentOCX.DigitDTMF("9", 250)
End Sub

Private Sub BtnDialPadStar_Click()
    Dim Result
    EditPhoneNo = EditPhoneNo + "*"
    Result = VaxSIPUserAgentOCX.DigitDTMF("*", 250)
End Sub

Private Sub BtnDialPadNo_Click()
    Dim Result
    EditPhoneNo = EditPhoneNo + "#"
    Result = VaxSIPUserAgentOCX.DigitDTMF("#", 250)
End Sub

Private Sub BtnSample_Click()
    HelpForm.Show vbModal
End Sub

Private Sub CheckMuteMic_Click()
    Dim Result
    Result = VaxSIPUserAgentOCX.MuteMic(CheckMuteMic.Value)
End Sub

Private Sub CheckSpkMute_Click()
    Dim Result
    Result = VaxSIPUserAgentOCX.MuteSpk(CheckSpkMute.Value)
End Sub


Private Sub SliderMicVol_Click()
    ' SetMicVolume method requires Volume value from 0 to 255 range    '
    ' but the slider range is 0 to 10, so we multiply the slider value '
    ' to 25 to get the required value to pass to SetMicVolume method   '
    
    Dim Result
    Result = VaxSIPUserAgentOCX.SetMicVolume(SliderMicVol.Value * 25)
        
    If Result = False Then
        ErrorMessages
    End If
End Sub

Private Sub SliderSpkVol_Click()

' SetSpkVolume method requires Volume value from 0 to 255 range    '
' but the slider range is 0 to 10, so we multiply the slider value '
' to 25 to get the required value to pass to SetSpkVolume method   '
    
    Dim Result
    Result = VaxSIPUserAgentOCX.SetSpkVolume(SliderSpkVol.Value * 25)
    
    If Result = False Then
        ErrorMessages
    End If
    
End Sub

Private Sub ErrorMessages()

    Dim Error
    Error = VaxSIPUserAgentOCX.GetVaxObjectError
    
    If Error = 10 Then
        MsgBox ("You are not Online, please click the 'Online' button first")
    End If
    
    If Error = 11 Then
        MsgBox ("Cann't open local communication port.")
    End If
    
    If Error = 12 Then
        MsgBox ("License Key is not valid.")
    End If
    
    If Error = 13 Then
        MsgBox ("Fail to initialize VaxVoIP task window.")
    End If
    
    If Error = 14 Then
        MsgBox ("Cann't access Input/Mic device or device is already in use.")
    End If
    
    If Error = 15 Then
        MsgBox ("Cann't access Output/Speaker device or device is already in use.")
    End If
    
    If Error = 16 Then
        MsgBox ("Fail to initialize voice compression manager.")
    End If
    
    If Error = 17 Then
        MsgBox ("Recording media initialization error.")
    End If
    
    If Error = 18 Then
        MsgBox ("Cann't open the wave file.")
    End If
    
    If Error = 19 Then
        MsgBox ("Fail to open voice recording channel.")
    End If
    
    If Error = 20 Then
        MsgBox ("Your sound device does not support mic volume.")
    End If
        
    If Error = 21 Then
        MsgBox ("Your sound device does not support speaker volume.")
    End If
    
    If Error = 22 Then
        MsgBox ("Error to open wave file to play.")
    End If
    
    If Error = 23 Then
        MsgBox ("Provided SIP URI is not valid.")
    End If
    
    If Error = 24 Then
        MsgBox ("Codec is not supported.")
    End If
    
    If Error = 25 Then
        MsgBox ("Error to create SDP (Session Description Protocol) request.")
    End If
    
    If Error = 26 Then
        MsgBox ("Error to create CONNECTION request. Please check the provided SIP URI is valid.")
    End If
    
    If Error = 27 Then
        MsgBox ("Error to create REGISTER request. Please check the provided SIP URI is valid.")
    End If
    
    If Error = 28 Then
        MsgBox ("Error to create UN-REGISTER request. Please check the provided SIP URI is valid.")
    End If
            
    If Error = 29 Then
        MsgBox ("Error to create DISCONNECT request.")
    End If
        
End Sub

Private Sub BtnOnline_Click()
    
    Dim MyIP
    Dim FromURI
    Dim Status
        
    If EditLoginId.Text = "" Then
        MsgBox ("Please enter the SIP proxy Login Id.")
        Exit Sub
    End If
    
    If EditSIPProxy.Text = "" Then
        MsgBox ("Please enter the SIP proxy address or URI.")
        Exit Sub
    End If
    
    VaxSIPUserAgentOCX.SetLicenceKey ("TRIAL-LICENSE-KEY")
    
    MyIP = VaxSIPUserAgentOCX.GetMyIP()
    
    '****** Constructing SIP From URI for IP Telephony *******
    FromURI = EditLoginId.Text + " <sip:" + EditLoginId.Text + "@" + MyIP + ">"
    
    '********************************************************************
    '   Listen Port: default SIP port 5060.
    '     SIP Proxy: SIP Proxy IP or FQDN provided by your service provider.
    ' OutboundProxy: SIP outbound/NAT proxy IP or FQDN provided by your
    '                service provider to use SIP phone behind the NAT.
    '
    '*********************************************************************
    
    Result = VaxSIPUserAgentOCX.Initialize(5060, -1, -1, FromURI, EditOutBoundProxy.Text, EditSIPProxy.Text, EditLoginId.Text, EditLoginPwd.Text)
    
    If Result = False Then
       ErrorMessages
       Exit Sub
    End If
    
    CheckEchoCancel.Value = 1
    CheckGSM610.Value = 1
    CheckiLBC.Value = 1
    CheckG711A.Value = 1
    CheckG711U.Value = 1
      
    Result = VaxSIPUserAgentOCX.RegisterToProxy(5000)
    If Result = False Then
      ErrorMessages
      Exit Sub
    End If
        
    ListStatusLog.AddItem ("Registering to SIP Proxy.")
        
End Sub

Private Sub VaxSIPUserAgentOCX_OnFailToRegister()
    ListStatusLog.AddItem ("Fail to register.")
End Sub

Private Sub VaxSIPUserAgentOCX_OnSuccessToConnect(ByVal TxCodecNo As Long)
    Dim Result
    
    ListStatusLog.AddItem ("Call connected successfully.")
     
    Result = VaxSIPUserAgentOCX.GetSpkVolume()
    SliderSpkVol.Value = Result / 25
    
    Result = VaxSIPUserAgentOCX.GetMicVolume()
    SliderMicVol.Value = Result / 25
     
    Result = VaxSIPUserAgentOCX.IsMicBoostEnable()
    If Result = True Then
      CheckMicBoost.Value = 1
    Else
      CheckMicBoost.Value = 0
    End If
End Sub

Private Sub VaxSIPUserAgentOCX_OnSuccessToRegister()
    ListStatusLog.AddItem ("Registered successfully.")
End Sub

Private Sub BtnOffline_Click()
    VaxSIPUserAgentOCX.UnInitialize
End Sub

Private Sub VaxSIPUserAgentOCX_OnSuccessToUnRegister()
    ListStatusLog.AddItem ("Unregistered successfully.")
End Sub

Private Sub VaxSIPUserAgentOCX_OnFailToUnRegister()
    ListStatusLog.AddItem ("Fail to unregister.")
End Sub

Private Sub BtnDial_Click()
    
    Dim ToURI
    Dim Result
    Dim MyIP
    
    If EditPhoneNo.Text = "" Then
        MsgBox ("Please enter a phone number.")
        Exit Sub
    End If
    
    '*******************************************************
    '       Constructing SIP To URI for IP Telephony:
    '                sip:PhoneNumber@SIP Proxy
    '********************************************************
    
    ToURI = "sip:" + EditPhoneNo.Text + "@" + EditSIPProxy.Text
    
    MyIP = VaxSIPUserAgentOCX.GetMyIP()
    
    Result = VaxSIPUserAgentOCX.Connect(ToURI, MyIP, 7000)
    If Result = False Then
        ErrorMessages
    Else
        ListStatusLog.AddItem ("Dialing....")
    End If
    
End Sub

Private Sub VaxSIPUserAgentOCX_OnConnecting()
    ListStatusLog.AddItem ("Trying to connect.")
End Sub

Private Sub VaxSIPUserAgentOCX_OnFailToConnect()
    ListStatusLog.AddItem ("Fail to connect.")
End Sub

Private Sub VaxSIPUserAgentOCX_OnDisconnectCall()
    ListStatusLog.AddItem ("Hung up by the other party.")
    LabelIncomingCall = ""
End Sub

Private Sub BtnHangUp_Click()
    Dim Result
    
    Result = VaxSIPUserAgentOCX.Disconnect
    If Result = False Then
        ErrorMessages
    End If
    
    LabelIncomingCall = ""
    
End Sub

Private Sub VaxSIPUserAgentOCX_OnIncomingCall(ByVal DisplayName As String, ByVal UserName As String, ByVal FromURI As String)
    
    '*** SIP URI Format:  "DisplayName"<sip:UserName@doamin.com> ****
    LabelIncomingCall = "CALL: " + UserName
    
End Sub

Private Sub VaxSIPUserAgentOCX_OnIncomingCallRingingStart()
    ListStatusLog.AddItem ("Incoming call ringing start.")
End Sub

Private Sub VaxSIPUserAgentOCX_OnIncomingCallRingingStop()
    LabelIncomingCall = ""
    ListStatusLog.AddItem ("Incoming call ringing stop.")
End Sub

Private Sub BtnAccept_Click()
    Dim Result
    
    Dim MyIP
    MyIP = VaxSIPUserAgentOCX.GetMyIP()
    
    Result = VaxSIPUserAgentOCX.AcceptCall(MyIP, 7000)
    If Result = False Then
        ErrorMessages
    End If
    
End Sub

Private Sub BtnReject_Click()
    Dim Result
    Result = VaxSIPUserAgentOCX.RejectCall()
    If Result = False Then
        ErrorMessages
    End If
    
    LabelIncomingCall = ""
    
End Sub

Private Sub BtnResetRecordingBuffer_Click()
    VaxSIPUserAgentOCX.ResetRecording
End Sub

Private Sub BtnSaveToWaveFile_Click()
    Dim Result
    Result = VaxSIPUserAgentOCX.SaveRecordingToWaveFile(TxtSaveFileName.Text)
    If Result = False Then
        ErrorMessages
        Exit Sub
    End If
   
    MsgBox ("Saved Successfully")
End Sub

Private Sub ChkStartRecording_Click()
    If ChkStartRecording.Value = 1 Then
        VaxSIPUserAgentOCX.StartRecording
    Else
        VaxSIPUserAgentOCX.StopRecording
    End If
End Sub

Private Sub CheckEchoCancel_Click()
    If CheckEchoCancel.Value = 1 Then
        VaxSIPUserAgentOCX.EnableEchoNoiseCancellation
    Else
        VaxSIPUserAgentOCX.DisableEchoNoiseCancellation
    End If
End Sub

Private Sub CheckMicBoost_Click()
    If CheckMicBoost.Value = 1 Then
        VaxSIPUserAgentOCX.EnableMicBoost
    Else
        VaxSIPUserAgentOCX.DisableMicBoost
    End If
End Sub

Private Sub CheckDisturb_Click()
    If CheckDisturb.Value = 1 Then
        VaxSIPUserAgentOCX.EnableDonotDisturb
    Else
        VaxSIPUserAgentOCX.DisableDonotDisturb
    End If
End Sub

Private Sub CheckGSM610_Click()
    
    '****Codec No 0 represents GSM 6.10 *****
    
    If CheckGSM610.Value = 1 Then
        VaxSIPUserAgentOCX.SelectVoiceCodec (0)
    Else
        VaxSIPUserAgentOCX.DeselectVoiceCodec (0)
    End If
End Sub

Private Sub CheckiLBC_Click()
    
    '****Codec No 1 represents iLBC *****
    
    If CheckiLBC.Value = 1 Then
        VaxSIPUserAgentOCX.SelectVoiceCodec (1)
    Else
        VaxSIPUserAgentOCX.DeselectVoiceCodec (1)
    End If
End Sub

Private Sub CheckG711A_Click()
    
    '****Codec No 2 represents G711 A-LAW *****
    
    If CheckG711A.Value = 1 Then
        VaxSIPUserAgentOCX.SelectVoiceCodec (2)
    Else
        VaxSIPUserAgentOCX.DeselectVoiceCodec (2)
    End If
End Sub

Private Sub CheckG711U_Click()
    
    '****Codec No 3 represents G711 U-LAW *****
    
    If CheckG711U.Value = 1 Then
        VaxSIPUserAgentOCX.SelectVoiceCodec (3)
    Else
        VaxSIPUserAgentOCX.DeselectVoiceCodec (3)
    End If
End Sub

Private Sub VaxSIPUserAgentOCX_OnProvisionalResponse(ByVal StatusCode As Long, ByVal ReasonPhrase As String)
    ListStatusLog.AddItem ("Response: " + ReasonPhrase)
End Sub

Private Sub VaxSIPUserAgentOCX_OnRedirectionResponse(ByVal StatusCode As Long, ByVal ReasonPhrase As String, ByVal Contact As String)
    ListStatusLog.AddItem ("Response: " + ReasonPhrase)
End Sub

Private Sub VaxSIPUserAgentOCX_OnRequestFailureResponse(ByVal StatusCode As Long, ByVal ReasonPhrase As String)
    ListStatusLog.AddItem ("Response: " + ReasonPhrase)
End Sub

Private Sub VaxSIPUserAgentOCX_OnServerFailureResponse(ByVal StatusCode As Long, ByVal ReasonPhrase As String)
    ListStatusLog.AddItem ("Response: " + ReasonPhrase)
End Sub

Private Sub VaxSIPUserAgentOCX_OnGeneralFailureResponse(ByVal StatusCode As Long, ByVal ReasonPhrase As String)
    ListStatusLog.AddItem ("Response: " + ReasonPhrase)
End Sub

