unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, OleCtrls, HelpUnit, VAXSIPUSERAGENTOCXLib_TLB;

type
   TMainForm = class(TForm)
    GroupBox1: TGroupBox;
    EditLoginId: TEdit;
    EditLoginPwd: TEdit;
    EditSIPProxy: TEdit;
    EditOutboundProxy: TEdit;
    
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    BtnInit: TButton;
    BtnUnInit: TButton;
    BtnHelp: TButton;
    EditPhoneNo: TEdit;
    BtnDial1: TButton;
    BtnDial2: TButton;
    BtnDial3: TButton;
    BtnDial4: TButton;
    BtnDial5: TButton;
    BtnDial6: TButton;
    BtnDial7: TButton;
    BtnDial8: TButton;
    BtnDial9: TButton;
    BtnDialStar: TButton;
    BtnDial0: TButton;
    BtnDialNo: TButton;
    GroupBox2: TGroupBox;
    EditIncomeCall: TEdit;
    BtnAccept: TButton;
    BtnDial: TButton;
    BtnHangUp: TButton;
    GroupBoxVolume: TGroupBox;
    LabelSpeaker: TLabel;
    Label5: TLabel;
    TrackBarSpkVol: TTrackBar;
    CheckBoxSpkMute: TCheckBox;
    GroupBoxLine: TGroupBox;
    CheckBoxMuteMic: TCheckBox;
    TrackBarMicVol: TTrackBar;
    GroupBox3: TGroupBox;
    BtnReject: TButton;
    ListStatusLog: TListBox;
    BtnClear: TButton;
    GroupBox4: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    GroupBox5: TGroupBox;
    GroupBox6: TGroupBox;
    GroupBox7: TGroupBox;
    Label10: TLabel;
    ChkBoxStartRecording: TCheckBox;
    BtnResetBuffer: TButton;
    BtnSave: TButton;
    EditFileName: TEdit;
    CheckEchoCancel: TCheckBox;
    CheckMicBoost: TCheckBox;
    CheckDonotDisturb: TCheckBox;
    CheckGSM610: TCheckBox;
    CheckiLBC: TCheckBox;
    CheckG711A: TCheckBox;
    CheckG711U: TCheckBox;
    VaxSIPUserAgentOCX: TVaxSIPUserAgentOCX;
    procedure ErrorMessages();
    procedure TrackBarSpkVolChange(Sender: TObject);
    procedure TrackBarMicVolChange(Sender: TObject);
    procedure BtnInitClick(Sender: TObject);
    procedure BtnUnInitClick(Sender: TObject);
    procedure BtnDial1Click(Sender: TObject);
    procedure BtnDial2Click(Sender: TObject);
    procedure BtnDial3Click(Sender: TObject);
    procedure BtnDial4Click(Sender: TObject);
    procedure BtnDial5Click(Sender: TObject);
    procedure BtnDial6Click(Sender: TObject);
    procedure BtnDial7Click(Sender: TObject);
    procedure BtnDial8Click(Sender: TObject);
    procedure BtnDial9Click(Sender: TObject);
    procedure BtnDialStarClick(Sender: TObject);
    procedure BtnDial0Click(Sender: TObject);
    procedure BtnDialNoClick(Sender: TObject);
    procedure BtnDialClick(Sender: TObject);
    procedure BtnHangUpClick(Sender: TObject);
    procedure BtnHelpClick(Sender: TObject);
    procedure BtnAcceptClick(Sender: TObject);
    procedure BtnRejectClick(Sender: TObject);
    procedure BtnClearClick(Sender: TObject);
    procedure BtnSaveClick(Sender: TObject);
    procedure ChkBoxStartRecordingClick(Sender: TObject);
    procedure BtnResetBufferClick(Sender: TObject);
    procedure CheckBoxSpkMuteClick(Sender: TObject);
    procedure CheckBoxMuteMicClick(Sender: TObject);
    procedure VaxSIPUserAgentOCXConnecting(Sender: TObject);
    procedure VaxSIPUserAgentOCXDisconnectCall(Sender: TObject);
    procedure VaxSIPUserAgentOCXFailToConnect(Sender: TObject);
    procedure VaxSIPUserAgentOCXFailToRegister(Sender: TObject);
    procedure VaxSIPUserAgentOCXFailToUnRegister(Sender: TObject);
    procedure VaxSIPUserAgentOCXGeneralFailureResponse(Sender: TObject;
      StatusCode: Integer; const ReasonPhrase: WideString);
    procedure VaxSIPUserAgentOCXProvisionalResponse(Sender: TObject;
      StatusCode: Integer; const ReasonPhrase: WideString);
    procedure VaxSIPUserAgentOCXRedirectionResponse(Sender: TObject;
      StatusCode: Integer; const ReasonPhrase, Contact: WideString);
    procedure VaxSIPUserAgentOCXRequestFailureResponse(Sender: TObject;
      StatusCode: Integer; const ReasonPhrase: WideString);
    procedure VaxSIPUserAgentOCXServerFailureResponse(Sender: TObject;
      StatusCode: Integer; const ReasonPhrase: WideString);
    procedure VaxSIPUserAgentOCXSuccessToUnRegister(Sender: TObject);
    procedure VaxSIPUserAgentOCXIncomingCall(Sender: TObject;
      const DisplayName, UserName, FromURI: WideString);
    procedure VaxSIPUserAgentOCXIncomingCallRingingStart(Sender: TObject);
    procedure VaxSIPUserAgentOCXIncomingCallRingingStop(Sender: TObject);
    procedure CheckEchoCancelClick(Sender: TObject);
    procedure CheckMicBoostClick(Sender: TObject);
    procedure CheckDonotDisturbClick(Sender: TObject);
    procedure CheckGSM610Click(Sender: TObject);
    procedure CheckiLBCClick(Sender: TObject);
    procedure CheckG711AClick(Sender: TObject);
    procedure CheckG711UClick(Sender: TObject);
    procedure VaxSIPUserAgentOCXSuccessToConnect(Sender: TObject;
      TxCodecNo: Integer);
    procedure VaxSIPUserAgentOCXSuccessToRegister(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.ErrorMessages();
var
  ErrorCode : DWORD;
begin

  ErrorCode :=  VaxSIPUserAgentOCX.GetVaxObjectError();

  case ErrorCode of
     10: application.MessageBox('You are not Online, please click the ''Online'' button first.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     11: application.MessageBox('Cann''t open local communication port.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     12: application.MessageBox('License Key is not valid.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     13: application.MessageBox('Fail to initialize VaxVoIP task window.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     14: application.MessageBox('Cann''t access Input/Mic device or device is already in use.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     15: application.MessageBox('Cann''t access Output/Speaker device or device is already in use.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     16: application.MessageBox('Fail to initialize voice compression manager.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     17: application.MessageBox('Recording media initialization error.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     18: application.MessageBox('Cann''t open the wave file.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     19: application.MessageBox('Fail to open voice recording channel.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     20: application.MessageBox('Your sound device does not support mic volume.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     21: application.MessageBox('Your sound device does not support speaker volume.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     22: application.MessageBox('Error to open wave file to play.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     23: application.MessageBox('Provided SIP URI is not valid.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     24: application.MessageBox('Codec is not supported.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     25: application.MessageBox('Error to create SDP (Session Description Protocol) request.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     26: application.MessageBox('Error to create CONNECTION request. Please check the provided SIP URI is valid.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     27: application.MessageBox('Error to create REGISTER request. Please check the provided SIP URI is valid.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     28: application.MessageBox('Error to create UN-REGISTER request. Please check the provided SIP URI is valid.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     29: application.MessageBox('Error to create DISCONNECT request.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
     
   end;
end;

procedure TMainForm.TrackBarSpkVolChange(Sender: TObject);
begin
    {***************************************************************
     SetSpkVolume method requires Volume value from 0 to 255 range
     but the slider range is 0 to 10, so we multiply the slider value
     to 25 to get the required value to pass to SetSpkVolume method

	For more detail, please see the method details document
   *****************************************************************}

   VaxSIPUserAgentOCX.SetSpkVolume(TrackBarSpkVol.Position * 25);

end;

procedure TMainForm.TrackBarMicVolChange(Sender: TObject);
begin
     {***************************************************************
     SetMicVolume method requires Volume value from 0 to 255 range    
     but the slider range is 0 to 10, so we multiply the slider value
     to 25 to get the required value to pass to SetMicVolume method

         For more detail, please see the method details document
   *****************************************************************}

   VaxSIPUserAgentOCX.SetMicVolume(TrackBarMicVol.Position * 25);
end;

procedure TMainForm.BtnInitClick(Sender: TObject);
var
MyIP : string;
FromURI : string;
Result : bool;
begin

   If EditLoginId.Text = '' Then
   begin
        application.MessageBox('Please enter the SIP proxy Login Id.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
        exit;
   end;

   If EditSIPProxy.Text = '' Then
   Begin
        application.MessageBox('Please enter the SIP proxy address or URI.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
        exit;
   end;

   VaxSIPUserAgentOCX.SetLicenceKey('TRIAL-LICENSE-KEY');

   MyIP := VaxSIPUserAgentOCX.GetMyIP();

   {****** Constructing SIP From URI for IP Telephony *******}
   FromURI := EditLoginId.Text + ' <sip:' + EditLoginId.Text + '@' + MyIP + '>';

   {********************************************************************
      Listen Port: default SIP port 5060.
        SIP Proxy: SIP Proxy IP or FQDN provided by your service provider.
    OutboundProxy: SIP outbound/NAT proxy IP or FQDN provided by your
                   service provider to use SIP phone behind the NAT.

   *********************************************************************}

   Result := VaxSIPUserAgentOCX.Initialize(5060, -1, -1, FromURI, EditOutBoundProxy.Text, EditSIPProxy.Text, EditLoginId.Text, EditLoginPwd.Text);
   If Result = False Then
   begin
       ErrorMessages();
       exit;
   end;

   CheckEchoCancel.Checked := True;
   CheckGSM610.Checked     := True;
   CheckiLBC.Checked       := True;
   CheckG711A.Checked      := True;
   CheckG711U.Checked      := True;

   Result := VaxSIPUserAgentOCX.RegisterToProxy(5000);
   If Result = False Then
   begin
     ErrorMessages();
     exit;
   end;

   ListStatusLog.Items.Add('Registering to SIP Proxy.');

end;

procedure TMainForm.BtnUnInitClick(Sender: TObject);
begin
   VaxSIPUserAgentOCX.UnInitialize();
end;

procedure TMainForm.BtnDial1Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '1';
  VaxSIPUserAgentOCX.DigitDTMF('1', 250);
end;

procedure TMainForm.BtnDial2Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '2';
  VaxSIPUserAgentOCX.DigitDTMF('2', 250);
end;

procedure TMainForm.BtnDial3Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '3';
  VaxSIPUserAgentOCX.DigitDTMF('3', 250);
end;

procedure TMainForm.BtnDial4Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '4';
  VaxSIPUserAgentOCX.DigitDTMF('4', 250);
end;

procedure TMainForm.BtnDial5Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '5';
  VaxSIPUserAgentOCX.DigitDTMF('5', 250);
end;

procedure TMainForm.BtnDial6Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '6';
  VaxSIPUserAgentOCX.DigitDTMF('6', 250);
end;

procedure TMainForm.BtnDial7Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '7';
  VaxSIPUserAgentOCX.DigitDTMF('7', 250);
end;

procedure TMainForm.BtnDial8Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '8';
  VaxSIPUserAgentOCX.DigitDTMF('8', 250);
end;

procedure TMainForm.BtnDial9Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '9';
  VaxSIPUserAgentOCX.DigitDTMF('9', 250);
end;

procedure TMainForm.BtnDialStarClick(Sender: TObject);
begin
  VaxSIPUserAgentOCX.DigitDTMF('*', 250);
end;

procedure TMainForm.BtnDial0Click(Sender: TObject);
begin
  EditPhoneNo.Text := EditPhoneNo.Text + '0';
  VaxSIPUserAgentOCX.DigitDTMF('0', 250);
end;

procedure TMainForm.BtnDialNoClick(Sender: TObject);
begin
  VaxSIPUserAgentOCX.DigitDTMF('#', 250);
end;

procedure TMainForm.BtnDialClick(Sender: TObject);
var
ToURI  : string;
MyIP   : string;
Result : bool;
begin

  If EditPhoneNo.Text = '' Then
  Begin
    application.MessageBox('Please enter a phone number.', 'VaxVoIP SDK', MB_ICONEXCLAMATION);
    Exit;
  End;

  {*******************************************************
         Constructing SIP To URI for IP Telephony:
                  sip:PhoneNumber@SIP Proxy
  ********************************************************}

  ToURI := 'sip:' + EditPhoneNo.Text + '@' + EditSIPProxy.Text;

  MyIP := VaxSIPUserAgentOCX.GetMyIP();

  Result := VaxSIPUserAgentOCX.Connect(ToURI, MyIP, 7000);
  If Result = False Then
      ErrorMessages()
  Else
      ListStatusLog.Items.Add('Dialing....');
end;

procedure TMainForm.BtnHangUpClick(Sender: TObject);
var
Result : bool;
begin

   Result := VaxSIPUserAgentOCX.Disconnect();
   If Result = False Then
       ErrorMessages();

   EditIncomeCall.Text := '';

end;

procedure TMainForm.BtnHelpClick(Sender: TObject);
var
 HelpForm : THelpForm;
begin
  HelpForm := THelpForm.Create(self);
  HelpForm.ShowModal;
  HelpForm.Free;
end;

procedure TMainForm.BtnAcceptClick(Sender: TObject);
var
Result : bool;
MyIP   : string;
begin
  MyIP := VaxSIPUserAgentOCX.GetMyIP();
  Result := VaxSIPUserAgentOCX.AcceptCall(MyIP, 7000);
  If Result = False Then
      ErrorMessages();
end;

procedure TMainForm.BtnRejectClick(Sender: TObject);
var
Result : bool;
begin
  Result := VaxSIPUserAgentOCX.RejectCall();
  If Result = False Then
      ErrorMessages();

  EditIncomeCall.Text := '';
end;

procedure TMainForm.BtnClearClick(Sender: TObject);
begin
  ListStatusLog.Items.Clear();
end;

procedure TMainForm.BtnSaveClick(Sender: TObject);
begin

  if VaxSIPUserAgentOCX.SaveRecordingToWaveFile(EditFileName.Text) = False then
    ErrorMessages()
  else
    application.MessageBox('Saved Successfully', 'VaxVoIP SDK', MB_ICONEXCLAMATION);

end;

procedure TMainForm.ChkBoxStartRecordingClick(Sender: TObject);
begin
  if ChkBoxStartRecording.Checked = True then
    VaxSIPUserAgentOCX.StartRecording
  else
    VaxSIPUserAgentOCX.StopRecording
end;

procedure TMainForm.BtnResetBufferClick(Sender: TObject);
begin
  VaxSIPUserAgentOCX.ResetRecording();
end;

procedure TMainForm.CheckBoxSpkMuteClick(Sender: TObject);
begin
  VaxSIPUserAgentOCX.MuteSpk(CheckBoxSpkMute.Checked);
end;

procedure TMainForm.CheckBoxMuteMicClick(Sender: TObject);
begin
  VaxSIPUserAgentOCX.MuteMic(CheckBoxMuteMic.Checked);
end;

procedure TMainForm.VaxSIPUserAgentOCXConnecting(Sender: TObject);
begin
  ListStatusLog.Items.Add('Trying to connect.');
end;

procedure TMainForm.VaxSIPUserAgentOCXDisconnectCall(Sender: TObject);
begin
  ListStatusLog.Items.Add('Hung up by the other party.');
  EditIncomeCall.Text := '';
end;

procedure TMainForm.VaxSIPUserAgentOCXFailToConnect(Sender: TObject);
begin
  ListStatusLog.Items.Add('Fail to connect.');
end;

procedure TMainForm.VaxSIPUserAgentOCXFailToRegister(Sender: TObject);
begin
  ListStatusLog.Items.Add('Fail to register.');
end;

procedure TMainForm.VaxSIPUserAgentOCXFailToUnRegister(Sender: TObject);
begin
 ListStatusLog.Items.Add('Fail to un-register.');
end;

procedure TMainForm.VaxSIPUserAgentOCXGeneralFailureResponse(
  Sender: TObject; StatusCode: Integer; const ReasonPhrase: WideString);
begin
  ListStatusLog.Items.Add('Response: ' + ReasonPhrase);
end;

procedure TMainForm.VaxSIPUserAgentOCXProvisionalResponse(Sender: TObject;
  StatusCode: Integer; const ReasonPhrase: WideString);
begin
  ListStatusLog.Items.Add('Response: ' + ReasonPhrase);
end;

procedure TMainForm.VaxSIPUserAgentOCXRedirectionResponse(Sender: TObject;
  StatusCode: Integer; const ReasonPhrase, Contact: WideString);
begin
  ListStatusLog.Items.Add('Response: ' + ReasonPhrase);
end;

procedure TMainForm.VaxSIPUserAgentOCXRequestFailureResponse(
  Sender: TObject; StatusCode: Integer; const ReasonPhrase: WideString);
begin
  ListStatusLog.Items.Add('Response: ' + ReasonPhrase);
end;

procedure TMainForm.VaxSIPUserAgentOCXServerFailureResponse(
  Sender: TObject; StatusCode: Integer; const ReasonPhrase: WideString);
begin
  ListStatusLog.Items.Add('Response: ' + ReasonPhrase);
end;


procedure TMainForm.VaxSIPUserAgentOCXSuccessToUnRegister(Sender: TObject);
begin
  ListStatusLog.Items.Add('Unregistered successfully.');
end;

procedure TMainForm.VaxSIPUserAgentOCXIncomingCall(Sender: TObject;
  const DisplayName, UserName, FromURI: WideString);
begin

  {*** SIP URI Format:  "DisplayName"<sip:UserName@doamin.com> ****}
  EditIncomeCall.Text := 'CALL: ' + UserName;

end;

procedure TMainForm.VaxSIPUserAgentOCXIncomingCallRingingStart(
  Sender: TObject);
begin
  ListStatusLog.Items.Add('Incoming call ringing start.');
end;

procedure TMainForm.VaxSIPUserAgentOCXIncomingCallRingingStop(
  Sender: TObject);
begin
  EditIncomeCall.Text := '';
  ListStatusLog.Items.Add('Incoming call ringing stop.');
end;

procedure TMainForm.CheckEchoCancelClick(Sender: TObject);
begin

  If CheckEchoCancel.Checked = True Then
    VaxSIPUserAgentOCX.EnableEchoNoiseCancellation()
  Else
    VaxSIPUserAgentOCX.DisableEchoNoiseCancellation();
  
end;

procedure TMainForm.CheckMicBoostClick(Sender: TObject);
begin
  If CheckMicBoost.Checked = True Then
    VaxSIPUserAgentOCX.EnableMicBoost()
  Else
    VaxSIPUserAgentOCX.DisableMicBoost();
end;

procedure TMainForm.CheckDonotDisturbClick(Sender: TObject);
begin
   If CheckDonotDisturb.Checked = True Then
     VaxSIPUserAgentOCX.EnableDonotDisturb()
   Else
     VaxSIPUserAgentOCX.DisableDonotDisturb();
end;

procedure TMainForm.CheckGSM610Click(Sender: TObject);
begin
  {****Codec No 0 represents GSM 6.10 *****}

  If CheckGSM610.Checked = True Then
      VaxSIPUserAgentOCX.SelectVoiceCodec(0)
  Else
      VaxSIPUserAgentOCX.DeselectVoiceCodec(0);
end;

procedure TMainForm.CheckiLBCClick(Sender: TObject);
begin
  {****Codec No 1 represents iLBC *****}

  If CheckiLBC.Checked = True Then
      VaxSIPUserAgentOCX.SelectVoiceCodec(1)
  Else
      VaxSIPUserAgentOCX.DeselectVoiceCodec(1);
end;

procedure TMainForm.CheckG711AClick(Sender: TObject);
begin
{****Codec No 2 represents iLBC *****}

  If CheckG711A.Checked = True Then
      VaxSIPUserAgentOCX.SelectVoiceCodec(2)
  Else
      VaxSIPUserAgentOCX.DeselectVoiceCodec(2);
end;

procedure TMainForm.CheckG711UClick(Sender: TObject);
begin
{****Codec No 3 represents iLBC *****}

  If CheckG711U.Checked = True Then
      VaxSIPUserAgentOCX.SelectVoiceCodec(3)
  Else
      VaxSIPUserAgentOCX.DeselectVoiceCodec(3);
end;

procedure TMainForm.VaxSIPUserAgentOCXSuccessToConnect(Sender: TObject; TxCodecNo: Integer);
var
Vol : Integer;
Result : bool;
begin
  ListStatusLog.Items.Add('Call connected successfully.');

  Vol := VaxSIPUserAgentOCX.GetSpkVolume();
  TrackBarSpkVol.Position := Vol div 25;

  Vol := VaxSIPUserAgentOCX.GetMicVolume();
  TrackBarMicVol.Position := Vol div 25;

  Result := VaxSIPUserAgentOCX.IsMicBoostEnable();
  If Result = True Then
    CheckMicBoost.Checked := True
  Else
    CheckMicBoost.Checked := False;
end;

procedure TMainForm.VaxSIPUserAgentOCXSuccessToRegister(Sender: TObject);
begin
  ListStatusLog.Items.Add('Registered successfully.');
end;

end.
