package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Quarterly Orders<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class Quarterly_OrdersBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected String CustomerID;
    protected String CompanyName;
    protected String City;
    protected String Country;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected Quarterly_OrdersBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public Quarterly_OrdersBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public Quarterly_OrdersBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        CustomerID = rs.getString("CustomerID");
        CompanyName = rs.getString("CompanyName");
        City = rs.getString("City");
        Country = rs.getString("Country");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for CustomerID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCustomerID() {
        return CustomerID;
    }

    /**
     * Setter for CustomerID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCustomerID(String value) {
        this.CustomerID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Quarterly_OrdersBase's by querying table field CustomerID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCustomerID(
        int maxResults) throws SQLException {
        return getResultSetWithCustomerIDValueOf(cs, getCustomerID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Quarterly_OrdersBase's by querying table field CustomerID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCustomerIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Quarterly_OrdersBase_CustomerID");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Quarterly_OrdersBase's by querying table field CustomerID
     * for equality with the same CustomerID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCustomerID(int maxResults)
        throws SQLException {
        return getLinkedListWithCustomerIDValueOf(cs, getCustomerID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Quarterly_OrdersBase's by querying table field CustomerID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCustomerIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCustomerIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Quarterly_OrdersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Quarterly_OrdersBase's by querying table field CustomerID
     * for equality with the same CustomerID as this instance.
     */
    public Iterator getIteratorWithSameValueOfCustomerID(int maxResults)
        throws SQLException {
        return getIteratorWithCustomerIDValueOf(cs, getCustomerID(), maxResults);
    }

    /**
     * Gets an Iterator of Quarterly_OrdersBase's by querying table field CustomerID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCustomerIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCustomerIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for CompanyName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCompanyName() {
        return CompanyName;
    }

    /**
     * Setter for CompanyName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCompanyName(String value) {
        this.CompanyName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Quarterly_OrdersBase's by querying table field CompanyName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCompanyName(
        int maxResults) throws SQLException {
        return getResultSetWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Quarterly_OrdersBase's by querying table field CompanyName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Quarterly_OrdersBase_CompanyName");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Quarterly_OrdersBase's by querying table field CompanyName
     * for equality with the same CompanyName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCompanyName(int maxResults)
        throws SQLException {
        return getLinkedListWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Quarterly_OrdersBase's by querying table field CompanyName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCompanyNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Quarterly_OrdersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Quarterly_OrdersBase's by querying table field CompanyName
     * for equality with the same CompanyName as this instance.
     */
    public Iterator getIteratorWithSameValueOfCompanyName(int maxResults)
        throws SQLException {
        return getIteratorWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets an Iterator of Quarterly_OrdersBase's by querying table field CompanyName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCompanyNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for City.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCity() {
        return City;
    }

    /**
     * Setter for City.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCity(String value) {
        this.City = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Quarterly_OrdersBase's by querying table field City
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getResultSetWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Quarterly_OrdersBase's by querying table field City
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCityValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Quarterly_OrdersBase_City");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Quarterly_OrdersBase's by querying table field City
     * for equality with the same City as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getLinkedListWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets a LinkedList of Quarterly_OrdersBase's by querying table field City
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCityValueOf(cs, value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Quarterly_OrdersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Quarterly_OrdersBase's by querying table field City
     * for equality with the same City as this instance.
     */
    public Iterator getIteratorWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getIteratorWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets an Iterator of Quarterly_OrdersBase's by querying table field City
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithCityValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for Country.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCountry() {
        return Country;
    }

    /**
     * Setter for Country.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCountry(String value) {
        this.Country = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Quarterly_OrdersBase's by querying table field Country
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getResultSetWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Quarterly_OrdersBase's by querying table field Country
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Quarterly_OrdersBase_Country");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Quarterly_OrdersBase's by querying table field Country
     * for equality with the same Country as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getLinkedListWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets a LinkedList of Quarterly_OrdersBase's by querying table field Country
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCountryValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Quarterly_OrdersBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Quarterly_OrdersBase's by querying table field Country
     * for equality with the same Country as this instance.
     */
    public Iterator getIteratorWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getIteratorWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets an Iterator of Quarterly_OrdersBase's by querying table field Country
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCountryValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithCountryValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        try {
            cc = cs.allocCS("INSERT_Quarterly_OrdersBase");

            cc.setString(1, getCustomerID());

            cc.setString(2, getCompanyName());

            cc.setString(3, getCity());

            cc.setString(4, getCountry());

            cc.executeUpdate();

            isDirty = false;
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "CustomerID:" + getCustomerID());

        System.out.println(prefix + "CompanyName:" + getCompanyName());

        System.out.println(prefix + "City:" + getCity());

        System.out.println(prefix + "Country:" + getCountry());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(CustomerID);
        sb.append(",");
        sb.append(CompanyName);
        sb.append(",");
        sb.append(City);
        sb.append(",");
        sb.append(Country);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
