package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Order Details<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class Order_DetailsBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected int OrderID;
    protected int old_OrderID; // Old value of the key is kept too
    protected int ProductID;
    protected int old_ProductID; // Old value of the key is kept too
    protected double UnitPrice;
    protected short Quantity;
    protected float Discount;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected Order_DetailsBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public Order_DetailsBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Get from primary key(s), queries the database
     */
    public Order_DetailsBase(CS cs, int OrderID, int ProductID)
        throws SQLException {
        this.cs = cs;

        CallableStatement cc = null;
        ResultSet rs = null;

        try {
            cc = cs.allocCS("SELECT_Order_DetailsBase");

            cc.setInt(1, OrderID);

            cc.setInt(2, ProductID);

            rs = cc.executeQuery();
            rs.next();
            setFromRs(rs);
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public Order_DetailsBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        OrderID = old_OrderID = rs.getInt("OrderID");
        ProductID = old_ProductID = rs.getInt("ProductID");
        UnitPrice = rs.getDouble("UnitPrice");
        Quantity = rs.getShort("Quantity");
        Discount = rs.getFloat("Discount");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for OrderID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public int getOrderID() {
        return OrderID;
    }

    /**
     * Setter for OrderID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setOrderID(int value) {
        this.OrderID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Order_DetailsBase's by querying table field OrderID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getResultSetWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Order_DetailsBase's by querying table field OrderID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithOrderIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Order_DetailsBase_OrderID");
        cc.setMaxRows(maxResults);

        try {
            cc.setInt(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Order_DetailsBase's by querying table field OrderID
     * for equality with the same OrderID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getLinkedListWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets a LinkedList of Order_DetailsBase's by querying table field OrderID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithOrderIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithOrderIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Order_DetailsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Order_DetailsBase's by querying table field OrderID
     * for equality with the same OrderID as this instance.
     */
    public Iterator getIteratorWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getIteratorWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets an Iterator of Order_DetailsBase's by querying table field OrderID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithOrderIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithOrderIDValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for ProductID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public int getProductID() {
        return ProductID;
    }

    /**
     * Setter for ProductID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setProductID(int value) {
        this.ProductID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Order_DetailsBase's by querying table field ProductID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfProductID(
        int maxResults) throws SQLException {
        return getResultSetWithProductIDValueOf(cs, getProductID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Order_DetailsBase's by querying table field ProductID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithProductIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Order_DetailsBase_ProductID");
        cc.setMaxRows(maxResults);

        try {
            cc.setInt(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Order_DetailsBase's by querying table field ProductID
     * for equality with the same ProductID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfProductID(int maxResults)
        throws SQLException {
        return getLinkedListWithProductIDValueOf(cs, getProductID(), maxResults);
    }

    /**
     * Gets a LinkedList of Order_DetailsBase's by querying table field ProductID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithProductIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithProductIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Order_DetailsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Order_DetailsBase's by querying table field ProductID
     * for equality with the same ProductID as this instance.
     */
    public Iterator getIteratorWithSameValueOfProductID(int maxResults)
        throws SQLException {
        return getIteratorWithProductIDValueOf(cs, getProductID(), maxResults);
    }

    /**
     * Gets an Iterator of Order_DetailsBase's by querying table field ProductID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithProductIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithProductIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for UnitPrice.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public double getUnitPrice() {
        return UnitPrice;
    }

    /**
     * Setter for UnitPrice.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setUnitPrice(double value) {
        this.UnitPrice = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Order_DetailsBase's by querying table field UnitPrice
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfUnitPrice(
        int maxResults) throws SQLException {
        return getResultSetWithUnitPriceValueOf(cs, getUnitPrice(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Order_DetailsBase's by querying table field UnitPrice
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithUnitPriceValueOf(CS cs,
        double value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Order_DetailsBase_UnitPrice");
        cc.setMaxRows(maxResults);

        try {
            cc.setDouble(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Order_DetailsBase's by querying table field UnitPrice
     * for equality with the same UnitPrice as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfUnitPrice(int maxResults)
        throws SQLException {
        return getLinkedListWithUnitPriceValueOf(cs, getUnitPrice(), maxResults);
    }

    /**
     * Gets a LinkedList of Order_DetailsBase's by querying table field UnitPrice
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithUnitPriceValueOf(CS cs,
        double value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithUnitPriceValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Order_DetailsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Order_DetailsBase's by querying table field UnitPrice
     * for equality with the same UnitPrice as this instance.
     */
    public Iterator getIteratorWithSameValueOfUnitPrice(int maxResults)
        throws SQLException {
        return getIteratorWithUnitPriceValueOf(cs, getUnitPrice(), maxResults);
    }

    /**
     * Gets an Iterator of Order_DetailsBase's by querying table field UnitPrice
     * for equality with the "value".
     */
    public static Iterator getIteratorWithUnitPriceValueOf(CS cs, double value,
        int maxResults) throws SQLException {
        return getLinkedListWithUnitPriceValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for Quantity.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public short getQuantity() {
        return Quantity;
    }

    /**
     * Setter for Quantity.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setQuantity(short value) {
        this.Quantity = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Order_DetailsBase's by querying table field Quantity
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfQuantity(int maxResults)
        throws SQLException {
        return getResultSetWithQuantityValueOf(cs, getQuantity(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Order_DetailsBase's by querying table field Quantity
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithQuantityValueOf(CS cs,
        short value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Order_DetailsBase_Quantity");
        cc.setMaxRows(maxResults);

        try {
            cc.setShort(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Order_DetailsBase's by querying table field Quantity
     * for equality with the same Quantity as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfQuantity(int maxResults)
        throws SQLException {
        return getLinkedListWithQuantityValueOf(cs, getQuantity(), maxResults);
    }

    /**
     * Gets a LinkedList of Order_DetailsBase's by querying table field Quantity
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithQuantityValueOf(CS cs,
        short value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithQuantityValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Order_DetailsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Order_DetailsBase's by querying table field Quantity
     * for equality with the same Quantity as this instance.
     */
    public Iterator getIteratorWithSameValueOfQuantity(int maxResults)
        throws SQLException {
        return getIteratorWithQuantityValueOf(cs, getQuantity(), maxResults);
    }

    /**
     * Gets an Iterator of Order_DetailsBase's by querying table field Quantity
     * for equality with the "value".
     */
    public static Iterator getIteratorWithQuantityValueOf(CS cs, short value,
        int maxResults) throws SQLException {
        return getLinkedListWithQuantityValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for Discount.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public float getDiscount() {
        return Discount;
    }

    /**
     * Setter for Discount.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setDiscount(float value) {
        this.Discount = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Order_DetailsBase's by querying table field Discount
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfDiscount(int maxResults)
        throws SQLException {
        return getResultSetWithDiscountValueOf(cs, getDiscount(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Order_DetailsBase's by querying table field Discount
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithDiscountValueOf(CS cs,
        float value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_Order_DetailsBase_Discount");
        cc.setMaxRows(maxResults);

        try {
            cc.setFloat(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Order_DetailsBase's by querying table field Discount
     * for equality with the same Discount as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfDiscount(int maxResults)
        throws SQLException {
        return getLinkedListWithDiscountValueOf(cs, getDiscount(), maxResults);
    }

    /**
     * Gets a LinkedList of Order_DetailsBase's by querying table field Discount
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithDiscountValueOf(CS cs,
        float value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithDiscountValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Order_DetailsBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Order_DetailsBase's by querying table field Discount
     * for equality with the same Discount as this instance.
     */
    public Iterator getIteratorWithSameValueOfDiscount(int maxResults)
        throws SQLException {
        return getIteratorWithDiscountValueOf(cs, getDiscount(), maxResults);
    }

    /**
     * Gets an Iterator of Order_DetailsBase's by querying table field Discount
     * for equality with the "value".
     */
    public static Iterator getIteratorWithDiscountValueOf(CS cs, float value,
        int maxResults) throws SQLException {
        return getLinkedListWithDiscountValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return Order_DetailsBase.delete(cs, OrderID, ProductID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int OrderID, int ProductID)
        throws SQLException {
        CallableStatement cc = null;
        int res = 0;

        try {
            cc = cs.allocCS("DELETE_Order_DetailsBase");

            cc.setInt(1, OrderID);

            cc.setInt(2, ProductID);

            res = cc.executeUpdate();
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
        return res;
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            CallableStatement cc = null;
            int res = 0;

            try {
                cc = cs.allocCS("UPDATE_Order_DetailsBase");

                cc.setDouble(1, getUnitPrice());

                cc.setShort(2, getQuantity());

                cc.setFloat(3, getDiscount());

                cc.setInt(4, getOrderID());

                cc.setInt(5, getProductID());

                res = cc.executeUpdate();
                isDirty = false;
            } finally {
                cs.freeCS(cc);
            }

            // template/debug was set to >0 during conversion
            return res;
        }

        return -1;
    }

    private void updateOldKeys() {
        // update the old_x old key values
        old_OrderID = OrderID;

        old_ProductID = ProductID;
    }

    /**
     * Updates the object to the database, even the primary keys are updated (but not the autoincrements or autoincr PK's)
     */
    public int updateAll() throws SQLException {
        if (isDirty) {
            CallableStatement cc = null;
            int res = 0;

            try {
                cc = cs.allocCS("UPDATEALL_Order_DetailsBase");

                cc.setInt(1, getOrderID());

                cc.setInt(2, getProductID());

                cc.setDouble(3, getUnitPrice());

                cc.setShort(4, getQuantity());

                cc.setFloat(5, getDiscount());

                cc.setInt(6, old_OrderID);

                cc.setInt(7, old_ProductID);

                res = cc.executeUpdate();
                isDirty = false;
            } finally {
                cs.freeCS(cc);
            }

            // template/debug was set to >0 during conversion
            updateOldKeys();

            return res;
        }

        return -1;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        try {
            cc = cs.allocCS("INSERT_Order_DetailsBase");

            cc.setInt(1, getOrderID());

            cc.setInt(2, getProductID());

            cc.setDouble(3, getUnitPrice());

            cc.setShort(4, getQuantity());

            cc.setFloat(5, getDiscount());

            cc.executeUpdate();

            updateOldKeys();

            isDirty = false;
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "OrderID:" + getOrderID());

        System.out.println(prefix + "ProductID:" + getProductID());

        System.out.println(prefix + "UnitPrice:" + getUnitPrice());

        System.out.println(prefix + "Quantity:" + getQuantity());

        System.out.println(prefix + "Discount:" + getDiscount());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(OrderID);
        sb.append(",");
        sb.append(ProductID);
        sb.append(",");
        sb.append(UnitPrice);
        sb.append(",");
        sb.append(Quantity);
        sb.append(",");
        sb.append(Discount);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
