/*
 * Decompiled with CFR 0.152.
 */
package org.aris.oodb;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Iterator;
import java.util.List;
import org.aris.dbutils.DBInfo;
import org.aris.oodb.TableToClass;
import org.aris.oodb.db.SqlServer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class TheMain {
    private String configFile = null;

    public void execute() {
        TheMain.main(new String[]{this.configFile});
    }

    public void setconfigfile(String s) {
        this.configFile = s;
    }

    public static void main(String[] args) {
        String saxDriver = System.getProperty("org.xml.sax.driver");
        if (saxDriver == null) {
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
        }
        if (args[0] == null) {
            System.err.println("Error: no config file specified.");
            return;
        }
        File confFile = new File(args[0]);
        if (!confFile.exists()) {
            System.err.println("Error: config file " + args[0] + " not found.");
            return;
        }
        try {
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build(confFile);
            Element root = doc.getRootElement();
            List databases = root.getChildren("database");
            Iterator itdb = databases.iterator();
            while (itdb.hasNext()) {
                Element database = (Element)itdb.next();
                Element connection = database.getChild("connection");
                Element debugE = database.getChild("debug");
                int debugLevel = Integer.valueOf(debugE.getText());
                String driver = connection.getChildText("driver");
                if (!driver.equals("com.microsoft.jdbc.sqlserver.SQLServerDriver")) {
                    throw new RuntimeException("Driver " + driver + " not supported.");
                }
                Class.forName(driver);
                SqlServer dbi = new SqlServer();
                Connection con = DriverManager.getConnection(connection.getChildText("string"), connection.getChildText("user"), connection.getChildText("password"));
                DBInfo info = new DBInfo(con);
                Element templates = database.getChild("templates");
                Iterator it = templates.getChildren("template").iterator();
                while (it.hasNext()) {
                    Element template = (Element)it.next();
                    TableToClass ttc = new TableToClass(info, template, templates.getChild("commonParams"), database.getChildText("catalog"), dbi);
                    ttc.convertAll(debugLevel);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error occured. Please check your configuration.xml file.");
            e.printStackTrace();
        }
        System.out.println("\n===> DONE");
    }
}

