#ifndef __CGraph2D__
#define __CGraph2D__

//includes
#include <CError.h>
#include <globals.h>
#include <fstream>
#include <cmath>
#include <cstdio>
#include <CSurface.h>
using namespace std;
//defines

#ifdef DEBUG_NOVA
#pragma comment(lib,"CGraph2DD.lib")
#endif
#ifndef DEBUG_NOVA
#pragma comment(lib,"CGraph2D.lib")
#endif

class CGraph2D
{
public:
	//creation/destruction
	CGraph2D();
	CGraph2D(HWND main_win,CError *err);
	~CGraph2D();
	int Destroy();
	//engine stuff
	int Loop();
	//user stuff
	int Text(char *text,int x,int y,int red,int green,int blue);
	int Text(int text,int x,int y,int red,int green,int blue);
	int Fade();
	int Fill(RECT dest,int red, int green, int blue);
	int Plot(int x, int y, int red, int green, int blue);
	int Line(int x1,int y1, int x2,int y2,int red,int green,int blue);
	int Circle(int x,int y, int radius,int red, int green, int blue);
	int Set_Mode(int Width,int Height,int BPP);
	CSurface *Create_Surface(const char *file,int type_flag);
	int Destroy_Surface(CSurface *surf);
	int Blit(CSurface *surf,RECT destination, RECT source);
	bool Restored;
	int erro;
private:
	LPDIRECTDRAWSURFACE7 back;
	LPDIRECTDRAW7 lpdd;
	CError *error;
	int Restore();
	int Lock();
	int Unlock();
	LPDIRECTDRAWSURFACE7 front;
	LPDIRECTDRAWGAMMACONTROL gamma;
	DDSURFACEDESC2 ddsd;
	DDBLTFX fx;
	DDPIXELFORMAT pixel;
	LPDIRECTDRAWCLIPPER lpddclipper;
	unsigned int *primary_buffer;
	unsigned short *back_buffer;

	RECT dest;
	double lcos[360];
	double lsin[360];
	int width, height,bpp;
	bool Locked;
	HWND main_window;
};

#endif
