#include <CMP3.h>


int CMP3::Pan_Left(int pan)
{
	if(pan>100)
		pan=100;
	if(pan<0)
		pan=0;
	long temp=pan*(-30);
	if(BA->put_Balance(temp)!=S_OK)
		return D_ERROR;
	return D_FINE;	
}

int CMP3::Center_Pan()
{
	if(BA->put_Balance(0)!=S_OK)
		return D_ERROR;
	return D_FINE;	
}

int CMP3::Pan_Right(int pan)
{
	if(pan>100)
		pan=100;
	if(pan<0)
		pan=0;
	long temp=pan*30;
	if(BA->put_Balance(temp)!=S_OK)
		return D_ERROR;
	return D_FINE;	
}

int CMP3::Set_Speed(int speed)
{
	if(speed>100)
		speed=100;
	if(speed<0)
		speed=0;
	double temp;
	temp=(double)speed/50;
	if(MediaSeeking->SetRate(temp)!=S_OK)
		return D_ERROR;
	speed2=speed;
	return D_FINE;
}

int CMP3::Go_To_Position(int time)
{
	const GUID Format=TIME_FORMAT_MEDIA_TIME;
	if(S_OK==MediaSeeking->IsUsingTimeFormat(&Format))
	{
		LONGLONG pos = time*10000000;
		MediaControl->Stop();
		MediaSeeking->SetPositions(&pos, AM_SEEKING_AbsolutePositioning,NULL, AM_SEEKING_NoPositioning);
		MediaControl->Pause();
	}
	else
	{
		if(MediaSeeking->IsFormatSupported(&Format)==S_OK)
		{
			MediaSeeking->SetTimeFormat(&Format);
			LONGLONG pos = time*10000000;
			MediaControl->Stop();
			MediaSeeking->SetPositions(&pos, AM_SEEKING_AbsolutePositioning,NULL, AM_SEEKING_NoPositioning);
			MediaControl->Pause();
		}
	}
	return D_FINE;
}

int CMP3::Pause()
{
	if(MP3_Active)
	{
		if(state==1)
		{
			MediaControl->Pause();
			state=0;
		}
		else
			MediaControl->Run();
	}
	return D_FINE;
}

int CMP3::Set_Volume(int volume)
{
	if(MP3_Active)
	{
		if(volume>100)
			volume=100;
		if(volume<0)
			volume=0;
		long temp=100-volume;
		temp=temp*(-30);
		BA->put_Volume(temp);
		volume2=volume;
	}
	return D_FINE;
}

bool CMP3::Is_Mp3_Running()
{
	long evCode;
	bool temp=FALSE;
	if(MP3_Active)
	{
		temp=TRUE;
		if(Event->WaitForCompletion(0, &evCode)==VFW_E_WRONG_STATE)
			temp=FALSE;
	}
	return temp;
}

int CMP3::Stop()
{
	if(MP3_Active)
	{
		LONGLONG pos = 0;
		MediaControl->Stop();
		MediaSeeking->SetPositions(&pos, AM_SEEKING_AbsolutePositioning,NULL, AM_SEEKING_NoPositioning);
		MediaControl->Pause();
		state=0;
	}
	return D_FINE;
}

CMP3::CMP3()
{
	Graph = NULL;
	MediaControl = NULL;
	MediaSeeking = NULL;
	Event=NULL;
	BA=NULL;
	MP3_Active=FALSE;
	state=-1;
	volume2=100;
	speed2=50;
}

CMP3::~CMP3()
{

}

int CMP3::Set_Up_Mp3(WCHAR *wFile)
{
	this->CleanUp();
	 // Create the filter graph manager.
    CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC, 
        IID_IGraphBuilder, (void **)&Graph);
    Graph->QueryInterface(IID_IMediaControl, (void **)&MediaControl);
	Graph->QueryInterface(IID_IMediaSeeking, (void **)&MediaSeeking);
	Graph->QueryInterface(IID_IMediaEvent, (void **)&Event);
	Graph->QueryInterface(IID_IBasicAudio, (void **)&BA);
    // Build the graph. 
    if(Graph->RenderFile(wFile, NULL)!=S_OK)
		return D_ERROR;
	MP3_Active=TRUE;
	state=0;
	MediaControl->Pause();
	return D_FINE;
}

int CMP3::PlayFile()
{
    // Run the graph.
	if(MP3_Active)
	{
		LONGLONG pos = 0;
		MediaSeeking->SetPositions(&pos, AM_SEEKING_AbsolutePositioning,NULL, AM_SEEKING_NoPositioning);
		MediaControl->Pause();
		this->Set_Speed(speed2);
		this->Set_Volume(volume2);
		MediaControl->Run();
		state=1;
	}
	return D_FINE;
}

int CMP3::CleanUp()
{
	if (MediaControl!=NULL)
        this->Stop();
	if(MediaSeeking!=NULL)
	{
		MediaSeeking->Release();
		MediaSeeking=NULL;
	}
	if(MediaControl!=NULL)
	{
		MediaControl->Release();
		MediaControl=NULL;
	}
	if(Event!=NULL)
	{
		Event->Release();
		Event=NULL;
	}
	if(Graph!=NULL)
	{
		Graph->Release();
		Graph=NULL;
	}
	if(BA!=NULL)
	{
		BA->Release();
		BA=NULL;
	}
	return D_FINE;
}