#include <file.h>

CFile::~CFile()
{
	this->close();
}

void CFile::close()
{
	file1.close();
}

void CFile::write(void *a,int size=0)
{
	if(this->flags&BINARY)
	{
		file1.write((char *)a,size);
		return;
	}
	file1<<(char *)a;
}

void CFile::write(unsigned char a)
{
	if(this->flags&BINARY)
	{
		file1.write((char *)&a,sizeof(a));
		return;
	}
	file1<<a;
}

void CFile::write(unsigned long a)
{
	if(this->flags&BINARY)
	{
		file1.write((char *)&a,sizeof(a));
		return;
	}
	file1<<a;
}

void CFile::write(unsigned short a)
{
	if(this->flags&BINARY)
	{
		file1.write((char *)&a,sizeof(a));
		return;
	}
	file1<<a;
}

void CFile::write(unsigned int a)
{
	if(this->flags&BINARY)
	{
		file1.write((char *)&a,sizeof(a));
		return;
	}
	file1<<a;
}

void CFile::write(float a)
{
	if(this->flags&BINARY)
	{
		file1.write((char *)&a,sizeof(a));
		return;
	}
	file1<<a;
}

void CFile::write(long a)
{
	if(this->flags&BINARY)
	{
		file1.write((char *)&a,sizeof(a));
		return;
	}
	file1<<a;
}

void CFile::write(short a)
{
	if(this->flags&BINARY)
	{
		file1.write((char *)&a,sizeof(a));
		return;
	}
	file1<<a;
}

void CFile::write(char a)
{
	if(this->flags&BINARY)
	{
		file1.write((char *)&a,sizeof(a));
		return;
	}
	file1<<a;
}

void CFile::write(int a)
{
	if(this->flags&BINARY)
	{
		file1.write((char *)&a,sizeof(a));
		return;
	}
	file1<<a;
}

void CFile::read(int *a)
{
	if(this->flags&BINARY)
	{
		file2.read((char *)a,sizeof(*a));
		return;
	}
	file2>>*a;
}

void CFile::read(char *a)
{
	if(this->flags&BINARY)
	{
		file2.read(a,sizeof(*a));
		return;
	}
	file2>>*a;
}

void CFile::read(short *a)
{
	if(this->flags&BINARY)
	{
		file2.read((char *)a,sizeof(*a));
		return;
	}
	file2>>*a;
}

void CFile::read(long *a)
{
	if(this->flags&BINARY)
	{
		file2.read((char *)a,sizeof(*a));
		return;
	}
	file2>>*a;
}

void CFile::read(float *a)
{
	if(this->flags&BINARY)
	{
		file2.read((char *)a,sizeof(*a));
		return;
	}
	file2>>*a;
}

void CFile::read(unsigned int *a)
{
	if(this->flags&BINARY)
	{
		file2.read((char *)a,sizeof(*a));
		return;
	}
	file2>>*a;
}

void CFile::read(unsigned short *a)
{
	if(this->flags&BINARY)
	{
		file2.read((char *)a,sizeof(*a));
		return;
	}
	file2>>*a;
}

void CFile::read(unsigned long *a)
{
	if(this->flags&BINARY)
	{
		file2.read((char *)a,sizeof(*a));
		return;
	}
	file2>>*a;
}

void CFile::read(unsigned char *a)
{
	if(this->flags&BINARY)
	{
		file2.read(a,sizeof(*a));
		return;
	}
	file2>>*a;
}

CFile::CFile()
{
}

CFile::CFile(const char *filename,int flags=TEXT|TRUNC)
{
	this->flags=flags;
	if(flags&IN)
	{
		if(flags&BINARY)
		{
			file2.open(filename,ios::binary);
			return;
		}
		file2.open(filename);
		return;
	}
	if(flags&APPEND)
	{
		if(flags&BINARY)
		{
			file1.open(filename,ios::binary|ios::app);
			return;
		}
		file1.open(filename,ios::app);
		return;
	}
	if(flags&BINARY)
	{
		file1.open(filename,ios::binary);
		return;
	}
	file1.open(filename,ios::trunc);
}

CFile::CFile(const char *filename)
{
	this->flags=flags;
	file1.open(filename,ios::trunc);
}

void CFile::open(const char *filename,int flags=TEXT|TRUNC)
{
	this->flags=flags;
	if(flags&IN)
	{
		if(flags&BINARY)
		{
			file2.open(filename,ios::binary);
			return;
		}
		file2.open(filename);
		return;
	}
	if(flags&APPEND)
	{
		if(flags&BINARY)
		{
			file1.open(filename,ios::binary|ios::app);
			return;
		}
		file1.open(filename,ios::app);
		return;
	}
	if(flags&BINARY)
	{
		file1.open(filename,ios::binary);
		return;
	}
	file1.open(filename,ios::trunc);
}

void CFile::open(const char *filename)
{
	this->flags=flags;
	file1.open(filename,ios::trunc);
}