// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "BCGPOutlookDemo.h"
#include "WorkspaceObj.h"
#include "FolderListPopupWnd.h"
#include "PreviewPane.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

const int  iMaxUserToolbars		= 10;
const UINT uiFirstUserToolBarId	= AFX_IDW_CONTROLBAR_FIRST + 40;
const UINT uiLastUserToolBarId	= uiFirstUserToolBarId + iMaxUserToolbars - 1;

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_VIEW_ADVANCED_TOOLBAR, OnViewAdvancedToolbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ADVANCED_TOOLBAR, OnUpdateViewAdvancedToolbar)
	ON_COMMAND(ID_VIEW_WEB_TOOLBAR, OnViewWebToolbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_WEB_TOOLBAR, OnUpdateViewWebToolbar)
	ON_COMMAND(ID_VIEW_OUTLOOKBAR, OnViewOutlookbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_OUTLOOKBAR, OnUpdateViewOutlookbar)
	ON_COMMAND(ID_VIEW_CAPTIONBAR, OnViewCaptionbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_CAPTIONBAR, OnUpdateViewCaptionbar)
	ON_COMMAND(ID_VIEW_FOLDER_LIST, OnViewFolderList)
	ON_UPDATE_COMMAND_UI(ID_VIEW_FOLDER_LIST, OnUpdateViewFolderList)
	ON_WM_ACTIVATE()
	ON_COMMAND(ID_OUTLOOK_ADD_PAGE, OnOutlookAddPage)
	ON_COMMAND(ID_OUTLOOK_ANIMATION, OnOutlookAnimation)
	ON_COMMAND(ID_OUTLOOK_DELETE_PAGE, OnOutlookDeletePage)
	ON_COMMAND(ID_OUTLOOK_RENAME_PAGE, OnOutlookRenamePage)
	ON_COMMAND(ID_OUTLOOK_SHOW_TEXT_LABELS, OnOutlookShowTextLabels)
	ON_UPDATE_COMMAND_UI(ID_OUTLOOK_RENAME_PAGE, OnUpdateOutlookRenamePage)
	ON_UPDATE_COMMAND_UI(ID_OUTLOOK_DELETE_PAGE, OnUpdateOutlookDeletePage)
	ON_UPDATE_COMMAND_UI(ID_OUTLOOK_ANIMATION, OnUpdateOutlookAnimation)
	ON_UPDATE_COMMAND_UI(ID_OUTLOOK_SHOW_TEXT_LABELS, OnUpdateOutlookShowTextLabels)
	ON_COMMAND(ID_RESET_PAGE, OnResetPage)
	ON_UPDATE_COMMAND_UI(ID_RESET_PAGE, OnUpdateResetPage)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_VIEW_CUSTOMIZE, OnViewCustomize)
	ON_REGISTERED_MESSAGE(BCGM_RESETTOOLBAR, OnToolbarReset)
	ON_REGISTERED_MESSAGE(BCGM_TOOLBARMENU, OnToolbarContextMenu)
	ON_REGISTERED_MESSAGE(BCGM_CREATETOOLBAR, OnToolbarCreateNew)
	ON_COMMAND_RANGE(ID_VIEW_USER_TOOLBAR1, ID_VIEW_USER_TOOLBAR10, OnToolsViewUserToolbar)
	ON_UPDATE_COMMAND_UI_RANGE(ID_VIEW_USER_TOOLBAR1, ID_VIEW_USER_TOOLBAR10, OnUpdateToolsViewUserToolbar)
	ON_COMMAND_RANGE(ID_VIEW_GOTO_HOME, ID_VIEW_GOTO_FAVORITES, OnViewWorkSpace)
	ON_COMMAND(ID_SHOW_FOLDERS_POPUP, OnViewFoldersPopup)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame() :
	m_wndFolderList (m_lstWorkspaces, m_ImagesSmall)
{
	m_uiHilightedPage = (UINT)-1;
	m_pCurrWorkSpace = NULL;
	m_pCurrOutlookWnd = NULL;
	m_pCurrOutlookPage = NULL;

	CBCGPVisualManager::SetDefaultManager (RUNTIME_CLASS (CBCGPVisualManagerXP));
	CBCGPOutlookWnd::EnableAnimation (TRUE);
}
//****************************************************************************************
CMainFrame::~CMainFrame()
{
	while (!m_lstWorkspaces.IsEmpty ())
	{
		delete m_lstWorkspaces.RemoveHead ();
	}
}
//****************************************************************************************
int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// Load toolbar user images:
	if (!m_UserImages.Load (_T(".\\Userimages.bmp")))
	{
		TRACE(_T("Failed to load user images\n"));
		ASSERT (FALSE);
	}
	else
	{
		CBCGPToolBar::SetUserImages (&m_UserImages);
	}

	CBCGPToolBar::EnableQuickCustomization ();
	CBCGPToolBar::SetLook2000 ();
	CBCGPToolbarComboBoxButton::SetFlatMode ();
	CBCGPToolBar::AddToolBarForImageCollection (IDR_MENU_IMAGES);

	//------------------------------------------------------
	// Define basic commands. These commands will appear in
	// the menu by default:
	//------------------------------------------------------
	SetBasicCommands ();

	//-----------------
	// Create menu bar:
	//-----------------
	if (!m_wndMenuBar.Create (this))
	{
		TRACE0("Failed to create menubar\n");
		return -1;      // fail to create
	}

	m_wndMenuBar.SetBarStyle(m_wndMenuBar.GetBarStyle() | CBRS_SIZE_DYNAMIC);

	//---------------------
	// Create main toolbar:
	//---------------------
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	CString strMainToolbarTitle;
	strMainToolbarTitle.LoadString (IDS_MAIN_TOOLBAR);
	m_wndToolBar.SetWindowText (strMainToolbarTitle);

	//-------------------------
	// Create advanced toolbar:
	//-------------------------
	if (!m_wndToolBarAdvanced.Create (this, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC,
		ID_VIEW_ADVANCED_TOOLBAR) ||
		!m_wndToolBarAdvanced.LoadToolBar(IDR_ADVANCED))
	{
		TRACE0("Failed to create advanced toolbar\n");
		return -1;      // fail to create
	}

	CString strAdvToolbarTitle;
	strAdvToolbarTitle.LoadString (IDS_ADV_TOOLBAR);
	m_wndToolBarAdvanced.SetWindowText (strAdvToolbarTitle);

	//--------------------
	// Create Web toolbar:
	//--------------------
	if (!m_wndToolBarWeb.Create (this, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC,
		ID_VIEW_WEB_TOOLBAR) ||
		!m_wndToolBarWeb.LoadToolBar(IDR_WEB))
	{
		TRACE0("Failed to create web toolbar\n");
		return -1;      // fail to create
	}

	CString strWebToolbarTitle;
	strWebToolbarTitle.LoadString (IDS_WEB_TOOLBAR);
	m_wndToolBarWeb.SetWindowText (strWebToolbarTitle);

	//-------------------
	// Create status bar:
	//-------------------
	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	m_wndMenuBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndToolBarAdvanced.EnableDocking(CBRS_ALIGN_ANY);
	m_wndToolBarWeb.EnableDocking(CBRS_ALIGN_ANY);

	//------------------------------------------------------------------
	// Outlook bar will be created at left, so temporary disable docking
	// at the left side:
	//------------------------------------------------------------------
	EnableDocking (CBRS_ALIGN_TOP | CBRS_ALIGN_BOTTOM | CBRS_ALIGN_RIGHT);

	//------------------------------------------
	// Create and setup "Outlook" shortcuts bar:
	//------------------------------------------
	if (!CreateOutlookBar ())
	{
		TRACE0("Failed to create outlook bar\n");
		return -1;      // fail to create
	}

	m_ImagesSmall.Create (IDB_OUTLOOK_SMALL, 16, 0, RGB (255, 0, 255));

	//----------------------
	// Create a caption bar:
	//----------------------
	if (!CreateCaptionBar ())
	{
		TRACE0("Failed to create caption bar\n");
		return -1;      // fail to create
	}
	//---------------------
	// Create folders list:
	//---------------------
	if (!m_wndFolderList.Create (_T("Folder List"),this, CRect (0, 0, 200, 200),
		TRUE,
		ID_VIEW_FOLDER_LIST,
		WS_CHILD | WS_VISIBLE | CBRS_LEFT | CBRS_HIDE_INPLACE | WS_CAPTION,
		CBRS_BCGP_OUTLOOK_TABS,
		CBRS_BCGP_CLOSE | CBRS_BCGP_RESIZE))
	{
		TRACE0("Failed to create folder list\n");
		return -1;      // fail to create
	}

	m_wndFolderList.EnableDocking (CBRS_ALIGN_LEFT);
	DockControlBar(&m_wndFolderList);

	//----------------------------------------------------
	// Outlook bar is created and docking on the left side
	// should be allowed.
	//----------------------------------------------------
	EnableDocking (CBRS_ALIGN_LEFT);
	EnableAutoHideBars(CBRS_ALIGN_RIGHT);

	DockControlBar(&m_wndMenuBar);
	DockControlBar(&m_wndToolBar);
	DockControlBar(&m_wndToolBarAdvanced);
	DockControlBarLeftOf (&m_wndToolBarWeb, &m_wndToolBarAdvanced);

	//----------------------------------------
	// Allow user-defined toolbars operations:
	//----------------------------------------
	InitUserToobars (NULL,
					uiFirstUserToolBarId,
					uiLastUserToolBarId);

	//-----------------------------------------------
	// Enable customization button fore all toolbars:
	//-----------------------------------------------
	m_wndToolBar.EnableCustomizeButton (TRUE, ID_VIEW_CUSTOMIZE, IDS_CUSTOMIZE);
	m_wndToolBarAdvanced.EnableCustomizeButton (TRUE, ID_VIEW_CUSTOMIZE, IDS_CUSTOMIZE);
	m_wndToolBarWeb.EnableCustomizeButton (TRUE, ID_VIEW_CUSTOMIZE, IDS_CUSTOMIZE);

	SetWorkSpace ((CWorkspaceObj*) m_lstWorkspaces.GetHead ());
	return 0;
}
//*************************************************************************************
BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers


void CMainFrame::OnViewCustomize()
{
	//------------------------------------
	// Create a customize toolbars dialog:
	//------------------------------------
	CBCGPToolbarCustomize* pDlgCust = new CBCGPToolbarCustomize (this,
		TRUE /* Automatic menus scaning */);

	pDlgCust->EnableUserDefinedToolbars ();
	pDlgCust->Create ();
}
//*************************************************************************************
LRESULT CMainFrame::OnToolbarContextMenu(WPARAM wp,LPARAM lp)
{
	CPoint point (BCG_GET_X_LPARAM(lp), BCG_GET_Y_LPARAM(lp));

	m_pCurrOutlookPage = DYNAMIC_DOWNCAST (	CBCGPOutlookBarPane, 
							CWnd::FromHandlePermanent ((HWND) wp));

	BOOL bOutlookbarMenu = m_pCurrOutlookPage != NULL;

	CMenu menu;
	VERIFY(menu.LoadMenu (bOutlookbarMenu ? 
							IDR_POPUP_OLBAR : IDR_POPUP_TOOLBAR));

	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);

	SetupToolbarMenu (*pPopup, ID_VIEW_USER_TOOLBAR1, ID_VIEW_USER_TOOLBAR10);

	CBCGPPopupMenu* pPopupMenu = new CBCGPPopupMenu;
	pPopupMenu->Create (this, point.x, point.y, pPopup->Detach ());

	if (bOutlookbarMenu)
	{
		m_uiHilightedPage = FindFocusedOutlookWnd (&m_pCurrOutlookWnd);
	}
	else
	{
		m_uiHilightedPage = (UINT)-1;
	}

	return 0;
}
//*************************************************************************************
void CMainFrame::OnToolsViewUserToolbar (UINT uiId)
{
	CBCGPToolBar* pUserToolBar = GetUserBarByIndex (uiId - ID_VIEW_USER_TOOLBAR1);
	if (pUserToolBar == NULL)
	{
		ASSERT (FALSE);
		return;
	}

	ShowControlBar (pUserToolBar, !(pUserToolBar->GetStyle () & WS_VISIBLE), FALSE, TRUE);
	RecalcLayout ();
}
//*************************************************************************************
void CMainFrame::OnUpdateToolsViewUserToolbar (CCmdUI* pCmdUI)
{
	CBCGPToolBar* pUserToolBar = GetUserBarByIndex (pCmdUI->m_nID - ID_VIEW_USER_TOOLBAR1);
	if (pUserToolBar == NULL)
	{
		pCmdUI->Enable (FALSE);
		return;
	}

	pCmdUI->Enable ();
	pCmdUI->SetCheck (pUserToolBar->GetStyle () & WS_VISIBLE);
}
//*************************************************************************************
LRESULT CMainFrame::OnToolbarReset(WPARAM wp,LPARAM)
{
	UINT uiToolBarId = (UINT) wp;
	if (uiToolBarId == IDR_MAINFRAME)
	{
		// Replace new button by the menu
		CMenu menu;
		VERIFY (menu.LoadMenu (IDR_MAINFRAME));

		CMenu* pMenuFile = menu.GetSubMenu (0);
		VERIFY (pMenuFile != NULL);

		CMenu* pMenuNew = pMenuFile->GetSubMenu (0);
		VERIFY (pMenuNew != NULL);

		UINT uiNewCmdID = (m_pCurrWorkSpace == NULL) ? 
							ID_NEW_MAIL : m_pCurrWorkSpace->m_uiDefaultNewAction;

		CBCGPToolbarMenuButton btnNew (uiNewCmdID, pMenuNew->GetSafeHmenu (), 
			CImageHash::GetImageOfCommand (uiNewCmdID));
		m_wndToolBar.ReplaceButton (ID_FILE_NEW, btnNew);

		m_wndToolBar.SetToolBarBtnText (m_wndToolBar.CommandToIndex (uiNewCmdID),
			_T("&New"));

		// Send/Receive appear with the text label:
		m_wndToolBar.SetToolBarBtnText (m_wndToolBar.CommandToIndex (ID_SEND_RECEIVE));

		// Replace Find Contact by combo:
		m_wndToolBar.ReplaceButton (ID_FIND_CONTACT, 
			CBCGPToolbarComboBoxButton (ID_FIND_CONTACT, 
					CImageHash::GetImageOfCommand (ID_FIND_CONTACT), CBS_DROPDOWN));
	}
	else if (uiToolBarId == IDR_WEB)
	{
		CMenu menu;
		VERIFY (menu.LoadMenu (IDR_DUMMY));
		CMenu* pSubMenu = menu.GetSubMenu (0);

		CBCGPToolbarMenuButton btnBack (ID_WEB_BACK, pSubMenu->GetSafeHmenu (), 
			CImageHash::GetImageOfCommand (ID_WEB_BACK));
		m_wndToolBarWeb.ReplaceButton (ID_WEB_BACK, btnBack);

		m_wndToolBarWeb.ReplaceButton (ID_WEB_ADDRESS, 
			CBCGPToolbarComboBoxButton (ID_WEB_ADDRESS, 
					CImageHash::GetImageOfCommand (ID_WEB_ADDRESS), CBS_DROPDOWN));
	}
	else if (uiToolBarId == IDR_ADVANCED)
	{
		CMenu menu;
		VERIFY (menu.LoadMenu (IDR_DUMMY));
		CMenu* pSubMenu = menu.GetSubMenu (0);

		CBCGPToolbarMenuButton btnBack (ID_VIEW_BACK, pSubMenu->GetSafeHmenu (), 
			CImageHash::GetImageOfCommand (ID_VIEW_BACK));
		m_wndToolBarAdvanced.ReplaceButton (ID_VIEW_BACK, btnBack);
	}

	return 0;
}
//*************************************************************************************
BOOL CMainFrame::OnShowPopupMenu (CBCGPPopupMenu* pMenuPopup)
{
	//---------------------------------------------------------
	// Replace ID_VIEW_TOOLBARS menu item to the toolbars list:
	//---------------------------------------------------------
    CFrameWnd::OnShowPopupMenu (pMenuPopup);

    if (pMenuPopup != NULL &&
		pMenuPopup->GetMenuBar ()->CommandToIndex (ID_VIEW_TOOLBARS) >= 0)
    {
		if (CBCGPToolBar::IsCustomizeMode ())
		{
			//----------------------------------------------------
			// Don't show toolbars list in the cuztomization mode!
			//----------------------------------------------------
			return FALSE;
		}

		pMenuPopup->RemoveAllItems ();

		CMenu menu;
		VERIFY(menu.LoadMenu (IDR_POPUP_TOOLBAR));

		CMenu* pPopup = menu.GetSubMenu(0);
		ASSERT(pPopup != NULL);

		SetupToolbarMenu (*pPopup, ID_VIEW_USER_TOOLBAR1, ID_VIEW_USER_TOOLBAR10);
		pMenuPopup->GetMenuBar ()->ImportFromMenu (*pPopup, TRUE);
    }

	return TRUE;
}
//*************************************************************************************
void CMainFrame::OnViewAdvancedToolbar() 
{
	ShowControlBar (&m_wndToolBarAdvanced,
					!(m_wndToolBarAdvanced.GetStyle () & WS_VISIBLE),
					FALSE, TRUE);
}
//*************************************************************************************
void CMainFrame::OnUpdateViewAdvancedToolbar(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_wndToolBarAdvanced.GetStyle () & WS_VISIBLE);
}
//*************************************************************************************
void CMainFrame::OnViewWebToolbar() 
{
	ShowControlBar (&m_wndToolBarWeb,
					!(m_wndToolBarWeb.GetStyle () & WS_VISIBLE),
					FALSE, TRUE);
}
//*************************************************************************************
void CMainFrame::OnUpdateViewWebToolbar(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_wndToolBarWeb.GetStyle () & WS_VISIBLE);
}
//*************************************************************************************
void CMainFrame::OnViewOutlookbar() 
{
	ShowControlBar (&m_wndBarOutlook,
					!(m_wndBarOutlook.GetStyle () & WS_VISIBLE),
					FALSE, TRUE);
}
//*************************************************************************************
void CMainFrame::OnUpdateViewOutlookbar(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_wndBarOutlook.GetStyle () & WS_VISIBLE);
}
//*************************************************************************************
void CMainFrame::AddWorkSpace (const CString& strName, const int iIconIndex, 
							   const UINT uiCmd,
							   const UINT uiPageId,
							   const UINT uiNewCmdID,
							   CImageList& images)
{
	if (uiPageId == 1)
	{
		m_wndOutlookPane1.AddButton (images.ExtractIcon (iIconIndex), strName, uiCmd);
	}
	else
	{
		m_wndOutlookPane2.AddButton (images.ExtractIcon (iIconIndex), strName, uiCmd);
	}

	m_lstWorkspaces.AddTail (new CWorkspaceObj (strName, uiCmd, iIconIndex, uiPageId, uiNewCmdID));
}
//*************************************************************************************
BOOL CMainFrame::CreateOutlookBar ()
{
	if (!m_wndBarOutlook.Create (_T("Shortcuts"), this, CRect (0, 0, 100, 100), 
		ID_VIEW_OUTLOOKBAR, WS_CHILD | WS_VISIBLE | CBRS_LEFT))
	{
		return FALSE;		// fail to create
	}

	CBCGPOutlookWnd* pOutlookBar = (CBCGPOutlookWnd*) 
										m_wndBarOutlook.GetUnderlinedWindow ();

	if (pOutlookBar == NULL)
	{
		ASSERT (FALSE);
		return FALSE;
	}

	pOutlookBar->EnableInPlaceEdit (TRUE);

	const UINT uiPage1ID = 1;
	const UINT uiPage2ID = 2;
	const UINT uiPage3ID = 3;

	DWORD dwPaneStyle = dwDefaultToolbarStyle | CBRS_FLOAT_MULTI;

	m_wndOutlookPane1.Create (&m_wndBarOutlook, dwPaneStyle, uiPage1ID);
	m_wndOutlookPane1.SetOwner (this);
	m_wndOutlookPane1.EnableTextLabels ();
	m_wndOutlookPane1.EnableDocking (CBRS_ALIGN_LEFT | CBRS_ALIGN_RIGHT);

	m_wndOutlookPane2.Create (&m_wndBarOutlook, dwPaneStyle, uiPage2ID);
	m_wndOutlookPane2.SetOwner (this);
	m_wndOutlookPane2.EnableTextLabels ();
	m_wndOutlookPane2.EnableDocking (CBRS_ALIGN_ANY);


	CImageList images;
	images.Create (IDB_OUTLOOK_LARGE, 32, 0, RGB (255, 0, 255));

	AddWorkSpace (_T("Home"), 0, ID_VIEW_GOTO_HOME, uiPage1ID, ID_NEW_MAIL, images);
	AddWorkSpace (_T("Calendar"), 1, ID_VIEW_GOTO_CALENDAR, uiPage1ID, ID_NEW_APPOINMENT, images);
	AddWorkSpace (_T("Drafts"), 2, ID_VIEW_GOTO_DRAFTS, uiPage1ID, ID_NEW_MAIL, images);
	AddWorkSpace (_T("Inbox"), 3, ID_VIEW_GOTO_INBOX, uiPage1ID, ID_NEW_MAIL, images);
	AddWorkSpace (_T("Journal"), 4, ID_VIEW_GOTO_JOURNAL, uiPage1ID, ID_NEW_JOURNAL_ENTRY, images);
	AddWorkSpace (_T("Notes"), 5, ID_VIEW_GOTO_NOTES, uiPage1ID, ID_NEW_NOTE, images);
	AddWorkSpace (_T("Outbox"), 6, ID_VIEW_GOTO_OUTBOX, uiPage1ID, ID_NEW_MAIL, images);
	AddWorkSpace (_T("Sent Items"), 7, ID_VIEW_GOTO_SENTITEMS, uiPage1ID, ID_NEW_MAIL, images);
	AddWorkSpace (_T("Tasks"), 8, ID_VIEW_GOTO_TASKS, uiPage1ID, ID_NEW_TASK, images);

	pOutlookBar->AddTab (&m_wndOutlookPane1, "General");
	m_wndOutlookPane1.EnableDocking (CBRS_ALIGN_ANY);
	m_wndOutlookPane1.SetDefaultState ();

	CBCGPDockingCBWrapper* pWrapper = 
		DYNAMIC_DOWNCAST (CBCGPDockingCBWrapper, 
							pOutlookBar->GetTabWnd (0));
	ASSERT_VALID (pWrapper);
	pWrapper->SetTabbedControlBarRTC (RUNTIME_CLASS (CBCGPOutlookBar));

	AddWorkSpace (_T("My Computer"), 9, ID_VIEW_MY_COMPUTER, uiPage2ID, ID_NEW_SHORTCUT, images);
	AddWorkSpace (_T("Personal"), 10, ID_VIEW_GOTO_PERSONAL, uiPage2ID, ID_NEW_SHORTCUT, images);
	AddWorkSpace (_T("Favorites"), 10, ID_VIEW_GOTO_FAVORITES, uiPage2ID, ID_NEW_SHORTCUT, images);

	pOutlookBar->AddTab (&m_wndOutlookPane2, "Other Shortcuts");
	m_wndOutlookPane2.EnableDocking (CBRS_ALIGN_ANY);
	m_wndOutlookPane2.SetDefaultState ();

	pWrapper = DYNAMIC_DOWNCAST (CBCGPDockingCBWrapper, 
							pOutlookBar->GetTabWnd (1));
	ASSERT_VALID (pWrapper);
	pWrapper->SetTabbedControlBarRTC (RUNTIME_CLASS (CBCGPOutlookBar));

	CRect rectDummy (0, 0, 0, 0);
	// iot can't have set it later for its wrapper!
	const DWORD dwTreeStyle =	WS_CHILD | WS_VISIBLE | TVS_HASLINES | 
								TVS_LINESATROOT | TVS_HASBUTTONS;

	m_wndTree.Create (dwTreeStyle, rectDummy, &m_wndBarOutlook, 1200);

	TCHAR szWinDir [MAX_PATH + 1];
	GetWindowsDirectory (szWinDir, MAX_PATH);

	SHFILEINFO sfi;
	HIMAGELIST himSystem = (HIMAGELIST)SHGetFileInfo (szWinDir,
                                       0,
                                       &sfi, 
                                       sizeof(SHFILEINFO), 
                                       SHGFI_SYSICONINDEX | SHGFI_SMALLICON);
	int iIndex = sfi.iIcon;

	m_wndTree.SetImageList (CImageList::FromHandle (himSystem), TVSIL_NORMAL);

	HTREEITEM hRoot = m_wndTree.InsertItem (_T("Folders"), iIndex, iIndex);
	m_wndTree.InsertItem (_T("Folder 1"), iIndex, iIndex, hRoot);
	m_wndTree.InsertItem (_T("Folder 2"), iIndex, iIndex, hRoot);
	m_wndTree.Expand (hRoot, TVE_EXPAND);

	pOutlookBar->AddTab (&m_wndTree, _T("Folders"));

	pWrapper = DYNAMIC_DOWNCAST (CBCGPDockingCBWrapper, 
							pOutlookBar->GetTabWnd (2));
	ASSERT_VALID (pWrapper);
	pWrapper->SetTabbedControlBarRTC (RUNTIME_CLASS (CBCGPOutlookBar));
	pWrapper->SetMiniFrameRTC (RUNTIME_CLASS (CBCGPMultiMiniFrameWnd));
	// we need this flag for the runtime checking
	pWrapper->SetBarStyle(pWrapper->GetBarStyle() | CBRS_FLOAT_MULTI);

	m_wndOutlookPane1.EnableTextLabels (TRUE);

	m_wndBarOutlook.SetBarStyle(m_wndBarOutlook.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

	BOOL bAnimation = theApp.GetInt (_T("OutlookAnimation"), TRUE);
	CBCGPOutlookWnd::EnableAnimation (bAnimation);

	return TRUE;
}
//****************************************************************************************
BOOL CMainFrame::CreateCaptionBar ()
{
	if (!m_wndCaption.Create (WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS, 
		this, ID_VIEW_CAPTIONBAR, -1))
	{
		TRACE0("Failed to create caption bar\n");
		return FALSE;
	}

	m_wndCaption.SetFlatBorder ();
	return TRUE;
}
//****************************************************************************************
void CMainFrame::OnViewCaptionbar() 
{
	ShowControlBar (&m_wndCaption,
					!(m_wndCaption.GetStyle () & WS_VISIBLE),
					FALSE, TRUE);
}
//*************************************************************************************
void CMainFrame::OnUpdateViewCaptionbar(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_wndCaption.GetStyle () & WS_VISIBLE);
}
//*************************************************************************************
void CMainFrame::OnViewWorkSpace (UINT id)
{
	for (POSITION pos = m_lstWorkspaces.GetHeadPosition (); pos != NULL;)
	{
		CWorkspaceObj* pWS = (CWorkspaceObj*) m_lstWorkspaces.GetNext (pos);
		ASSERT_VALID (pWS);

		if (pWS->m_uiCmd == id)
		{
			SetWorkSpace (pWS);
		}
	}
}
//*************************************************************************************
void CMainFrame::SetWorkSpace (CWorkspaceObj* pWorkSpace)
{
	ASSERT_VALID (pWorkSpace);

	m_pCurrWorkSpace = pWorkSpace;

	m_wndCaption.SetIcon (m_ImagesSmall.ExtractIcon (m_pCurrWorkSpace->m_iIconIndex));
	m_wndCaption.SetButton (m_pCurrWorkSpace->m_strName, ID_SHOW_FOLDERS_POPUP);

	m_wndCaption.Invalidate ();
	m_wndCaption.UpdateWindow ();

	m_wndFolderList.SelectWorkspace (pWorkSpace);

}
//*************************************************************************************
void CMainFrame::OnViewFolderList() 
{
	ShowControlBar (&m_wndFolderList,
					!(m_wndFolderList.GetStyle () & WS_VISIBLE),
					FALSE, TRUE);
	RecalcLayout ();

}
//*************************************************************************************
void CMainFrame::OnUpdateViewFolderList(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck (m_wndFolderList.GetStyle () & WS_VISIBLE);
}
//*************************************************************************************
void CMainFrame::OnViewFoldersPopup()
{
	// First, calulate popup window rectangle.
	// Top left corner need to be under the caption's button:
	CRect rectButton = m_wndCaption.GetButtonRect ();
	m_wndCaption.ClientToScreen (&rectButton);

	// Width will be same as folder bar's width:
	CRect rectFolderBar;
	m_wndFolderList.GetWindowRect (&rectFolderBar);

	// Bottom will be near the main frame bottom:
	CRect rectStatusBar;
	m_wndStatusBar.GetWindowRect (rectStatusBar);

	CRect rectPopup (rectButton.left, rectButton.bottom,
		rectButton.left + rectFolderBar.Width (), rectStatusBar.bottom - 1);

	CFolderListPopupWnd* pFoldersPopup = 
		new CFolderListPopupWnd (m_lstWorkspaces, m_ImagesSmall, m_pCurrWorkSpace);
	pFoldersPopup->Create (rectPopup);

	m_wndCaption.SetButtonPressed ();
}
//*************************************************************************************
void CMainFrame::OnCloseFoldersPopup (BOOL bKeep)
{
	if (bKeep)
	{
		m_wndCaption.EnableButton (FALSE);
		ShowControlBar (&m_wndFolderList, TRUE, FALSE, TRUE);
	}

	m_wndCaption.SetButtonPressed (FALSE);
}
//*************************************************************************************
void CMainFrame::RecalcLayout(BOOL bNotify) 
{
	CFrameWnd::RecalcLayout(bNotify);

	if (m_wndFolderList.GetSafeHwnd () != NULL)
	{
		m_wndCaption.EnableButton (!(m_wndFolderList.GetStyle () & WS_VISIBLE));
	}
}
//*************************************************************************************
void CMainFrame::AdjustDockingLayout (HDWP hdwp)
{
	CFrameWnd::AdjustDockingLayout (hdwp);
	if (m_wndFolderList.GetSafeHwnd () != NULL)
	{
		m_wndCaption.EnableButton (!(m_wndFolderList.GetStyle () & WS_VISIBLE));
	}
}
//*************************************************************************************
BOOL CMainFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	CRect rectClient;
	GetClientRect (rectClient);

	m_wndSplitter.CreateStatic (this, 2, 1);
	m_wndSplitter.CreateView (0, 0, pContext->m_pNewViewClass, 
							CSize (0, rectClient.Height () / 2), pContext);
	m_wndSplitter.CreateView (1, 0, RUNTIME_CLASS (CPreviewPane), 
							CSize (0, rectClient.Height () / 2), pContext);
	
	return TRUE;
}
//*************************************************************************************
void CMainFrame::SetBasicCommands ()
{
	CList<UINT, UINT>	lstBasicCommands;

	lstBasicCommands.AddTail (ID_VIEW_TOOLBARS);
	lstBasicCommands.AddTail (ID_FILE_NEW);
	lstBasicCommands.AddTail (ID_FILE_OPEN);
	lstBasicCommands.AddTail (ID_FILE_SAVE);
	lstBasicCommands.AddTail (ID_FILE_PRINT);
	lstBasicCommands.AddTail (ID_APP_EXIT);
	lstBasicCommands.AddTail (ID_EDIT_CUT);
	lstBasicCommands.AddTail (ID_EDIT_PASTE);
	lstBasicCommands.AddTail (ID_EDIT_UNDO);
	lstBasicCommands.AddTail (ID_APP_ABOUT);
	lstBasicCommands.AddTail (ID_VIEW_TOOLBAR);
	lstBasicCommands.AddTail (ID_VIEW_CUSTOMIZE);
	lstBasicCommands.AddTail (ID_NEW_MAIL);
	lstBasicCommands.AddTail (ID_NEW_FAX);
	lstBasicCommands.AddTail (ID_NEW_POST_FOLDER);
	lstBasicCommands.AddTail (ID_NEW_APPOINMENT);
	lstBasicCommands.AddTail (ID_NEW_MEETING);
	lstBasicCommands.AddTail (ID_NEW_CONTRACT);
	lstBasicCommands.AddTail (ID_NEW_DISTRIBUTION_LIST);
	lstBasicCommands.AddTail (ID_NEW_TASK);
	lstBasicCommands.AddTail (ID_NEW_NOTE);
	lstBasicCommands.AddTail (ID_DUMMY);
	lstBasicCommands.AddTail (ID_VIEW_FOLDER_LIST);
	lstBasicCommands.AddTail (ID_MAIL_SEND);
	lstBasicCommands.AddTail (ID_MAIL_SAVE);
	lstBasicCommands.AddTail (ID_FILE_SAVE_AS);
	lstBasicCommands.AddTail (ID_MAIL_SAVE_ATTACHMENTS);
	lstBasicCommands.AddTail (ID_MAIL_SAVE_STATIONERY);
	lstBasicCommands.AddTail (ID_MAIL_DELETE);
	lstBasicCommands.AddTail (ID_MAIL_MOVE_TO_FOLDER);
	lstBasicCommands.AddTail (ID_FILE_PRINT_PREVIEW);
	lstBasicCommands.AddTail (ID_FILE_CLOSE);
	lstBasicCommands.AddTail (ID_MAIL_ATTACHMENT);
	lstBasicCommands.AddTail (ID_MAIL_ITEM);
	lstBasicCommands.AddTail (ID_MAIL_SIGNATURE);
	lstBasicCommands.AddTail (ID_MAIL_SPELL);
	lstBasicCommands.AddTail (ID_MAIL_CLOSE);
	lstBasicCommands.AddTail (ID_ADDRESS_BOOK);

	CBCGPToolBar::SetBasicCommands (lstBasicCommands);
}
//****************************************************************************************
void CMainFrame::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CFrameWnd::OnActivate(nState, pWndOther, bMinimized);
	
	if (nState != WA_INACTIVE)
	{
		theApp.SetActiveFrame (CBCGPOutlookDemoApp::MainFrame);
		theApp.m_pMainWnd = this;
	}
}
//**************************************************************************************
BOOL CMainFrame::LoadFrame(UINT nIDResource, DWORD dwDefaultStyle, CWnd* pParentWnd, CCreateContext* pContext) 
{
	if (!CFrameWnd::LoadFrame(nIDResource, dwDefaultStyle, pParentWnd, pContext))
	{
		return FALSE;
	}

	//----------------------------------------------------
	// Enable customization button fore all user toolbars:
	//----------------------------------------------------
	for (int i = 0; i < uiLastUserToolBarId - uiFirstUserToolBarId + 1; i++)
	{
		CBCGPToolBar* pUserToolbar = GetUserBarByIndex (i);
		if (pUserToolbar != NULL)
		{
			pUserToolbar->EnableCustomizeButton (TRUE, ID_VIEW_CUSTOMIZE, IDS_CUSTOMIZE);
		}
	}

	return TRUE;
}
//***************************************************************************************
LRESULT CMainFrame::OnToolbarCreateNew(WPARAM wp,LPARAM lp)
{
	LRESULT lres = CBCGPFrameWnd::OnToolbarCreateNew (wp,lp);
	if (lres == 0)
	{
		return 0;
	}

	CBCGPToolBar* pUserToolbar = (CBCGPToolBar*) lres;
	ASSERT_VALID (pUserToolbar);

	pUserToolbar->EnableCustomizeButton (TRUE, ID_VIEW_CUSTOMIZE, _T("Customize..."));
	pUserToolbar->AdjustLayout ();
	return lres;
}
//*************************************************************************************
void CMainFrame::OnOutlookAddPage() 
{
	CBCGPOutlookWnd* pOutlookBar = (CBCGPOutlookWnd*) 
										m_wndBarOutlook.GetUnderlinedWindow ();
	if (pOutlookBar == NULL)
	{
		return;
	}

	CBCGPOutlookBarPane* pPane = 
		m_wndBarOutlook.CreateCustomPage (_T("New Page"), TRUE, CBRS_ALIGN_ANY);

	OnOutlookRenamePage ();
}
//*************************************************************************************
void CMainFrame::OnOutlookAnimation() 
{
	ASSERT_VALID (m_pCurrOutlookWnd);
	CBCGPOutlookWnd::EnableAnimation (!CBCGPOutlookWnd::IsAnimation ());
}
//*************************************************************************************
void CMainFrame::OnResetPage() 
{
	if (m_pCurrOutlookPage == NULL)
	{
		ASSERT (FALSE);
		return;
	}

	ASSERT_VALID (m_pCurrOutlookPage);

	if (AfxMessageBox (IDP_REST_OUTLOOK_PAGE, MB_YESNO) == IDYES)
	{
		m_pCurrOutlookPage->RestoreOriginalstate ();
	}
}
//*************************************************************************************
void CMainFrame::OnUpdateResetPage(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable (m_pCurrOutlookPage != NULL && m_pCurrOutlookPage->CanBeRestored ());
}
//*************************************************************************************
void CMainFrame::OnOutlookDeletePage() 
{
	if (m_pCurrOutlookWnd == NULL)
	{
		return;
	}

	UINT uiPage = m_pCurrOutlookWnd->GetActiveTab ();

	CString strPageName;
	m_pCurrOutlookWnd->GetTabLabel (uiPage,strPageName);
	
	CString strMessage;
	strMessage.Format (_T("Remove page '%s'?"), strPageName);

	if (AfxMessageBox (strMessage, MB_YESNO) == IDYES)
	{
		m_wndBarOutlook.RemoveCustomPage (uiPage, m_pCurrOutlookWnd);
	}
}
//*************************************************************************************
void CMainFrame::OnOutlookRenamePage() 
{
	if (m_pCurrOutlookWnd != NULL)
	{
		if (!m_pCurrOutlookWnd->IsInPlaceEdit ())
		{
			m_pCurrOutlookWnd->EnableInPlaceEdit (TRUE);
		}
		m_pCurrOutlookWnd->StartRenameTab (m_pCurrOutlookWnd->GetActiveTab ());
	}
}
//*************************************************************************************
void CMainFrame::OnOutlookShowTextLabels() 
{
	m_wndOutlookPane1.EnableTextLabels (!m_wndOutlookPane1.AreTextLabels ());
}
//*************************************************************************************
void CMainFrame::OnUpdateOutlookRenamePage(CCmdUI* pCmdUI) 
{
	BOOL bEnable = (m_pCurrOutlookWnd != NULL) && ((UINT)m_uiHilightedPage != -1);
	pCmdUI->Enable (bEnable);
}
//*************************************************************************************
void CMainFrame::OnUpdateOutlookDeletePage(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable (m_uiHilightedPage != (UINT)-1);
}
//*************************************************************************************
void CMainFrame::OnUpdateOutlookAnimation(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (CBCGPOutlookWnd::IsAnimation ());
}
//************************************************************************************
void CMainFrame::OnUpdateOutlookShowTextLabels(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_wndOutlookPane1.AreTextLabels ());
}
//************************************************************************************
int CMainFrame::FindFocusedOutlookWnd (CBCGPOutlookWnd** ppOutlookWnd)
{
	ASSERT (ppOutlookWnd != NULL);

	*ppOutlookWnd = NULL;

	// find the outlook from the current point
	CPoint pt;
	GetCursorPos (&pt);

	CWnd* pWnd = m_dockManager.ControlBarFromPoint (pt, 0);
	*ppOutlookWnd = FindOutlookParent (pWnd);

	// find focused ouitlook
	if (*ppOutlookWnd == NULL)
	{
		CWnd* pWnd = GetFocus ();

		if (pWnd == &m_wndBarOutlook)
		{
			*ppOutlookWnd = (CBCGPOutlookWnd*) m_wndBarOutlook.GetUnderlinedWindow ();
		}
		else if (pWnd->IsKindOf (RUNTIME_CLASS (CBCGPOutlookBar))) 
		{
			*ppOutlookWnd = (CBCGPOutlookWnd*) ((CBCGPOutlookBar*)pWnd)->GetUnderlinedWindow ();
		}
		else 
		{
			CWnd* pParent = pWnd->GetParent ();
			while (pParent != NULL)
			{
				if (pParent->IsKindOf (RUNTIME_CLASS (CBCGPOutlookBar)))
				{
					*ppOutlookWnd = (CBCGPOutlookWnd*) ((CBCGPOutlookBar*)pParent)->GetUnderlinedWindow ();
					break;
				}
				pParent = pParent->GetParent ();
			}
		}
	}

	if (*ppOutlookWnd != NULL)
	{
		return (*ppOutlookWnd)->GetActiveTab ();
	}

	return -1;
}
//************************************************************************************
CBCGPOutlookWnd* CMainFrame::FindOutlookParent (CWnd* pWnd)
{
	if (pWnd == NULL)
	{
		return NULL;
	}

	if (pWnd->IsKindOf (RUNTIME_CLASS (CBCGPOutlookBar)))
	{	
		return (CBCGPOutlookWnd*) ((CBCGPOutlookBar*)pWnd)->GetUnderlinedWindow ();
	}

	CWnd* pParent = pWnd->GetParent ();
	while (pParent != NULL)
	{
		if (pParent->IsKindOf (RUNTIME_CLASS (CBCGPOutlookBar)))
		{
			return (CBCGPOutlookWnd*) ((CBCGPOutlookBar*)pParent)->GetUnderlinedWindow ();
			
		}
		pParent = pParent->GetParent ();
	}
	return NULL;
}
//*******************************************************************************************
void CMainFrame::OnClose() 
{
	theApp.WriteInt (_T("OutlookAnimation"), CBCGPOutlookWnd::IsAnimation ());
	CFrameWnd::OnClose();
}
