/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Locale;

import java.io.PrintWriter;
import java.io.IOException;

import javax.servlet.ServletException;

import stec.iws.iws;
import stec.iws.Request;
import stec.iws.Response;

public class SimpleFormServlet extends BaseServlet
{
	public void service(Request _request, Response _response) throws ServletException, IOException
	{
		PrintWriter writer = _response.getWriter();

		writer.println("<html>");
		writer.println("<head><title>Simple Entry Form Servlet</title></head>");
		writer.println("<body>");

		String name = _request.getParameter("name");
		if(name == null)
		{
			String oldvalue = _request.getParameter("oldvalue");
			if(oldvalue == null)
			{
				oldvalue = "";
			}

			writer.println("Please enter your name");
			writer.println("<br>");
			writer.println("<form action=\"./simpleform.html\" method=\"get\">");
			writer.println("<input type=\"text\" name=\"name\" value=\"" + oldvalue + "\">");
			writer.println("<br>");
			writer.println("<input type=\"submit\" value=\"Submit\">");
			writer.println("<input type=\"reset\" value=\"Reset\">");
			writer.println("</form>");
		}
		else if(name.length() == 0)
		{
			writer.println("<h1>Please enter your name</h1>");
			writer.println("<br>");
			writer.println("[ <a href=\"./simpleform.html?oldvalue=\">try again</a> ]");
		}
		else
		{
			writer.println("<h1>Hello " + name + "</h1>");
			writer.println("<br>");
			writer.println("[ <a href=\"./simpleform.html?oldvalue=" + name + "\">try again</a> ]");
		}

		writer.println("</body>");
		writer.println("</html>");
	}
}
