/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Enumeration;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;

import stec.iws.Utils;
import stec.iws.Request;
import stec.iws.Response;

public class HeadersServlet extends BaseServlet
{
	public void service(Request _request, Response _response) throws ServletException, IOException
	{
		PrintWriter writer = _response.getWriter();

		writer.println("<html>");
		writer.println("<head><title>Display Headers Servlet</title></head>");
		writer.println("<body>");

		server_variables(writer, _request);
		headers(writer, _request);

		writer.println("</body>");
		writer.println("</html>");
	}

	protected static void server_variables(PrintWriter writer, Request _request) throws IOException
	{
		writer.println("<h1>Server Variables:</h1>");

		writer.println("<lit>");

		writer.println("AUTH_TYPE = [" + _request.getAuthType() + "]<br>");
		writer.println("REQUEST_METHOD = [" + _request.getMethod() + "]<br>");
		writer.println("PATH_INFO = [" + _request.getPathInfo() + "]<br>");
		writer.println("PATH_TRANSLATED = [" + _request.getPathTranslated() + "]<br>");
		writer.println("QUERY_STRING = [" + _request.getQueryString() + "]<br>");
		writer.println("REQUEST_URI = [" + _request.getRequestURI() + "]<br>");
		writer.println("SCRIPT_NAME = [" + _request.getServletPath() + "]<br>");
		writer.println("LOCAL_ADDR = [" + _request.getLocalAddr() + "]<br>");
		writer.println("SERVER_PROTOCOL = [" + _request.getProtocol() + "]<br>");
		writer.println("REMOTE_ADDR = [" + _request.getRemoteAddr() + "]<br>");
		writer.println("REMOTE_HOST = [" + _request.getRemoteHost() + "]<br>");
		writer.println("SCHEME = [" + _request.getScheme() + "]<br>");
		writer.println("SERVER_NAME = [" + _request.getServerName() + "]<br>");
		writer.println("SERVER_PORT = [" + _request.getServerPort() + "]<br>");

		writer.println("</lit>");
	}

	protected static void headers(PrintWriter writer, Request _request) throws IOException
	{
		writer.println("<h1>Headers:</h1>");

		writer.println("<lit>");

		Enumeration values;
		String key;

		Enumeration headers = _request.getHeaderNames();
		while(headers.hasMoreElements())
		{
			key = (String)headers.nextElement();
			values = _request.getHeaders(key);
			while(values.hasMoreElements())
			{
				writer.println(key + " = [" + values.nextElement() + "]<br>");
			}
		}

		writer.println("</lit>");
	}
}
