/*
 * Copyright (c) 1998-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.StringTokenizer;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;

import stec.iws.Utils;
import stec.iws.Request;
import stec.iws.Response;

public class ArgsServlet extends BaseServlet
{
	public void service(Request _request, Response _response) throws ServletException, IOException
	{
		PrintWriter writer = _response.getWriter();

		writer.println("<html>");
		writer.println("<head><title>Display Arguments Servlet</title></head>");
		writer.println("<body>");

		args(writer, _request, _response);

		writer.println("</body>");
		writer.println("</html>");
	}

	protected static void args(PrintWriter writer, Request _request, Response _response) throws IOException
	{
		writer.println("<h1>Arguments:</h1>");

		writer.println("<lit>");

		String qs = _request.getQueryString();
		if(qs != null)
		{
			int counter = 0;

			String args = Utils.decodeURL(Utils.getArgs(_request), _response.getCharacterEncoding());
			if(args != null)
			{
				StringTokenizer st = new StringTokenizer(args);
				while(st.hasMoreElements())
				{
					writer.println("args[" + counter + "] = [" + st.nextElement() + "]<br>");
					counter++;
				}
			}
		}

		writer.println("</lit>");
	}
}
