/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import stec.iws.AccessLogEntry;
import stec.iws.Logger;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public abstract class OutputStreamLogger
extends Logger {
    private static final String j = "-";
    private static final String k = ", ";
    public PrintStream accesslog = null;
    public PrintStream errorslog = null;
    public PrintStream eventslog = null;
    public String accessLogTemplate;
    public String accessLogHeaderTemplate;

    public void init(Hashtable hashtable) throws Exception {
        String string;
        super.init(hashtable);
        Hashtable hashtable2 = Utils.getConfig("./templates.ini");
        Object v = hashtable.get("access_log_header_template");
        if (v != null) {
            string = ((String[])v)[0];
            if ((v = hashtable2.get(string)) == null) {
                throw new Exception(iws.Z.getLocalString("err.was_not_found", "access_log_header_template", string));
            }
            this.accessLogHeaderTemplate = (String)v;
        }
        if ((string = (v = hashtable.get("access_log_template")) == null ? "default" : ((String[])v)[0]).equalsIgnoreCase("none")) {
            this.accessLogTemplate = null;
            return;
        }
        v = hashtable2.get(string);
        if (v == null) {
            v = hashtable2.get("default");
        }
        if (v == null) {
            throw new Exception(iws.Z.getLocalString("err.was_not_found", "access_log_template", string));
        }
        this.accessLogTemplate = (String)v;
    }

    public String convertToString(AccessLogEntry accessLogEntry) {
        Date date = new Date(accessLogEntry.timestamp);
        if (this.accessLogTemplate == null) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(accessLogEntry.remoteAddress == null ? j : accessLogEntry.remoteAddress);
            stringBuffer.append(k);
            stringBuffer.append(accessLogEntry.remoteHost == null ? j : accessLogEntry.remoteHost);
            stringBuffer.append(k);
            stringBuffer.append(OutputStreamLogger.formatTimeDateStamp(date, "MM/dd/yy"));
            stringBuffer.append(k);
            stringBuffer.append(OutputStreamLogger.formatTimeDateStamp(date, "HH:mm:ss"));
            stringBuffer.append(k);
            stringBuffer.append(accessLogEntry.remoteUser == null ? j : accessLogEntry.remoteUser);
            stringBuffer.append(k);
            String string2 = string = accessLogEntry.host == null ? j : accessLogEntry.host;
            if (string.indexOf(58) == -1) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append('[');
                stringBuffer.append(string);
                stringBuffer.append(']');
            }
            stringBuffer.append(':');
            stringBuffer.append(String.valueOf(accessLogEntry.port == -1 ? 80 : accessLogEntry.port));
            stringBuffer.append(k);
            stringBuffer.append(accessLogEntry.localAddress == null ? j : accessLogEntry.localAddress);
            stringBuffer.append(k);
            stringBuffer.append(String.valueOf(accessLogEntry.contentLength == (long)-1 ? 0L : accessLogEntry.contentLength));
            stringBuffer.append(k);
            stringBuffer.append(String.valueOf(accessLogEntry.requestLength));
            stringBuffer.append(k);
            stringBuffer.append(String.valueOf(accessLogEntry.responseTime));
            stringBuffer.append(k);
            stringBuffer.append(String.valueOf(accessLogEntry.statusCode));
            stringBuffer.append(k);
            stringBuffer.append(String.valueOf(accessLogEntry.errorCode));
            stringBuffer.append(k);
            stringBuffer.append(accessLogEntry.requestMethod == null ? j : accessLogEntry.requestMethod);
            stringBuffer.append(k);
            stringBuffer.append(accessLogEntry.requestURI == null ? j : accessLogEntry.requestURI);
            stringBuffer.append(k);
            stringBuffer.append(accessLogEntry.userAgent == null ? j : accessLogEntry.userAgent);
            stringBuffer.append(k);
            stringBuffer.append(accessLogEntry.referer == null ? j : accessLogEntry.referer);
            stringBuffer.append(k);
            stringBuffer.append(accessLogEntry.protocol == null ? j : accessLogEntry.protocol);
            stringBuffer.append(k);
            stringBuffer.append(accessLogEntry.serverService == null ? j : accessLogEntry.serverService);
            return stringBuffer.toString();
        }
        String string = this.accessLogTemplate;
        string = DString.replace(string, "%remote_address%", accessLogEntry.remoteAddress == null ? j : accessLogEntry.remoteAddress);
        string = DString.replace(string, "%remote_host%", accessLogEntry.remoteHost == null ? j : accessLogEntry.remoteHost);
        string = DString.replace(string, "%date%", OutputStreamLogger.formatTimeDateStamp(date, "MM/dd/yy"));
        string = DString.replace(string, "%ldate%", OutputStreamLogger.formatTimeDateStamp(date, "MM/dd/yyyy"));
        string = DString.replace(string, "%xdate%", OutputStreamLogger.formatTimeDateStamp(date, "yyyy-MM-dd"));
        string = DString.replace(string, "%edate%", OutputStreamLogger.formatTimeDateStamp(date, "yyyy/MM/dd"));
        string = DString.replace(string, "%time%", OutputStreamLogger.formatTimeDateStamp(date, "HH:mm:ss"));
        string = DString.replace(string, "%timestamp%", OutputStreamLogger.formatTimeDateStamp(date, "MM/dd/yyyy:HH:mm:ss zzz"));
        string = DString.replace(string, "%xtimestamp%", OutputStreamLogger.formatTimeDateStamp(date, "dd/MMM/yyyy:HH:mm:ss zzz"));
        string = DString.replace(string, "%remote_user%", accessLogEntry.remoteUser == null ? j : accessLogEntry.remoteUser);
        string = DString.replace(string, "%host%", accessLogEntry.host == null ? j : accessLogEntry.host);
        string = DString.replace(string, "%port%", String.valueOf(accessLogEntry.port == -1 ? 80 : accessLogEntry.port));
        string = DString.replace(string, "%local_address%", accessLogEntry.localAddress == null ? j : accessLogEntry.localAddress);
        string = DString.replace(string, "%content_length%", String.valueOf(accessLogEntry.contentLength == (long)-1 ? 0L : accessLogEntry.contentLength));
        string = DString.replace(string, "%request_length%", String.valueOf(accessLogEntry.requestLength));
        string = DString.replace(string, "%response_time%", String.valueOf(accessLogEntry.responseTime));
        string = DString.replace(string, "%status_code%", String.valueOf(accessLogEntry.statusCode));
        string = DString.replace(string, "%error_code%", String.valueOf(accessLogEntry.errorCode));
        string = DString.replace(string, "%request_method%", accessLogEntry.requestMethod == null ? j : accessLogEntry.requestMethod);
        string = DString.replace(string, "%request_uri%", accessLogEntry.requestURI == null ? j : accessLogEntry.requestURI);
        string = DString.replace(string, "%base_uri%", accessLogEntry.baseURI == null ? j : accessLogEntry.baseURI);
        string = DString.replace(string, "%query_string%", accessLogEntry.queryString == null ? j : accessLogEntry.queryString);
        string = DString.replace(string, "%user_agent%", accessLogEntry.userAgent == null ? j : accessLogEntry.userAgent);
        string = DString.replace(string, "%xuser_agent%", accessLogEntry.userAgent == null ? j : DString.replace(accessLogEntry.userAgent, " ", "+"));
        string = DString.replace(string, "%referer%", accessLogEntry.referer == null ? j : accessLogEntry.referer);
        string = DString.replace(string, "%protocol%", accessLogEntry.protocol == null ? j : accessLogEntry.protocol);
        string = DString.replace(string, "%server_service%", accessLogEntry.serverService == null ? j : accessLogEntry.serverService);
        return string;
    }

    public String convertHeaderToString() {
        String string = this.accessLogHeaderTemplate;
        Date date = new Date();
        string = DString.replace(string, "%date%", OutputStreamLogger.formatTimeDateStamp(date, "MM/dd/yy"));
        string = DString.replace(string, "%ldate%", OutputStreamLogger.formatTimeDateStamp(date, "MM/dd/yyyy"));
        string = DString.replace(string, "%xdate%", OutputStreamLogger.formatTimeDateStamp(date, "yyyy-MM-dd"));
        string = DString.replace(string, "%edate%", OutputStreamLogger.formatTimeDateStamp(date, "yyyy/MM/dd"));
        string = DString.replace(string, "%time%", OutputStreamLogger.formatTimeDateStamp(date, "HH:mm:ss"));
        string = DString.replace(string, "%logo%", iws.int());
        return string;
    }

    public static String formatTimeDateStamp(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(date);
    }

    static {
        j = j;
        k = k;
    }
}

